/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleProvider;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ColumnTableModelWrapper;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.IndexChangeEvent;
import com.jidesoft.grid.IndexChangeEventGenerator;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.IndexChangeListenerHelper;
import com.jidesoft.grid.JoinTableModel;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.RowTableModelWrapper;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.SummaryCalculator;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grid.ToolTipSupport;
import com.jidesoft.pivot.CompoundKey;
import com.jidesoft.pivot.DefaultValues;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotDataEditingProvider;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotSummaryCalculator;
import com.jidesoft.pivot.PivotValueProviderEvent;
import com.jidesoft.pivot.PivotValueProviderListener;
import com.jidesoft.pivot.RowIndexValue;
import com.jidesoft.pivot.RowIndexesValue;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.TableModelPivotDataSource;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import com.jidesoft.swing.JideSwingUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class AggregateTableModel
extends JoinTableModel
implements RowTableModelWrapper,
ColumnTableModelWrapper,
GroupModelProvider,
IndexChangeEventGenerator {
    private PivotDataModel _pivotDataModel;
    private TableModel _tableModel;
    private CellStyleProvider _cellStyleProvider;
    private boolean _settingAggregateColumns = false;
    private boolean _needFireStructureChangeEvent = false;
    private Map<String, Boolean> _expansionState;
    private IndexChangeListenerHelper _listener;
    public static final String PROPERTY_AGGREGATED_COLUMNS_CHANGING = "aggregateColumnsChanging";
    private static final long serialVersionUID = -8485304402263156476L;
    private PropertyChangeSupport _changeSupport;

    public AggregateTableModel(TableModel tableModel) {
        this(tableModel, new int[0]);
    }

    public AggregateTableModel(TableModel tableModel, String[] stringArray) {
        this._tableModel = tableModel;
        this._pivotDataModel = this.createPivotDataModel(tableModel);
        this.customizePivotDataModel(this._pivotDataModel);
        this.setAggregatedColumns(stringArray);
        this.aggregate();
    }

    public AggregateTableModel(TableModel tableModel, int[] nArray) {
        this._tableModel = tableModel;
        this._pivotDataModel = this.createPivotDataModel(tableModel);
        this.customizePivotDataModel(this._pivotDataModel);
        this.setAggregatedColumns(nArray);
        this.aggregate();
    }

    protected PivotDataModel createPivotDataModel(TableModel tableModel) {
        return new AggregateTablePivotDataModel(tableModel);
    }

    private IndexChangeListenerHelper getIndexChangeListenerHelper() {
        if (this._listener == null) {
            this._listener = new IndexChangeListenerHelper(this){

                @Override
                public void indexChanged(IndexChangeEvent indexChangeEvent) {
                    super.indexChanged(indexChangeEvent);
                }
            };
        }
        return this._listener;
    }

    private boolean isAggregateColumnChanged() {
        int[] nArray;
        int[] nArray2 = this.getAggregatedColumns();
        return !JideSwingUtilities.equals(nArray2, nArray = this.getAggregatedColumnsInPivotFields(), true);
    }

    protected void customizePivotDataModel(PivotDataModel pivotDataModel) {
        PivotField[] pivotFieldArray;
        pivotDataModel.setShowGrandTotalForColumn(false);
        pivotDataModel.setShowGrandTotalForRow(false);
        pivotDataModel.setSummaryMode(true);
        pivotDataModel.setAggregateMode(true);
        pivotDataModel.setAutoSortKeys(true);
        pivotDataModel.setAutoUpdate(true);
        pivotDataModel.setRowHeaderEditingProvider(new PivotDataEditingProvider(){

            @Override
            public boolean isCellEditable(PivotDataModel pivotDataModel, int n, int n2) {
                int n3 = AggregateTableModel.this.getActualModelColumnIndex(n2);
                Values values = pivotDataModel.getRowHeaderTableModel().getValuesAt(n);
                if (values instanceof SummaryValues || values instanceof GrandTotalValues) {
                    return false;
                }
                Integer[] integerArray = AggregateTableModel.this.getActualRowsAt(n, n2);
                if (integerArray != null) {
                    for (Integer n4 : integerArray) {
                        if (!pivotDataModel.getTableModel().isCellEditable(n4, n3)) continue;
                        return true;
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setValueAt(PivotDataModel pivotDataModel, Object object, int n, int n2) {
                boolean bl = AggregateTableModel.this.getPivotDataModel().isAutoUpdate();
                try {
                    AggregateTableModel.this.getPivotDataModel().setAutoUpdate(false);
                    int n3 = AggregateTableModel.this.getActualModelColumnIndex(n2);
                    Integer[] integerArray = AggregateTableModel.this.getActualRowsAt(n, n2);
                    if (integerArray != null) {
                        for (Integer n4 : integerArray) {
                            Object object2;
                            if (!pivotDataModel.getTableModel().isCellEditable(n4, n3) || JideSwingUtilities.equals(object2 = pivotDataModel.getTableModel().getValueAt(n4, n3), object)) continue;
                            pivotDataModel.getTableModel().setValueAt(object, n4, n3);
                        }
                    }
                    AggregateTableModel.this.getPivotDataModel().calculate();
                }
                finally {
                    AggregateTableModel.this.getPivotDataModel().setAutoUpdate(bl);
                }
            }
        });
        pivotDataModel.setDataEditingProvider(new PivotDataEditingProvider(){

            @Override
            public boolean isCellEditable(PivotDataModel pivotDataModel, int n, int n2) {
                int n3 = AggregateTableModel.this.getActualModelColumnIndex(n2 + AggregateTableModel.this.getAggregatedColumnCount());
                int n4 = AggregateTableModel.this.getActualRowAt(n);
                return n4 != -1 && pivotDataModel.getTableModel().isCellEditable(n4, n3);
            }

            @Override
            public void setValueAt(PivotDataModel pivotDataModel, Object object, int n, int n2) {
                Object object2;
                int n3 = AggregateTableModel.this.getActualModelColumnIndex(n2 + AggregateTableModel.this.getAggregatedColumnCount());
                int n4 = AggregateTableModel.this.getActualRowAt(n);
                if (n4 != -1 && pivotDataModel.getTableModel().isCellEditable(n4, n3) && !JideSwingUtilities.equals(object2 = pivotDataModel.getTableModel().getValueAt(n4, n3), object)) {
                    pivotDataModel.getTableModel().setValueAt(object, n4, n3);
                }
            }
        });
        for (PivotField pivotField : pivotFieldArray = pivotDataModel.getFields()) {
            pivotField.addPropertyChangeListener("title", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    AggregateTableModel.this._needFireStructureChangeEvent = true;
                }
            });
        }
        pivotDataModel.addPivotValueProviderListener(new PivotValueProviderListener(){

            @Override
            public void pivotValueProviderEventHandler(PivotValueProviderEvent pivotValueProviderEvent) {
                if (pivotValueProviderEvent.getType() == 1) {
                    AggregateTableModel.this._expansionState = AggregateTableModel.this.getPivotDataModel().getRowHeaderTableModel().getExpansionState();
                }
                if ((pivotValueProviderEvent.getType() == 2 || pivotValueProviderEvent.getType() == 7 || pivotValueProviderEvent.getType() == 6 || pivotValueProviderEvent.getType() == 5 && pivotValueProviderEvent.getObject() == null || pivotValueProviderEvent.getType() == 3 || pivotValueProviderEvent.getType() == 8) && AggregateTableModel.this.getPivotDataModel() instanceof PivotDataModel) {
                    ((PivotDataModel)AggregateTableModel.this.getPivotDataModel()).setOriginalDataUpdate(pivotValueProviderEvent.getObject());
                    if (pivotValueProviderEvent.getType() == 3) {
                        AggregateTableModel.this.fireTableDataChanged();
                    } else {
                        ((PivotDataModel)AggregateTableModel.this.getPivotDataModel()).updateRowHeaderTableModel(AggregateTableModel.this._expansionState);
                        if (AggregateTableModel.this.getAggregatedColumnCount() == 0) {
                            AggregateTableModel.this.fireTableDataChanged();
                        }
                    }
                }
            }
        });
    }

    public void setAggregatedColumns(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.setAggregatedColumns(new String[0]);
        } else {
            String[] stringArray = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                stringArray[i] = this._pivotDataModel.getField(n).getName();
            }
            this.setAggregatedColumns(stringArray);
        }
    }

    public void setAggregatedColumns(String[] stringArray) {
        PivotField[] pivotFieldArray;
        this.setSettingAggregateColumns(true);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        for (PivotField pivotField : pivotFieldArray = this._pivotDataModel.getFields()) {
            int n = arrayList.indexOf(pivotField.getName());
            if (n != -1) {
                pivotField.setAreaType(0);
                pivotField.setAreaIndex(n * 2 + 1);
                continue;
            }
            if (pivotField.getAreaType() != 0) continue;
            pivotField.setAreaType(3);
        }
        this.setSettingAggregateColumns(false);
    }

    public void addAggregatedColumn(int n, int n2) {
        Object object;
        if (this.isColumnAggregated(n2)) {
            return;
        }
        int n3 = this.getAggregatedColumnCount();
        if (n < n3) {
            object = this.getAggregatedColumns();
            for (int n4 : object) {
                PivotField pivotField = this.getField(n4);
                if (pivotField == null || pivotField.getAreaType() != 0 || pivotField.getAreaIndex() < n * 2 + 1) continue;
                pivotField.setAreaIndex(pivotField.getAreaIndex() + 2);
            }
        } else {
            n = n3;
        }
        if ((object = (Object)this.getField(n2)) == null) {
            return;
        }
        this.setSettingAggregateColumns(true);
        ((PivotField)object).setAreaType(0);
        ((PivotField)object).setAreaIndex(n * 2 + 1);
        this.setSettingAggregateColumns(false);
    }

    public void addAggregatedColumn(int n) {
        if (this.isColumnAggregated(n)) {
            return;
        }
        int n2 = this.getAggregatedColumnCount();
        PivotField pivotField = this.getField(n);
        if (pivotField == null) {
            return;
        }
        this.setSettingAggregateColumns(true);
        pivotField.setAreaType(0);
        pivotField.setAreaIndex(n2 * 2 + 1);
        this.setSettingAggregateColumns(false);
    }

    public void removeAggregatedColumn(int n) {
        if (!this.isColumnAggregated(n)) {
            return;
        }
        PivotField pivotField = this.getField(n);
        if (pivotField == null) {
            return;
        }
        this.setSettingAggregateColumns(true);
        pivotField.setAreaType(3);
        int n2 = pivotField.getAreaIndex();
        for (PivotField pivotField2 : this._pivotDataModel.getFields()) {
            if (pivotField2.getAreaType() != 0 || pivotField2.getAreaIndex() <= n2) continue;
            pivotField2.setAreaIndex(pivotField2.getAreaIndex() - 2);
        }
        this.setSettingAggregateColumns(false);
    }

    public void hideColumn(int n) {
        PivotField pivotField = this._pivotDataModel.getField(n);
        pivotField.setAreaType(-1);
    }

    public boolean isAggregated() {
        return this._pivotDataModel.isCalculated();
    }

    public boolean isColumnAggregated(int n) {
        return this._pivotDataModel.getField(n).getAreaType() == 0;
    }

    public void setShowSummary(boolean bl) {
        this._pivotDataModel.setShowSummaryOnAggregate(bl);
    }

    public boolean isShowSummary() {
        return this._pivotDataModel.isShowSummaryOnAggregate();
    }

    public void setSummaryMode(boolean bl) {
        this._pivotDataModel.setSummaryMode(bl);
    }

    public boolean isSummaryMode() {
        return this._pivotDataModel.isSummaryMode();
    }

    public void setShowSummaryOnly(boolean bl) {
        this._pivotDataModel.setSummaryMode(bl);
        this._pivotDataModel.setAggregateMode(!bl);
    }

    public boolean isShowSummaryOnly() {
        return !this._pivotDataModel.isAggregateMode();
    }

    public void setSortAggregatedColumns(boolean bl) {
        this._pivotDataModel.setAutoSortKeys(bl);
    }

    public boolean isSortAggregatedColumns() {
        return this._pivotDataModel.isAutoSortKeys();
    }

    public void setShowGrandTotal(boolean bl) {
        this._pivotDataModel.setShowGrandTotalForRow(bl);
    }

    public boolean isShowGrandTotal() {
        return this._pivotDataModel.isShowGrandTotalForRow();
    }

    public int getMaximumAggregatedRows() {
        return this._pivotDataModel.getMaximumAggregatedRows();
    }

    public void setMaximumAggregatedRows(int n) {
        this._pivotDataModel.setMaximumAggregatedRows(n);
    }

    public PivotField getField(String string) {
        return this._pivotDataModel.getField(string);
    }

    public PivotField getField(int n) {
        return this._pivotDataModel.getField(n);
    }

    public void aggregate() {
        this._pivotDataModel.calculate();
    }

    public boolean hasAggregateColumns() {
        PivotField[] pivotFieldArray;
        for (PivotField pivotField : pivotFieldArray = this._pivotDataModel.getFields()) {
            if (pivotField.getAreaType() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getGroupColumnCount() {
        return this.getAggregatedColumnCount();
    }

    @Override
    public int getGroupColumnAt(int n) {
        int[] nArray = this.getAggregatedColumns();
        if (nArray == null || n < 0 || n >= nArray.length) {
            return -1;
        }
        return nArray[n];
    }

    @Override
    public final int getGroupColumnOrder(int n) {
        return 0;
    }

    @Override
    public void setGroupColumns(int[] nArray, int[] nArray2) {
        this.setAggregatedColumns(nArray);
    }

    @Override
    public void groupAndRefresh() {
        this.aggregate();
    }

    @Override
    public void groupAndRefresh(boolean bl) {
        this.aggregate();
    }

    @Override
    public boolean isColumnGroupable(int n) {
        return true;
    }

    @Override
    public final boolean isDisplayGroupColumns() {
        return true;
    }

    @Override
    public boolean groupColumnsFirst() {
        return true;
    }

    @Override
    public Object getGroupColumnIdentifier(int n) {
        return this.getColumnIdentifier(n);
    }

    public int getAggregatedColumnCount() {
        PivotField[] pivotFieldArray;
        int n = 0;
        for (PivotField pivotField : pivotFieldArray = this._pivotDataModel.getFields()) {
            if (pivotField.getAreaType() != 0) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int[] getAggregatedColumnsInPivotFields() {
        void objectArray;
        PivotField[] pivotFieldArray = this._pivotDataModel.getFields();
        int[] nArray = new int[pivotFieldArray.length];
        int n = 0;
        boolean i = false;
        while (objectArray < pivotFieldArray.length) {
            nArray[objectArray] = -1;
            ++objectArray;
        }
        PivotField[] pivotFieldArray2 = pivotFieldArray;
        int n2 = pivotFieldArray2.length;
        for (int j = 0; j < n2; ++j) {
            PivotField pivotField = pivotFieldArray2[j];
            if (pivotField.getAreaType() != 0) continue;
            nArray[(pivotField.getAreaIndex() - 1) / 2] = pivotField.getModelIndex();
            ++n;
        }
        if (n == 0) {
            return new int[0];
        }
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            if (nArray[n2] == -1) {
                System.err.println("Area index should be contiguous. We should have " + n + "fields, but the " + n2 + " one is an empty index.");
            }
            nArray2[n2] = nArray[n2];
        }
        return nArray2;
    }

    public int[] getAggregatedColumns() {
        PivotField[] pivotFieldArray = this._pivotDataModel.getRowFields();
        if (pivotFieldArray == null) {
            return new int[0];
        }
        int[] nArray = new int[pivotFieldArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            PivotField pivotField = pivotFieldArray[i];
            nArray[i] = pivotField.getModelIndex();
        }
        return nArray;
    }

    public CellStyleProvider getCellStyleProvider() {
        return this._cellStyleProvider;
    }

    public void setCellStyleProvider(CellStyleProvider cellStyleProvider) {
        this._cellStyleProvider = cellStyleProvider;
    }

    @Override
    public CellStyle getCellStyleAt(int n, int n2) {
        return this._cellStyleProvider.getCellStyleAt(this, n, n2);
    }

    @Override
    public boolean isCellStyleOn() {
        return this._cellStyleProvider != null;
    }

    public void setSummaryCalculator(PivotSummaryCalculator pivotSummaryCalculator) {
        this._pivotDataModel.setSummaryCalculator(pivotSummaryCalculator);
    }

    public SummaryCalculator getSummaryCalculator() {
        return this._pivotDataModel.getSummaryCalculator();
    }

    public int getActualModelColumnIndex(int n) {
        if (!this.hasAggregateColumns()) {
            return n;
        }
        int n2 = this._pivotDataModel.getRowFields().length;
        int n3 = this._pivotDataModel.getDataFields().length;
        if (n >= 0 && n < n2) {
            return this._pivotDataModel.getRowFields()[n].getModelIndex();
        }
        if (n >= n2 && n < n2 + n3) {
            return this._pivotDataModel.getDataFields()[n - n2].getModelIndex();
        }
        return -1;
    }

    String getTableHeaderToolTipText(int n) {
        ToolTipSupport toolTipSupport = (ToolTipSupport)((Object)TableModelWrapperUtils.getActualTableModel(this.getActualModel(), ToolTipSupport.class));
        if (toolTipSupport != null) {
            String string;
            int n2 = this.getActualModelColumnIndex(n);
            int n3 = TableModelWrapperUtils.getActualColumnAt(this.getActualModel(), n2, (TableModel)((Object)toolTipSupport));
            if (n3 >= 0 && n3 < ((TableModel)((Object)toolTipSupport)).getColumnCount() && (string = toolTipSupport.getToolTipText(n3)) != null && string.trim().length() != 0) {
                return string;
            }
        }
        return null;
    }

    public int getModelColumnIndex(int n) {
        PivotField pivotField = this._pivotDataModel.getField(n);
        if (pivotField.getAreaType() == -1 || pivotField.getAreaType() == 1) {
            return -1;
        }
        PivotField[] pivotFieldArray = this._pivotDataModel.getRowFields();
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            PivotField pivotField2 = pivotFieldArray[i];
            if (pivotField2.getModelIndex() != pivotField.getModelIndex()) continue;
            return i;
        }
        PivotField[] pivotFieldArray2 = this._pivotDataModel.getDataFields();
        for (int i = 0; i < pivotFieldArray2.length; ++i) {
            PivotField pivotField3 = pivotFieldArray2[i];
            if (pivotField3.getModelIndex() != pivotField.getModelIndex()) continue;
            return i + pivotFieldArray.length;
        }
        return -1;
    }

    public Integer[] getActualRowsAt(int n, int n2) {
        if (this.getAggregatedColumnCount() <= 0) {
            return new Integer[]{n};
        }
        List<Integer> list = this._pivotDataModel.getDataAt(n, -n2 - 1);
        return list.toArray(new Integer[list.size()]);
    }

    public int getRowAt(int n) {
        int n2 = this._tableModel.getRowCount();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.getAggregatedColumnCount() <= 0) {
            return n;
        }
        CompoundKey compoundKey = this._pivotDataModel.getRowKeyAt(n);
        List list = this._pivotDataModel.getRowHeaderTableModel().getFlatData();
        Values values = compoundKey.toValues();
        if (values instanceof DefaultValues) {
            Object e;
            int n3;
            int n4;
            for (n4 = n3 = Math.abs(this._pivotDataModel.getRowHeaderTableModel().getInsertIndexInFlatData((DefaultValues)values, list)); n4 < list.size(); ++n4) {
                e = list.get(n4);
                if (!(e instanceof DefaultValues) || !this.isSameKeyValue(values, (DefaultValues)e) || !(((DefaultValues)e).getValueAt(values.getCount()) instanceof RowIndexValue) || ((RowIndexValue)((DefaultValues)e).getValueAt(values.getCount())).getRowIndex() != n) continue;
                return n4;
            }
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                e = list.get(n4);
                if (!(e instanceof DefaultValues) || ((DefaultValues)e).getCount() < values.getCount() || !this.isSameKeyValue(values, (DefaultValues)e) || !(((DefaultValues)e).getValueAt(values.getCount()) instanceof RowIndexValue) || ((RowIndexValue)((DefaultValues)e).getValueAt(values.getCount())).getRowIndex() != n) continue;
                return n4;
            }
        }
        return -1;
    }

    private boolean isSameKeyValue(Values values, DefaultValues defaultValues) {
        if (values == null || defaultValues == null) {
            return false;
        }
        if (defaultValues.getCount() < values.getCount()) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < values.getCount(); ++i) {
            Value value = values.getValueAt(i);
            Value value2 = defaultValues.getValueAt(i);
            if (value == null || value2 == null) {
                bl = false;
                break;
            }
            if (JideSwingUtilities.equals(value.getValue(), value2.getValue())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public int getActualRowAt(int n) {
        if (this.getAggregatedColumnCount() <= 0) {
            return n;
        }
        List<Integer> list = this._pivotDataModel.getDataAt(n, 0);
        if (list != null && list.size() == 1) {
            if (this._pivotDataModel.getRowFields().length == 0) {
                return list.get(0);
            }
            DefaultValues defaultValues = (DefaultValues)this._pivotDataModel.getRowHeaderTableModel().getValuesAt(n);
            if (this._pivotDataModel.isShowSubtotalAsChild() && defaultValues instanceof SummaryValues) {
                defaultValues = ((SummaryValues)defaultValues).shorten();
            }
            if (defaultValues.getCount() > 0 && defaultValues.getValueAt(defaultValues.getCount() - 1) instanceof RowIndexesValue) {
                return -1;
            }
            return list.get(0);
        }
        return -1;
    }

    @Override
    public int getVisualRowAt(int n) {
        return this.getRowAt(n);
    }

    public List<Integer> getActualRowsAt(int n) {
        if (this.getAggregatedColumnCount() <= 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(n);
            return arrayList;
        }
        return this._pivotDataModel.getDataAt(n, 0);
    }

    public IPivotDataModel getPivotDataModel() {
        return this._pivotDataModel;
    }

    @Override
    public Object getColumnIdentifier(int n) {
        if (this.hasAggregateColumns()) {
            return super.getColumnIdentifier(n);
        }
        if (this.getPivotDataModel().getRowFields().length > 0) {
            return super.getColumnIdentifier(n);
        }
        if (this._tableModel instanceof ColumnIdentifierTableModel) {
            return ((ColumnIdentifierTableModel)((Object)this._tableModel)).getColumnIdentifier(n);
        }
        return this._tableModel.getColumnName(n);
    }

    @Override
    public synchronized Class<?> getColumnClass(int n) {
        if (this.hasAggregateColumns()) {
            PivotField pivotField = this.getPivotDataModel().getField(this.getActualColumnAt(n));
            if (pivotField != null) {
                return pivotField.getType();
            }
            return super.getColumnClass(n);
        }
        return this._tableModel.getColumnClass(n);
    }

    @Override
    public synchronized String getColumnName(int n) {
        if (this.hasAggregateColumns()) {
            return super.getColumnName(n);
        }
        if (this.getPivotDataModel().getRowFields().length > 0) {
            return super.getColumnName(n);
        }
        return this._tableModel.getColumnName(n);
    }

    @Override
    public synchronized int getColumnCount() {
        if (this.hasAggregateColumns()) {
            return super.getColumnCount();
        }
        return this._tableModel.getColumnCount();
    }

    @Override
    public synchronized int getRowCount() {
        if (this.hasAggregateColumns()) {
            return super.getRowCount();
        }
        return this._tableModel.getRowCount();
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        if (this.hasAggregateColumns()) {
            return super.getValueAt(n, n2);
        }
        return this._tableModel.getValueAt(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.hasAggregateColumns()) {
            super.setValueAt(object, n, n2);
        } else {
            this._tableModel.setValueAt(object, n, n2);
        }
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        if (this.hasAggregateColumns()) {
            return super.getConverterContextAt(n, n2);
        }
        if (this._tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this._tableModel).getConverterContextAt(n, n2);
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        if (this.hasAggregateColumns()) {
            return super.getEditorContextAt(n, n2);
        }
        if (this._tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this._tableModel).getEditorContextAt(n, n2);
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        if (this.hasAggregateColumns()) {
            return super.getCellClassAt(n, n2);
        }
        if (this._tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this._tableModel).getCellClassAt(n, n2);
        }
        return this._tableModel.getColumnClass(n2);
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        if (this.hasAggregateColumns()) {
            return super.getCellSpanAt(n, n2);
        }
        if (this._tableModel instanceof SpanModel) {
            return ((SpanModel)((Object)this._tableModel)).getCellSpanAt(n, n2);
        }
        return null;
    }

    @Override
    public boolean isCellSpanOn() {
        if (this.hasAggregateColumns()) {
            return super.isCellSpanOn();
        }
        return this._tableModel instanceof SpanModel && ((SpanModel)((Object)this._tableModel)).isCellSpanOn();
    }

    @Override
    public int getTableIndex(int n) {
        if (this.hasAggregateColumns()) {
            return super.getTableIndex(n);
        }
        if (this._tableModel instanceof MultiTableModel) {
            return ((MultiTableModel)this._tableModel).getTableIndex(n);
        }
        return 0;
    }

    @Override
    public int getColumnType(int n) {
        if (this.hasAggregateColumns()) {
            return super.getColumnType(n);
        }
        if (this._tableModel instanceof MultiTableModel) {
            return ((MultiTableModel)this._tableModel).getColumnType(n);
        }
        return 0;
    }

    @Override
    public TableModel getActualModel() {
        return this._tableModel;
    }

    protected synchronized void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this._changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this._changeSupport == null) {
            return;
        }
        this._changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this._changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this._changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this);
        }
        this._changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this._changeSupport == null) {
            return;
        }
        this._changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this._changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this._changeSupport.getPropertyChangeListeners(string);
    }

    public boolean isSettingAggregateColumns() {
        return this._settingAggregateColumns;
    }

    public void setSettingAggregateColumns(boolean bl) {
        if (this._settingAggregateColumns != bl) {
            boolean bl2 = this._settingAggregateColumns;
            this._settingAggregateColumns = bl;
            this.firePropertyChange(PROPERTY_AGGREGATED_COLUMNS_CHANGING, bl2, this._settingAggregateColumns);
        }
    }

    @Override
    public int getActualColumnAt(int n) {
        PivotField pivotField;
        if (n < 0) {
            return n;
        }
        Object object = this.getColumnIdentifier(n);
        object = TableUtils.eraseIdentifierFlag(object, ":::DATA:::");
        if ((object = TableUtils.eraseIdentifierFlag(object, ":::HEADER")) != null && (pivotField = this.getField(object.toString())) != null) {
            return pivotField.getModelIndex();
        }
        return -1;
    }

    @Override
    public int getVisualColumnAt(int n) {
        PivotField pivotField = this.getField(n);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            Object object = this.getColumnIdentifier(i);
            object = TableUtils.eraseIdentifierFlag(object, ":::DATA:::");
            if (!JideSwingUtilities.equals(object = TableUtils.eraseIdentifierFlag(object, ":::HEADER"), pivotField.getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addIndexChangeListener(IndexChangeListener indexChangeListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, IndexChangeListener.class, (EventListener)indexChangeListener)) {
            this.listenerList.add(IndexChangeListener.class, indexChangeListener);
        }
    }

    @Override
    public void removeIndexChangeListener(IndexChangeListener indexChangeListener) {
        this.listenerList.remove(IndexChangeListener.class, indexChangeListener);
    }

    @Override
    public IndexChangeListener[] getIndexChangeListeners() {
        return (IndexChangeListener[])this.listenerList.getListeners(IndexChangeListener.class);
    }

    protected class AggregateTablePivotDataModel
    extends PivotDataModel {
        public AggregateTablePivotDataModel(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        protected boolean tableRowsInserted(int n, int n2) {
            super.tableRowsInserted(n, n2);
            return true;
        }

        @Override
        protected boolean tableRowsDeleted(int n, int n2) {
            super.tableRowsDeleted(n, n2);
            return true;
        }

        @Override
        public void initialize() {
            PivotField[] pivotFieldArray;
            Object object;
            int n;
            PivotField[] pivotFieldArray2 = this.getFields();
            super.initialize();
            PivotField[] pivotFieldArray3 = this.getFields();
            if (pivotFieldArray2 == null || pivotFieldArray2.length == 0) {
                for (n = 0; n < pivotFieldArray3.length; ++n) {
                    object = pivotFieldArray3[n];
                    ((PivotField)object).setAreaType(3);
                    ((PivotField)object).setAreaIndex(n * 2 + 1);
                }
            } else {
                n = -1;
                for (PivotField pivotField : pivotFieldArray3) {
                    if (pivotField.getAreaType() != 3 || pivotField.getAreaIndex() <= n) continue;
                    n = pivotField.getAreaIndex();
                }
                object = Arrays.asList(pivotFieldArray2);
                for (PivotField pivotField : pivotFieldArray3) {
                    if (pivotField.getAreaType() != -1 || object.contains(pivotField)) continue;
                    pivotField.setAreaType(3);
                    pivotField.setAreaIndex(n += 2);
                }
            }
            if ((pivotFieldArray = this.getRowFields()) != null) {
                object = new String[pivotFieldArray.length];
                if (((Object)object).length > 0) {
                    for (int i = 0; i < pivotFieldArray.length; ++i) {
                        PivotField pivotField = pivotFieldArray[i];
                        object[i] = pivotField.getName();
                    }
                }
                AggregateTableModel.this.setAggregatedColumns((String[])object);
            }
        }

        @Override
        public void calculate() {
            if (!AggregateTableModel.this._needFireStructureChangeEvent) {
                AggregateTableModel.this._needFireStructureChangeEvent = AggregateTableModel.this.isAggregateColumnChanged();
            }
            super.calculate();
        }

        @Override
        void forceCalculate(boolean bl) {
            AggregateTableModel.this.removeAllTableModels();
            super.forceCalculate(bl);
            this.invalidateColumnHeaderTableModel();
            this.invalidateRowHeaderTableModel();
            this.invalidateDataTableModel();
            AggregateTableModel.this.addTableModel(AggregateTableModel.this._pivotDataModel.getRowHeaderTableModel());
            AggregateTableModel.this.addTableModel(AggregateTableModel.this._pivotDataModel.getDataTableModel());
            if (AggregateTableModel.this._needFireStructureChangeEvent) {
                AggregateTableModel.this.fireTableStructureChanged();
            } else {
                AggregateTableModel.this.fireTableDataChanged();
            }
            AggregateTableModel.this._needFireStructureChangeEvent = false;
        }

        @Override
        public void setOriginalTableModel(TableModel tableModel) {
            if (this.getDataSource() instanceof TableModelPivotDataSource && ((TableModelPivotDataSource)this.getDataSource())._filterTableModel instanceof IndexChangeEventGenerator) {
                ((IndexChangeEventGenerator)((Object)((TableModelPivotDataSource)this.getDataSource())._filterTableModel)).removeIndexChangeListener(AggregateTableModel.this.getIndexChangeListenerHelper());
            }
            super.setOriginalTableModel(tableModel);
            if (this.getDataSource() instanceof TableModelPivotDataSource && ((TableModelPivotDataSource)this.getDataSource())._filterTableModel instanceof IndexChangeEventGenerator) {
                ((IndexChangeEventGenerator)((Object)((TableModelPivotDataSource)this.getDataSource())._filterTableModel)).addIndexChangeListener(AggregateTableModel.this.getIndexChangeListenerHelper());
            }
        }

        @Override
        public boolean isHideExpandIconOnSingleRow() {
            return false;
        }
    }
}

