/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.grid.SummaryCalculator;
import com.jidesoft.list.DualList;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotResources;
import com.jidesoft.pivot.SubtotalSettingPanel;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import com.jidesoft.utils.ResourceProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AggregateColumnsEditor
extends AbstractDialogPage
implements ResourceProvider {
    private IPivotDataModel _pivotDataModel;
    private DualList _dualList;
    private PivotField[] _fields;
    public SubtotalSettingPanel _subtotalSettingPanel;
    public PivotField _selectedField;

    public AggregateColumnsEditor(IPivotDataModel iPivotDataModel) {
        this._pivotDataModel = iPivotDataModel;
        this._fields = this._pivotDataModel.getFields();
    }

    @Override
    public void lazyInitialize() {
        this.initComponents();
    }

    protected void initComponents() {
        this._dualList = new DualList(this._fields){

            @Override
            protected void setupList(final JList jList, boolean bl) {
                super.setupList(jList, bl);
                if (!bl) {
                    jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent listSelectionEvent) {
                            int n;
                            if (listSelectionEvent.getValueIsAdjusting()) {
                                return;
                            }
                            if (AggregateColumnsEditor.this._selectedField != null) {
                                AggregateColumnsEditor.this._subtotalSettingPanel.saveData(AggregateColumnsEditor.this._selectedField, 0);
                                AggregateColumnsEditor.this._selectedField = null;
                            }
                            if ((n = jList.getSelectedIndex()) != -1) {
                                JideSwingUtilities.setEnabledRecursively(AggregateColumnsEditor.this._subtotalSettingPanel, true);
                                PivotField pivotField = (PivotField)jList.getModel().getElementAt(n);
                                final SummaryCalculator summaryCalculator = AggregateColumnsEditor.this._pivotDataModel.getSummaryCalculator();
                                AbstractListModel abstractListModel = new AbstractListModel(){

                                    @Override
                                    public int getSize() {
                                        return summaryCalculator.getNumberOfSummaries();
                                    }

                                    @Override
                                    public Object getElementAt(int n) {
                                        return summaryCalculator.getSummaryName(AggregateColumnsEditor.this.getLocale(), n);
                                    }
                                };
                                AggregateColumnsEditor.this._subtotalSettingPanel.setListModel(abstractListModel);
                                AggregateColumnsEditor.this._subtotalSettingPanel.loadData(pivotField.getSubtotalType(), pivotField.getCustomSubtotals());
                                AggregateColumnsEditor.this._selectedField = pivotField;
                            } else {
                                JideSwingUtilities.setEnabledRecursively(AggregateColumnsEditor.this._subtotalSettingPanel, false);
                            }
                        }
                    });
                }
            }
        };
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent((JList<?>)jList, ((PivotField)object).getTitle(), n, bl, bl2);
            }
        };
        for (int i = 0; i < this._fields.length; ++i) {
            PivotField pivotField = this._fields[i];
            if (pivotField.getAreaType() != 0) continue;
            this._dualList.addSelectionInterval(i, i);
        }
        this._dualList.setCellRenderer(defaultListCellRenderer);
        this._dualList.setSelectedCellRenderer(defaultListCellRenderer);
        this._dualList.setSelectionMode(0);
        this._dualList.getOriginalListPane().setBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "All Columns"));
        this._dualList.getSelectedListPane().setBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "Aggregated Columns"));
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)this._dualList, "Center");
        this._subtotalSettingPanel = new SubtotalSettingPanel(this);
        this._subtotalSettingPanel.setBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "Column Settings"));
        this.add((Component)this._subtotalSettingPanel, "After");
        JideSwingUtilities.setEnabledRecursively(this._subtotalSettingPanel, false);
    }

    public Object[] getSelectedColumns() {
        return this._dualList.getSelectedValues();
    }

    @Override
    public String getResourceString(String string) {
        return this.getResourceBundle().getString(string);
    }

    public ResourceBundle getResourceBundle() {
        return PivotResources.getResourceBundle(this.getLocale());
    }

    public IPivotDataModel getPivotDataModel() {
        return this._pivotDataModel;
    }

    public void commit() {
        PivotField[] pivotFieldArray;
        Object[] objectArray = this.getSelectedColumns();
        for (PivotField pivotField : pivotFieldArray = this._pivotDataModel.getFields()) {
            pivotField.setAreaType(3);
            pivotField.setAreaIndex(0);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (!(object instanceof PivotField)) continue;
            ((PivotField)object).setAreaIndex(i * 2 + 1);
            ((PivotField)object).setAreaType(0);
        }
        if (this._selectedField != null) {
            this._subtotalSettingPanel.saveData(this._selectedField, 0);
            this._selectedField = null;
        }
    }
}

