/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.pane.Resource;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.PartialEtchedBorder;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class OutlookTabbedPane
extends JTabbedPane {
    private Vector<AbstractButton> _buttons;
    private Set<Integer> _hiddenTabs;
    private Vector<String> _titles;
    private BottomPanel _bottomPanel = null;
    private Divider _divider = new Divider();
    private int _bottomButtonCount = 0;
    private JPanel _leftPanel;
    private JPanel _buttonPanel;
    private JideButton _chevron;
    private int _tabCount;
    private int _buttonPanelHeight = 30;
    private int _dividerHeight = 7;
    private String _optionDialogTitle;
    private JButton _moveUpButton;
    private JButton _moveDownButton;
    private StandardDialog dialog = null;
    private ListModel _listModel;
    private CheckBoxList _list;
    private String[] _newTabOrder;
    public static final String PROPERTY_BOTTOM_BUTTON_COUNT = "bottomButtonCount";
    protected ChangeListener _selectionChangeListener;
    private ThemePainter _painter;
    private String _version;
    public static final String CONTEXT_MENU_SHOW_MORE_BUTTON = "OutlookTabbedPane.showMoreButton";
    public static final String CONTEXT_MENU_SHOW_FEWER_BUTTON = "OutlookTabbedPane.showFewerButton";
    public static final String CONTEXT_MENU_OPTION = "OutlookTabbedPane.option.dialogTitle";
    public static final String CONTEXT_MENU_ADD_REMOVE_BUTTON = "OutlookTabbedPane.addRemoveButton";
    Point p = new Point(0, 0);
    private boolean flag = false;
    private boolean _updating = false;
    private Component visibleComponent;

    public OutlookTabbedPane() {
        this.setTabPlacement(3);
        this.setFocusable(true);
        this._buttons = new Vector();
        this._titles = new Vector();
        this._hiddenTabs = new HashSet<Integer>();
        this._bottomPanel = new BottomPanel();
        this.add(this._bottomPanel);
        this._leftPanel = new NullPanel();
        this._leftPanel.setOpaque(false);
        this._bottomPanel.setLayout(new JideBoxLayout(this._bottomPanel, 0));
        this._leftPanel.setLayout(new BorderLayout());
        this._buttonPanel = new NullPanel();
        this._buttonPanel.setLayout(new GridLayout(1, 0, 0, 0));
        this._buttonPanel.setOpaque(false);
        this._leftPanel.add((Component)this._buttonPanel, "After");
        this._chevron = new JideButton(this.getImageIcon("icons/chevron.gif"));
        this._chevron.setRequestFocusEnabled(false);
        this._chevron.setCursor(Cursor.getPredefinedCursor(12));
        this._chevron.addActionListener(new ChevronActionListener());
        this.customizeBottomButton(this._chevron);
        this._bottomPanel.add(this._leftPanel);
        this._bottomPanel.add(this._chevron);
        this._selectionChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = OutlookTabbedPane.this.getSelectedIndex();
                if (n >= 0 && n < OutlookTabbedPane.this.getButtons().size()) {
                    OutlookTabbedPane.this.getButtons().get(n).setSelected(true);
                }
            }
        };
        this.getModel().addChangeListener(this._selectionChangeListener);
        MouseHandler mouseHandler = new MouseHandler();
        this._divider.addMouseListener(mouseHandler);
        this._divider.addMouseMotionListener(mouseHandler);
        this.add(this._divider);
        this.setLayout(this.createLayout());
        this.setBorder(UIDefaultsLookup.getBorder("TextField.border"));
        this._tabCount = 0;
    }

    @Override
    public void updateUI() {
        Component component;
        int n;
        if (UIDefaultsLookup.get("Theme.painter") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this.doLayout();
        if (this._buttons != null) {
            for (n = 0; n < this._buttons.size(); ++n) {
                component = this._buttons.elementAt(n);
                ((AbstractButton)component).updateUI();
                this.customizeButton((AbstractButton)component);
            }
        }
        for (n = 0; n < this.getTabCount(); ++n) {
            component = this.getComponentAt(n);
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
        }
    }

    protected LayoutManager createLayout() {
        return new OutlookTabbedPaneLayout();
    }

    protected Action createSwitchPageAction(String string, Icon icon, int n) {
        return new SwitchPageAction(string, icon);
    }

    public Vector<AbstractButton> getButtons() {
        return this._buttons;
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        this.invalidate();
        this.doLayout();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeTabAt(int n) {
        AbstractButton abstractButton;
        Object object;
        if (this.getButtons().size() == 0) {
            return;
        }
        if (this.getTabCount() > 1) {
            void var4_6;
            int n3 = this.getSelectedIndex();
            object = this.createCounts();
            boolean n2 = false;
            while (var4_6 < ((int[])object).length) {
                if (object[var4_6] > n) {
                    void v0 = var4_6;
                    object[v0] = object[v0] - 1;
                }
                ++var4_6;
            }
            if (n == n3) {
                void var4_8;
                boolean bl = false;
                while (var4_8 < ((int[])object).length) {
                    if (object[var4_8] > n3) {
                        this.setSelectedIndex(object[var4_8 - true]);
                        break;
                    }
                    if (object[var4_8] < n3) {
                        this.setSelectedIndex(object[var4_8]);
                        break;
                    }
                    ++var4_8;
                }
                if (((int[])object).length == 1) {
                    this.setSelectedIndex(-1);
                }
            }
        }
        if ("".equals((abstractButton = this._buttons.elementAt(n)).getText())) {
            object = (JButton)this.getButtons().elementAt(n);
            this._buttonPanel.remove((Component)object);
            this.customizeButton((AbstractButton)object);
            abstractButton.setToolTipText(this.getToolTipTextAt(n));
            this._buttons.removeElementAt(n);
            this.setBottomButtonCount(this.getBottomButtonCount() - 1);
        } else {
            this._buttons.removeElementAt(n);
        }
        super.removeTabAt(n);
        if (abstractButton.getParent() != null) {
            abstractButton.getParent().remove(abstractButton);
        }
        this._titles.removeElementAt(n);
        object = this._hiddenTabs.toArray(new Integer[this._hiddenTabs.size()]);
        this._hiddenTabs.clear();
        for (int n2 : object) {
            if (n2.intValue() > n) {
                Integer n3 = n2.intValue() - 1;
                this._hiddenTabs.add(n3);
                continue;
            }
            if (n2.intValue() >= n) continue;
            this._hiddenTabs.add(n2);
        }
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        AbstractButton abstractButton = this.createButton(this.createSwitchPageAction(string, icon, n));
        if (!(abstractButton instanceof UIResource)) {
            throw new IllegalArgumentException("The button returned from createButton(Action action) method is not an instance of UIResoruce.");
        }
        abstractButton.setToolTipText(string2);
        this._buttons.insertElementAt(abstractButton, n);
        this._titles.insertElementAt(string, n);
        if (n == this.getSelectedIndex()) {
            abstractButton.setSelected(true);
        }
        this.add(abstractButton);
        component.setVisible(true);
        abstractButton.setEnabled(this.isEnabledAt(n));
    }

    protected AbstractButton createButton(Action action) {
        OutlookButton outlookButton = new OutlookButton(action);
        outlookButton.setName((String)action.getValue("Name"));
        this.customizeButton(outlookButton);
        return outlookButton;
    }

    public int getButtonPanelHeight() {
        return this._buttonPanelHeight;
    }

    public void setButtonPanelHeight(int n) {
        if (this._buttonPanelHeight != n) {
            this._buttonPanelHeight = n;
            this.doLayout();
        }
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.getButtons().size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Tab count: " + this.getButtons().size());
        }
    }

    @Override
    public int getMnemonicAt(int n) {
        this.checkIndex(n);
        return super.getMnemonicAt(n);
    }

    @Override
    public void setMnemonicAt(int n, int n2) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setMnemonic(n2);
        super.setMnemonicAt(n, n2);
    }

    @Override
    public int getDisplayedMnemonicIndexAt(int n) {
        this.checkIndex(n);
        return super.getDisplayedMnemonicIndexAt(n);
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int n, int n2) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setDisplayedMnemonicIndex(n2);
        super.setDisplayedMnemonicIndexAt(n, n2);
    }

    @Override
    public void setTitleAt(int n, String string) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        if (!"".equals(abstractButton.getText())) {
            abstractButton.setText(string);
        }
        this._titles.set(n, string);
        this._newTabOrder = null;
        super.setTitleAt(n, string);
    }

    @Override
    public String getTitleAt(int n) {
        this.checkIndex(n);
        return super.getTitleAt(n);
    }

    @Override
    public Icon getIconAt(int n) {
        this.checkIndex(n);
        return super.getIconAt(n);
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setIcon(icon);
        super.setIconAt(n, icon);
    }

    @Override
    public Icon getDisabledIconAt(int n) {
        this.checkIndex(n);
        return super.getDisabledIconAt(n);
    }

    @Override
    public void setDisabledIconAt(int n, Icon icon) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setDisabledIcon(icon);
        super.setDisabledIconAt(n, icon);
    }

    @Override
    public String getToolTipTextAt(int n) {
        this.checkIndex(n);
        return super.getToolTipTextAt(n);
    }

    @Override
    public void setToolTipTextAt(int n, String string) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setToolTipText(string);
        super.setToolTipTextAt(n, string);
    }

    @Override
    public boolean isEnabledAt(int n) {
        this.checkIndex(n);
        return super.isEnabledAt(n);
    }

    @Override
    public void setEnabledAt(int n, boolean bl) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setEnabled(bl);
        super.setEnabledAt(n, bl);
    }

    @Override
    public void setForegroundAt(int n, Color color) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setForeground(color);
        super.setForegroundAt(n, color);
    }

    @Override
    public Color getForegroundAt(int n) {
        this.checkIndex(n);
        return super.getForegroundAt(n);
    }

    @Override
    public void setBackgroundAt(int n, Color color) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setBackground(color);
        super.setBackgroundAt(n, color);
    }

    @Override
    public Color getBackgroundAt(int n) {
        this.checkIndex(n);
        return super.getBackgroundAt(n);
    }

    public JPanel getBottomPanel() {
        return this._bottomPanel;
    }

    protected String getResourceString(String string) {
        return Resource.getResourceBundle(this.getLocale()).getString(string);
    }

    protected JPopupMenu createPopupMenu() {
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        JMenuItem jMenuItem = jidePopupMenu.add(new JMenuItem(this.getResourceString(CONTEXT_MENU_SHOW_MORE_BUTTON), this.getImageIcon("icons/more.gif")));
        jMenuItem.setName(CONTEXT_MENU_SHOW_MORE_BUTTON);
        jMenuItem.setEnabled(this.getBottomButtonCount() > 0);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = OutlookTabbedPane.this.getBottomButtonCount();
                if (n > 0) {
                    OutlookTabbedPane.this.setBottomButtonCount(n - 1);
                }
            }
        });
        JMenuItem jMenuItem2 = jidePopupMenu.add(new JMenuItem(this.getResourceString(CONTEXT_MENU_SHOW_FEWER_BUTTON), this.getImageIcon("icons/less.gif")));
        jMenuItem2.setName(CONTEXT_MENU_SHOW_FEWER_BUTTON);
        jMenuItem2.setEnabled(this.getBottomButtonCount() < this._buttons.size() - this._hiddenTabs.size());
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = OutlookTabbedPane.this.getBottomButtonCount();
                if (n <= OutlookTabbedPane.this._buttons.size() - OutlookTabbedPane.this._hiddenTabs.size()) {
                    OutlookTabbedPane.this.setBottomButtonCount(n + 1);
                    OutlookTabbedPane.this.updateUI();
                }
            }
        });
        JMenuItem jMenuItem3 = jidePopupMenu.add(new JMenuItem(this.getOptionDialogTitle() + "..."));
        jMenuItem3.setName(CONTEXT_MENU_OPTION);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutlookTabbedPane.this.displayOptionDialog();
            }
        });
        JMenu jMenu = new JMenu(this.getResourceString(CONTEXT_MENU_ADD_REMOVE_BUTTON));
        jMenu.setName(CONTEXT_MENU_ADD_REMOVE_BUTTON);
        jidePopupMenu.add(jMenu);
        for (int i = 0; i < this.getTabCount(); ++i) {
            JMenuItem jMenuItem4 = jMenu.add(new JCheckBoxMenuItem(this._titles.elementAt(i), this.getIconAt(i)));
            jMenuItem4.setSelected(this.getButtons().elementAt(i).isVisible());
            jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    int n = -1;
                    for (int i = 0; i < OutlookTabbedPane.this._titles.size(); ++i) {
                        if (!((String)OutlookTabbedPane.this._titles.elementAt(i)).equals(string)) continue;
                        n = i;
                        break;
                    }
                    OutlookTabbedPane.this.setTabVisibleAt(n, !OutlookTabbedPane.this.isTabVisibleAt(n));
                }
            });
        }
        int[] nArray = this.createCounts();
        int n = nArray.length;
        int n2 = this.getBottomButtonCount();
        if (n2 > 0 && n >= n2) {
            n -= n2;
        }
        if (nArray.length > this._tabCount) {
            boolean bl = false;
            for (int i = nArray.length - this._tabCount; i < nArray.length; ++i) {
                if (!bl) {
                    jidePopupMenu.addSeparator();
                    bl = true;
                }
                JButton jButton = (JButton)this._buttons.elementAt(nArray[i]);
                JMenuItem jMenuItem5 = new JMenuItem(this._titles.elementAt(nArray[i]), jButton.getIcon());
                jMenuItem5.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        int n = -1;
                        for (int i = 0; i < OutlookTabbedPane.this._titles.size(); ++i) {
                            if (!jMenuItem.getText().equals(OutlookTabbedPane.this._titles.elementAt(i))) continue;
                            n = i;
                            break;
                        }
                        int[] nArray = OutlookTabbedPane.this.createCounts();
                        Insets insets = OutlookTabbedPane.this.getInsets();
                        int n2 = OutlookTabbedPane.this.getWidth() - insets.left - insets.right;
                        int n3 = nArray.length;
                        int n4 = OutlookTabbedPane.this.getBottomButtonCount();
                        if (n4 > 0) {
                            n3 = n3 >= n4 ? (n3 -= n4) : 0;
                        }
                        JButton jButton = (JButton)OutlookTabbedPane.this.getButtons().elementAt(0);
                        OutlookTabbedPane.this.customizeButton(jButton);
                        int n5 = jButton.getPreferredSize().height;
                        int n6 = OutlookTabbedPane.this.getHeight() - insets.top - insets.bottom - n3 * n5 - OutlookTabbedPane.this.getButtonPanelHeight() - OutlookTabbedPane.this._dividerHeight;
                        if (n >= 0) {
                            for (int i = 0; i < OutlookTabbedPane.this.getTabCount(); ++i) {
                                Component component = OutlookTabbedPane.this.getComponentAt(i);
                                component.setVisible(false);
                            }
                            OutlookTabbedPane.this.setSelectedIndex(n);
                            Component component = OutlookTabbedPane.this.getComponentAt(nArray[n]);
                            component.setBounds(insets.left, insets.top, n2, n6);
                            component.setVisible(true);
                        }
                    }
                });
                jidePopupMenu.add(jMenuItem5);
            }
        }
        return jidePopupMenu;
    }

    protected void displayOptionDialog() {
        Window window = SwingUtilities.getWindowAncestor(this);
        this.dialog = window instanceof Frame ? new OptionDialog((Frame)window, this.getOptionDialogTitle()) : (window instanceof Dialog ? new OptionDialog((Dialog)window, this.getOptionDialogTitle()) : new OptionDialog((Frame)null, this.getOptionDialogTitle()));
        this.customizeOptionDialog(this.dialog);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this);
        this.dialog.setVisible(true);
    }

    protected void customizeOptionDialog(JDialog jDialog) {
    }

    protected int[] createCounts() {
        int n = this.getButtons().size();
        int[] nArray = new int[n - this._hiddenTabs.size()];
        int n2 = 0;
        if (this._hiddenTabs.size() > 0) {
            for (int i = 0; i < n; ++i) {
                if (this._hiddenTabs.contains(new Integer(i))) {
                    JButton jButton = (JButton)this._buttons.elementAt(i);
                    jButton.setVisible(false);
                    continue;
                }
                if (n2 >= nArray.length) continue;
                nArray[n2] = i;
                ++n2;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
        }
        return nArray;
    }

    protected void customizeButton(AbstractButton abstractButton) {
        abstractButton.setOpaque(true);
        abstractButton.setHorizontalAlignment(10);
        abstractButton.setMargin(new Insets(3, 6, 4, 6));
        if (abstractButton instanceof JideButton) {
            ((JideButton)abstractButton).setButtonStyle(UIDefaultsLookup.getInt("OutlookTabbedPane.buttonStyle"));
        }
    }

    protected void customizeBottomButton(AbstractButton abstractButton) {
        abstractButton.setOpaque(false);
        abstractButton.setHorizontalAlignment(0);
        abstractButton.setMargin(new Insets(0, 4, 0, 4));
        if (abstractButton instanceof JideButton) {
            ((JideButton)abstractButton).setButtonStyle(0);
        }
    }

    public String getOptionDialogTitle() {
        if (this._optionDialogTitle == null) {
            return this.getResourceString(CONTEXT_MENU_OPTION);
        }
        return this._optionDialogTitle;
    }

    public void setOptionDialogTitle(String string) {
        this._optionDialogTitle = string;
    }

    public int[] getVisibleTabs() {
        int[] nArray = new int[this.getButtons().size() - this._hiddenTabs.size()];
        int n = 0;
        for (int i = 0; i < this.getButtons().size(); ++i) {
            if (!this.isTabVisibleAt(i)) continue;
            nArray[n] = i;
            ++n;
        }
        return nArray;
    }

    public void setVisibleTabs(int[] nArray) {
        this._hiddenTabs = new HashSet<Integer>();
        for (int i = 0; i < this.getButtons().size(); ++i) {
            this._hiddenTabs.add(i);
        }
        for (int n : nArray) {
            this._hiddenTabs.remove(new Integer(n));
        }
        this.updateUI();
        this.fireStateChanged();
    }

    public boolean isTabVisibleAt(int n) {
        return !this._hiddenTabs.contains(new Integer(n));
    }

    public void setTabVisibleAt(int n, boolean bl) {
        if (bl) {
            this._hiddenTabs.remove(new Integer(n));
            if (this._hiddenTabs.size() == this._buttons.size() - 1) {
                this.setSelectedIndex(n);
            }
        } else {
            this._hiddenTabs.add(n);
        }
        this.updateUI();
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTabOrder(String[] stringArray, boolean bl) {
        int n;
        int n2;
        Icon[] iconArray = new Icon[this.getButtons().size()];
        Component[] componentArray = new Component[this.getButtons().size()];
        String[] stringArray2 = new String[this.getButtons().size()];
        String[] stringArray3 = new String[this.getButtons().size()];
        int[] nArray = new int[this.getButtons().size()];
        int n3 = 0;
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            n = this._titles.indexOf(stringArray[n3]);
            if (n == -1) continue;
            stringArray2[n2] = this._titles.get(n);
            iconArray[n2] = this.getIconAt(n);
            componentArray[n2] = this.getComponentAt(n);
            stringArray3[n2] = this.getToolTipTextAt(n);
            nArray[n2] = this.getMnemonicAt(n);
            ++n3;
        }
        n2 = this.getBottomButtonCount();
        this._updating = true;
        try {
            int n4;
            HashSet<Integer> hashSet = null;
            if (!bl) {
                hashSet = new HashSet<Integer>();
                hashSet.addAll(this._hiddenTabs);
            }
            for (n = this.getButtons().size() - 1; n >= 0; --n) {
                this.removeTabAt(n);
            }
            this._hiddenTabs = bl ? new HashSet<Integer>() : hashSet;
            n = -1;
            for (n4 = 0; n4 < stringArray2.length; ++n4) {
                this.insertTab(stringArray2[n4], iconArray[n4], componentArray[n4], stringArray3[n4], n4);
                if (bl && !this._list.getCheckBoxListSelectionModel().isSelectedIndex(n4)) {
                    this._hiddenTabs.add(n4);
                    continue;
                }
                if (n != -1 || !this.isTabVisibleAt(n4)) continue;
                n = n4;
            }
            for (n4 = 0; n4 < nArray.length; ++n4) {
                int n5 = nArray[n4];
                this.setMnemonicAt(n4, n5);
            }
            if (iconArray.length - this._hiddenTabs.size() < n2) {
                this.setBottomButtonCount(iconArray.length - this._hiddenTabs.size());
            } else {
                this.setBottomButtonCount(n2);
            }
            if (n != -1) {
                this.setSelectedIndex(n);
            }
        }
        finally {
            this.doLayout();
            this._updating = false;
        }
        this.fireStateChanged();
    }

    @Override
    protected void fireStateChanged() {
        if (!this._updating) {
            super.fireStateChanged();
        }
    }

    protected String[] createTitles(Vector<String> vector) {
        return vector.toArray(new String[vector.size()]);
    }

    public String[] getTabOrder() {
        if (this._newTabOrder == null) {
            return this.createTitles(this._titles);
        }
        return (String[])this._newTabOrder.clone();
    }

    public void setTabOrder(String[] stringArray) {
        for (String string : stringArray) {
            boolean bl = false;
            for (int i = 0; i < this.getTabCount(); ++i) {
                String string2 = this.getTitleAt(i);
                if (!string2.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new IllegalArgumentException("The \"" + string + "\" tab specified in the \"titles\" array doesn't exist in the tabbed pane.");
        }
        this._newTabOrder = stringArray;
        this.updateTabOrder(this._newTabOrder, false);
    }

    public int getBottomButtonCount() {
        return this._bottomButtonCount;
    }

    public void setBottomButtonCount(int n) {
        int n2 = this._bottomButtonCount;
        if (n2 != n) {
            this._bottomButtonCount = n;
            this.firePropertyChange(PROPERTY_BOTTOM_BUTTON_COUNT, n2, n);
            this.updateUI();
        }
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    public void setChevronVisible(boolean bl) {
        this._chevron.setVisible(bl);
    }

    public boolean isChevronVisible() {
        return this._chevron.isVisible();
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component != null && component.isFocusable()) {
            JideSwingUtilities.compositeRequestFocus(component);
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    protected ImageIcon getImageIcon(String string) {
        return IconsFactory.getImageIcon(OutlookTabbedPane.class, string);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ String[] access$1902(OutlookTabbedPane outlookTabbedPane, String[] stringArray) {
        outlookTabbedPane._newTabOrder = stringArray;
        return stringArray;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(OutlookTabbedPane.class.getName(), 2);
        }
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        private static final long serialVersionUID = -9182677685546392019L;

        public AccessibleJTabbedPane() {
            super(OutlookTabbedPane.this);
            OutlookTabbedPane.this.model.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return OutlookTabbedPane.this.getTabCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= OutlookTabbedPane.this.getTabCount()) {
                return null;
            }
            return (Accessible)OutlookTabbedPane.this._buttons.elementAt(n);
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            int n = ((TabbedPaneUI)OutlookTabbedPane.this.ui).tabForCoordinate(OutlookTabbedPane.this, point.x, point.y);
            if (n == -1) {
                n = OutlookTabbedPane.this.getSelectedIndex();
            }
            return this.getAccessibleChild(n);
        }

        @Override
        public int getAccessibleSelectionCount() {
            return 1;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            int n2 = OutlookTabbedPane.this.getSelectedIndex();
            if (n2 == -1) {
                return null;
            }
            return (Accessible)OutlookTabbedPane.this._buttons.elementAt(n2);
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            return n == OutlookTabbedPane.this.getSelectedIndex();
        }

        @Override
        public void addAccessibleSelection(int n) {
            OutlookTabbedPane.this.setSelectedIndex(n);
        }

        @Override
        public void removeAccessibleSelection(int n) {
        }

        @Override
        public void clearAccessibleSelection() {
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    public class OptionDialog
    extends StandardDialog {
        public OptionDialog(Frame frame, String string) throws HeadlessException {
            super(frame, string);
        }

        public OptionDialog(Dialog dialog, String string) throws HeadlessException {
            super(dialog, string);
        }

        private ButtonPanel createRearrangeButtonPanel() {
            ButtonPanel buttonPanel = new ButtonPanel(1);
            OutlookTabbedPane.this._moveUpButton = new JButton(OutlookTabbedPane.this.getResourceString("OutlookTabbedPane.option.moveUp"));
            OutlookTabbedPane.this._moveUpButton.setMnemonic(OutlookTabbedPane.this.getResourceString("OutlookTabbedPane.option.moveUp.mnemonic").charAt(0));
            OutlookTabbedPane.this._moveDownButton = new JButton(OutlookTabbedPane.this.getResourceString("OutlookTabbedPane.option.moveDown"));
            OutlookTabbedPane.this._moveDownButton.setMnemonic(OutlookTabbedPane.this.getResourceString("OutlookTabbedPane.option.moveDown.mnemonic").charAt(0));
            JButton jButton = new JButton(OutlookTabbedPane.this.getResourceString("OutlookTabbedPane.option.reset"));
            jButton.setMnemonic(OutlookTabbedPane.this.getResourceString("OutlookTabbedPane.option.reset.mnemonic").charAt(0));
            buttonPanel.addButton(OutlookTabbedPane.this._moveUpButton);
            buttonPanel.addButton(OutlookTabbedPane.this._moveDownButton);
            buttonPanel.addButton(jButton);
            OutlookTabbedPane.this._moveUpButton.setEnabled(false);
            OutlookTabbedPane.this._moveUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = OutlookTabbedPane.this._list.getSelectedIndex();
                    if (n > 0) {
                        int n2;
                        String string = OutlookTabbedPane.this._newTabOrder[n];
                        boolean[] blArray = new boolean[OutlookTabbedPane.this._list.getModel().getSize()];
                        for (n2 = 0; n2 < blArray.length; ++n2) {
                            blArray[n2] = OutlookTabbedPane.this._list.getCheckBoxListSelectionModel().isSelectedIndex(n2);
                        }
                        ((OutlookTabbedPane)OutlookTabbedPane.this)._newTabOrder[n] = OutlookTabbedPane.this._newTabOrder[n - 1];
                        ((OutlookTabbedPane)OutlookTabbedPane.this)._newTabOrder[n - 1] = string;
                        n2 = blArray[n];
                        blArray[n] = blArray[n - 1];
                        blArray[n - 1] = n2;
                        OutlookTabbedPane.this._listModel = OptionDialog.this.createListModel(OutlookTabbedPane.this._newTabOrder);
                        OutlookTabbedPane.this._list.setModel(OutlookTabbedPane.this._listModel);
                        OutlookTabbedPane.this._list.setSelectedIndex(n - 1);
                        OutlookTabbedPane.this._list.getCheckBoxListSelectionModel().clearSelection();
                        for (int i = 0; i < blArray.length; ++i) {
                            if (!blArray[i]) continue;
                            OutlookTabbedPane.this._list.getCheckBoxListSelectionModel().addSelectionInterval(i, i);
                        }
                    }
                }
            });
            OutlookTabbedPane.this._moveDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = OutlookTabbedPane.this._list.getSelectedIndex();
                    if (n >= 0) {
                        int n2;
                        String string = OutlookTabbedPane.this._newTabOrder[n];
                        boolean[] blArray = new boolean[OutlookTabbedPane.this._list.getModel().getSize()];
                        for (n2 = 0; n2 < blArray.length; ++n2) {
                            blArray[n2] = OutlookTabbedPane.this._list.getCheckBoxListSelectionModel().isSelectedIndex(n2);
                        }
                        ((OutlookTabbedPane)OutlookTabbedPane.this)._newTabOrder[n] = OutlookTabbedPane.this._newTabOrder[n + 1];
                        ((OutlookTabbedPane)OutlookTabbedPane.this)._newTabOrder[n + 1] = string;
                        n2 = blArray[n];
                        blArray[n] = blArray[n + 1];
                        blArray[n + 1] = n2;
                        OutlookTabbedPane.this._listModel = OptionDialog.this.createListModel(OutlookTabbedPane.this._newTabOrder);
                        OutlookTabbedPane.this._list.setModel(OutlookTabbedPane.this._listModel);
                        OutlookTabbedPane.this._list.setSelectedIndex(n + 1);
                        OutlookTabbedPane.this._list.getCheckBoxListSelectionModel().clearSelection();
                        for (int i = 0; i < blArray.length; ++i) {
                            if (!blArray[i]) continue;
                            OutlookTabbedPane.this._list.getCheckBoxListSelectionModel().addSelectionInterval(i, i);
                        }
                    }
                }
            });
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutlookTabbedPane.access$1902(OutlookTabbedPane.this, OutlookTabbedPane.this.createTitles(OutlookTabbedPane.this._titles));
                    OutlookTabbedPane.this._listModel = OptionDialog.this.createListModel(OutlookTabbedPane.this._titles);
                    OutlookTabbedPane.this._list.setModel(OutlookTabbedPane.this._listModel);
                    OptionDialog.this.updateSelection(OutlookTabbedPane.this._list);
                }
            });
            return buttonPanel;
        }

        @Override
        public ButtonPanel createButtonPanel() {
            ButtonPanel buttonPanel = new ButtonPanel();
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 6, 10));
            AbstractAction abstractAction = new AbstractAction(JideSwingUtilities.getOKString(OutlookTabbedPane.this.getLocale())){
                private static final long serialVersionUID = -8178607506407332812L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutlookTabbedPane.this.updateTabOrder(OutlookTabbedPane.this._newTabOrder, true);
                    OutlookTabbedPane.this.dialog.setVisible(false);
                }
            };
            AbstractAction abstractAction2 = new AbstractAction(JideSwingUtilities.getCancelString(OutlookTabbedPane.this.getLocale())){
                private static final long serialVersionUID = -6132647786506392019L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutlookTabbedPane.this.dialog.setVisible(false);
                }
            };
            JButton jButton = new JButton(abstractAction);
            buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
            buttonPanel.addButton((AbstractButton)new JButton(abstractAction2), "CANCEL");
            this.setDefaultCancelAction(abstractAction2);
            this.setDefaultAction(abstractAction);
            this.getRootPane().setDefaultButton(jButton);
            return buttonPanel;
        }

        protected void updateSelection(CheckBoxList checkBoxList) {
            checkBoxList.getCheckBoxListSelectionModel().clearSelection();
            for (int i = 0; i < checkBoxList.getModel().getSize(); ++i) {
                boolean bl = ((AbstractButton)OutlookTabbedPane.this._buttons.elementAt(i)).isVisible();
                if (!bl) continue;
                checkBoxList.getCheckBoxListSelectionModel().addSelectionInterval(i, i);
            }
        }

        protected ListModel createListModel(Vector<String> vector) {
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (String string : vector) {
                defaultListModel.addElement(string);
            }
            return defaultListModel;
        }

        protected ListModel createListModel(String[] stringArray) {
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            for (String string : stringArray) {
                defaultListModel.addElement(string);
            }
            return defaultListModel;
        }

        @Override
        public JComponent createBannerPanel() {
            return null;
        }

        @Override
        public JComponent createContentPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(12, 12));
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 6, 6, 6), new JideTitledBorder(new PartialEtchedBorder(1, 1), OutlookTabbedPane.this.getResourceString("OutlookTabbedPane.display"))));
            ButtonPanel buttonPanel = this.createRearrangeButtonPanel();
            jPanel.add((Component)buttonPanel, "After");
            OutlookTabbedPane.this._listModel = this.createListModel(OutlookTabbedPane.this._titles);
            OutlookTabbedPane.this._list = new CheckBoxList(OutlookTabbedPane.this._listModel){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dimension = super.getPreferredScrollableViewportSize();
                    if (dimension.width < 200) {
                        dimension.width = 200;
                    }
                    return dimension;
                }
            };
            OutlookTabbedPane.this._list.setVisibleRowCount(8);
            OutlookTabbedPane.this._list.setSelectionMode(0);
            OutlookTabbedPane.this._list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = OutlookTabbedPane.this._list.getSelectedIndex();
                    if (OutlookTabbedPane.this._moveUpButton != null) {
                        OutlookTabbedPane.this._moveUpButton.setEnabled(n != 0);
                    }
                    if (OutlookTabbedPane.this._moveDownButton != null) {
                        OutlookTabbedPane.this._moveDownButton.setEnabled(n != OutlookTabbedPane.this._listModel.getSize() - 1);
                    }
                }
            });
            this.updateSelection(OutlookTabbedPane.this._list);
            OutlookTabbedPane.this._list.setSelectedIndex(0);
            jPanel.add(new JScrollPane(OutlookTabbedPane.this._list));
            OutlookTabbedPane.access$1902(OutlookTabbedPane.this, OutlookTabbedPane.this.createTitles(OutlookTabbedPane.this._titles));
            return jPanel;
        }
    }

    private class OutlookTabbedPaneLayout
    implements LayoutManager {
        private OutlookTabbedPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                if (!(container instanceof OutlookTabbedPane)) {
                    return new Dimension(0, 0);
                }
                OutlookTabbedPane outlookTabbedPane = (OutlookTabbedPane)container;
                if (outlookTabbedPane.getButtons().size() == 0) {
                    return new Dimension(0, 0);
                }
                JButton jButton = (JButton)outlookTabbedPane.getButtons().elementAt(0);
                OutlookTabbedPane.this.customizeButton(jButton);
                Dimension dimension = jButton.getPreferredSize();
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < outlookTabbedPane.getButtons().size(); ++i) {
                    int n3;
                    int n4 = outlookTabbedPane.getButtons().elementAt((int)i).getPreferredSize().width;
                    if (n4 > n) {
                        n = n4;
                    }
                    Component component = outlookTabbedPane.getComponentAt(i);
                    int n5 = component.getPreferredSize().width;
                    if (n5 > n) {
                        n = n5;
                    }
                    if ((n3 = component.getPreferredSize().height) <= n2) continue;
                    n2 = n3;
                }
                return new Dimension(n, outlookTabbedPane.getTabCount() * dimension.height + n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                if (!(container instanceof OutlookTabbedPane)) {
                    return new Dimension(0, 0);
                }
                OutlookTabbedPane outlookTabbedPane = (OutlookTabbedPane)container;
                if (outlookTabbedPane.getButtons().size() == 0) {
                    return new Dimension(0, 0);
                }
                JButton jButton = (JButton)outlookTabbedPane.getButtons().elementAt(0);
                OutlookTabbedPane.this.customizeButton(jButton);
                Dimension dimension = jButton.getMinimumSize();
                int n = 0;
                int n2 = 0;
                for (int i = 0; i < outlookTabbedPane.getButtons().size(); ++i) {
                    int n3;
                    int n4 = outlookTabbedPane.getButtons().elementAt((int)i).getMinimumSize().width;
                    if (n4 > n) {
                        n = n4;
                    }
                    Component component = outlookTabbedPane.getComponentAt(i);
                    int n5 = component.getMinimumSize().width;
                    if (n5 > n) {
                        n = n5;
                    }
                    if ((n3 = component.getMinimumSize().height) <= n2) continue;
                    n2 = n3;
                }
                return new Dimension(n, outlookTabbedPane.getTabCount() * dimension.height + n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                ArrayList<Component> arrayList;
                int n;
                int n2;
                int n3;
                JButton jButton;
                if (!(container instanceof OutlookTabbedPane)) {
                    return;
                }
                if (OutlookTabbedPane.this._updating) {
                    return;
                }
                OutlookTabbedPane outlookTabbedPane = (OutlookTabbedPane)container;
                int n4 = outlookTabbedPane.getSelectedIndex();
                Component component = OutlookTabbedPane.this.getVisibleComponent();
                Component component2 = n4 == -1 ? null : outlookTabbedPane.getComponentAt(n4);
                boolean bl = false;
                if (component2 != null) {
                    if (component2 != component && component != null && JideSwingUtilities.isAncestorOfFocusOwner(component)) {
                        bl = true;
                    }
                    OutlookTabbedPane.this.setVisibleComponent(component2);
                }
                Insets insets = outlookTabbedPane.getInsets();
                int n5 = outlookTabbedPane.getWidth() - insets.left - insets.right;
                OutlookTabbedPane.this._leftPanel.setPreferredSize(new Dimension(n5 - 20, OutlookTabbedPane.this.getButtonPanelHeight()));
                OutlookTabbedPane.this._chevron.setPreferredSize(new Dimension(20, 24));
                int[] nArray = OutlookTabbedPane.this.createCounts();
                if (outlookTabbedPane.getButtons().size() - OutlookTabbedPane.this._hiddenTabs.size() <= 0) {
                    int n6;
                    if (outlookTabbedPane.getTabPlacement() == 1) {
                        n6 = insets.top;
                        OutlookTabbedPane.this._bottomPanel.setBounds(insets.left, n6, n5, OutlookTabbedPane.this.getButtonPanelHeight());
                        OutlookTabbedPane.this._divider.setBounds(insets.left, n6 + OutlookTabbedPane.this.getButtonPanelHeight(), n5, OutlookTabbedPane.this._dividerHeight);
                    } else {
                        n6 = outlookTabbedPane.getHeight() - insets.top - insets.bottom - OutlookTabbedPane.this.getButtonPanelHeight() - OutlookTabbedPane.this._dividerHeight;
                        int n7 = insets.top + n6;
                        OutlookTabbedPane.this._divider.setBounds(insets.left, n7, n5, OutlookTabbedPane.this._dividerHeight);
                        OutlookTabbedPane.this._bottomPanel.setBounds(insets.left, outlookTabbedPane.getHeight() - insets.bottom - OutlookTabbedPane.this.getButtonPanelHeight(), n5, OutlookTabbedPane.this.getButtonPanelHeight());
                    }
                    for (n6 = 0; n6 < outlookTabbedPane.getTabCount(); ++n6) {
                        outlookTabbedPane.getComponentAt(n6).setVisible(false);
                    }
                    return;
                }
                if (OutlookTabbedPane.this.getTabCount() > 0) {
                    jButton = (JButton)OutlookTabbedPane.this.createButton(OutlookTabbedPane.this.createSwitchPageAction(OutlookTabbedPane.this.getTitleAt(0), OutlookTabbedPane.this.getIconAt(0), 0));
                    n3 = jButton.getPreferredSize().height;
                } else {
                    jButton = (JButton)OutlookTabbedPane.this.createButton(OutlookTabbedPane.this.createSwitchPageAction("Test", null, 0));
                    n3 = jButton.getPreferredSize().height;
                }
                int n8 = nArray.length;
                int n9 = OutlookTabbedPane.this.getBottomButtonCount();
                if (n9 > 0) {
                    n8 = n8 >= n9 ? (n8 -= n9) : 0;
                }
                int n10 = n8 * n3;
                int n11 = outlookTabbedPane.getHeight() - insets.top - insets.bottom - n10 - OutlookTabbedPane.this.getButtonPanelHeight() - OutlookTabbedPane.this._dividerHeight;
                if (outlookTabbedPane.getTabPlacement() == 1) {
                    n2 = insets.top;
                    OutlookTabbedPane.this._bottomPanel.setBounds(insets.left, n2 + n10, n5, OutlookTabbedPane.this.getButtonPanelHeight());
                    OutlookTabbedPane.this._divider.setBounds(insets.left, n2 + n10 + OutlookTabbedPane.this.getButtonPanelHeight(), n5, OutlookTabbedPane.this._dividerHeight);
                } else {
                    n2 = insets.top + n11;
                    OutlookTabbedPane.this._divider.setBounds(insets.left, n2, n5, OutlookTabbedPane.this._dividerHeight);
                    OutlookTabbedPane.this._bottomPanel.setBounds(insets.left, outlookTabbedPane.getHeight() - insets.bottom - OutlookTabbedPane.this.getButtonPanelHeight(), n5, OutlookTabbedPane.this.getButtonPanelHeight());
                    n2 += OutlookTabbedPane.this._dividerHeight;
                }
                for (n = 0; n < n8; ++n) {
                    AbstractButton abstractButton = (AbstractButton)OutlookTabbedPane.this._buttons.elementAt(nArray[n]);
                    abstractButton.setVisible(true);
                    if ("".equals(abstractButton.getText()) || OutlookTabbedPane.this._buttonPanel.isAncestorOf(abstractButton)) {
                        abstractButton.setVisible(false);
                        if (abstractButton.getParent() != null) {
                            abstractButton.getParent().remove(abstractButton);
                        }
                        arrayList = (String)OutlookTabbedPane.this._titles.elementAt(nArray[n]);
                        Icon icon = OutlookTabbedPane.this.getIconAt(nArray[n]);
                        String object22 = OutlookTabbedPane.this.getToolTipTextAt(nArray[n]);
                        int n6 = OutlookTabbedPane.this.getMnemonicAt(nArray[n]);
                        OutlookTabbedPane.this._buttons.remove(nArray[n]);
                        abstractButton = OutlookTabbedPane.this.createButton(OutlookTabbedPane.this.createSwitchPageAction((String)((Object)arrayList), icon, nArray[n]));
                        abstractButton.setToolTipText(object22);
                        abstractButton.setMnemonic(n6);
                        abstractButton.setCursor(Cursor.getPredefinedCursor(12));
                        OutlookTabbedPane.this._buttons.insertElementAt(abstractButton, nArray[n]);
                        if (nArray[n] == OutlookTabbedPane.this.getSelectedIndex()) {
                            abstractButton.setSelected(true);
                        }
                        OutlookTabbedPane.this.add(abstractButton);
                        abstractButton.setBounds(insets.left, n2, n5, n3);
                    } else {
                        abstractButton.setBounds(insets.left, n2, n5, n3);
                    }
                    abstractButton.setEnabled(OutlookTabbedPane.this.isEnabledAt(n));
                    n2 += n3;
                    arrayList = outlookTabbedPane.getComponentAt(nArray[n]);
                    if (OutlookTabbedPane.this.getSelectedIndex() == nArray[n]) {
                        abstractButton.setSelected(true);
                        continue;
                    }
                    abstractButton.setSelected(false);
                    ((Component)((Object)arrayList)).setBounds(insets.left, 0, n5, 0);
                    ((Component)((Object)arrayList)).setVisible(false);
                }
                if (component2 != null) {
                    if (OutlookTabbedPane.this.getTabPlacement() == 1) {
                        component2.setBounds(insets.left, insets.top + OutlookTabbedPane.this.getButtonPanelHeight() + OutlookTabbedPane.this._dividerHeight + n10, n5, n11);
                    } else {
                        component2.setBounds(insets.left, insets.top, n5, n11);
                    }
                    component2.setVisible(true);
                }
                OutlookTabbedPane.this._tabCount = 0;
                if (n5 - OutlookTabbedPane.this.getButtonPanelHeight() < (nArray.length - n8) * 25) {
                    n = (nArray.length - n8) * 25 - (n5 - OutlookTabbedPane.this.getButtonPanelHeight());
                    int n13 = 0;
                    if (n % 25 > 0) {
                        n13 = 1;
                    }
                    OutlookTabbedPane.this._tabCount = n / 25 + n13;
                }
                OutlookTabbedPane.this._buttonPanel.setPreferredSize(new Dimension((nArray.length - n8 - OutlookTabbedPane.this._tabCount) * 25, OutlookTabbedPane.this.getButtonPanelHeight()));
                OutlookTabbedPane.this._buttonPanel.setSize(new Dimension((nArray.length - n8 - OutlookTabbedPane.this._tabCount) * 25, OutlookTabbedPane.this.getButtonPanelHeight()));
                Component[] componentArray = OutlookTabbedPane.this._buttonPanel.getComponents();
                arrayList = new ArrayList<Component>();
                arrayList.addAll(Arrays.asList(componentArray));
                for (int i = nArray.length - OutlookTabbedPane.this._tabCount - 1; i >= n8; --i) {
                    JButton jButton2 = (JButton)OutlookTabbedPane.this._buttons.elementAt(nArray[i]);
                    jButton2.setText("");
                    String string = OutlookTabbedPane.this.getToolTipTextAt(nArray[i]);
                    jButton2.setToolTipText(string != null && string.trim().length() > 0 ? string : OutlookTabbedPane.this.getTitleAt(nArray[i]));
                    OutlookTabbedPane.this.customizeBottomButton(jButton2);
                    jButton2.setVisible(true);
                    Component component3 = outlookTabbedPane.getComponentAt(nArray[i]);
                    OutlookTabbedPane.this._buttonPanel.remove(jButton2);
                    OutlookTabbedPane.this._buttonPanel.add((Component)jButton2, 0);
                    arrayList.remove(jButton2);
                    if (outlookTabbedPane.getSelectedIndex() == nArray[i]) {
                        jButton2.setSelected(true);
                        if (OutlookTabbedPane.this.getTabPlacement() == 1) {
                            component3.setBounds(insets.left, outlookTabbedPane.getHeight() - n11 - insets.bottom, n5, n11);
                        } else {
                            component3.setBounds(insets.left, insets.top, n5, n11);
                        }
                        component3.setVisible(true);
                        continue;
                    }
                    jButton2.setSelected(false);
                    component3.setBounds(insets.left, 0, n5, 0);
                    component3.setVisible(false);
                }
                for (Component component4 : arrayList) {
                    OutlookTabbedPane.this._buttonPanel.remove(component4);
                }
                if (bl && !OutlookTabbedPane.this.requestFocusForVisibleComponent()) {
                    outlookTabbedPane.requestFocus();
                }
            }
        }
    }

    private class Divider
    extends JComponent
    implements UIResource {
        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            OutlookTabbedPane.this._painter.paintDividerBackground(this, graphics, rectangle, 1, 0);
            OutlookTabbedPane.this._painter.paintGripper(this, graphics, rectangle, 1, 0);
        }
    }

    public class MouseHandler
    extends MouseInputAdapter {
        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            OutlookTabbedPane.this.setCursor(Cursor.getPredefinedCursor(9));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!OutlookTabbedPane.this.flag) {
                OutlookTabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            OutlookTabbedPane.this.setCursor(Cursor.getPredefinedCursor(9));
            OutlookTabbedPane.this.p = new Point(mouseEvent.getX(), mouseEvent.getY());
            OutlookTabbedPane.this.flag = true;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            OutlookTabbedPane.this.setCursor(Cursor.getPredefinedCursor(0));
            OutlookTabbedPane.this.flag = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            OutlookTabbedPane.this.setCursor(Cursor.getPredefinedCursor(9));
            OutlookTabbedPane.this.flag = true;
            if (OutlookTabbedPane.this._buttons.size() == 0) {
                return;
            }
            Rectangle rectangle = null;
            for (n = 0; n < OutlookTabbedPane.this._buttons.size(); ++n) {
                if (!OutlookTabbedPane.this.isTabVisibleAt(n)) continue;
                Rectangle rectangle2 = ((AbstractButton)OutlookTabbedPane.this._buttons.elementAt(n)).getBounds();
                if (rectangle2.height == 0) continue;
                rectangle = rectangle2;
            }
            if (rectangle != null) {
                n = OutlookTabbedPane.this.getBottomButtonCount();
                if (OutlookTabbedPane.this.getTabPlacement() == 1) {
                    if (OutlookTabbedPane.this.p.y - mouseEvent.getY() > rectangle.height && n < OutlookTabbedPane.this._buttons.size() - OutlookTabbedPane.this._hiddenTabs.size()) {
                        OutlookTabbedPane.this.setBottomButtonCount(n + 1);
                    }
                    if (OutlookTabbedPane.this.p.y + mouseEvent.getY() > rectangle.height && n > 0) {
                        OutlookTabbedPane.this.setBottomButtonCount(n - 1);
                    }
                } else {
                    if (OutlookTabbedPane.this.p.y + mouseEvent.getY() > rectangle.height && n < OutlookTabbedPane.this._buttons.size() - OutlookTabbedPane.this._hiddenTabs.size()) {
                        OutlookTabbedPane.this.setBottomButtonCount(n + 1);
                    }
                    if (OutlookTabbedPane.this.p.y - mouseEvent.getY() > rectangle.height && n > 0) {
                        OutlookTabbedPane.this.setBottomButtonCount(n - 1);
                    }
                }
            }
        }
    }

    private class ChevronActionListener
    implements ActionListener {
        private ChevronActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JPopupMenu jPopupMenu = OutlookTabbedPane.this.createPopupMenu();
            if (jPopupMenu != null && jPopupMenu.getComponentCount() > 0) {
                Point point = new Point(OutlookTabbedPane.this._chevron.getWidth() / 2, OutlookTabbedPane.this._chevron.getHeight() / 2 - (OutlookTabbedPane.this.getTabPlacement() == 1 ? 0 : jPopupMenu.getPreferredSize().height));
                JideSwingUtilities.showPopupMenu(jPopupMenu, OutlookTabbedPane.this._chevron, point.x, point.y);
            }
        }
    }

    private class BottomPanel
    extends JPanel
    implements UIResource {
        private BottomPanel() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            OutlookTabbedPane.this._painter.paintButtonBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), 0, 0, false);
        }
    }

    public class OutlookButton
    extends JideButton
    implements UIResource {
        public OutlookButton(Action action) {
            super(action);
        }
    }

    private class SwitchPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 2148707106607734892L;

        public SwitchPageAction(String string, Icon icon) {
            super(string, icon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = OutlookTabbedPane.this._buttons.indexOf(actionEvent.getSource());
            if (n == -1) {
                return;
            }
            if (OutlookTabbedPane.this.getSelectedIndex() == n) {
                return;
            }
            OutlookTabbedPane.this.setSelectedIndex(n);
        }
    }
}

