/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.animation.CustomAnimation;
import com.jidesoft.animation.Function;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.JideButton;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class FloorTabbedPane
extends JTabbedPane {
    protected Vector<AbstractButton> _buttons;
    protected int _percentage = 100;
    protected int _nextIndex = -1;
    protected int _prevIndex = -1;
    private int _initDelay = 50;
    private int _stepDelay = 5;
    private int _steps = 50;
    private Function _animationFunction;
    public static String PERCENTAGE_PROPERTY;
    public static String PROPERTY_ORIENTATION;
    private int _orientation = 1;

    public FloorTabbedPane() {
        this.setFocusable(true);
        this._buttons = new Vector();
        this.setLayout(this.createLayout());
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    public FloorTabbedPane(int n, int n2, int n3) {
        this();
        this._steps = n3;
        this._stepDelay = n2;
        this._initDelay = n;
    }

    @Override
    public void updateUI() {
        Component component;
        int n;
        if (this._buttons != null) {
            for (n = 0; n < this._buttons.size(); ++n) {
                component = this._buttons.elementAt(n);
                ((AbstractButton)component).updateUI();
            }
        }
        for (n = 0; n < this.getTabCount(); ++n) {
            component = this.getComponentAt(n);
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
        }
    }

    protected LayoutManager createLayout() {
        return new FloorTabbedPaneLayout();
    }

    protected Action createSwitchPageAction(String string, Icon icon, int n) {
        return new SwitchPageAction(string, icon, n);
    }

    public int getPercentage() {
        return this._percentage;
    }

    private void setPercentage(int n) {
        int n2 = this._percentage;
        if (this._percentage != n) {
            this._percentage = n;
            this.firePropertyChange(PERCENTAGE_PROPERTY, n2, this._percentage);
        }
    }

    public Vector<AbstractButton> getButtons() {
        return this._buttons;
    }

    public int getPrevIndex() {
        return this._prevIndex;
    }

    private void setPrevIndex(int n) {
        this._prevIndex = n;
    }

    public int getNextIndex() {
        return this._nextIndex;
    }

    private void setNextIndex(int n) {
        this._nextIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTabAt(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            AbstractButton abstractButton = this._buttons.elementAt(n);
            int n2 = this.getSelectedIndex();
            if (n2 >= this.getTabCount() - 1) {
                this.setSelectedIndex(n2 - 1);
            }
            this._buttons.removeElementAt(n);
            this.remove(abstractButton);
            int n3 = this._buttons.size();
            for (int i = n; i < n3; ++i) {
                abstractButton = this._buttons.elementAt(i);
                SwitchPageAction switchPageAction = (SwitchPageAction)abstractButton.getAction();
                switchPageAction.setIndex(i);
            }
            super.removeTabAt(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.insertTab(string, icon, component, string2, n);
            AbstractButton abstractButton = this.createButton(this.createSwitchPageAction(string, icon, n));
            if (!(abstractButton instanceof UIResource)) {
                throw new IllegalArgumentException("The button returned from createButton(Action action) method is not an instance of UIResource.");
            }
            if (abstractButton instanceof Alignable) {
                ((Alignable)((Object)abstractButton)).setOrientation(this.adjustOrientation(this.getOrientation()));
            }
            abstractButton.setName(string);
            abstractButton.setToolTipText(string2);
            this.customizeButton(abstractButton);
            this._buttons.insertElementAt(abstractButton, n);
            this.add(abstractButton);
            this.setPercentage(0);
            component.setVisible(true);
            int n2 = this._buttons.size();
            for (int i = n; i < n2; ++i) {
                abstractButton = this._buttons.elementAt(i);
                SwitchPageAction switchPageAction = (SwitchPageAction)abstractButton.getAction();
                switchPageAction.setIndex(i);
            }
            this.updateButtonSelectionState(this.getSelectedIndex());
        }
    }

    protected AbstractButton createButton(Action action) {
        return new FloorButton(action);
    }

    private int adjustOrientation(int n) {
        return n == 1 ? 0 : 1;
    }

    @Override
    public void setSelectedIndex(int n) {
        int n2 = this.getSelectedIndex();
        if (n2 != -1) {
            this.setPrevIndex(n2);
        }
        super.setSelectedIndex(n);
        if (n >= 0) {
            this.setNextIndex(n);
        }
        this.animate();
        this.updateButtonSelectionState(n);
    }

    protected void updateButtonSelectionState(int n) {
        Vector<AbstractButton> vector = this.getButtons();
        for (int i = 0; i < vector.size(); ++i) {
            AbstractButton abstractButton = vector.get(i);
            abstractButton.setSelected(i == n);
        }
    }

    private void animate() {
        Animator animator = new Animator(this, this._initDelay, this._stepDelay, this._steps);
        animator.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
                if (component instanceof FloorTabbedPane) {
                    ((FloorTabbedPane)component).setPercentage(100);
                }
            }

            @Override
            public void animationFrame(Component component, int n, int n2) {
                if (n == 0) {
                    return;
                }
                if (component instanceof FloorTabbedPane) {
                    FloorTabbedPane floorTabbedPane = (FloorTabbedPane)component;
                    double d = FloorTabbedPane.this.getAnimationFunction().calculate(n2, n);
                    int n3 = (int)(100.0 * (1.0 - d));
                    floorTabbedPane.setPercentage(n3);
                    floorTabbedPane.invalidate();
                    floorTabbedPane.validate();
                }
            }

            @Override
            public void animationEnds(Component component) {
                if (component instanceof FloorTabbedPane) {
                    FloorTabbedPane floorTabbedPane = (FloorTabbedPane)component;
                    floorTabbedPane.setPercentage(0);
                    floorTabbedPane.invalidate();
                    floorTabbedPane.validate();
                }
            }
        });
        animator.start();
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.getButtons().size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Tab count: " + this.getButtons().size());
        }
    }

    @Override
    public int getMnemonicAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getMnemonic();
    }

    @Override
    public void setMnemonicAt(int n, int n2) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setMnemonic(n2);
        super.setMnemonicAt(n, n2);
    }

    @Override
    public int getDisplayedMnemonicIndexAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getDisplayedMnemonicIndex();
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int n, int n2) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setDisplayedMnemonicIndex(n2);
        super.setDisplayedMnemonicIndexAt(n, n2);
    }

    @Override
    public void setTitleAt(int n, String string) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setText(string);
        super.setTitleAt(n, string);
    }

    @Override
    public String getTitleAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getText();
    }

    @Override
    public Icon getIconAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getIcon();
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setIcon(icon);
        super.setIconAt(n, icon);
    }

    @Override
    public Icon getDisabledIconAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getDisabledIcon();
    }

    @Override
    public void setDisabledIconAt(int n, Icon icon) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setDisabledIcon(icon);
        super.setDisabledIconAt(n, icon);
    }

    @Override
    public String getToolTipTextAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getToolTipText();
    }

    @Override
    public void setToolTipTextAt(int n, String string) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setToolTipText(string);
        super.setToolTipTextAt(n, string);
    }

    @Override
    public boolean isEnabledAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.isEnabled();
    }

    @Override
    public void setEnabledAt(int n, boolean bl) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setEnabled(bl);
        super.setEnabledAt(n, bl);
    }

    @Override
    public void setForegroundAt(int n, Color color) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setForeground(color);
        super.setForegroundAt(n, color);
    }

    @Override
    public Color getForegroundAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getForeground();
    }

    @Override
    public void setBackgroundAt(int n, Color color) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setBackground(color);
        super.setBackgroundAt(n, color);
    }

    @Override
    public Color getBackgroundAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getBackground();
    }

    public int getInitDelay() {
        return this._initDelay;
    }

    public void setInitDelay(int n) {
        this._initDelay = n;
    }

    public int getStepDelay() {
        return this._stepDelay;
    }

    public void setStepDelay(int n) {
        this._stepDelay = n;
    }

    public int getSteps() {
        return this._steps;
    }

    public void setSteps(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Steps can not be less than zero. Please pass in non-negative integer.");
        }
        this._steps = n;
    }

    public Function getAnimationFunction() {
        return this._animationFunction == null ? CustomAnimation.FUNC_POW2 : this._animationFunction;
    }

    public void setAnimationFunction(Function function) {
        this._animationFunction = function;
    }

    protected void customizeButton(AbstractButton abstractButton) {
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void setOrientation(int n) {
        if (this._orientation != n) {
            int n2 = this._orientation;
            this._orientation = n;
            this.firePropertyChange(PROPERTY_ORIENTATION, n2, this._orientation);
            for (AbstractButton abstractButton : this._buttons) {
                if (!(abstractButton instanceof Alignable)) continue;
                ((Alignable)((Object)abstractButton)).setOrientation(this.adjustOrientation(this.getOrientation()));
            }
            this.revalidate();
            this.doLayout();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
        }
        return this.accessibleContext;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(FloorTabbedPane.class.getName(), 2);
        }
        PERCENTAGE_PROPERTY = "percentage";
        PROPERTY_ORIENTATION = "orientation";
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        private static final long serialVersionUID = -60018244891799895L;

        public AccessibleJTabbedPane() {
            super(FloorTabbedPane.this);
            FloorTabbedPane.this.model.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return FloorTabbedPane.this.getTabCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= FloorTabbedPane.this.getTabCount()) {
                return null;
            }
            return (Accessible)((Object)FloorTabbedPane.this._buttons.elementAt(n));
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            int n = ((TabbedPaneUI)FloorTabbedPane.this.ui).tabForCoordinate(FloorTabbedPane.this, point.x, point.y);
            if (n == -1) {
                n = FloorTabbedPane.this.getSelectedIndex();
            }
            return this.getAccessibleChild(n);
        }

        @Override
        public int getAccessibleSelectionCount() {
            return 1;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            int n2 = FloorTabbedPane.this.getSelectedIndex();
            if (n2 == -1) {
                return null;
            }
            return (Accessible)((Object)FloorTabbedPane.this._buttons.elementAt(n2));
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            return n == FloorTabbedPane.this.getSelectedIndex();
        }

        @Override
        public void addAccessibleSelection(int n) {
            FloorTabbedPane.this.setSelectedIndex(n);
        }

        @Override
        public void removeAccessibleSelection(int n) {
        }

        @Override
        public void clearAccessibleSelection() {
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    private class FloorTabbedPaneLayout
    implements LayoutManager {
        private FloorTabbedPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                if (!(container instanceof FloorTabbedPane)) {
                    return new Dimension(0, 0);
                }
                FloorTabbedPane floorTabbedPane = (FloorTabbedPane)container;
                if (floorTabbedPane.getButtons().size() == 0) {
                    return new Dimension(0, 0);
                }
                JButton jButton = (JButton)floorTabbedPane.getButtons().elementAt(0);
                FloorTabbedPane.this.customizeButton(jButton);
                Dimension dimension = jButton.getPreferredSize();
                int n = 0;
                int n2 = 0;
                if (FloorTabbedPane.this.getOrientation() == 1) {
                    for (int i = 0; i < floorTabbedPane.getButtons().size(); ++i) {
                        int n3;
                        int n4 = floorTabbedPane.getButtons().elementAt((int)i).getPreferredSize().width;
                        if (n4 > n) {
                            n = n4;
                        }
                        Component component = floorTabbedPane.getComponentAt(i);
                        int n5 = component.getPreferredSize().width;
                        if (n5 > n) {
                            n = n5;
                        }
                        if ((n3 = component.getPreferredSize().height) <= n2) continue;
                        n2 = n3;
                    }
                    return new Dimension(n, floorTabbedPane.getTabCount() * dimension.height + n2);
                }
                for (int i = 0; i < floorTabbedPane.getButtons().size(); ++i) {
                    int n6;
                    int n7 = floorTabbedPane.getButtons().elementAt((int)i).getPreferredSize().height;
                    if (n7 > n2) {
                        n2 = n7;
                    }
                    Component component = floorTabbedPane.getComponentAt(i);
                    int n8 = component.getPreferredSize().height;
                    if (n8 > n2) {
                        n2 = n8;
                    }
                    if ((n6 = component.getPreferredSize().width) <= n) continue;
                    n = n6;
                }
                return new Dimension(floorTabbedPane.getTabCount() * dimension.width + n, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                if (!(container instanceof FloorTabbedPane)) {
                    return new Dimension(0, 0);
                }
                FloorTabbedPane floorTabbedPane = (FloorTabbedPane)container;
                if (floorTabbedPane.getButtons().size() == 0) {
                    return new Dimension(0, 0);
                }
                JButton jButton = (JButton)floorTabbedPane.getButtons().elementAt(0);
                FloorTabbedPane.this.customizeButton(jButton);
                Dimension dimension = jButton.getMinimumSize();
                int n = 0;
                int n2 = 0;
                if (FloorTabbedPane.this.getOrientation() == 1) {
                    for (int i = 0; i < floorTabbedPane.getButtons().size(); ++i) {
                        int n3;
                        int n4 = floorTabbedPane.getButtons().elementAt((int)i).getMinimumSize().width;
                        if (n4 > n) {
                            n = n4;
                        }
                        Component component = floorTabbedPane.getComponentAt(i);
                        int n5 = component.getMinimumSize().width;
                        if (n5 > n) {
                            n = n5;
                        }
                        if ((n3 = component.getMinimumSize().height) <= n2) continue;
                        n2 = n3;
                    }
                    return new Dimension(n, floorTabbedPane.getTabCount() * dimension.height + n2);
                }
                for (int i = 0; i < floorTabbedPane.getButtons().size(); ++i) {
                    int n6;
                    int n7 = floorTabbedPane.getButtons().elementAt((int)i).getMinimumSize().height;
                    if (n7 > n2) {
                        n2 = n7;
                    }
                    Component component = floorTabbedPane.getComponentAt(i);
                    int n8 = component.getMinimumSize().height;
                    if (n8 > n2) {
                        n2 = n8;
                    }
                    if ((n6 = component.getMinimumSize().width) <= n) continue;
                    n = n6;
                }
                return new Dimension(floorTabbedPane.getTabCount() * dimension.width + n, n2);
            }
        }

        @Override
        public void layoutContainer(Container container) {
            if (!(container instanceof FloorTabbedPane)) {
                return;
            }
            FloorTabbedPane floorTabbedPane = (FloorTabbedPane)container;
            if (floorTabbedPane.getButtons().size() == 0) {
                return;
            }
            Insets insets = floorTabbedPane.getInsets();
            Vector<AbstractButton> vector = floorTabbedPane.getButtons();
            if (FloorTabbedPane.this.getOrientation() == 1) {
                int n = floorTabbedPane.getWidth() - insets.left - insets.right;
                int n2 = floorTabbedPane.getButtons().elementAt((int)0).getPreferredSize().height;
                int n3 = floorTabbedPane.getHeight() - insets.top - insets.bottom - vector.size() * n2;
                int n4 = FloorTabbedPane.this.getPercentage() * n3 / 100;
                int n5 = n3 - n4;
                int n6 = insets.top;
                for (int i = 0; i < vector.size(); ++i) {
                    JButton jButton = (JButton)vector.elementAt(i);
                    jButton.setBounds(insets.left, n6, n, n2);
                    n6 += n2;
                    Component component = floorTabbedPane.getComponentAt(i);
                    if (floorTabbedPane.getPrevIndex() == i && floorTabbedPane.getNextIndex() != i) {
                        component.setBounds(insets.left, n6, n, n4);
                        component.setVisible(true);
                        n6 += n4;
                        continue;
                    }
                    if (floorTabbedPane.getNextIndex() == i) {
                        component.setBounds(insets.left, n6, n, n5);
                        component.setVisible(true);
                        n6 += n5;
                        continue;
                    }
                    component.setBounds(insets.left, n6, n, 0);
                    component.setVisible(false);
                }
            } else {
                int n = floorTabbedPane.getHeight() - insets.top - insets.bottom;
                int n7 = floorTabbedPane.getButtons().elementAt((int)0).getPreferredSize().width;
                int n8 = floorTabbedPane.getWidth() - insets.left - insets.right - vector.size() * n7;
                int n9 = FloorTabbedPane.this.getPercentage() * n8 / 100;
                int n10 = n8 - n9;
                int n11 = insets.left;
                for (int i = 0; i < vector.size(); ++i) {
                    JButton jButton = (JButton)vector.elementAt(i);
                    jButton.setBounds(n11, insets.top, n7, n);
                    n11 += n7;
                    Component component = floorTabbedPane.getComponentAt(i);
                    if (floorTabbedPane.getPrevIndex() == i && floorTabbedPane.getNextIndex() != i) {
                        component.setBounds(n11, insets.top, n9, n);
                        component.setVisible(true);
                        n11 += n9;
                        continue;
                    }
                    if (floorTabbedPane.getNextIndex() == i) {
                        component.setBounds(n11, insets.top, n10, n);
                        component.setVisible(true);
                        n11 += n10;
                        continue;
                    }
                    component.setBounds(n11, insets.top, 0, n);
                    component.setVisible(false);
                }
            }
        }
    }

    public class FloorButton
    extends JideButton
    implements UIResource {
        public FloorButton(Action action) {
            super(action);
            this.setOpaque(true);
            this.setContentAreaFilled(true);
            this.setButtonStyle(UIDefaultsLookup.getInt("FloorTabbedPane.buttonStyle"));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setOpaque(true);
            this.setContentAreaFilled(true);
            this.setButtonStyle(UIDefaultsLookup.getInt("FloorTabbedPane.buttonStyle"));
        }

        public int getButtonIndex() {
            if (this.getAction() instanceof SwitchPageAction) {
                return ((SwitchPageAction)this.getAction()).getIndex();
            }
            return -1;
        }
    }

    private class SwitchPageAction
    extends AbstractAction {
        private static final long serialVersionUID = 9210099378091997660L;
        private int _index;

        public SwitchPageAction(String string, Icon icon, int n) {
            super(string, icon);
            this._index = 0;
            this._index = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FloorTabbedPane.this.getSelectedIndex() == this._index) {
                return;
            }
            FloorTabbedPane.this.setSelectedIndex(this._index);
            if (actionEvent.getSource() instanceof AbstractButton) {
                ((AbstractButton)actionEvent.getSource()).getModel().setRollover(false);
            }
        }

        public int getIndex() {
            return this._index;
        }

        public void setIndex(int n) {
            this._index = n;
        }
    }
}

