/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.paging;

import com.jidesoft.paging.NavigationFieldIconsFactory;
import com.jidesoft.paging.PageNavigationBarResource;
import com.jidesoft.swing.LabeledTextField;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PageNavigationField
extends LabeledTextField {
    public static final int TYPE_PAGE = 1;
    public static final int TYPE_RECORD = 2;
    private int _allowedType = 3;
    private int _type = 1;
    protected transient ChangeEvent changeEvent = null;

    public PageNavigationField() {
        this(3, 1);
    }

    public PageNavigationField(int n) {
        this(n, n == 2 ? 2 : 1);
    }

    public PageNavigationField(int n, int n2) {
        super(n2 == 1 ? PageNavigationField.getDefaultPageMenuIcon() : PageNavigationField.getDefaultRecordMenuIcon());
        this.setType(n2);
        this.setAllowedType(n);
        this.getTextField().setHorizontalAlignment(0);
    }

    private static ImageIcon getDefaultPageMenuIcon() {
        return NavigationFieldIconsFactory.getImageIcon("icons/page_menu.png");
    }

    private static ImageIcon getDefaultRecordMenuIcon() {
        return NavigationFieldIconsFactory.getImageIcon("icons/record_menu.png");
    }

    private static ImageIcon getDefaultPageIcon() {
        return NavigationFieldIconsFactory.getImageIcon("icons/page.png");
    }

    private static ImageIcon getDefaultRecordIcon() {
        return NavigationFieldIconsFactory.getImageIcon("icons/record.png");
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        if (1 != n && 2 != n) {
            throw new IllegalArgumentException("Illegal type: must be TYPE_PAGE, or TYPE_RECORD");
        }
        this._type = n;
        if (this._type == 2) {
            this.setIcon(PageNavigationField.getDefaultRecordMenuIcon());
        } else {
            this.setIcon(PageNavigationField.getDefaultPageMenuIcon());
        }
        this.fireStateChanged();
    }

    public int getAllowedType() {
        return this._allowedType;
    }

    public void setAllowedType(int n) {
        this._allowedType = n;
        if (this._allowedType == 1) {
            this.setType(1);
        } else if (this._allowedType == 2) {
            this.setType(2);
        }
    }

    @Override
    protected void customizePopupMenu(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem;
        ResourceBundle resourceBundle = PageNavigationBarResource.getResourceBundle(Locale.getDefault());
        if ((this.getAllowedType() & 2) != 0) {
            jMenuItem = jPopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("PageNavigationField.field.record"), PageNavigationField.getDefaultRecordIcon()));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 5846020525680122532L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PageNavigationField.this.setType(2);
                }
            });
            jMenuItem.setSelected(this.getType() == 2);
        }
        if ((this.getAllowedType() & 1) != 0) {
            jMenuItem = jPopupMenu.add(new JCheckBoxMenuItem(resourceBundle.getString("PageNavigationField.field.page"), PageNavigationField.getDefaultPageIcon()));
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 4556436583170178L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PageNavigationField.this.setType(1);
                }
            });
            jMenuItem.setSelected(this.getType() == 1);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2048)) {
            Lm.showInvalidProductMessage(PageNavigationField.class.getName(), 2048);
        }
    }
}

