/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeRowMarginSupport
extends AbstractRowMarginSupport {
    protected JTree _tree;
    private TreeModelListener _treeModelListener;
    private TreeExpansionListener _treeExpansionListener;
    private PropertyChangeListener _propertyChangeListener;

    public TreeRowMarginSupport(JTree jTree, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._tree = jTree;
    }

    @Override
    public int getRowCount() {
        return this._tree.getRowCount();
    }

    @Override
    public void scrollTo(int n, int n2, boolean bl) {
        if (bl) {
            this._tree.getSelectionModel().clearSelection();
            TreePath[] treePathArray = new TreePath[Math.abs(n2 - n) + 1];
            for (int i = 0; i < treePathArray.length; ++i) {
                treePathArray[i] = this._tree.getPathForRow(Math.min(n, n2) + i);
            }
            this._tree.getSelectionModel().addSelectionPaths(treePathArray);
        }
        this._tree.scrollRectToVisible(this._tree.getPathBounds(this._tree.getPathForRow(n2)));
    }

    @Override
    public int getRowHeight(int n) {
        return this._tree.isFixedRowHeight() ? this._tree.getRowHeight() : this._tree.getRowBounds((int)n).height;
    }

    @Override
    public int positionToRow(int n) {
        int n2 = this.getViewPosition();
        return this._tree.getClosestRowForLocation(0, n2 + n);
    }

    @Override
    public int rowToPosition(int n) {
        Rectangle rectangle = this._tree.getRowBounds(n);
        if (rectangle == null) {
            return Integer.MIN_VALUE;
        }
        int n2 = this.getViewPosition();
        return rectangle.y - n2;
    }

    @Override
    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        super.installListeners(repaintCallback, modelChangedCallback);
        if (modelChangedCallback != null) {
            if (this._treeModelListener == null) {
                this._treeModelListener = new TreeModelListener(){

                    @Override
                    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                        modelChangedCallback.modelChanged(treeModelEvent);
                    }

                    @Override
                    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                        modelChangedCallback.modelChanged(treeModelEvent);
                    }

                    @Override
                    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                        modelChangedCallback.modelChanged(treeModelEvent);
                    }

                    @Override
                    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                        modelChangedCallback.modelChanged(treeModelEvent);
                    }
                };
            }
            if (this._treeExpansionListener == null) {
                this._treeExpansionListener = new TreeExpansionListener(){

                    @Override
                    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                        modelChangedCallback.modelChanged(treeExpansionEvent);
                    }

                    @Override
                    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                        modelChangedCallback.modelChanged(treeExpansionEvent);
                    }
                };
            }
            if (this._propertyChangeListener == null) {
                this._propertyChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof TreeModel) {
                            ((TreeModel)object2).removeTreeModelListener(TreeRowMarginSupport.this._treeModelListener);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof TreeModel) {
                            ((TreeModel)object).addTreeModelListener(TreeRowMarginSupport.this._treeModelListener);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._tree.addPropertyChangeListener("model", this._propertyChangeListener);
            this._tree.addTreeExpansionListener(this._treeExpansionListener);
            this._tree.getModel().addTreeModelListener(this._treeModelListener);
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        if (this._propertyChangeListener != null) {
            this._tree.removePropertyChangeListener("model", this._propertyChangeListener);
        }
        if (this._treeExpansionListener != null) {
            this._tree.removeTreeExpansionListener(this._treeExpansionListener);
        }
        if (this._treeModelListener != null) {
            this._tree.getModel().removeTreeModelListener(this._treeModelListener);
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

