/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractRowMargin;
import com.jidesoft.margin.MarginSupport;
import com.jidesoft.margin.RowMarginSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;

public class RowNumberMargin
extends AbstractRowMargin {
    private static Color DEFAULT_FOREGROUND = new Color(128, 0, 0);
    private boolean _showTooltip = false;
    private transient int _oldCount = -1;

    public RowNumberMargin(RowMarginSupport rowMarginSupport) {
        super(rowMarginSupport);
        this.setForeground(DEFAULT_FOREGROUND);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this._oldCount = rowMarginSupport.getRowCount();
    }

    @Override
    public void paintRowMargin(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = ((RowMarginSupport)this._marginSupport).visualRowToActualRow(n);
        if (n2 != -1) {
            int n3 = n2 + 1;
            String string = "" + n3;
            graphics.setColor(this.getForeground());
            graphics.setFont(this.getFont());
            graphics.drawString(string, rectangle.x + rectangle.width - this.getFontMetrics(this.getFont()).stringWidth(string), rectangle.y + (rectangle.height + this.getFontMetrics(this.getFont()).getAscent() - this.getFontMetrics(this.getFont()).getDescent()) / 2 + ((RowMarginSupport)this._marginSupport).getBaselineAdjustment() - 1);
        }
    }

    @Override
    public String getToolTipText(int n) {
        int n2;
        if (this.isShowTooltip() && (n2 = ((RowMarginSupport)this._marginSupport).visualRowToActualRow(n)) >= 0) {
            return "" + (n2 + 1);
        }
        return null;
    }

    @Override
    public int getPreferredWidth() {
        int n = ((RowMarginSupport)this._marginSupport).getRowCount() - 1;
        String string = String.valueOf(((RowMarginSupport)this._marginSupport).visualRowToActualRow(n) + 1);
        Insets insets = this.getInsets();
        return insets.left + insets.right + this.getFontMetrics(this.getFont()).stringWidth(string);
    }

    public boolean isShowTooltip() {
        return this._showTooltip;
    }

    public void setShowTooltip(boolean bl) {
        this._showTooltip = bl;
    }

    @Override
    protected MarginSupport.ModelChangedCallback createModelChangedCallback() {
        return new MarginSupport.ModelChangedCallback(){

            @Override
            public void modelChanged(Object object) {
                int n = ((RowMarginSupport)RowNumberMargin.this._marginSupport).getRowCount();
                if (RowNumberMargin.this._oldCount == -1 || n != RowNumberMargin.this._oldCount && (int)Math.log10(n) != (int)Math.log10(RowNumberMargin.this._oldCount)) {
                    RowNumberMargin.this.revalidate();
                    RowNumberMargin.this.repaint();
                }
                RowNumberMargin.this._oldCount = n;
            }
        };
    }
}

