/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListRowMarginSupport
extends AbstractRowMarginSupport {
    protected JList _list;
    private ListDataListener _listDataListener;
    private PropertyChangeListener _propertyChangeListener;

    public ListRowMarginSupport(JList jList, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._list = jList;
    }

    @Override
    public int getRowCount() {
        return this._list.getModel().getSize();
    }

    @Override
    public void scrollTo(int n, int n2, boolean bl) {
        if (bl) {
            this._list.getSelectionModel().setSelectionInterval(Math.min(n, n2), Math.max(n, n2));
        }
        this._list.scrollRectToVisible(this._list.getCellBounds(n2, n2));
    }

    @Override
    public int getRowHeight(int n) {
        Rectangle rectangle = this._list.getCellBounds(n, n);
        return rectangle != null ? rectangle.height : -1;
    }

    @Override
    public int positionToRow(int n) {
        int n2 = this.getViewPosition();
        return this._list.locationToIndex(new Point(0, n2 + n));
    }

    @Override
    public int rowToPosition(int n) {
        Point point = this._list.indexToLocation(n);
        if (point != null) {
            int n2 = this.getViewPosition();
            return point.y - n2;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        super.installListeners(repaintCallback, modelChangedCallback);
        if (modelChangedCallback != null) {
            if (this._listDataListener == null) {
                this._listDataListener = new ListDataListener(){

                    @Override
                    public void intervalAdded(ListDataEvent listDataEvent) {
                        modelChangedCallback.modelChanged(listDataEvent);
                    }

                    @Override
                    public void intervalRemoved(ListDataEvent listDataEvent) {
                        modelChangedCallback.modelChanged(listDataEvent);
                    }

                    @Override
                    public void contentsChanged(ListDataEvent listDataEvent) {
                        modelChangedCallback.modelChanged(listDataEvent);
                    }
                };
            }
            if (this._propertyChangeListener == null) {
                this._propertyChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof ListModel) {
                            ((ListModel)object2).removeListDataListener(ListRowMarginSupport.this._listDataListener);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof ListModel) {
                            ((ListModel)object).addListDataListener(ListRowMarginSupport.this._listDataListener);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._list.addPropertyChangeListener("model", this._propertyChangeListener);
            this._list.getModel().addListDataListener(this._listDataListener);
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        if (this._propertyChangeListener != null) {
            this._list.removePropertyChangeListener("model", this._propertyChangeListener);
        }
        if (this._listDataListener != null) {
            this._list.getModel().removeListDataListener(this._listDataListener);
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

