/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractMargin;
import com.jidesoft.margin.RowMarginPainter;
import com.jidesoft.margin.RowMarginSupport;
import com.jidesoft.utils.SortedList;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.ToolTipManager;

public abstract class AbstractRowMargin
extends AbstractMargin
implements MouseListener,
MouseMotionListener {
    protected List<RowMarginPainter> _rowMarginPainters;
    private int _mouseDragStartLine = -1;
    private int _ctrlStartLine = -1;

    public AbstractRowMargin(RowMarginSupport rowMarginSupport) {
        super(rowMarginSupport);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void paintMargin(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = this.getFontMetrics(this.getFont()).getHeight();
        int n2 = ((RowMarginSupport)this._marginSupport).positionToRow(0);
        int n3 = ((RowMarginSupport)this._marginSupport).getRowCount();
        if (n2 == -1 || n2 >= n3) {
            return;
        }
        int n4 = ((RowMarginSupport)this._marginSupport).positionToRow(this._marginSupport.getViewSize());
        n4 = n4 == -1 || n4 >= n3 ? n3 - 1 : ++n4;
        int n5 = this.getPreferredSize().width;
        if (!this.isEnabled()) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        try {
            int n6 = 0;
            Rectangle rectangle = new Rectangle(0, n6, n5, n);
            Insets insets = this.getInsets();
            rectangle.x += insets.left;
            rectangle.width -= insets.left + insets.right;
            List<RowMarginPainter> list = this.getRowMarginPainters();
            for (int i = n2; i <= n4; ++i) {
                rectangle.y = ((RowMarginSupport)this._marginSupport).rowToPosition(i);
                ++rectangle.y;
                rectangle.height = ((RowMarginSupport)this._marginSupport).getRowHeight(i);
                if (rectangle.height <= 0 || rectangle.y + rectangle.height < 0) continue;
                rectangle.y += insets.top;
                int n7 = this.paintLowerRowMargins(list, graphics2D, rectangle, i);
                this.paintRowMargin(graphics2D, rectangle, i);
                this.paintHigherRowMargin(list, n7, graphics2D, rectangle, i);
            }
        }
        catch (Exception exception) {
            System.err.println("Error repainting line range {" + n2 + "," + n4 + "}:");
        }
        graphics2D.dispose();
    }

    private int paintLowerRowMargins(List<RowMarginPainter> list, Graphics graphics, Rectangle rectangle, int n) {
        int n2;
        if (list != null) {
            RowMarginPainter rowMarginPainter;
            for (n2 = 0; n2 < list.size() && (rowMarginPainter = list.get(n2)).getLayer() < 1000; ++n2) {
                rowMarginPainter.paintRowMargin(graphics, (RowMarginSupport)this._marginSupport, rectangle, n);
            }
        }
        return n2;
    }

    private void paintHigherRowMargin(List<RowMarginPainter> list, int n, Graphics graphics, Rectangle rectangle, int n2) {
        if (list != null) {
            for (int i = n; i < list.size(); ++i) {
                RowMarginPainter rowMarginPainter = list.get(i);
                rowMarginPainter.paintRowMargin(graphics, (RowMarginSupport)this._marginSupport, rectangle, n2);
            }
        }
    }

    public void addRowMarginPainter(RowMarginPainter rowMarginPainter) {
        if (this._rowMarginPainters == null) {
            this._rowMarginPainters = new SortedList<RowMarginPainter>(new ArrayList(), new Comparator<RowMarginPainter>(){

                @Override
                public int compare(RowMarginPainter rowMarginPainter, RowMarginPainter rowMarginPainter2) {
                    int n;
                    int n2 = rowMarginPainter.getLayer();
                    if (n2 < (n = rowMarginPainter2.getLayer())) {
                        return -1;
                    }
                    if (n2 > n) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        this._rowMarginPainters.add(rowMarginPainter);
    }

    public void removeRowMarginPainter(RowMarginPainter rowMarginPainter) {
        if (this._rowMarginPainters == null) {
            return;
        }
        this._rowMarginPainters.remove(rowMarginPainter);
    }

    protected List<RowMarginPainter> getRowMarginPainters() {
        return this._rowMarginPainters;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        String string = this.getToolTipText(mouseEvent);
        if (string == null) {
            return null;
        }
        int n = this.getFontMetrics(this.getFont()).getHeight();
        int n2 = mouseEvent.getPoint().y / n;
        return new Point(this.getPreferredSize().width + 6, n2 * n + n / 2);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText(((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getY()));
    }

    public abstract void paintRowMargin(Graphics var1, Rectangle var2, int var3);

    public abstract String getToolTipText(int var1);

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this._marginSupport.getViewPosition();
        int n2 = ((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getPoint().y);
        if (n2 < 0 || n2 > ((RowMarginSupport)this._marginSupport).positionToRow(n + this._marginSupport.getViewSize())) {
            return;
        }
        if ((mouseEvent.getModifiers() & 2) != 0 && (mouseEvent.getModifiers() & 1) == 0) {
            this._ctrlStartLine = n2;
        } else if (this._ctrlStartLine >= 0 && (mouseEvent.getModifiers() & 2) == 0 && (mouseEvent.getModifiers() & 1) != 0) {
            int n3 = Math.max(Math.min(n2, this._ctrlStartLine), 0);
            int n4 = Math.max(n2, this._ctrlStartLine) + 1;
            ((RowMarginSupport)this._marginSupport).scrollTo(n3, n4, this.isClickToSelect());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._mouseDragStartLine = ((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getPoint().y);
        ((RowMarginSupport)this._marginSupport).scrollTo(this._mouseDragStartLine, this._mouseDragStartLine, this.isClickToSelect());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._mouseDragStartLine = -1;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._mouseDragStartLine < 0) {
            return;
        }
        this._ctrlStartLine = -1;
        int n = ((RowMarginSupport)this._marginSupport).positionToRow(mouseEvent.getPoint().y);
        int n2 = this._mouseDragStartLine;
        int n3 = Math.max(0, n);
        ((RowMarginSupport)this._marginSupport).scrollTo(n2, n3, this.isClickToSelect());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

