/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.MarginSupport;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JScrollPane;

public abstract class AbstractMarginSupport
implements MarginSupport {
    protected JScrollPane _scrollPane;
    protected AdjustmentListener _listener;
    private Map<MarginSupport.RepaintCallback, AdjustmentListener> _cache;

    public AbstractMarginSupport(JScrollPane jScrollPane) {
        this._scrollPane = jScrollPane;
        this._cache = new HashMap<MarginSupport.RepaintCallback, AdjustmentListener>();
    }

    @Override
    public int getViewPosition() {
        return this._scrollPane.getViewport().getViewPosition().y;
    }

    @Override
    public int getViewSize() {
        return this._scrollPane.getViewport().getViewRect().height - (this._scrollPane.getHorizontalScrollBar().isVisible() ? this._scrollPane.getHorizontalScrollBar().getHeight() : 0);
    }

    @Override
    public void installListeners(final MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        AdjustmentListener adjustmentListener = this._cache.get(repaintCallback);
        if (adjustmentListener == null) {
            adjustmentListener = new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    repaintCallback.repaint();
                }
            };
            this._scrollPane.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
            this._cache.put(repaintCallback, adjustmentListener);
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        AdjustmentListener adjustmentListener = this._cache.get(repaintCallback);
        if (adjustmentListener != null) {
            this._scrollPane.getVerticalScrollBar().removeAdjustmentListener(adjustmentListener);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(AbstractMarginSupport.class.getName(), 4);
        }
    }
}

