/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.Margin;
import com.jidesoft.margin.MarginPainter;
import com.jidesoft.margin.MarginSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SortedList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractMargin
extends JComponent
implements Margin {
    protected MarginSupport _marginSupport;
    protected Dimension _preferredSize;
    protected List<MarginPainter> _marginPainters;
    protected MarginSupport.RepaintCallback _repaintCallback;
    protected MarginSupport.ModelChangedCallback _modelChangedCallback;
    private boolean _clickToSelect = true;
    public static final String PROPERTY_CLICK_TO_SELECT = "clickToSelect";

    protected AbstractMargin() {
    }

    public AbstractMargin(MarginSupport marginSupport) {
        this.setMarginSupport(marginSupport);
    }

    @Override
    public void invalidate() {
        this._preferredSize = null;
        super.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        Object object = JideSwingUtilities.setupAntialiasing(this, graphics);
        Color color = graphics.getColor();
        try {
            this.paintBackground(graphics);
            List<MarginPainter> list = this.getMarginPainters();
            int n = this.paintLowerMargins(list, graphics);
            this.paintMargin(graphics);
            this.paintHigherMargin(list, n, graphics);
        }
        finally {
            graphics.setColor(color);
            JideSwingUtilities.restoreAntialiasing(this, graphics, object);
        }
    }

    private int paintLowerMargins(List<MarginPainter> list, Graphics graphics) {
        int n = 0;
        if (list != null) {
            MarginPainter marginPainter;
            while ((marginPainter = list.get(n)).getLayer() < 1000) {
                marginPainter.paintMargin(graphics, this.getMarginSupport());
                ++n;
            }
        }
        return n;
    }

    private void paintHigherMargin(List<MarginPainter> list, int n, Graphics graphics) {
        if (list != null) {
            for (int i = n; i < list.size(); ++i) {
                MarginPainter marginPainter = list.get(i);
                marginPainter.paintMargin(graphics, this.getMarginSupport());
            }
        }
    }

    protected void paintBackground(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._preferredSize == null) {
            this._preferredSize = new Dimension(this.getPreferredWidth(), 0);
        }
        return this._preferredSize;
    }

    @Override
    public MarginSupport getMarginSupport() {
        return this._marginSupport;
    }

    @Override
    public void setMarginSupport(MarginSupport marginSupport) {
        if (this._marginSupport != null) {
            this._marginSupport.uninstallListeners(this._repaintCallback, this._modelChangedCallback);
        }
        this._marginSupport = marginSupport;
        if (this._marginSupport != null) {
            if (this._repaintCallback == null) {
                this._repaintCallback = this.createRepaintCallback();
            }
            if (this._modelChangedCallback == null) {
                this._modelChangedCallback = this.createModelChangedCallback();
            }
            this._marginSupport.installListeners(this._repaintCallback, this._modelChangedCallback);
        }
    }

    protected MarginSupport.RepaintCallback createRepaintCallback() {
        return new MarginSupport.RepaintCallback(){

            @Override
            public void repaint() {
                AbstractMargin.this.repaint();
            }
        };
    }

    protected MarginSupport.ModelChangedCallback createModelChangedCallback() {
        return null;
    }

    @Override
    public Component getMarginComponent() {
        return this;
    }

    @Override
    public void addMarginPainter(MarginPainter marginPainter) {
        if (this._marginPainters == null) {
            this._marginPainters = new SortedList<MarginPainter>(new ArrayList(), new Comparator(){

                public int compare(Object object, Object object2) {
                    int n;
                    int n2 = ((MarginPainter)object).getLayer();
                    if (n2 < (n = ((MarginPainter)object2).getLayer())) {
                        return -1;
                    }
                    if (n2 > n) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        this._marginPainters.add(marginPainter);
    }

    @Override
    public void removeMarginPainter(MarginPainter marginPainter) {
        if (this._marginPainters == null) {
            return;
        }
        this._marginPainters.remove(marginPainter);
    }

    protected List<MarginPainter> getMarginPainters() {
        return this._marginPainters;
    }

    public boolean isClickToSelect() {
        return this._clickToSelect;
    }

    public void setClickToSelect(boolean bl) {
        boolean bl2 = this._clickToSelect;
        if (bl2 != bl) {
            this._clickToSelect = bl;
            this.firePropertyChange(PROPERTY_CLICK_TO_SELECT, bl2, this._clickToSelect);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(AbstractMargin.class.getName(), 4);
        }
    }
}

