/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.lucene;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.FilterableTableModelEvent;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.lucene.LuceneDocumentProvider;
import com.jidesoft.lucene.LuceneSupport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.table.TableModel;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;

public class LuceneFilterableTableModel
extends FilterableTableModel
implements LuceneDocumentProvider {
    private static final long serialVersionUID = 4755534842798484885L;
    private LuceneSupport _luceneSupport;
    String[] _columnNames;
    ConverterContext[] _converters;
    Class[] _columnClasses;
    private boolean _needAdjustFilter;

    public LuceneFilterableTableModel(TableModel tableModel) {
        super(tableModel);
        this.setLuceneSupport(new LuceneSupport(this));
        this.setFilterAlgorithm(1);
        this.initQueryFields();
    }

    private void initQueryFields() {
        this._columnNames = new String[this._model.getColumnCount()];
        this._converters = new ConverterContext[this._model.getColumnCount()];
        this._columnClasses = new Class[this._model.getColumnCount()];
        for (int i = 0; i < this._model.getColumnCount(); ++i) {
            this._columnNames[i] = this.getFieldNameForColumn(i);
            this._converters[i] = null;
            if (this._model instanceof ContextSensitiveTableModel) {
                this._converters[i] = ((ContextSensitiveTableModel)this._model).getConverterContextAt(0, i);
            }
            this._columnClasses[i] = this._model.getColumnClass(i);
        }
    }

    protected String getFieldNameForColumn(int n) {
        String string = this.getColumnIdentifier(n).toString().toLowerCase();
        string = string.replaceAll(" ", "");
        return string;
    }

    @Override
    public Document getDocument(int n) {
        if (n < 0 || n >= this._model.getRowCount()) {
            return null;
        }
        Document document = new Document();
        for (int i = 0; i < this._model.getColumnCount(); ++i) {
            String string = ObjectConverterManager.toString(this._model.getValueAt(n, i), this._columnClasses[i], this._converters[i]).toLowerCase();
            Field field = new Field(this._columnNames[i], string, Field.Store.YES, Field.Index.ANALYZED);
            document.add((IndexableField)field);
        }
        return document;
    }

    @Override
    public int getDocumentCount() {
        return this._model.getRowCount();
    }

    @Override
    public void notifyIndexCreated() {
    }

    @Override
    protected void tableDataChanged() {
        this.getLuceneSupport().startIndexing(0, this._model.getRowCount() - 1, false);
        super.tableDataChanged();
    }

    @Override
    protected void tableStructureChanged() {
        this.getLuceneSupport().startIndexing(0, this._model.getRowCount() - 1, false);
        super.tableStructureChanged();
    }

    @Override
    protected void tableRowsInserted(int n, int n2) {
        this.getLuceneSupport().startIndexing(n, this._model.getRowCount() - 1, false);
        super.tableRowsInserted(n, n2);
    }

    @Override
    protected void tableRowsDeleted(int n, int n2) {
        this.getLuceneSupport().startIndexing(n, this._model.getRowCount() - 1, false);
        super.tableRowsDeleted(n, n2);
    }

    @Override
    protected void tableRowsUpdated(int n, int n2) {
        this.getLuceneSupport().startIndexing(n, n2, false);
        super.tableRowsUpdated(n, n2);
    }

    @Override
    protected void tableCellsUpdated(int n, int n2, int n3) {
        this.getLuceneSupport().startIndexing(n2, n3, false);
        super.tableCellsUpdated(n, n2, n3);
    }

    @Override
    protected List<Integer> getReservedRows(int n, int n2) {
        if (this.getLuceneSupport().isIndexing()) {
            return super.getReservedRows(n, n2);
        }
        this.prepareFilters();
        Set<Integer> set = this.getLuceneSupport().getMatchingRows();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = n; i <= n2; ++i) {
            if (!set.contains(i)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    @Override
    protected void filter(boolean bl) {
        Object object;
        if (this.getLuceneSupport().isIndexing()) {
            super.filter(bl);
            return;
        }
        if (this.getLuceneQuery() == null) {
            this.convertFilterToQuery();
            if (this.getLuceneQuery() == null) {
                super.filter(bl);
                return;
            }
        }
        List<Integer> list = this.getReservedRows(0, this._model.getRowCount());
        if (this.isNeedAdjustFilter()) {
            this.invalidateFilterCache();
            object = new ArrayList<Integer>(list);
            list.clear();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                boolean bl2 = this.shouldBeFiltered(n);
                if (bl2) continue;
                list.add(n);
            }
        }
        object = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            object[i] = list.get(i);
        }
        this.setIndexes((int[])object);
    }

    protected Query getLuceneQuery() {
        return this.getLuceneSupport().getQuery();
    }

    private void convertFilterToQuery() {
        if (this._eachColumnFilters == null || this.getColumnCount() == 0) {
            this.getLuceneSupport().clearQuery();
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < this._eachColumnFilters.length; ++i) {
            List list = this._eachColumnFilters[i];
            if (list == null || list.size() == 0) continue;
            if (bl) {
                bl = false;
            } else if (this.isAndMode()) {
                stringBuffer.append(" AND ");
            } else {
                stringBuffer.append("OR");
            }
            stringBuffer.append("(");
            for (Filter filter : list) {
                String string = this.convertFilterToLuceneQueryText(i, filter);
                if (string == null) {
                    return;
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(")");
        }
        if (stringBuffer.length() == 0) {
            this.getLuceneSupport().clearQuery();
            return;
        }
        this.getLuceneSupport().createQuery(stringBuffer.toString(), this._columnNames[0]);
    }

    protected String convertFilterToLuceneQueryText(int n, Filter filter) {
        if (filter instanceof SingleValueFilter) {
            ConverterContext converterContext = null;
            if (this._model instanceof ContextSensitiveTableModel) {
                converterContext = ((ContextSensitiveTableModel)this._model).getConverterContextAt(0, n);
            }
            String string = ObjectConverterManager.toString(((SingleValueFilter)filter).getValue(), this._model.getColumnClass(n), converterContext).toLowerCase();
            return this.getFieldNameForColumn(n) + ":\"" + string + "\"";
        }
        if (filter instanceof MultipleValuesFilter) {
            ConverterContext converterContext = null;
            if (this._model instanceof ContextSensitiveTableModel) {
                converterContext = ((ContextSensitiveTableModel)this._model).getConverterContextAt(0, n);
            }
            T[] TArray = ((MultipleValuesFilter)filter).getValues();
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.getFieldNameForColumn(n);
            for (Object t : TArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append("(");
                String string2 = ObjectConverterManager.toString(t, this._model.getColumnClass(n), converterContext).toLowerCase();
                stringBuffer.append(string).append(":").append("\"").append(string2).append("\"");
                stringBuffer.append(")");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public void fireFilterChanged(FilterableTableModelEvent filterableTableModelEvent) {
        this.getLuceneSupport().clearQuery();
        super.fireFilterChanged(filterableTableModelEvent);
    }

    public LuceneSupport getLuceneSupport() {
        return this._luceneSupport;
    }

    public void setLuceneSupport(LuceneSupport luceneSupport) {
        this._luceneSupport = luceneSupport;
    }

    public int getBooleanQueryMaxClauseCount() {
        return this._luceneSupport.getBooleanQueryMaxClauseCount();
    }

    public void setBooleanQueryMaxClauseCount(int n) {
        this._luceneSupport.setBooleanQueryMaxClauseCount(n);
    }

    public boolean isRangeQueryInclusive() {
        return this._luceneSupport.isRangeQueryInclusive();
    }

    public void setRangeQueryInclusive(boolean bl) {
        this._luceneSupport.setRangeQueryInclusive(bl);
    }

    public boolean isAllowLeadingWildcard() {
        return this._luceneSupport.isAllowLeadingWildcard();
    }

    public void setAllowLeadingWildcard(boolean bl) {
        this._luceneSupport.setAllowLeadingWildcard(bl);
    }

    boolean isNeedAdjustFilter() {
        return this._needAdjustFilter;
    }

    void setNeedAdjustFilter(boolean bl) {
        this._needAdjustFilter = bl;
    }
}

