/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.lucene;

import com.jidesoft.lucene.BrowserLauncher;
import com.jidesoft.lucene.LuceneFilterField;
import com.jidesoft.lucene.LuceneResource;
import com.jidesoft.lucene.LuceneSupport;
import com.jidesoft.swing.JidePopupMenu;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class LuceneFilterMenuSupport {
    private static String _luceneHelpURL = "http://lucene.apache.org/core/2_9_4/queryparsersyntax.html";
    private LuceneFilterField _field;
    private LuceneSupport _luceneSupport;

    LuceneFilterMenuSupport(LuceneFilterField luceneFilterField, LuceneSupport luceneSupport) {
        this._field = luceneFilterField;
        this._luceneSupport = luceneSupport;
        if (luceneFilterField == null) {
            throw new IllegalArgumentException("LucentFilterField should not be null.");
        }
        if (luceneSupport == null) {
            throw new IllegalArgumentException("LuceneSupport should not be null.");
        }
    }

    void customizePopupMenu(JidePopupMenu jidePopupMenu, String[] stringArray) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.getResourceString("LuceneMenuItem.inputMode"));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                LuceneFilterMenuSupport.this._field.setLuceneInputMode(abstractButton.isSelected());
            }
        });
        jCheckBoxMenuItem.setMnemonic(this.getResourceString("LuceneMenuItem.inputMode.mnemonic").charAt(0));
        jCheckBoxMenuItem.setName("LuceneMenuItem.inputMode");
        jCheckBoxMenuItem.setSelected(this._field.isLuceneInputMode());
        if (this._field.isLuceneInputMode()) {
            jidePopupMenu.removeAll();
            jidePopupMenu.add(jCheckBoxMenuItem);
            jidePopupMenu.addSeparator();
            jCheckBoxMenuItem = new JCheckBoxMenuItem(this.getResourceString("LuceneMenuItem.rangeQueryInclusive.text"));
            jCheckBoxMenuItem.setMnemonic(this.getResourceString("LuceneMenuItem.rangeQueryInclusive.mnemonic").charAt(0));
            jCheckBoxMenuItem.setName("LuceneMenuItem.rangeQueryInclusive");
            jCheckBoxMenuItem.setSelected(this._luceneSupport.isRangeQueryInclusive());
            jCheckBoxMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 971538218159403428L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    LuceneFilterMenuSupport.this._luceneSupport.setRangeQueryInclusive(jMenuItem.isSelected());
                    String string = LuceneFilterMenuSupport.this._field.getTextField() != null ? LuceneFilterMenuSupport.this._field.getTextField().getText().trim() : "";
                    if (string != null && string.length() != 0) {
                        LuceneFilterMenuSupport.this._field.applyFilter(string);
                    }
                }
            });
            jidePopupMenu.add(jCheckBoxMenuItem);
            jidePopupMenu.addSeparator();
            if (stringArray != null && stringArray.length != 0) {
                int n = 0;
                for (String string : stringArray) {
                    if (string == null) continue;
                    jidePopupMenu.add(new JMenuItem(this.createAction(string, null, ":")));
                    ++n;
                }
                if (n != 0) {
                    jidePopupMenu.addSeparator();
                }
            }
            jidePopupMenu.add(new JMenuItem(this.createAction("AND", this.getResourceString("LuceneMenuHelper.and"), " ")));
            jidePopupMenu.add(new JMenuItem(this.createAction("OR", this.getResourceString("LuceneMenuHelper.or"), " ")));
            jidePopupMenu.add(new JMenuItem(this.createAction("NOT", this.getResourceString("LuceneMenuHelper.not"), " ")));
            jidePopupMenu.add(new JMenuItem(this.createAction("(", this.getResourceString("LuceneMenuHelper.parentheses"), null, ")")));
            jidePopupMenu.addSeparator();
            jidePopupMenu.add(new JMenuItem(this.createAction("TO", this.getResourceString("LuceneMenuHelper.to"), " ")));
            jidePopupMenu.add(new JMenuItem(this.createAction("[", this.getResourceString("LuceneMenuHelper.squareBrackets"), null, "]")));
            jidePopupMenu.add(new JMenuItem(this.createAction("{", this.getResourceString("LuceneMenuHelper.braces"), null, "}")));
            jidePopupMenu.addSeparator();
            jidePopupMenu.add(new JMenuItem(this.createAction("\"", this.getResourceString("LuceneMenuHelper.quotes"), null, "\"")));
            jidePopupMenu.add(new JMenuItem(this.createAction("?", this.getResourceString("LuceneMenuHelper.questionMark"))));
            jidePopupMenu.add(new JMenuItem(this.createAction("*", this.getResourceString("LuceneMenuHelper.asterisk"))));
            jidePopupMenu.add(new JMenuItem(this.createAction("~", this.getResourceString("LuceneMenuHelper.tilde"))));
            jidePopupMenu.add(new JMenuItem(this.createAction("^", this.getResourceString("LuceneMenuHelper.caret"))));
            jidePopupMenu.add(new JMenuItem(this.createAction("+", this.getResourceString("LuceneMenuHelper.plus"))));
            jidePopupMenu.add(new JMenuItem(this.createAction("-", this.getResourceString("LuceneMenuHelper.minus"))));
            jidePopupMenu.addSeparator();
            JMenuItem jMenuItem = new JMenuItem(this.getResourceString("LuceneMenuItem.getLuceneHelp.text"));
            jMenuItem.setMnemonic(this.getResourceString("LuceneMenuItem.getLuceneHelp.mnemonic").charAt(0));
            jMenuItem.setName("LuceneMenuItem.getLuceneHelp.text");
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        BrowserLauncher.openURL("http://lucene.apache.org/core/2_9_4/queryparsersyntax.html");
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            jidePopupMenu.add(jMenuItem);
        } else {
            Component[] componentArray;
            for (Component component : componentArray = jidePopupMenu.getComponents()) {
                String string = component.getName();
                if ("Filter.matchFromStart".equals(string) || "Filter.matchExactly".equals(string) || "Filter.matchAnywhere".equals(string)) continue;
                jidePopupMenu.remove(component);
            }
            int n = 0;
            jidePopupMenu.add((Component)jCheckBoxMenuItem, n++);
            jidePopupMenu.add((Component)new JPopupMenu.Separator(), n);
        }
    }

    private Action createAction(String string, String string2) {
        return this.createAction(string, string2, null);
    }

    private Action createAction(String string, String string2, String string3) {
        return this.createAction(string, string2, string3, null);
    }

    private Action createAction(final String string, String string2, final String string3, final String string4) {
        return new AbstractAction(string + (string4 == null ? "" : " " + string4) + (string2 == null ? "" : " " + string2)){
            private static final long serialVersionUID = 1521431261524358984L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LuceneFilterMenuSupport.this._field == null) {
                    return;
                }
                String string5 = string3 == null ? string : (string3.equals(" ") ? string3 + string + string3 : string + string3);
                JTextField jTextField = LuceneFilterMenuSupport.this._field.getTextField();
                int n = jTextField.getSelectionStart();
                int n2 = jTextField.getSelectionEnd();
                String string2 = jTextField.getText();
                string2 = string4 == null ? (n2 == -1 ? string2 + string4 : string2.substring(0, n) + string5 + string2.substring(n2)) : (n2 == -1 ? string2 + string5 + string4 : string2.substring(0, n) + string5 + string2.substring(n, n2) + string4 + string2.substring(n2));
                jTextField.setText(string2);
                if (n2 != -1) {
                    int n3 = n + string5.length();
                    if (string4 != null) {
                        n3 += n2 - n;
                    }
                    jTextField.setCaretPosition(n3);
                }
            }
        };
    }

    private String getResourceString(String string) {
        String string2 = this._field.getResourceString(string);
        if (null != string2 && string2.length() > 0) {
            return string2;
        }
        return LuceneResource.getResourceBundle(this._field.getTextField().getLocale()).getString(string);
    }

    public static String getLuceneHelpURL() {
        return _luceneHelpURL;
    }

    public static void setLuceneHelpURL(String string) {
        _luceneHelpURL = string;
    }
}

