/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.list.CompoundListDataEvent;
import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.DualList;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;

public class TextFieldList
extends JideSplitPane
implements ListSelectionListener {
    public static final String COMMAND_MOVE_LEFT = "moveLeft";
    public static final String COMMAND_MOVE_RIGHT = "moveRight";
    public static final String COMMAND_MOVE_UP = "moveUp";
    public static final String COMMAND_MOVE_DOWN = "moveDown";
    public static final String COMMAND_MOVE_TO_TOP = "moveToTop";
    public static final String COMMAND_MOVE_TO_BOTTOM = "moveToBottom";
    private static final Logger LOGGER;
    private JTextComponent _originalTextField;
    private JList _selectedList;
    private Container _buttonPanelMiddle;
    private Container _buttonPanelRight;
    private boolean _allowDuplicates = true;
    private ListCellRenderer _cellRenderer;
    private ListCellRenderer _disabledCellRenderer;
    private ListCellRenderer _selectedCellRenderer;
    private static ListCellRenderer _defaultRenderer;
    private ListCellRenderer _defaultDisabledRenderer;
    private Map<String, Action> _actions;
    private ActionHandler _handler;
    public JComponent _originalFieldPane;
    public JComponent _selectedListPane;
    public final String CLIENT_PROPERTY_ALWAYS_DISABLED = "DualList.alwaysDisabled";
    protected DefaultListModelWrapper _selectedListModel;
    public static final int FIELD_TRANSFERRED_NO_ACTION = 0;
    public static final int FIELD_TRANSFERRED_CLEAR_TEXT = 1;
    public static final int FIELD_TRANSFERRED_SELECT_ALL = 2;
    private int _fieldTransferredMode = 0;
    private String _startString;

    public TextFieldList() {
        this(new DefaultListModel());
    }

    public TextFieldList(DefaultListModel defaultListModel) {
        this._selectedListModel = this.createWrapperListModel(defaultListModel);
        this.initComponent();
    }

    protected DefaultListModelWrapper createWrapperListModel(DefaultListModel defaultListModel) {
        return new DefaultListModelWrapper(defaultListModel){
            private static final long serialVersionUID = 8272173575872636814L;

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                super.intervalAdded(listDataEvent);
                if (listDataEvent.getIndex0() != listDataEvent.getIndex1() || listDataEvent.getIndex0() != this._model.getSize() - 1) {
                    return;
                }
                int[] nArray = this.getIndexes();
                int[] nArray2 = new int[this._model.getSize()];
                if (nArray != null) {
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray2[nArray2.length - 1] = nArray2.length - 1;
                } else {
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = i;
                    }
                }
                this.setIndexes(nArray2);
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 1, nArray2.length - 1, nArray2.length - 1));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                super.intervalRemoved(listDataEvent);
                int n = listDataEvent.getIndex0();
                if (n != listDataEvent.getIndex1()) {
                    return;
                }
                int[] nArray = this.getIndexes();
                if (nArray == null || nArray.length != this._model.getSize() + 1) {
                    this.reallocateIndexes();
                    return;
                }
                int[] nArray2 = new int[nArray.length - 1];
                int n2 = -1;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == n) {
                        n2 = i;
                        continue;
                    }
                    nArray2[i - (n2 >= 0 ? 1 : 0)] = nArray[i] - (nArray[i] > n ? 1 : 0);
                }
                this.setIndexes(nArray2);
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 2, n2, n2));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
            }
        };
    }

    protected JList createList(ListModel listModel) {
        JList jList = new JList(listModel){

            @Override
            public int getNextMatch(String string, int n, Position.Bias bias) {
                return -1;
            }
        };
        jList.setName("TextFieldTransferBox.rightList");
        return jList;
    }

    protected void setupList(JList jList) {
        jList.addMouseListener(this._handler);
        jList.addListSelectionListener(this._handler);
        SearchableUtils.installSearchable(jList);
    }

    protected JTextComponent createTextField() {
        return new JTextField(10);
    }

    private void initComponent() {
        this._handler = new ActionHandler();
        this.addPropertyChangeListener("model", this._handler);
        this.addPropertyChangeListener("componentOrientation", this._handler);
        this._actions = new HashMap<String, Action>();
        this._actions.put(COMMAND_MOVE_RIGHT, this.createAction(COMMAND_MOVE_RIGHT));
        this._actions.put(COMMAND_MOVE_LEFT, this.createAction(COMMAND_MOVE_LEFT));
        this._actions.put(COMMAND_MOVE_UP, this.createAction(COMMAND_MOVE_UP));
        this._actions.put(COMMAND_MOVE_DOWN, this.createAction(COMMAND_MOVE_DOWN));
        this._actions.put(COMMAND_MOVE_TO_TOP, this.createAction(COMMAND_MOVE_TO_TOP));
        this._actions.put(COMMAND_MOVE_TO_BOTTOM, this.createAction(COMMAND_MOVE_TO_BOTTOM));
        this._originalTextField = this.createTextField();
        this._originalTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TextFieldList.this.enableAction(TextFieldList.COMMAND_MOVE_RIGHT, TextFieldList.this.isInputValid(TextFieldList.this._originalTextField.getText()));
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TextFieldList.this.enableAction(TextFieldList.COMMAND_MOVE_RIGHT, TextFieldList.this.isInputValid(TextFieldList.this._originalTextField.getText()));
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TextFieldList.this.enableAction(TextFieldList.COMMAND_MOVE_RIGHT, TextFieldList.this.isInputValid(TextFieldList.this._originalTextField.getText()));
            }
        });
        this._selectedList = this.createList(this._selectedListModel);
        this.setupList(this._selectedList);
        this._originalFieldPane = new NullPanel();
        this._originalFieldPane.setLayout(new JideBoxLayout(this._originalFieldPane, 1));
        this._originalFieldPane.setOpaque(false);
        this._selectedListPane = new NullPanel(new BorderLayout());
        this._selectedListPane.setOpaque(false);
        this._originalFieldPane.add((Component)this._originalTextField, "fix");
        this._originalFieldPane.add(Box.createGlue(), "vary");
        this._selectedListPane.add(new JScrollPane(this._selectedList));
        this._buttonPanelMiddle = this.createButtonPanel();
        if (this._buttonPanelMiddle instanceof JPanel) {
            ((JPanel)this._buttonPanelMiddle).setBorder(new EmptyBorder(0, 2, 0, 2){
                private static final long serialVersionUID = -8373234859482038083L;

                @Override
                public Insets getBorderInsets(Component component) {
                    Insets insets = super.getBorderInsets(component);
                    JComponent jComponent = TextFieldList.this.getOriginalFieldPane();
                    if (jComponent != null && jComponent.getBorder() != null) {
                        Insets insets2 = jComponent.getBorder().getBorderInsets(jComponent);
                        insets.top = insets2.top;
                        insets.bottom = insets2.bottom;
                    }
                    return insets;
                }
            });
        }
        this._buttonPanelMiddle.add(this.createDummyPanel(this.createButton(this._actions.get(COMMAND_MOVE_RIGHT))));
        this._buttonPanelMiddle.add(Box.createGlue(), "vary");
        this._buttonPanelRight = this.createButtonPanel();
        if (this._buttonPanelRight instanceof JPanel) {
            ((JPanel)this._buttonPanelRight).setBorder(new EmptyBorder(0, 2, 0, 2){
                private static final long serialVersionUID = 3516521895389487344L;

                @Override
                public Insets getBorderInsets(Component component) {
                    Insets insets = super.getBorderInsets(component);
                    JComponent jComponent = TextFieldList.this.getSelectedListPane();
                    if (jComponent != null && jComponent.getBorder() != null) {
                        Insets insets2 = jComponent.getBorder().getBorderInsets(jComponent);
                        insets.top = insets2.top;
                        insets.bottom = insets2.bottom;
                    }
                    return insets;
                }
            });
        }
        AbstractButton abstractButton = this.createButton(this._actions.get(COMMAND_MOVE_LEFT));
        this._buttonPanelRight.add(this.createDummyPanel(abstractButton));
        this._buttonPanelRight.add(Box.createVerticalStrut(abstractButton.getPreferredSize().height - 8));
        this._buttonPanelRight.add(this.createDummyPanel(this.createButton(this._actions.get(COMMAND_MOVE_TO_TOP))));
        AbstractButton abstractButton2 = this.createButton(this._actions.get(COMMAND_MOVE_UP));
        this._buttonPanelRight.add(this.createDummyPanel(abstractButton2));
        this._buttonPanelRight.add(Box.createVerticalStrut(abstractButton2.getPreferredSize().height - 8));
        this._buttonPanelRight.add(this.createDummyPanel(this.createButton(this._actions.get(COMMAND_MOVE_DOWN))));
        this._buttonPanelRight.add(this.createDummyPanel(this.createButton(this._actions.get(COMMAND_MOVE_TO_BOTTOM))));
        this._buttonPanelRight.add(Box.createGlue(), "vary");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._selectedListPane, "Center");
        jPanel.add((Component)this._buttonPanelRight, "After");
        this.installKeyboardAction();
        this.setOrientation(1);
        this.setDividerSize(this._buttonPanelMiddle.getPreferredSize().width);
        this.add((Component)this._originalFieldPane, "flexible");
        this.add((Component)jPanel, "flexible");
        this.addButtonPanel(this.getDividerAt(0), this._buttonPanelMiddle);
        this.updateButtonPanel();
        if (this.getStartString() != null) {
            this._originalTextField.setText(this.getStartString());
        }
    }

    public JTextComponent getOriginalField() {
        return this._originalTextField;
    }

    public JList getSelectedList() {
        return this._selectedList;
    }

    public JComponent getOriginalFieldPane() {
        return this._originalFieldPane;
    }

    public JComponent getSelectedListPane() {
        return this._selectedListPane;
    }

    protected void addButtonPanel(Container container, Component component) {
        container.setLayout(new BorderLayout());
        container.add(component, "First");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this._buttonPanelMiddle != null) {
            dimension.height = Math.max(dimension.height, this._buttonPanelMiddle.getPreferredSize().height);
        }
        if (this._buttonPanelRight != null) {
            dimension.height = Math.max(dimension.height, this._buttonPanelRight.getPreferredSize().height);
        }
        if (this._originalTextField != null) {
            dimension.height = Math.max(dimension.height, this._originalTextField.getPreferredScrollableViewportSize().height);
        }
        if (this._selectedList != null) {
            dimension.height = Math.max(dimension.height, this._selectedList.getPreferredScrollableViewportSize().height);
        }
        return dimension;
    }

    protected Container createButtonPanel() {
        NullPanel nullPanel = new NullPanel();
        nullPanel.setOpaque(false);
        nullPanel.setLayout(new JideBoxLayout(nullPanel, 1, 4));
        return nullPanel;
    }

    private Action createAction(String string) {
        ActionHandler actionHandler = new ActionHandler();
        actionHandler.putValue("ActionCommandKey", string);
        this.updateAction(actionHandler, string);
        return actionHandler;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.updateButtonPanel();
        }
    }

    private void updateAction(Action action, String string) {
        block21: {
            Object object;
            String string2;
            block20: {
                String string3;
                block19: {
                    block18: {
                        block17: {
                            string2 = "dualList." + string + ".";
                            try {
                                string3 = this.getResourceString(string2 + "text");
                                if (string3 != null && string3.trim().length() > 0) {
                                    action.putValue("Name", string3);
                                }
                            }
                            catch (Exception exception) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block17;
                                LOGGER.fine(exception.getMessage());
                            }
                        }
                        string3 = null;
                        try {
                            string3 = this.getResourceString(string2 + "icon");
                        }
                        catch (Exception exception) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block18;
                            LOGGER.fine(exception.getMessage());
                        }
                    }
                    if (string3 != null) {
                        if (string3.trim().length() == 0) {
                            string3 = String.format("icons/%s.png", string);
                        }
                        object = IconsFactory.getImageIcon(DualList.class, string3);
                        action.putValue("SmallIcon", object);
                    }
                    string3 = null;
                    try {
                        string3 = this.getResourceString(string2 + "disabledIcon");
                    }
                    catch (Exception exception) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block19;
                        LOGGER.fine(exception.getMessage());
                    }
                }
                if (string3 != null) {
                    if (string3.trim().length() == 0) {
                        string3 = String.format("icons/%s_disabled.png", string);
                    }
                    object = IconsFactory.getImageIcon(DualList.class, string3);
                    action.putValue("disabledIcon", object);
                }
                try {
                    object = this.getResourceString(string2 + "tooltip");
                    if (object != null && ((String)object).trim().length() > 0) {
                        action.putValue("ShortDescription", object);
                    }
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block20;
                    LOGGER.fine(exception.getMessage());
                }
            }
            try {
                object = this.getResourceString(string2 + "mnemonic");
                if (object != null && ((String)object).trim().length() > 1) {
                    action.putValue("MnemonicKey", Character.valueOf(((String)object).charAt(0)));
                }
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.FINE)) break block21;
                LOGGER.fine(exception.getMessage());
            }
        }
    }

    protected AbstractButton createButton(final Action action) {
        final JideButton jideButton = new JideButton(action);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("disabledIcon".equals(propertyChangeEvent.getPropertyName())) {
                    jideButton.setDisabledIcon((Icon)action.getValue("disabledIcon"));
                }
            }
        });
        jideButton.setName("" + action.getValue("ActionCommandKey"));
        jideButton.setDisabledIcon((Icon)action.getValue("disabledIcon"));
        jideButton.setRequestFocusEnabled(false);
        return jideButton;
    }

    private void enableAction(String string, boolean bl) {
        Action action = this._actions.get(string);
        if (action != null) {
            if (!Boolean.TRUE.equals(action.getValue("DualList.alwaysDisabled"))) {
                action.setEnabled(bl);
            } else {
                action.setEnabled(false);
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this._originalTextField.setEnabled(bl);
        this._selectedList.clearSelection();
        this._selectedList.setEnabled(bl);
        super.setEnabled(bl);
    }

    protected boolean isInputValid(String string) {
        boolean bl;
        boolean bl2 = bl = string.length() > 0;
        if (bl && !this.isAllowDuplicates()) {
            Object[] objectArray;
            for (Object object : objectArray = this.getSelectedValues()) {
                if (!string.equals(object)) continue;
                return false;
            }
        }
        return bl;
    }

    private void updateButtonPanel() {
        this.enableAction(COMMAND_MOVE_RIGHT, this.isInputValid(this._originalTextField.getText()));
        this.enableAction(COMMAND_MOVE_LEFT, !this._selectedList.isSelectionEmpty());
        boolean bl = this._selectedList.getMaxSelectionIndex() >= this._selectedList.getSelectedIndices().length;
        boolean bl2 = this._selectedList.getMinSelectionIndex() >= 0 && this._selectedList.getMinSelectionIndex() < this._selectedList.getModel().getSize() - this._selectedList.getSelectedIndices().length;
        this.enableAction(COMMAND_MOVE_UP, bl);
        this.enableAction(COMMAND_MOVE_DOWN, bl2);
        this.enableAction(COMMAND_MOVE_TO_TOP, bl);
        this.enableAction(COMMAND_MOVE_TO_BOTTOM, bl2);
    }

    private void layoutImpl() {
        int n = this.getPreferredSize().width;
        int n2 = this.getDividerSize();
        if (this._buttonPanelMiddle.isVisible()) {
            n2 = this._buttonPanelMiddle.getPreferredSize().width;
        }
        int n3 = n - n2 >> 1;
        PortingUtils.setPreferredSize(this._originalTextField.getParent().getParent(), new Dimension(n3, this.getHeight()));
        PortingUtils.setPreferredSize(this._selectedList.getParent().getParent(), new Dimension(n3, this.getHeight()));
    }

    public Object[] getSelectedValues() {
        Object[] objectArray = new Object[this._selectedListModel.getSize()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this._selectedListModel.getElementAt(i);
        }
        return objectArray;
    }

    protected void installKeyboardAction() {
        this._originalTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (TextFieldList.this._originalTextField.getText() == null) {
                    return;
                }
                int n = keyEvent.getKeyCode();
                if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    boolean bl = TextFieldList.this.getComponentOrientation().isLeftToRight();
                    if (n == 39 && bl || n == 37 && !bl) {
                        TextFieldList.this._selectedList.requestFocusInWindow();
                        if (TextFieldList.this._selectedList.getSelectedIndex() == -1 && TextFieldList.this._selectedList.getModel().getSize() > 0) {
                            TextFieldList.this._selectedList.setSelectedIndex(0);
                        }
                        keyEvent.consume();
                    }
                } else {
                    boolean bl = TextFieldList.this.getComponentOrientation().isLeftToRight();
                    if (n == 10 || (n == 39 && bl || n == 37 && !bl) && TextFieldList.this._originalTextField.getCaretPosition() >= TextFieldList.this._originalTextField.getText().length()) {
                        TextFieldList.this.performAction(TextFieldList.COMMAND_MOVE_RIGHT);
                        keyEvent.consume();
                    }
                }
            }
        });
        this._selectedList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    if (n == 38) {
                        TextFieldList.this.performAction(TextFieldList.COMMAND_MOVE_UP);
                        keyEvent.consume();
                    } else if (n == 40) {
                        TextFieldList.this.performAction(TextFieldList.COMMAND_MOVE_DOWN);
                        keyEvent.consume();
                    } else if (n == 36) {
                        TextFieldList.this.performAction(TextFieldList.COMMAND_MOVE_TO_TOP);
                        keyEvent.consume();
                    } else if (n == 35) {
                        TextFieldList.this.performAction(TextFieldList.COMMAND_MOVE_TO_BOTTOM);
                        keyEvent.consume();
                    }
                    boolean bl = TextFieldList.this.getComponentOrientation().isLeftToRight();
                    if (n == 37 && bl || n == 39 && !bl) {
                        TextFieldList.this._originalTextField.requestFocusInWindow();
                        keyEvent.consume();
                    }
                } else {
                    boolean bl = TextFieldList.this.getComponentOrientation().isLeftToRight();
                    if (n == 127 || n == 37 && bl || n == 39 && !bl) {
                        TextFieldList.this.performAction(TextFieldList.COMMAND_MOVE_LEFT);
                        keyEvent.consume();
                    } else if (n == 27 && !TextFieldList.this._selectedList.getSelectionModel().isSelectionEmpty()) {
                        TextFieldList.this._selectedList.clearSelection();
                        TextFieldList.this._selectedList.getSelectionModel().setAnchorSelectionIndex(-1);
                        keyEvent.consume();
                    }
                }
            }
        });
    }

    public void setButtonVisible(String string, boolean bl) {
        String string2;
        Container container;
        int n;
        boolean bl2 = true;
        for (n = this._buttonPanelMiddle.getComponentCount() - 1; n >= 0; --n) {
            container = (Container)this._buttonPanelMiddle.getComponent(n);
            if (container.getComponentCount() < 1) continue;
            string2 = container.getComponent(0).getName();
            if (string.equals(string2)) {
                container.setVisible(bl);
            }
            if (!this._actions.containsKey(string2) || !container.isVisible()) continue;
            this._buttonPanelMiddle.setVisible(true);
            bl2 = false;
        }
        if (bl2) {
            this._buttonPanelMiddle.setVisible(false);
        }
        bl2 = true;
        for (n = this._buttonPanelRight.getComponentCount() - 1; n >= 0; --n) {
            container = (Container)this._buttonPanelRight.getComponent(n);
            if (container.getComponentCount() < 1) continue;
            string2 = container.getComponent(0).getName();
            if (string.equals(string2)) {
                container.setVisible(bl);
            }
            if (!this._actions.containsKey(string2) || !container.isVisible()) continue;
            this._buttonPanelRight.setVisible(true);
            bl2 = false;
        }
        if (bl2) {
            this._buttonPanelRight.setVisible(false);
        }
    }

    public boolean isButtonVisible(String string) {
        Component component;
        int n;
        for (n = this._buttonPanelMiddle.getComponentCount() - 1; n >= 0; --n) {
            component = this._buttonPanelMiddle.getComponent(n);
            if (!string.equals(component.getName())) continue;
            return component.isVisible();
        }
        for (n = this._buttonPanelRight.getComponentCount() - 1; n >= 0; --n) {
            component = this._buttonPanelRight.getComponent(n);
            if (!string.equals(component.getName())) continue;
            return component.isVisible();
        }
        throw new NoSuchElementException();
    }

    public void setButtonEnabled(String string, boolean bl) {
        Action action = this._actions.get(string);
        if (action != null) {
            if (bl) {
                action.putValue("DualList.alwaysDisabled", null);
            } else {
                action.putValue("DualList.alwaysDisabled", true);
            }
        } else {
            throw new NoSuchElementException();
        }
        this.updateButtonPanel();
    }

    public boolean isButtonEnabled(String string) {
        Action action = this._actions.get(string);
        if (action != null) {
            return !Boolean.TRUE.equals(action.getValue("DualList.alwaysDisabled"));
        }
        throw new NoSuchElementException();
    }

    public ListCellRenderer getCellRenderer() {
        if (this._cellRenderer != null) {
            return this._cellRenderer;
        }
        if (_defaultRenderer == null) {
            _defaultRenderer = new DefaultListCellRenderer();
        }
        return _defaultRenderer;
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        if (!JideSwingUtilities.equals(this._cellRenderer, listCellRenderer)) {
            ListCellRenderer listCellRenderer2 = this._cellRenderer;
            this._cellRenderer = listCellRenderer;
            this.firePropertyChange("cellRenderer", listCellRenderer2, listCellRenderer);
        }
    }

    public ListCellRenderer getSelectedCellRenderer() {
        return this._selectedCellRenderer != null ? this._selectedCellRenderer : this.getCellRenderer();
    }

    public void setSelectedCellRenderer(ListCellRenderer listCellRenderer) {
        if (!JideSwingUtilities.equals(this._selectedCellRenderer, listCellRenderer)) {
            ListCellRenderer listCellRenderer2 = this._selectedCellRenderer;
            this._selectedCellRenderer = listCellRenderer;
            this.firePropertyChange("selectedRenderer", listCellRenderer2, listCellRenderer);
        }
    }

    public ListCellRenderer getDisabledCellRenderer() {
        if (this._disabledCellRenderer != null) {
            return this._disabledCellRenderer;
        }
        if (this._defaultDisabledRenderer == null) {
            this._defaultDisabledRenderer = new DefaultDisabledRenderer();
        }
        return this._defaultDisabledRenderer;
    }

    public void setDisabledCellRenderer(ListCellRenderer listCellRenderer) {
        if (!JideSwingUtilities.equals(this._disabledCellRenderer, listCellRenderer)) {
            ListCellRenderer listCellRenderer2 = this._disabledCellRenderer;
            this._disabledCellRenderer = listCellRenderer;
            this.firePropertyChange("disabledRenderer", listCellRenderer2, listCellRenderer);
        }
    }

    public void removeSelectedText(String string) {
        int n;
        Object object;
        if (string == null || string.length() <= 0) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object[] objectArray = this.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            object = objectArray[i];
            if (!string.equals(object)) continue;
            arrayList.add(i);
        }
        Object[] objectArray2 = arrayList.toArray(new Integer[arrayList.size()]);
        object = (DefaultListModel)ListModelWrapperUtils.getActualListModel(this._selectedListModel, DefaultListModel.class);
        for (n = 0; n < objectArray2.length; ++n) {
            objectArray2[n] = ListModelWrapperUtils.getActualIndexAt(this._selectedListModel, (Integer)objectArray2[n]);
        }
        Arrays.sort(objectArray2);
        for (n = objectArray2.length - 1; n >= 0 && (Integer)objectArray2[n] >= 0; --n) {
            ((DefaultListModel)object).remove((Integer)objectArray2[n]);
        }
        if (objectArray2.length > 0) {
            n = (Integer)objectArray2[objectArray2.length - 1];
            if (n >= this._selectedList.getModel().getSize()) {
                n = this._selectedList.getModel().getSize() - 1;
            }
            if (n >= 0) {
                this._selectedList.setSelectedIndex(n);
            }
        }
    }

    public void addSelectedText(String string) {
        DefaultListModel defaultListModel = (DefaultListModel)ListModelWrapperUtils.getActualListModel(this._selectedListModel, DefaultListModel.class);
        defaultListModel.add(defaultListModel.getSize(), string);
        this._selectedList.setSelectedIndex(defaultListModel.getSize() - 1);
    }

    public void moveLeft() {
        int n;
        int[] nArray = this._selectedList.getSelectedIndices();
        DefaultListModel defaultListModel = (DefaultListModel)ListModelWrapperUtils.getActualListModel(this._selectedListModel, DefaultListModel.class);
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = ListModelWrapperUtils.getActualIndexAt(this._selectedListModel, nArray[n]);
        }
        Arrays.sort(nArray);
        for (n = nArray.length - 1; n >= 0 && nArray[n] >= 0; --n) {
            defaultListModel.remove(nArray[n]);
        }
        if (nArray.length > 0) {
            n = nArray[nArray.length - 1];
            if (n >= this._selectedList.getModel().getSize()) {
                n = this._selectedList.getModel().getSize() - 1;
            }
            if (n >= 0) {
                this._selectedList.setSelectedIndex(n);
            }
        }
    }

    public void moveRight() {
        DefaultListModel defaultListModel = (DefaultListModel)ListModelWrapperUtils.getActualListModel(this._selectedListModel, DefaultListModel.class);
        defaultListModel.add(defaultListModel.getSize(), this._originalTextField.getText());
        this._selectedList.setSelectedIndex(defaultListModel.getSize() - 1);
        switch (this.getFieldTransferredMode()) {
            case 1: {
                this._originalTextField.setText(this.getStartString() == null ? "" : this.getStartString());
                break;
            }
            case 2: {
                this._originalTextField.selectAll();
                this._originalTextField.requestFocusInWindow();
                break;
            }
        }
    }

    public void moveUp() {
        int[] nArray = this._selectedList.getSelectedIndices();
        int[] nArray2 = this._selectedListModel.getIndexes();
        if (nArray2 == null) {
            this._selectedListModel.reallocateIndexes();
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n;
            int n2 = nArray[i];
            int n3 = i;
            int n4 = n2;
            while (i >= 1 && nArray[i - 1] == n4 - 1) {
                n4 = nArray[--i];
            }
            if (n4 <= 0) continue;
            int n5 = nArray2[n4 - 1];
            for (n = n4; n <= n2; ++n) {
                nArray2[n - 1] = nArray2[n];
            }
            nArray2[n2] = n5;
            n = i;
            while (n <= n3) {
                int n6 = n++;
                nArray[n6] = nArray[n6] - 1;
            }
        }
        this._selectedListModel.setIndexes(nArray2);
        this._selectedList.setSelectedIndices(nArray);
    }

    public void moveDown() {
        int[] nArray = this._selectedList.getSelectedIndices();
        int[] nArray2 = this._selectedListModel.getIndexes();
        if (nArray2 == null) {
            this._selectedListModel.reallocateIndexes();
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2 = nArray[i];
            int n3 = i;
            int n4 = n2;
            while (i < nArray.length - 1 && nArray[i + 1] == n4 + 1) {
                n4 = nArray[++i];
            }
            if (n4 >= nArray2.length - 1) continue;
            int n5 = nArray2[n4 + 1];
            for (n = n4; n >= n2; --n) {
                nArray2[n + 1] = nArray2[n];
            }
            nArray2[n2] = n5;
            n = n3;
            while (n <= i) {
                int n6 = n++;
                nArray[n6] = nArray[n6] + 1;
            }
        }
        this._selectedListModel.setIndexes(nArray2);
        this._selectedList.setSelectedIndices(nArray);
    }

    public void moveToTop() {
        int n;
        int[] nArray = this._selectedList.getSelectedIndices();
        int[] nArray2 = this._selectedListModel.getIndexes();
        if (nArray2 == null) {
            this._selectedListModel.reallocateIndexes();
            return;
        }
        if (nArray.length <= 0) {
            return;
        }
        int n2 = nArray[nArray.length - 1];
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (n = 0; n <= n2; ++n) {
            hashMap.put(n, nArray2[n]);
        }
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = (Integer)hashMap.remove(nArray[n]);
            nArray[n] = n;
        }
        Object[] objectArray = hashMap.keySet().toArray(new Integer[hashMap.size()]);
        Arrays.sort(objectArray);
        for (int i = nArray.length; i <= n2; ++i) {
            nArray2[i] = (Integer)hashMap.get(objectArray[i - nArray.length]);
        }
        this._selectedListModel.setIndexes(nArray2);
        this._selectedList.setSelectedIndices(nArray);
    }

    public void moveToBottom() {
        int n;
        int[] nArray = this._selectedList.getSelectedIndices();
        int[] nArray2 = this._selectedListModel.getIndexes();
        if (nArray2 == null) {
            this._selectedListModel.reallocateIndexes();
            return;
        }
        if (nArray.length <= 0) {
            return;
        }
        int n2 = nArray[0];
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (n = n2; n < nArray2.length; ++n) {
            hashMap.put(n, nArray2[n]);
        }
        int n3 = nArray2.length - 1;
        for (n = nArray.length - 1; n >= 0; --n) {
            nArray2[n3] = (Integer)hashMap.remove(nArray[n]);
            nArray[n] = n3--;
        }
        Object[] objectArray = hashMap.keySet().toArray(new Integer[hashMap.size()]);
        Arrays.sort(objectArray);
        n3 = nArray2.length - nArray.length - 1;
        for (int i = objectArray.length - 1; n3 >= n2 && i >= 0; --n3, --i) {
            nArray2[n3] = (Integer)hashMap.get(objectArray[i]);
        }
        this._selectedListModel.setIndexes(nArray2);
        this._selectedList.setSelectedIndices(nArray);
    }

    public void setVisibleRowCount(int n) {
        int n2 = this._selectedList.getVisibleRowCount();
        n = Math.max(0, n);
        this._selectedList.setVisibleRowCount(n);
        this.firePropertyChange("visibleRowCount", n2, n);
    }

    public int getVisibleRowCount() {
        return this._selectedList.getVisibleRowCount();
    }

    public int getFieldTransferredMode() {
        return this._fieldTransferredMode;
    }

    public void setFieldTransferredMode(int n) {
        this._fieldTransferredMode = n;
    }

    public String getStartString() {
        return this._startString;
    }

    public void setStartString(String string) {
        this._startString = string;
        if (this._originalTextField != null) {
            this._originalTextField.setText(string);
        }
    }

    private void updateArrowButtons() {
        boolean bl;
        this.updateAction(this._actions.get(COMMAND_MOVE_LEFT), (bl = this.getComponentOrientation().isLeftToRight()) ? COMMAND_MOVE_LEFT : COMMAND_MOVE_RIGHT);
        this.updateAction(this._actions.get(COMMAND_MOVE_RIGHT), bl ? COMMAND_MOVE_RIGHT : COMMAND_MOVE_LEFT);
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.list.dualList", this.getLocale()).getString(string);
    }

    protected void performAction(String string) {
        Action action = this._actions.get(string);
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(new Object(), 0, string));
        }
    }

    private JComponent createDummyPanel(Component component) {
        JPanel jPanel = JideSwingUtilities.createCenterPanel(component);
        jPanel.setCursor(Cursor.getDefaultCursor());
        return jPanel;
    }

    public boolean isAllowDuplicates() {
        return this._allowDuplicates;
    }

    public void setAllowDuplicates(boolean bl) {
        this._allowDuplicates = bl;
        this.updateButtonPanel();
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(TextFieldList.class.getName(), 4);
        }
        LOGGER = Logger.getLogger(TextFieldList.class.getName());
    }

    private class DefaultDisabledRenderer
    extends DefaultListCellRenderer {
        private DefaultDisabledRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = TextFieldList.this.getCellRenderer().getListCellRendererComponent(jList, object, n, bl, bl2);
            component.setEnabled(false);
            return component;
        }
    }

    private class ActionHandler
    extends AbstractAction
    implements MouseListener,
    ListSelectionListener,
    PropertyChangeListener {
        private static final long serialVersionUID = 4970089188727578646L;

        private ActionHandler() {
        }

        @Override
        public synchronized void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (TextFieldList.COMMAND_MOVE_LEFT.equals(string)) {
                TextFieldList.this.moveLeft();
            } else if (TextFieldList.COMMAND_MOVE_RIGHT.equals(string)) {
                TextFieldList.this.moveRight();
            } else if (TextFieldList.COMMAND_MOVE_UP.equals(string)) {
                TextFieldList.this.moveUp();
            } else if (TextFieldList.COMMAND_MOVE_DOWN.equals(string)) {
                TextFieldList.this.moveDown();
            } else if (TextFieldList.COMMAND_MOVE_TO_TOP.equals(string)) {
                TextFieldList.this.moveToTop();
            } else if (TextFieldList.COMMAND_MOVE_TO_BOTTOM.equals(string)) {
                TextFieldList.this.moveToBottom();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                TextFieldList.this.updateButtonPanel();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                Object object = mouseEvent.getSource();
                if (object == TextFieldList.this._originalTextField) {
                    TextFieldList.this.performAction(TextFieldList.COMMAND_MOVE_RIGHT);
                } else if (object == TextFieldList.this._selectedList && TextFieldList.this._selectedList.getSelectedIndex() != -1) {
                    TextFieldList.this.performAction(TextFieldList.COMMAND_MOVE_LEFT);
                }
            }
            TextFieldList.this.updateButtonPanel();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl;
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            boolean bl2 = "selectionMode".equals(string);
            boolean bl3 = "model".equals(string) && object == TextFieldList.this;
            boolean bl4 = bl = "componentOrientation".equals(string) && object == TextFieldList.this;
            if (bl2) {
                this.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
            if (bl3) {
                TextFieldList.this.updateButtonPanel();
                TextFieldList.this.layoutImpl();
            }
            if (bl) {
                TextFieldList.this.updateArrowButtons();
                TextFieldList.this.repaint();
            }
        }
    }
}

