/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortListener;
import com.jidesoft.list.CompoundListDataEvent;
import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.ListModelWrapper;
import java.util.Comparator;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;

public class SortableListModel<E>
extends DefaultListModelWrapper<E> {
    private static final long serialVersionUID = -8956513956241417515L;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = -1;
    public static final int UNSORTED = 0;
    private int _sortOrder = 1;
    private boolean _autoResort = true;
    private boolean _optimized = true;
    private ComparatorContext _comparatorContext;
    private Comparator<E> _comparator;
    private boolean _alwaysUseComparators = false;

    public SortableListModel() {
    }

    public SortableListModel(ListModel<E> listModel) {
        this.setActualModel(listModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        super.intervalAdded(listDataEvent);
        int n = this.fireIndexChanging(true);
        try {
            if (this._sortOrder == 0) {
                this.reallocateIndexes();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 1, listDataEvent.getIndex0(), listDataEvent.getIndex1()));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
                return;
            }
            if (!this.isOptimized()) {
                this.doSort();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, this.getSize() - 1));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
                return;
            }
            CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                int n2;
                if (this.isAutoResort()) {
                    n2 = this.insert(i);
                    compoundListDataEvent.addEvent(new ListDataEvent(this, 1, n2, n2));
                    continue;
                }
                n2 = this.append(i);
                compoundListDataEvent.addEvent(new ListDataEvent(this, 1, n2, n2));
            }
            CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        super.intervalRemoved(listDataEvent);
        int n = this.fireIndexChanging(true);
        try {
            if (this._sortOrder == 0) {
                this.reallocateIndexes();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 2, listDataEvent.getIndex0(), listDataEvent.getIndex1()));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
                return;
            }
            if (!this.isOptimized()) {
                this.doSort();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, this.getSize() - 1));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
                return;
            }
            if (listDataEvent.getIndex0() == 0 && listDataEvent.getIndex1() == this.getSize() - 1) {
                this.reallocateIndexes();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 2, listDataEvent.getIndex0(), listDataEvent.getIndex1()));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
            } else {
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                for (int i = listDataEvent.getIndex1(); i >= listDataEvent.getIndex0(); --i) {
                    int n2 = this.getIndexAt(i);
                    if (n2 == -1) continue;
                    this.remove(i);
                    compoundListDataEvent.addEvent(new ListDataEvent(this, 2, n2, n2));
                }
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
            }
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        super.contentsChanged(listDataEvent);
        int n = this.fireIndexChanging(true);
        try {
            if (this._sortOrder == 0) {
                this.reallocateIndexes();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, listDataEvent.getIndex0(), listDataEvent.getIndex1()));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
                return;
            }
            if (!this.isOptimized()) {
                this.doSort();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, this.getSize() - 1));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
                return;
            }
            if (this.isAutoResort()) {
                this.doSort();
            }
            CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
            compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, this.getSize() - 1));
            CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    private void doSort() {
        this.reallocateIndexes();
        if (this._indexes != null) {
            int[] nArray = this.getSortRanges();
            if (nArray.length % 2 == 1) {
                throw new IllegalArgumentException("The sort range array must have even length");
            }
            for (int i = 0; i < nArray.length; i += 2) {
                int n = nArray[i];
                int n2 = nArray[i + 1];
                this.sort((int[])this._indexes.clone(), this._indexes, n, n2);
            }
        }
    }

    protected int[] getSortRanges() {
        return new int[]{0, this._indexes.length};
    }

    protected int search(int[] nArray, int n) {
        return this.binarySearch(nArray, n);
    }

    private int binarySearch(int[] nArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = n2 = nArray.length - 1;
        boolean bl = false;
        while (n3 <= n2) {
            int n5 = n3 + n2 >> 1;
            int n6 = this.compare(nArray[n5], n);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n2 = n5 - 1;
                continue;
            }
            n4 = n5;
            bl = true;
            break;
        }
        if (!bl) {
            n4 = n3;
        }
        return n4;
    }

    protected void sort(int[] nArray, int[] nArray2, int n, int n2) {
        this.shuttlesort(nArray, nArray2, n, n2);
    }

    protected int compare(int n, int n2) {
        int n3 = this.compareRows(n, n2);
        if (n3 != 0) {
            return this._sortOrder > 0 ? n3 : -n3;
        }
        return 0;
    }

    private void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n + n2) / 2;
        this.shuttlesort(nArray2, nArray, n, n3);
        this.shuttlesort(nArray2, nArray, n3, n2);
        int n4 = n;
        int n5 = n3;
        if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
            System.arraycopy(nArray, n, nArray2, n, n2 - n);
            return;
        }
        for (int i = n; i < n2; ++i) {
            nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
        }
    }

    private int compareRows(int n, int n2) {
        Object e = this._model.getElementAt(n);
        Object e2 = this._model.getElementAt(n2);
        if (e == null && e2 == null) {
            return 0;
        }
        if (e == null) {
            return -1;
        }
        if (e2 == null) {
            return 1;
        }
        return this.compare(e, e2);
    }

    protected int compare(E e, E e2) {
        try {
            if (this.isAlwaysUseComparators() || this.getComparator() != null || this.getComparatorContext() != null) {
                Comparator comparator = this.getComparator();
                if (comparator == null) {
                    comparator = ObjectComparatorManager.getComparator(e.getClass(), this.getComparatorContext());
                }
                return comparator.compare(e, e2);
            }
            if (e == null && e2 == null) {
                return 0;
            }
            if (e == null) {
                return -1;
            }
            if (e2 == null) {
                return 1;
            }
            if (e instanceof String && e2 instanceof String) {
                return ((String)e).compareToIgnoreCase((String)e2);
            }
            if (e instanceof Comparable && e2 instanceof Comparable && e.getClass().isAssignableFrom(e2.getClass())) {
                return ((Comparable)e).compareTo(e2);
            }
            if (e instanceof Comparable && e2 instanceof Comparable && e2.getClass().isAssignableFrom(e.getClass())) {
                return ((Comparable)e2).compareTo(e);
            }
            Comparator comparator = this.getComparator();
            if (comparator == null) {
                comparator = ObjectComparatorManager.getComparator(e.getClass(), this.getComparatorContext());
            }
            return comparator.compare(e, e2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public Comparator<E> getComparator() {
        return this._comparator;
    }

    public void setComparator(Comparator<E> comparator) {
        this._comparator = comparator;
    }

    public ComparatorContext getComparatorContext() {
        return this._comparatorContext;
    }

    public void setComparatorContext(ComparatorContext comparatorContext) {
        this._comparatorContext = comparatorContext;
    }

    public int getSortOrder() {
        return this._sortOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSortOrder(int n) {
        int n2 = this.fireIndexChanging();
        try {
            if (n != 0 && n != 1 && n != -1) {
                throw new IllegalArgumentException("Sort order must be one of the three values: UNSORTED, SORT_DESCENDING or SORT_ASCENDING");
            }
            this._sortOrder = n;
            if (this._sortOrder == 0) {
                this.reset();
            } else {
                this.doSort();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, this.getSize() - 1));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
                this.fireSortEvent();
            }
        }
        finally {
            this.fireIndexChanged(n2);
        }
    }

    public void sort() {
        this.setSortOrder(1);
    }

    public void sort(int n) {
        this.fireSortingEvent();
        this.setSortOrder(n);
    }

    public void unsort() {
        this.sort(0);
    }

    public void reset() {
        int n = this.fireIndexChanging();
        try {
            this._sortOrder = 0;
            this.reallocateIndexes();
            CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
            compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, this.getSize() - 1));
            CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
            this.fireSortEvent();
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    @Override
    public void setIndexes(int[] nArray) {
        this._sortOrder = 0;
        super.setIndexes(nArray);
    }

    public static <E> SortableListModel<E> getSortableListModel(ListModel<E> listModel) {
        while (true) {
            if (listModel instanceof SortableListModel) {
                return (SortableListModel)listModel;
            }
            if (!(listModel instanceof ListModelWrapper)) break;
            listModel = ((ListModelWrapper)((Object)listModel)).getActualModel();
        }
        return null;
    }

    public boolean isOptimized() {
        return this._optimized;
    }

    public void setOptimized(boolean bl) {
        this._optimized = bl;
    }

    public boolean isAutoResort() {
        return this._autoResort;
    }

    public void setAutoResort(boolean bl) {
        this._autoResort = bl;
    }

    public void resort() {
        int n = this.fireIndexChanging();
        try {
            if (this._sortOrder != 0) {
                this.doSort();
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, this.getSize() - 1));
                CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
            }
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    public void addSortListener(SortListener sortListener) {
        this.listenerList.add(SortListener.class, sortListener);
    }

    public void removeSortListener(SortListener sortListener) {
        this.listenerList.remove(SortListener.class, sortListener);
    }

    public SortListener[] getSortListeners() {
        return (SortListener[])this.listenerList.getListeners(SortListener.class);
    }

    public void fireSortingEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i + 1]).sortChanging(sortEvent);
        }
    }

    public void fireSortEvent() {
        Object[] objectArray = this.listenerList.getListenerList();
        SortEvent sortEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SortListener.class) continue;
            if (sortEvent == null) {
                sortEvent = new SortEvent(this);
            }
            ((SortListener)objectArray[i + 1]).sortChanged(sortEvent);
        }
    }

    private void remove(int n) {
        int n2 = this.getIndexAt(n);
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length - 1];
        System.arraycopy(nArray, 0, this._indexes, 0, n2);
        System.arraycopy(nArray, n2 + 1, this._indexes, n2, this._indexes.length - n2);
        for (int i = 0; i < this._indexes.length; ++i) {
            int n3 = this._indexes[i];
            if (n3 <= n) continue;
            this._indexes[i] = n3 - 1;
        }
    }

    private int insert(int n) {
        int n2;
        for (n2 = 0; n2 < this._indexes.length; ++n2) {
            int n3 = this._indexes[n2];
            if (n3 < n) continue;
            this._indexes[n2] = n3 + 1;
        }
        n2 = this.search(this._indexes, n);
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, this._indexes, 0, n2);
        this._indexes[n2] = n;
        System.arraycopy(nArray, n2, this._indexes, n2 + 1, this._indexes.length - n2 - 1);
        return n2;
    }

    private int append(int n) {
        for (int i = 0; i < this._indexes.length; ++i) {
            int n2 = this._indexes[i];
            if (n2 < n) continue;
            this._indexes[i] = n2 + 1;
        }
        int[] nArray = (int[])this._indexes.clone();
        this._indexes = new int[nArray.length + 1];
        System.arraycopy(nArray, 0, this._indexes, 0, nArray.length);
        this._indexes[nArray.length] = n;
        return nArray.length;
    }

    public boolean isAlwaysUseComparators() {
        return this._alwaysUseComparators;
    }

    public void setAlwaysUseComparators(boolean bl) {
        this._alwaysUseComparators = bl;
    }
}

