/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.list.ListModelWrapperUtils;
import java.util.Arrays;
import javax.swing.JList;

public class ListUtils {
    public static int[] saveSelection(JList jList) {
        int[] nArray = jList.getSelectedIndices();
        if (jList.getModel() instanceof ListModelWrapper) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                nArray[i] = ListModelWrapperUtils.getActualIndexAt(jList.getModel(), n);
            }
        }
        return nArray;
    }

    public static void loadSelection(JList jList, int[] nArray) {
        if (nArray == null) {
            return;
        }
        jList.getSelectionModel().clearSelection();
        jList.getSelectionModel().setValueIsAdjusting(true);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (jList.getModel() instanceof ListModelWrapper) {
                int n2 = ListModelWrapperUtils.getIndexAt(jList.getModel(), n);
                if (n2 == -1) continue;
                jList.getSelectionModel().addSelectionInterval(n2, n2);
                continue;
            }
            jList.getSelectionModel().addSelectionInterval(n, n);
        }
        jList.getSelectionModel().setValueIsAdjusting(false);
        ListUtils.ensureSelectionVisible(jList);
    }

    public static Object[] saveSelectionByValues(JList jList) {
        return jList.getSelectedValues();
    }

    public static void loadSelectionByValues(JList jList, Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        int[] nArray = new int[objectArray.length];
        Arrays.fill(nArray, -1);
        for (int i = 0; i < jList.getModel().getSize(); ++i) {
            Object e = jList.getModel().getElementAt(i);
            for (int j = 0; j < objectArray.length; ++j) {
                if (nArray[j] != -1) continue;
                Object object = objectArray[j];
                if (object != null && object.equals(e)) {
                    nArray[j] = i;
                    continue;
                }
                if (object != null || object != e) continue;
                nArray[j] = i;
            }
        }
        jList.getSelectionModel().clearSelection();
        jList.setSelectedIndices(nArray);
        ListUtils.ensureSelectionVisible(jList);
    }

    public static void ensureSelectionVisible(JList jList) {
        int n = jList.getMaxSelectionIndex();
        if (n != -1) {
            jList.ensureIndexIsVisible(n);
        }
        int n2 = jList.getMinSelectionIndex();
        if (n != -1 && n != n2) {
            jList.ensureIndexIsVisible(n2);
        }
    }
}

