/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.AbstractGroupListModel;
import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.GroupableListModel;
import com.jidesoft.list.ListGroupChangeEvent;
import com.jidesoft.list.ListGroupChangeListener;
import com.jidesoft.list.ListModelWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class GroupableListModelWrapper
extends AbstractGroupListModel
implements ListModelWrapper {
    private static final String FORMAT = "index must be between 0(inclusive) && size(%d, exclusive), but it is %d";
    protected DefaultListModelWrapper _wrapper;
    protected Map<Object, List> _groups;
    protected Map<Integer, Object> _headers;
    private ListGroupChangeHandler _listener = new ListGroupChangeHandler();

    public GroupableListModelWrapper(GroupableListModel groupableListModel) {
        this._wrapper = new DefaultListModelWrapper();
        this.setActualModel((ListModel)groupableListModel);
    }

    public void setActualModel(ListModel listModel) {
        ListModel listModel2 = this._wrapper.getActualModel();
        if (listModel2 != null) {
            if (listModel2 instanceof GroupableListModel) {
                ((GroupableListModel)listModel2).removeListGroupChangeListener(this._listener);
            }
            listModel2.removeListDataListener(this._listener);
        }
        this._wrapper.setActualModel(listModel);
        if (listModel != null) {
            if (listModel instanceof GroupableListModel) {
                ((GroupableListModel)listModel).addListGroupChangeListener(this._listener);
            }
            listModel.addListDataListener(this._listener);
        }
        this.update();
    }

    public ListModel getActualModel() {
        return this._wrapper.getActualModel();
    }

    private void update() {
        if (this._groups == null) {
            this._groups = new LinkedHashMap<Object, List>();
        } else {
            this._groups.clear();
        }
        if (this._headers == null) {
            this._headers = new LinkedHashMap<Integer, Object>();
        } else {
            this._headers.clear();
        }
        ListModel listModel = this._wrapper.getActualModel();
        if (!(listModel instanceof GroupableListModel)) {
            return;
        }
        GroupableListModel groupableListModel = (GroupableListModel)listModel;
        Object[] objectArray = groupableListModel.getGroups();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        if (objectArray != null) {
            for (Object entry : objectArray) {
                this._groups.put(entry, new ArrayList());
                linkedHashMap.put(entry, new ArrayList());
            }
        }
        for (int i = 0; i < groupableListModel.getSize(); ++i) {
            Object object = groupableListModel.getGroupAt(i);
            List<Integer> list = this._groups.get(object);
            if (list == null) {
                list = new ArrayList();
                this._groups.put(object, list);
            }
            list.add((Integer)groupableListModel.getElementAt(i));
            list = (List)linkedHashMap.get(object);
            if (list == null) {
                list = new ArrayList();
                linkedHashMap.put(object, list);
            }
            list.add(i);
        }
        int[] nArray = new int[groupableListModel.getSize() + this._groups.size()];
        int n = 0;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            this._headers.put(n, entry.getKey());
            nArray[n] = -1;
            ++n;
            for (Integer n2 : (List)entry.getValue()) {
                nArray[n] = n2;
                ++n;
            }
        }
        this._wrapper.setIndexes(nArray);
    }

    public Object getElementAt(int n) {
        if (!this.isGroupRow(n)) {
            return this._wrapper.getElementAt(n);
        }
        return this._headers.get(n);
    }

    @Override
    public int getSize() {
        return this._wrapper.getSize();
    }

    @Override
    public int getGroupRowIndex(int n) {
        if (this.isGroupRow(n)) {
            return n;
        }
        int n2 = -1;
        for (Integer n3 : this._headers.keySet()) {
            if (n3 > n) break;
            n2 = n3;
        }
        return n2;
    }

    @Override
    public int getNextGroupRowIndex(int n) {
        int n2;
        if (0 <= n && n < (n2 = this.getSize())) {
            for (Integer n3 : this._headers.keySet()) {
                if (n3 <= n) continue;
                return n3;
            }
            return n2;
        }
        throw new IllegalArgumentException(this.ex(n));
    }

    @Override
    public boolean isGroupRow(int n) {
        return 0 <= n && n < this.getSize() && this._headers.containsKey(n);
    }

    @Override
    public int[] getGroupCellIndices() {
        int[] nArray = new int[this._headers.size()];
        int n = 0;
        for (Integer n2 : this._headers.keySet()) {
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    private String ex(int n) {
        return String.format(FORMAT, this.getSize(), n);
    }

    @Override
    public int getActualIndexAt(int n) {
        return this._wrapper.getActualIndexAt(n);
    }

    @Override
    public int getIndexAt(int n) {
        return this._wrapper.getIndexAt(n);
    }

    @Override
    public int[] getIndexes() {
        return this._wrapper.getIndexes();
    }

    @Override
    public void setIndexes(int[] nArray) {
        throw new UnsupportedOperationException("setIndexes(int[]) is not supported");
    }

    private class ListGroupChangeHandler
    implements ListGroupChangeListener,
    ListDataListener {
        private ListGroupChangeHandler() {
        }

        @Override
        public void groupChanged(ListGroupChangeEvent listGroupChangeEvent) {
            GroupableListModelWrapper.this.update();
            GroupableListModelWrapper.this.fireContentsChanged(GroupableListModelWrapper.this, 0, GroupableListModelWrapper.this.getSize());
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            GroupableListModelWrapper.this.update();
            int n = this.getIndex0(listDataEvent);
            int n2 = this.getIndex1(listDataEvent);
            GroupableListModelWrapper.this.fireContentsChanged(GroupableListModelWrapper.this, n, n2);
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            GroupableListModelWrapper.this.update();
            int n = this.getIndex0(listDataEvent);
            int n2 = this.getIndex1(listDataEvent);
            GroupableListModelWrapper.this.fireIntervalAdded(GroupableListModelWrapper.this, n, n2);
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                arrayList.add(GroupableListModelWrapper.this._wrapper.getIndexAt(i));
            }
            GroupableListModelWrapper.this.update();
            Object[] objectArray = arrayList.toArray(new Integer[arrayList.size()]);
            Arrays.sort(objectArray);
            int n = -1;
            int n2 = -1;
            for (int i = objectArray.length - 1; i >= 0; --i) {
                if (n2 != -1) {
                    if ((Integer)objectArray[i] != n2 - 1) {
                        GroupableListModelWrapper.this.fireIntervalRemoved(GroupableListModelWrapper.this, n2, n);
                        n = (Integer)objectArray[i];
                    }
                    n2 = (Integer)objectArray[i];
                    continue;
                }
                n2 = n = ((Integer)objectArray[objectArray.length - 1]).intValue();
            }
            if (n != -1) {
                GroupableListModelWrapper.this.fireIntervalRemoved(GroupableListModelWrapper.this, n2, n);
            }
        }

        private int getIndex0(ListDataEvent listDataEvent) {
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n3 = GroupableListModelWrapper.this.getSize() > 0 ? GroupableListModelWrapper.this.getSize() - 1 : 0;
            for (int i = n; i <= n2; ++i) {
                int n4 = GroupableListModelWrapper.this._wrapper.getIndexAt(i);
                if (n4 <= 0) continue;
                n3 = Math.min(n3, n4);
            }
            return n3;
        }

        private int getIndex1(ListDataEvent listDataEvent) {
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n3 = 0;
            for (int i = n; i <= n2; ++i) {
                int n4 = GroupableListModelWrapper.this._wrapper.getIndexAt(i);
                if (n4 <= 0) continue;
                n3 = Math.max(n3, n4);
            }
            return n3;
        }
    }
}

