/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.DualList;
import com.jidesoft.list.DualListModel;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.list.ListTransferHandler;
import com.jidesoft.list.ListUtils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JList;

class DualListTransferHandler
extends ListTransferHandler {
    private static final long serialVersionUID = -1303665926722010618L;
    private boolean _dualListImported;

    protected DualListTransferHandler() {
    }

    public boolean isDualListImported() {
        return this._dualListImported;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        boolean bl = super.canImport(jComponent, dataFlavorArray);
        if (bl) {
            boolean bl2;
            JList jList = (JList)jComponent;
            Object object = jList.getClientProperty("DualList.dualList");
            if (!(object instanceof DualList) || ((DualList)object).getSelectedList() != jList || this.isExporting()) {
                return bl;
            }
            JList jList2 = ((DualList)object).getSelectedList();
            boolean bl3 = bl2 = this == jList2.getTransferHandler();
            if (bl2) {
                Object[] objectArray;
                boolean bl4;
                Object[] objectArray2 = ((DualList)object).getOriginalList().getSelectedValues();
                boolean bl5 = bl4 = objectArray2.length > 0;
                if (bl4) {
                    bl4 = false;
                    for (int n : objectArray = ((DualList)object).getOriginalList().getSelectedIndices()) {
                        boolean bl6 = bl4 = !((DualList)object).getModel().isFreezeIndex(ListModelWrapperUtils.getActualIndexAt(((DualList)object).getOriginalList().getModel(), n, ((DualList)object).getModel()));
                        if (bl4) break;
                    }
                }
                if (bl4 && ((DualList)object).getSelectionMode() == 2 && !((DualList)object).isAllowDuplicates()) {
                    objectArray = ((DualList)object).getSelectedValues();
                    for (Object object2 : objectArray2) {
                        for (int n : objectArray) {
                            if (object2 != n) continue;
                            bl4 = false;
                            break;
                        }
                        if (!bl4) break;
                    }
                }
                bl = bl4;
            }
        }
        return bl;
    }

    @Override
    protected boolean importString(JComponent jComponent, String string, boolean bl) {
        DualListTransferHandler dualListTransferHandler;
        JList jList;
        this._dualListImported = false;
        if (!(jComponent instanceof JList)) {
            return false;
        }
        JList jList2 = (JList)jComponent;
        Object object = jList2.getClientProperty("DualList.dualList");
        if (!(object instanceof DualList)) {
            return false;
        }
        JList jList3 = ((DualList)object).getOriginalList();
        JList jList4 = ((DualList)object).getSelectedList();
        boolean bl2 = this == jList3.getTransferHandler();
        JList.DropLocation dropLocation = jList2.getDropLocation();
        if (dropLocation == null || !(jList3.getTransferHandler() instanceof DualListTransferHandler) || !(jList4.getTransferHandler() instanceof DualListTransferHandler)) {
            return false;
        }
        DualListTransferHandler dualListTransferHandler2 = (DualListTransferHandler)jList3.getTransferHandler();
        DualListTransferHandler dualListTransferHandler3 = (DualListTransferHandler)jList4.getTransferHandler();
        JList jList5 = bl2 ? jList4 : (jList = dualListTransferHandler3 == this ? jList3 : null);
        if (jList == null) {
            return false;
        }
        DualListTransferHandler dualListTransferHandler4 = dualListTransferHandler = bl2 ? dualListTransferHandler3 : dualListTransferHandler2;
        if (!dualListTransferHandler.isExporting() && !this.isExporting()) {
            return false;
        }
        bl = !dualListTransferHandler.isExporting();
        DualListModel dualListModel = ((DualList)object)._model;
        DefaultListModelWrapper defaultListModelWrapper = ((DualList)object)._selectedListModel;
        if (bl) {
            int n;
            int n2;
            int n3;
            if (bl2) {
                return false;
            }
            int[] nArray = jList4.getSelectedIndices();
            Arrays.sort(nArray);
            int n4 = dropLocation.getIndex();
            dualListModel.setValueIsAdjusting(true);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] <= n4) continue;
                n2 = ListModelWrapperUtils.getActualIndexAt(jList4.getModel(), nArray[n3], defaultListModelWrapper);
                n = ListModelWrapperUtils.getActualIndexAt(jList4.getModel(), n4, defaultListModelWrapper);
                dualListModel.moveSelection(n2, n2, n, true);
                nArray[n3] = n4++;
            }
            n3 = jList4.getModel().getSize();
            for (n2 = nArray.length - 1; n2 >= 0 && nArray[n2] < n4; --n2) {
                if (nArray[n2] >= n3 - (nArray.length - n2)) continue;
                n = ListModelWrapperUtils.getActualIndexAt(jList4.getModel(), nArray[n2], defaultListModelWrapper);
                int n5 = ListModelWrapperUtils.getActualIndexAt(jList4.getModel(), n4, defaultListModelWrapper);
                dualListModel.moveSelection(n, n, n5, true);
                nArray[n2] = --n4;
            }
            dualListModel.setValueIsAdjusting(false);
            jList4.setSelectedIndices(nArray);
            ListUtils.ensureSelectionVisible(jList4);
        } else if (bl2) {
            ((DualList)object).moveLeft();
        } else {
            jList4.clearSelection();
            jList4.getSelectionModel().setSelectionInterval(dropLocation.getIndex(), dropLocation.getIndex());
            boolean bl3 = dropLocation.getIndex() >= jList4.getModel().getSize();
            int n = jList3.getSelectedIndices().length;
            ((DualList)object).moveRight();
            if (bl3) {
                jList4.clearSelection();
                jList4.getSelectionModel().setSelectionInterval(dropLocation.getIndex(), dropLocation.getIndex() + n - 1);
            }
        }
        this._dualListImported = true;
        return true;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        boolean bl;
        if (!(jComponent instanceof JList)) {
            super.exportDone(jComponent, transferable, n);
            return;
        }
        JList jList = (JList)jComponent;
        Object object = jList.getClientProperty("DualList.dualList");
        if (!(object instanceof DualList)) {
            super.exportDone(jComponent, transferable, n);
            return;
        }
        JList jList2 = ((DualList)object).getOriginalList();
        JList jList3 = ((DualList)object).getSelectedList();
        boolean bl2 = bl = this == jList2.getTransferHandler();
        if (!(jList2.getTransferHandler() instanceof DualListTransferHandler) || !(jList3.getTransferHandler() instanceof DualListTransferHandler)) {
            if (bl) {
                super.exportDone(jComponent, transferable, n);
            }
            return;
        }
        DualListTransferHandler dualListTransferHandler = (DualListTransferHandler)jList2.getTransferHandler();
        DualListTransferHandler dualListTransferHandler2 = (DualListTransferHandler)jList3.getTransferHandler();
        if (!dualListTransferHandler.isDualListImported() && !dualListTransferHandler2.isDualListImported()) {
            if (bl) {
                super.exportDone(jComponent, transferable, n);
            }
            return;
        }
        if (bl && dualListTransferHandler.isDualListImported()) {
            super.exportDone(jComponent, transferable, n);
        }
        this.cleanUpFields();
    }
}

