/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.FilterableListModel;
import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.swing.CheckBoxListSelectionModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckBoxListSelectionModelWithWrapper
extends CheckBoxListSelectionModel
implements ListDataListener,
ListSelectionListener {
    private static final long serialVersionUID = 882976179331582167L;
    private boolean _filterableListModelOnly = false;
    private CheckBoxListSelectionModel _originalModel;

    public CheckBoxListSelectionModelWithWrapper() {
        this._originalModel = this.createOriginalSelectionModel();
        this._originalModel.addListSelectionListener(this);
    }

    public CheckBoxListSelectionModelWithWrapper(ListModel listModel) {
        super(listModel);
        this._originalModel = this.createOriginalSelectionModel(listModel);
        this._originalModel.addListSelectionListener(this);
        if (this.getModel() != null) {
            this.getModel().addListDataListener(this);
            boolean bl = this._filterableListModelOnly = listModel instanceof FilterableListModel || !(listModel instanceof ListModelWrapper);
            while (this._filterableListModelOnly && listModel instanceof FilterableListModel) {
                this._filterableListModelOnly = (listModel = ((FilterableListModel)listModel).getActualModel()) instanceof FilterableListModel || !(listModel instanceof ListModelWrapper);
            }
        }
    }

    protected CheckBoxListSelectionModel createOriginalSelectionModel() {
        return new CheckBoxListSelectionModel();
    }

    protected CheckBoxListSelectionModel createOriginalSelectionModel(ListModel listModel) {
        return new CheckBoxListSelectionModel(listModel);
    }

    public CheckBoxListSelectionModel getOriginalSelectionModel() {
        return this._originalModel;
    }

    @Override
    public void setModel(ListModel listModel) {
        if (this.getModel() != null) {
            this.getModel().removeListDataListener(this);
        }
        super.setModel(listModel);
        this._originalModel.setModel(listModel);
        if (this.getModel() != null) {
            this.getModel().addListDataListener(this);
            boolean bl = this._filterableListModelOnly = listModel instanceof FilterableListModel || !(listModel instanceof ListModelWrapper);
            while (this._filterableListModelOnly && listModel instanceof FilterableListModel) {
                this._filterableListModelOnly = (listModel = ((FilterableListModel)listModel).getActualModel()) instanceof FilterableListModel || !(listModel instanceof ListModelWrapper);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        int n2 = listSelectionEvent.getLastIndex();
        boolean bl = listSelectionEvent.getValueIsAdjusting();
        if (bl) {
            this.setValueIsAdjusting(bl);
        }
        if (this._filterableListModelOnly) {
            n = ListModelWrapperUtils.getIndexAt(this.getModel(), n);
            n2 = ListModelWrapperUtils.getIndexAt(this.getModel(), n2);
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = this.getModel().getSize() - 1;
            }
            this.fireValueChanged(n, n2, bl);
            if (!bl) {
                this.setValueIsAdjusting(bl);
            }
            return;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        for (int i = n; i <= n2; ++i) {
            int n5 = ListModelWrapperUtils.getIndexAt(this.getModel(), i);
            if (n5 >= 0 && n5 < n3) {
                n3 = n5;
            }
            if (n5 <= n4) continue;
            n4 = n5;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = this.getModel().getSize() - 1;
        }
        this.fireValueChanged(n3, n4, bl);
        if (!bl) {
            this.setValueIsAdjusting(bl);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public void insertIndexInterval(int n, int n2, boolean bl) {
        for (int i = n + n2 - 1; i >= 0; --i) {
            this._originalModel.insertIndexInterval(ListModelWrapperUtils.getActualIndexAt(this.getModel(), i), 1, bl);
        }
    }

    @Override
    public boolean isSelectedIndex(int n) {
        int n2 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n);
        return this._originalModel.isSelectedIndex(n2);
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        if (this._filterableListModelOnly) {
            n = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n);
            n2 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n2);
            if (n >= 0 && n2 >= 0) {
                this._originalModel.setSelectionInterval(n, n2);
            }
        } else {
            this._originalModel.clearSelection();
            for (int i = Math.min(n, n2); i <= Math.max(n, n2); ++i) {
                int n3 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), i);
                this._originalModel.addSelectionInterval(n3, n3);
            }
        }
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        if (this._filterableListModelOnly) {
            n = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n);
            n2 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n2);
            if (n >= 0 && n2 >= 0) {
                this._originalModel.addSelectionInterval(n, n2);
            }
        } else {
            for (int i = Math.min(n, n2); i <= Math.max(n, n2); ++i) {
                int n3 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), i);
                this._originalModel.addSelectionInterval(n3, n3);
            }
        }
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        if (this._filterableListModelOnly) {
            n = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n);
            n2 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n2);
            if (n >= 0 && n2 >= 0) {
                this._originalModel.removeSelectionInterval(n, n2);
            }
        } else {
            for (int i = Math.min(n, n2); i <= Math.max(n, n2); ++i) {
                int n3 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), i);
                this._originalModel.removeSelectionInterval(n3, n3);
            }
        }
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        this._originalModel.clearSelection();
    }

    @Override
    public void removeIndexInterval(int n, int n2) {
        if (this._filterableListModelOnly) {
            n = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n);
            n2 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n2);
            if (n >= 0 && n2 >= 0) {
                this._originalModel.removeIndexInterval(n, n2);
            }
        } else {
            for (int i = Math.min(n, n2); i <= Math.max(n, n2); ++i) {
                int n3 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), i);
                this._originalModel.removeIndexInterval(n3, n3);
            }
        }
    }

    @Override
    public void setAnchorSelectionIndex(int n) {
        n = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n);
        this._originalModel.setAnchorSelectionIndex(n);
    }

    @Override
    public void moveLeadSelectionIndex(int n) {
        n = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n);
        this._originalModel.moveLeadSelectionIndex(n);
    }

    @Override
    public void setLeadSelectionIndex(int n) {
        n = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n);
        this._originalModel.setLeadSelectionIndex(n);
    }

    @Override
    public int getMinSelectionIndex() {
        if (this._filterableListModelOnly) {
            int n = this._originalModel.getMinSelectionIndex();
            int n2 = ListModelWrapperUtils.getIndexAt(this.getModel(), n);
            if (n2 < 0) {
                int n3 = this._originalModel.getMaxSelectionIndex();
                for (int i = n + 1; i <= n3; ++i) {
                    n2 = ListModelWrapperUtils.getIndexAt(this.getModel(), i);
                    if (n2 < 0) continue;
                    return n2;
                }
            }
            return n2;
        }
        int n = this._originalModel.getMinSelectionIndex();
        int n4 = this._originalModel.getMaxSelectionIndex();
        int n5 = Integer.MAX_VALUE;
        for (int i = n; i <= n4; ++i) {
            int n6;
            if (!this._originalModel.isSelectedIndex(i) || (n6 = ListModelWrapperUtils.getIndexAt(this.getModel(), i)) < 0 || n6 >= n5) continue;
            n5 = n6;
        }
        return n5 == Integer.MAX_VALUE ? -1 : n5;
    }

    @Override
    public int getMaxSelectionIndex() {
        if (this._filterableListModelOnly) {
            int n = this._originalModel.getMaxSelectionIndex();
            int n2 = ListModelWrapperUtils.getIndexAt(this.getModel(), n);
            if (n2 < 0) {
                int n3 = this._originalModel.getMinSelectionIndex();
                for (int i = n - 1; i >= n3; --i) {
                    n2 = ListModelWrapperUtils.getIndexAt(this.getModel(), i);
                    if (n2 < 0) continue;
                    return n2;
                }
            }
            return n2;
        }
        int n = this._originalModel.getMaxSelectionIndex();
        int n4 = -1;
        int n5 = this._originalModel.getMinSelectionIndex();
        for (int i = n; i >= n5; --i) {
            int n6;
            if (!this._originalModel.isSelectedIndex(i) || (n6 = ListModelWrapperUtils.getIndexAt(this.getModel(), i)) <= n4) continue;
            n4 = n6;
        }
        return n4;
    }

    @Override
    public int getAnchorSelectionIndex() {
        int n = this._originalModel.getAnchorSelectionIndex();
        return ListModelWrapperUtils.getIndexAt(this.getModel(), n);
    }

    @Override
    public int getLeadSelectionIndex() {
        int n = this._originalModel.getLeadSelectionIndex();
        return ListModelWrapperUtils.getIndexAt(this.getModel(), n);
    }

    @Override
    public void setSelectionMode(int n) {
        super.setSelectionMode(n);
        if (this._originalModel != null) {
            this._originalModel.setSelectionMode(n);
        }
    }
}

