/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hssf;

import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.Field;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.hssf.HssfTableFormat;
import com.jidesoft.hssf.HssfTableUtils;
import com.jidesoft.hssf.HssfUtils;
import com.jidesoft.pivot.DummyValues;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.HeaderTable;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.RunningSummaryValues;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import com.jidesoft.utils.SystemInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class HssfPivotTableUtils
extends HssfTableUtils {
    public static boolean export(PivotTablePane pivotTablePane, String string, String string2, boolean bl) throws IOException {
        HssfTableFormat hssfTableFormat = new HssfTableFormat();
        return HssfPivotTableUtils.export(pivotTablePane, string, string2, bl, hssfTableFormat);
    }

    public static boolean export(PivotTablePane pivotTablePane, String string, String string2, boolean bl, HssfTableUtils.CellValueConverter cellValueConverter) throws IOException {
        HssfTableFormat hssfTableFormat = new HssfTableFormat();
        hssfTableFormat.setCellValueConverter(cellValueConverter);
        hssfTableFormat.setFreezePanes(true);
        return HssfPivotTableUtils.export(pivotTablePane, string, string2, bl, hssfTableFormat);
    }

    public static boolean export(PivotTablePane pivotTablePane, String string, String string2, boolean bl, HssfTableUtils.CellValueConverter cellValueConverter, boolean bl2) throws IOException {
        HssfTableFormat hssfTableFormat = new HssfTableFormat();
        hssfTableFormat.setCellValueConverter(cellValueConverter);
        hssfTableFormat.setFreezePanes(bl2);
        return HssfPivotTableUtils.export(pivotTablePane, string, string2, bl, hssfTableFormat);
    }

    public static boolean export(PivotTablePane pivotTablePane, String string, String string2, boolean bl, HssfTableFormat hssfTableFormat) throws IOException {
        Object object;
        XSSFWorkbook xSSFWorkbook;
        if (!HssfUtils.isHssfInstalled()) {
            return false;
        }
        if (!new File(string).exists()) {
            bl = false;
        }
        if ("2007".equals(pivotTablePane.getClientProperty("ExcelOutputFormat:"))) {
            xSSFWorkbook = bl ? new XSSFWorkbook((InputStream)new FileInputStream(string)) : new XSSFWorkbook();
            object = pivotTablePane.getClientProperty("UseSXSSFWorkbook");
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                Object object2 = pivotTablePane.getClientProperty("FlushRows");
                int n = 100;
                if (object2 instanceof Number) {
                    n = ((Number)object2).intValue();
                }
                xSSFWorkbook = new SXSSFWorkbook(n);
            }
        } else {
            xSSFWorkbook = bl ? new HSSFWorkbook((InputStream)new FileInputStream(string)) : new HSSFWorkbook();
        }
        HssfPivotTableUtils.exportToWorkbook((Workbook)xSSFWorkbook, string2, pivotTablePane, hssfTableFormat);
        object = new FileOutputStream(string);
        xSSFWorkbook.write((OutputStream)object);
        ((FileOutputStream)object).close();
        return true;
    }

    public static boolean export(PivotTablePane pivotTablePane, OutputStream outputStream, String string) throws IOException {
        return HssfPivotTableUtils.export(pivotTablePane, outputStream, string, null);
    }

    public static boolean export(PivotTablePane pivotTablePane, OutputStream outputStream, String string, HssfTableUtils.CellValueConverter cellValueConverter) throws IOException {
        return HssfPivotTableUtils.export(pivotTablePane, outputStream, string, cellValueConverter, true);
    }

    public static boolean export(PivotTablePane pivotTablePane, OutputStream outputStream, String string, HssfTableUtils.CellValueConverter cellValueConverter, boolean bl) throws IOException {
        Object object;
        XSSFWorkbook xSSFWorkbook;
        if (!HssfUtils.isHssfInstalled()) {
            return false;
        }
        if ("2007".equals(pivotTablePane.getClientProperty("ExcelOutputFormat:"))) {
            xSSFWorkbook = new XSSFWorkbook();
            object = pivotTablePane.getClientProperty("UseSXSSFWorkbook");
            if (object instanceof Boolean && ((Boolean)object).booleanValue()) {
                Object object2 = pivotTablePane.getClientProperty("FlushRows");
                int n = 100;
                if (object2 instanceof Number) {
                    n = ((Number)object2).intValue();
                }
                xSSFWorkbook = new SXSSFWorkbook(n);
            }
        } else {
            xSSFWorkbook = new HSSFWorkbook();
        }
        object = new HssfTableFormat();
        ((HssfTableFormat)object).setCellValueConverter(cellValueConverter);
        ((HssfTableFormat)object).setFreezePanes(bl);
        HssfPivotTableUtils.exportToWorkbook((Workbook)xSSFWorkbook, string, pivotTablePane, (HssfTableFormat)object);
        xSSFWorkbook.write(outputStream);
        outputStream.close();
        return true;
    }

    public static void exportToWorkbook(Workbook workbook, String string, PivotTablePane pivotTablePane, final HssfTableFormat hssfTableFormat) {
        int n;
        JTable jTable;
        HssfTableFormat hssfTableFormat2;
        HssfTableFormat hssfTableFormat3;
        Cloneable cloneable;
        boolean bl = workbook.getSheet(string) != null;
        Sheet sheet = bl ? workbook.getSheet(string) : workbook.createSheet(string);
        HssfTableUtils.DefaultCellValueConverter defaultCellValueConverter = new HssfTableUtils.DefaultCellValueConverter(){

            @Override
            public Object convert(JTable jTable, Object object, int n, int n2) {
                return HssfPivotTableUtils.getStringValue(jTable, hssfTableFormat.getCellValueConverter(), n, n2);
            }

            @Override
            public int getDataFormat(JTable jTable, Object object, int n, int n2) {
                return hssfTableFormat.getCellValueConverter() != null ? hssfTableFormat.getCellValueConverter().getDataFormat(jTable, object, n, n2) : -1;
            }
        };
        PivotField[] pivotFieldArray = pivotTablePane.getPivotDataModel().getRowFields();
        int n2 = -1;
        for (int i = 0; i < pivotFieldArray.length; ++i) {
            PivotField pivotField = pivotFieldArray[i];
            if (pivotTablePane.getRowHeaderTable().getColumnModel().getColumn(i).getWidth() == 0) continue;
            HssfPivotTableUtils.exportToCell(sheet, pivotTablePane.getColumnHeaderTable().getRowCount(), ++n2, pivotField.getTitle());
        }
        PivotField[] pivotFieldArray2 = pivotTablePane.getPivotDataModel().getColumnFields();
        n2 = pivotTablePane.getRowHeaderTable().getColumnCount() - pivotTablePane.getHiddenRowFields().length;
        for (int i = 0; i < pivotFieldArray2.length; ++i) {
            PivotField pivotField = pivotFieldArray2[i];
            HssfPivotTableUtils.exportToCell(sheet, 0, i + n2, pivotField.getTitle());
        }
        PivotField[] pivotFieldArray3 = pivotTablePane.getPivotDataModel().getDataFields();
        if (pivotFieldArray3.length == 1) {
            for (int i = 0; i < pivotFieldArray3.length; ++i) {
                cloneable = pivotFieldArray3[i];
                HssfPivotTableUtils.exportToCell(sheet, 0, i, ((Field)((Object)cloneable)).getTitle());
            }
        }
        int n3 = pivotTablePane.getRowHeaderTable().isVisible() ? pivotTablePane.getRowHeaderTable().getColumnCount() - pivotTablePane.getHiddenRowFields().length : 0;
        try {
            cloneable = (HssfTableFormat)hssfTableFormat.clone();
            ((HssfTableFormat)cloneable).setStartRow(pivotTablePane.getColumnHeaderTable().getRowCount() + 1 + hssfTableFormat.getStartRow());
            ((HssfTableFormat)cloneable).setStartColumn(hssfTableFormat.getStartColumn());
            ((HssfTableFormat)cloneable).setIncludeTableHeader(false);
            ((HssfTableFormat)cloneable).setCellValueConverter(defaultCellValueConverter);
            hssfTableFormat3 = (HssfTableFormat)hssfTableFormat.clone();
            hssfTableFormat3.setStartRow(1 + hssfTableFormat.getStartRow());
            hssfTableFormat3.setStartColumn(n3 + hssfTableFormat.getStartColumn());
            hssfTableFormat3.setIncludeTableHeader(false);
            hssfTableFormat3.setCellValueConverter(defaultCellValueConverter);
            hssfTableFormat2 = (HssfTableFormat)hssfTableFormat.clone();
            hssfTableFormat2.setStartRow(hssfTableFormat.getStartRow() + pivotTablePane.getColumnHeaderTable().getRowCount() + 1);
            hssfTableFormat2.setStartColumn(n3 + hssfTableFormat.getStartColumn());
            hssfTableFormat2.setIncludeTableHeader(false);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (SystemInfo.isJdk15Above()) {
                throw new IllegalStateException("Failed to clone format", cloneNotSupportedException);
            }
            throw new IllegalStateException("Failed to clone format");
        }
        if (pivotTablePane.getColumnHeaderTable().isVisible()) {
            HssfPivotTableUtils.exportToSheet(pivotTablePane.getColumnHeaderTable(), workbook, sheet, hssfTableFormat3);
        }
        JTable jTable2 = pivotTablePane.getDataTable();
        if (!workbook.getClass().getName().contains("SXSSF")) {
            if (pivotTablePane.getRowHeaderTable().isVisible()) {
                HssfPivotTableUtils.exportToSheet(pivotTablePane.getRowHeaderTable(), workbook, sheet, (HssfTableFormat)cloneable);
            }
            HssfPivotTableUtils.exportToSheet(jTable2, workbook, sheet, hssfTableFormat2);
        } else {
            int n4 = ((HssfTableFormat)cloneable).getStartRow();
            jTable = pivotTablePane.getRowHeaderTable();
            for (n = 0; n < jTable2.getRowCount(); ++n) {
                if (pivotTablePane.getRowHeaderTable().isVisible()) {
                    ((HssfTableFormat)cloneable).setStartRow(n + n4);
                    ((HssfTableFormat)cloneable).setFirstRow(n);
                    ((HssfTableFormat)cloneable).setNumberOfRows(1);
                    HssfPivotTableUtils.exportToSheet(jTable, workbook, sheet, (HssfTableFormat)cloneable);
                }
                hssfTableFormat2.setStartRow(n + n4);
                hssfTableFormat2.setFirstRow(n);
                hssfTableFormat2.setNumberOfRows(1);
                HssfPivotTableUtils.exportToSheet(jTable2, workbook, sheet, hssfTableFormat2);
            }
        }
        PrintSetup printSetup = sheet.getPrintSetup();
        sheet.setAutobreaks(true);
        printSetup.setLandscape(hssfTableFormat.isPrintLandscape());
        if (hssfTableFormat.isPrintFitToPage()) {
            printSetup.setFitHeight((short)1);
            printSetup.setFitWidth((short)1);
        }
        workbook.setPrintArea(workbook.getSheetIndex(sheet), 0, hssfTableFormat2.getStartColumn() + jTable2.getColumnCount(), 0, hssfTableFormat2.getStartRow() + jTable2.getRowCount());
        if (hssfTableFormat.isIncludePageNumbers()) {
            jTable = sheet.getFooter();
            jTable.setRight("Page " + HSSFFooter.page() + " of " + HSSFFooter.numPages());
        }
        jTable = sheet.getHeader();
        jTable.setCenter(hssfTableFormat.getHeader());
        if (hssfTableFormat.isFreezePanes() && n3 > 0) {
            sheet.createFreezePane(n3 + hssfTableFormat.getStartColumn(), pivotTablePane.getColumnHeaderTable().getRowCount() + 1 + hssfTableFormat.getStartRow());
        }
        if (hssfTableFormat.isGroupExpandable() && !workbook.getClass().getName().contains("SXSSF")) {
            n = ((HssfTableFormat)cloneable).getStartRow();
            TableModel tableModel = TableModelWrapperUtils.getActualTableModel(pivotTablePane.getRowHeaderTable().getModel(), HeaderTableModel.class);
            if (tableModel instanceof HeaderTableModel) {
                int n5 = tableModel.getColumnCount();
                int n6 = tableModel.getRowCount();
                for (int i = n5 - 2; i >= 0; --i) {
                    int n7 = 0;
                    while (n7 < n6) {
                        Values values = ((HeaderTableModel)tableModel).getValuesAt(n7);
                        Value value = values.getValueAt(i);
                        if (value instanceof Expandable && ((Expandable)((Object)value)).isExpanded() && ((Expandable)((Object)value)).hasChildren() && ((Expandable)((Object)value)).getNumberOfVisibleExpandable() > 2) {
                            int n8 = n + n7 + 1;
                            int n9 = n8 + ((Expandable)((Object)value)).getNumberOfVisibleExpandable() - 2;
                            sheet.groupRow(n8, n9);
                            n7 += ((Expandable)((Object)value)).getNumberOfVisibleExpandable();
                            continue;
                        }
                        ++n7;
                    }
                }
                if (((HeaderTableModel)tableModel).getPivotDataModel().isShowGrandTotalForRow() && n6 >= 2) {
                    sheet.groupRow(n, n + n6 - 2);
                }
            }
        }
    }

    private static Object getStringValue(JTable jTable, HssfTableUtils.CellValueConverter cellValueConverter, int n, int n2) {
        Values values;
        TableModel tableModel = jTable.getModel();
        if (jTable instanceof HeaderTable && tableModel instanceof HeaderTableModel && ((values = ((HeaderTableModel)tableModel).isRowHeader() ? ((HeaderTableModel)tableModel).getValuesAt(n) : ((HeaderTableModel)tableModel).getValuesAt(n2)) instanceof SummaryValues || values instanceof GrandTotalValues || values instanceof RunningSummaryValues || values instanceof DummyValues)) {
            return ((HeaderTable)jTable).getValueAtInString(n, n2, cellValueConverter);
        }
        return cellValueConverter == null ? jTable.getValueAt(n, n2) : cellValueConverter.convert(jTable, jTable.getValueAt(n, n2), n, n2);
    }
}

