/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.CategorizedTableModel;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ColumnWidthTableModel;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditableColumnTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.GroupableTableModel;
import com.jidesoft.grid.HierarchicalTableModel;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.NavigableModel;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.RowModel;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grouper.GrouperContext;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class TransposeTableModel
extends AbstractTableModel
implements ContextSensitiveTableModel,
StyleModel,
SpanModel,
NavigableModel,
MultiTableModel,
CategorizedTableModel,
ColumnIdentifierTableModel,
ColumnWidthTableModel,
EditableColumnTableModel,
GroupableTableModel,
HierarchicalTableModel,
RowModel,
TableModelWrapper {
    private TableModel _model;
    private String _transposedColumnName;
    private Class<?>[] _transposedColumnClasses;
    private boolean _transposed;
    private static final long serialVersionUID = -7880386008000905530L;

    public TransposeTableModel(TableModel tableModel) {
        this._model = tableModel;
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        if (this._model instanceof ContextSensitiveTableModel) {
            if (this.isTransposed()) {
                if (n2 == 0) {
                    return null;
                }
                int n3 = n2 - 1;
                n2 = n + 1;
                n = n3;
            }
            return ((ContextSensitiveTableModel)this._model).getConverterContextAt(n, n2);
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        if (this._model instanceof ContextSensitiveTableModel) {
            if (this.isTransposed()) {
                if (n2 == 0) {
                    return null;
                }
                int n3 = n2 - 1;
                n2 = n + 1;
                n = n3;
            }
            return ((ContextSensitiveTableModel)this._model).getEditorContextAt(n, n2);
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        if (this._model instanceof ContextSensitiveTableModel) {
            if (this.isTransposed()) {
                if (n2 == 0) {
                    return String.class;
                }
                int n3 = n2 - 1;
                n2 = n + 1;
                n = n3;
            }
            return ((ContextSensitiveTableModel)this._model).getCellClassAt(n, n2);
        }
        return this.getColumnClass(n2);
    }

    @Override
    public int getRowCount() {
        if (this._model != null) {
            if (this.isTransposed()) {
                return this._model.getColumnCount() - 1;
            }
            return this._model.getRowCount();
        }
        return 0;
    }

    @Override
    public int getColumnCount() {
        if (this._model != null) {
            if (this.isTransposed()) {
                return this._model.getRowCount() + 1;
            }
            return this._model.getColumnCount();
        }
        return 0;
    }

    protected String getDefaultTransposedColumnIdentifier(int n) {
        if (n < 0) {
            return "";
        }
        String string = "";
        while (n >= 0) {
            int n2 = 65 + n % 26;
            string = (char)n2 + string;
            if ((n /= 26) != 0) continue;
            break;
        }
        return string;
    }

    protected Class<?> getDefaultTransposedColumnClass(int n) {
        return Object.class;
    }

    @Override
    public String getColumnName(int n) {
        if (this._model != null) {
            if (this.isTransposed()) {
                if (n == 0) {
                    return this.getTransposedColumnName() == null ? "" : this.getTransposedColumnName();
                }
                Object object = this._model.getValueAt(n - 1, 0);
                if (this._model instanceof ContextSensitiveTableModel) {
                    return ObjectConverterManager.toString(object, ((ContextSensitiveTableModel)this._model).getCellClassAt(n, 0), ((ContextSensitiveTableModel)this._model).getConverterContextAt(n, 0));
                }
                return object == null ? "" : object.toString();
            }
            return this._model.getColumnName(n);
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (this._model != null) {
            if (this.isTransposed()) {
                if (this.getTransposedColumnClasses() != null && n >= 0 && n < this.getTransposedColumnClasses().length) {
                    return this.getTransposedColumnClasses()[n];
                }
                return this.getDefaultTransposedColumnClass(n);
            }
            return this._model.getColumnClass(n);
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this._model != null) {
            if (this.isTransposed()) {
                if (n2 == 0) {
                    return false;
                }
                int n3 = n2 - 1;
                n2 = n + 1;
                n = n3;
            }
            return this._model.isCellEditable(n, n2);
        }
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this._model != null) {
            if (this.isTransposed()) {
                if (n2 == 0) {
                    return this._model.getColumnName(n + 1);
                }
                int n3 = n2 - 1;
                n2 = n + 1;
                n = n3;
            }
            return this._model.getValueAt(n, n2);
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this._model != null) {
            if (this.isTransposed()) {
                if (n2 == 0) {
                    return;
                }
                int n3 = n2 - 1;
                n2 = n + 1;
                n = n3;
            }
            this._model.setValueAt(object, n, n2);
        }
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        if (this._model instanceof SpanModel) {
            if (this.isTransposed()) {
                if (n2 == 0) {
                    return null;
                }
                int n3 = n2 - 1;
                n = n3;
                CellSpan cellSpan = ((SpanModel)((Object)this._model)).getCellSpanAt(n, n2 = n + 1);
                CellSpan cellSpan2 = new CellSpan(cellSpan.getColumn() - 1, cellSpan.getRow(), cellSpan.getColumnSpan(), cellSpan.getRowSpan());
                if (cellSpan2.getRow() < 0) {
                    cellSpan2.setRow(0);
                    cellSpan2.setRowSpan(cellSpan2.getRowSpan() - 1);
                }
                return cellSpan2;
            }
            return ((SpanModel)((Object)this._model)).getCellSpanAt(n, n2);
        }
        return null;
    }

    @Override
    public boolean isCellSpanOn() {
        return this._model instanceof SpanModel && ((SpanModel)((Object)this._model)).isCellSpanOn();
    }

    @Override
    public CellStyle getCellStyleAt(int n, int n2) {
        if (this._model instanceof StyleModel) {
            if (this.isTransposed()) {
                if (n2 == 0) {
                    return null;
                }
                int n3 = n2 - 1;
                n2 = n + 1;
                n = n3;
            }
            return ((StyleModel)((Object)this._model)).getCellStyleAt(n, n2);
        }
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        return this._model instanceof StyleModel && ((StyleModel)((Object)this._model)).isCellStyleOn();
    }

    @Override
    public GrouperContext getGrouperContext(int n) {
        if (this._model instanceof GroupableTableModel && !this.isTransposed()) {
            return ((GroupableTableModel)this._model).getGrouperContext(n);
        }
        return null;
    }

    @Override
    public boolean isCategoryRow(int n) {
        return this._model instanceof CategorizedTableModel && !this.isTransposed() && ((CategorizedTableModel)((Object)this._model)).isCategoryRow(n);
    }

    @Override
    public Row getRowAt(int n) {
        if (this._model instanceof RowModel && !this.isTransposed()) {
            return ((RowModel)((Object)this._model)).getRowAt(n);
        }
        return null;
    }

    @Override
    public int getRowIndex(Row row) {
        if (this._model instanceof RowModel && !this.isTransposed()) {
            return ((RowModel)((Object)this._model)).getRowIndex(row);
        }
        return -1;
    }

    @Override
    public boolean isNavigableAt(int n, int n2) {
        if (this._model instanceof NavigableModel) {
            if (this.isTransposed()) {
                if (n2 == 0) {
                    return false;
                }
                int n3 = n2 - 1;
                n2 = n + 1;
                n = n3;
            }
            return ((NavigableModel)((Object)this._model)).isNavigableAt(n, n2);
        }
        return false;
    }

    @Override
    public boolean isNavigationOn() {
        return this._model instanceof NavigableModel && ((NavigableModel)((Object)this._model)).isNavigationOn();
    }

    @Override
    public int getMinimumWidth(int n) {
        if (this._model instanceof ColumnWidthTableModel && !this.isTransposed()) {
            return ((ColumnWidthTableModel)((Object)this._model)).getMinimumWidth(n);
        }
        return -1;
    }

    @Override
    public int getPreferredWidth(int n) {
        if (this._model instanceof ColumnWidthTableModel && !this.isTransposed()) {
            return ((ColumnWidthTableModel)((Object)this._model)).getPreferredWidth(n);
        }
        return -1;
    }

    @Override
    public int getMaximumWidth(int n) {
        if (this._model instanceof ColumnWidthTableModel && !this.isTransposed()) {
            return ((ColumnWidthTableModel)((Object)this._model)).getMaximumWidth(n);
        }
        return -1;
    }

    @Override
    public boolean isColumnHeaderEditable(int n) {
        return this._model instanceof EditableColumnTableModel && !this.isTransposed() && ((EditableColumnTableModel)((Object)this._model)).isColumnHeaderEditable(n);
    }

    @Override
    public TableCellEditor getColumnHeaderCellEditor(int n) {
        if (this._model instanceof EditableColumnTableModel && !this.isTransposed()) {
            return ((EditableColumnTableModel)((Object)this._model)).getColumnHeaderCellEditor(n);
        }
        return null;
    }

    @Override
    public Object getColumnIdentifier(int n) {
        if (this._model instanceof ColumnIdentifierTableModel && !this.isTransposed()) {
            return ((ColumnIdentifierTableModel)((Object)this._model)).getColumnIdentifier(n);
        }
        return this.getDefaultTransposedColumnIdentifier(n);
    }

    @Override
    public int getColumnType(int n) {
        if (this._model instanceof MultiTableModel && !this.isTransposed()) {
            return ((MultiTableModel)this._model).getColumnType(n);
        }
        if (this.isTransposed()) {
            return n <= 0 ? 1 : 0;
        }
        return 0;
    }

    @Override
    public int getTableIndex(int n) {
        if (this._model instanceof MultiTableModel && !this.isTransposed()) {
            return ((MultiTableModel)this._model).getTableIndex(n);
        }
        return 0;
    }

    @Override
    public boolean hasChild(int n) {
        return this._model instanceof HierarchicalTableModel && !this.isTransposed() && ((HierarchicalTableModel)((Object)this._model)).hasChild(n);
    }

    @Override
    public boolean isHierarchical(int n) {
        return this._model instanceof HierarchicalTableModel && !this.isTransposed() && ((HierarchicalTableModel)((Object)this._model)).isHierarchical(n);
    }

    @Override
    public Object getChildValueAt(int n) {
        if (this._model instanceof HierarchicalTableModel && !this.isTransposed()) {
            return ((HierarchicalTableModel)((Object)this._model)).getChildValueAt(n);
        }
        return null;
    }

    @Override
    public boolean isExpandable(int n) {
        return this._model instanceof HierarchicalTableModel && !this.isTransposed() && ((HierarchicalTableModel)((Object)this._model)).isExpandable(n);
    }

    @Override
    public TableModel getActualModel() {
        return this._model;
    }

    public boolean isTransposed() {
        return this._transposed;
    }

    public void setTransposed(boolean bl) {
        if (this._transposed != bl) {
            this._transposed = bl;
            this.fireTableStructureChanged();
        }
    }

    public Class<?>[] getTransposedColumnClasses() {
        return this._transposedColumnClasses;
    }

    public void setTransposedColumnClasses(Class<?>[] classArray) {
        this._transposedColumnClasses = classArray;
    }

    public String getTransposedColumnName() {
        return this._transposedColumnName;
    }

    public void setTransposedColumnName(String string) {
        this._transposedColumnName = string;
    }
}

