/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.filter.AbstractFilter;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.FilterUtils;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.filter.ObjectGrouperSupport;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ColumnTableModelWrapper;
import com.jidesoft.grid.ColumnWidthTableModel;
import com.jidesoft.grid.ContextSensitiveTable;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.DraggingTableHeader;
import com.jidesoft.grid.EditingNotStoppedException;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.FilterableTableHeaderCellDecorator;
import com.jidesoft.grid.GroupTable;
import com.jidesoft.grid.GroupableTableModel;
import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.IndexReferenceRow;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.ListSelectionModelGroup;
import com.jidesoft.grid.MixedTableSelectionModelGroup;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.MultiTableModelUtils;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.RowHeightChangeEvent;
import com.jidesoft.grid.RowHeightChangeListener;
import com.jidesoft.grid.RowHeights;
import com.jidesoft.grid.RowTableModelWrapper;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortListener;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableHeader;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableAdapter;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableColumnGroup;
import com.jidesoft.grid.TableColumnSnapshot;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.TableSelectionModel;
import com.jidesoft.grid.TableSelectionModelGroup;
import com.jidesoft.grid.TreeExpandablePanel;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grouper.GrouperContext;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.ObjectGrouperManager;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.TableHeaderUIDelegate;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.BasicTransferable;
import com.jidesoft.utils.ReflectionUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableUtils {
    public static final String CLIENT_PROPERTY_AUTO_RESIZE_CONSIDER_HEADER = "AutoResize.considerHeader";
    public static final String CLIENT_PROPERTY_AUTO_RESIZE_CONSIDER_VISIBLE_ROWS_ONLY = "AutoResize.considerVisibleRowsOnly";
    public static final String CLIENT_PROPERTY_AUTO_RESIZE_HIGH_PERFORMANCE = "AutoResize.highPerformance";
    public static final String CLIENT_PROPERTY_AUTO_RESIZE_RESPECT_COLUMN_WIDTH_TABLE_MODEL = "AutoResize.respectColumnWidthTableModel";
    public static final String CLIENT_PROPERTY_SAME_RENDERER_FOR_COLUMN = "JTable.sameRendererForColumn";
    public static final String CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT = "TableColumnSnapshot:";
    private static final String PREV_COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS = "\n\n\n:HEADER";
    private static final String PREV_COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS = "\n\n\n:DATA:";
    private static final String PREV_COLUMN_PROPERTY_GROUP_TABLE_COUNT_COLUMN = "GROUP COUNT\n\n\n:HEADER";
    public static final String COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS = ":::HEADER";
    public static final String COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS = ":::DATA:::";
    public static final String COLUMN_PROPERTY_GROUP_TABLE_COUNT_COLUMN = "GROUP_COUNT:::HEADER";
    public static final String COLUMN_PROPERTY_GROUP_TABLE_SEPARATE_GROUP_COLUMN = "GROUP_COLUMN:::HEADER";
    private static final Logger LOGGER_EVENT = Logger.getLogger(TableUtils.class.getName());
    private static int _autoResizeExtraWidth = 4;
    public static final char SEPARATOR = '\t';

    public static int[] saveRowHeights(JTable jTable) {
        int n;
        int n2;
        int n3;
        if (jTable instanceof JideTable && ((JideTable)jTable).internalGetRowHeights() == null) {
            int[] nArray = new int[]{jTable.getRowCount(), jTable.getRowHeight()};
            return nArray;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(jTable.getRowCount());
        int n4 = jTable.getRowHeight();
        arrayList.add(n4);
        if (jTable instanceof JideTable) {
            if (((JideTable)jTable).internalGetRowHeights() != null) {
                n3 = ((JideTable)jTable).getRowHeights().getRowCount();
                for (n2 = 0; n2 < n3; ++n2) {
                    int n5;
                    n = ((JideTable)jTable).getRowHeights().getRowHeight(n2);
                    if (n == n4 || (n5 = TableModelWrapperUtils.getActualRowAt(jTable.getModel(), n2)) == -1) continue;
                    arrayList.add(n5);
                    arrayList.add(n);
                }
            }
        } else {
            n3 = jTable.getRowCount();
            for (n2 = 0; n2 < n3; ++n2) {
                n = jTable.getRowHeight(n2);
                if (n == n4) continue;
                arrayList.add(TableModelWrapperUtils.getActualRowAt(jTable.getModel(), n2));
                arrayList.add(n);
            }
        }
        int[] nArray = new int[arrayList.size()];
        Object[] objectArray = arrayList.toArray();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = (Integer)objectArray[n2];
        }
        return nArray;
    }

    public static Map<Row, Integer> saveTreeTableRowHeights(TreeTable treeTable) {
        if (treeTable == null || !(treeTable.getTreeTableModel() instanceof IExpandableTreeTableModel)) {
            return null;
        }
        IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)treeTable.getTreeTableModel());
        HashMap<Row, Integer> hashMap = new HashMap<Row, Integer>();
        int n = treeTable.getRowHeight();
        hashMap.put((Row)iExpandableTreeTableModel.getRoot(), n);
        if (treeTable.internalGetRowHeights() != null) {
            int n2 = treeTable.getRowHeights().getRowCount();
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4 = treeTable.getRowHeights().getRowHeight(i);
                if (n4 == n || (n3 = TableModelWrapperUtils.getActualRowAt(treeTable.getModel(), i, (TableModel)((Object)iExpandableTreeTableModel))) == -1) continue;
                hashMap.put(iExpandableTreeTableModel.getRowAt(n3), n4);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void loadTreeTableRowHeights(TreeTable treeTable, Map<Row, Integer> map) {
        void var4_7;
        int n;
        int n2;
        if (treeTable == null || map == null || map.size() < 1) {
            return;
        }
        int n3 = -1;
        for (Row object2 : map.keySet()) {
            if (!(object2 instanceof RootExpandableRow)) continue;
            n3 = map.get(object2);
            break;
        }
        TableModel tableModel = treeTable.getTreeTableModel();
        if (n3 < 0 || !(tableModel instanceof IExpandableTreeTableModel)) {
            return;
        }
        if (treeTable.isRowAutoResizes()) {
            treeTable.clearRowHeightsValidity();
            return;
        }
        RowHeights rowHeights = treeTable.internalGetRowHeights();
        if (rowHeights != null) {
            rowHeights.setFireEvent(false);
            n2 = treeTable.getRowCount();
            n = rowHeights.getRowCount();
            if (n2 > n) {
                rowHeights.insertRows(n, n2 - n, n3);
            } else if (n2 < n) {
                rowHeights.removeRows(n2, n - n2);
            }
            rowHeights.setFireEvent(true);
        }
        treeTable.setRowHeight(n3);
        if (map.size() == 1) {
            if (rowHeights != null) {
                treeTable.setRowHeights(rowHeights);
            }
            return;
        }
        n2 = treeTable.getRowCount();
        if (rowHeights == null) {
            RowHeights rowHeights2 = treeTable.getRowHeights();
        }
        var4_7.setFireEvent(false);
        try {
            for (n = 0; n < n2; ++n) {
                var4_7.setRowHeight(n, n3);
            }
            for (Row row : map.keySet()) {
                if (row == null) continue;
                int n4 = tableModel instanceof DefaultGroupTableModel ? ((DefaultGroupTableModel)tableModel).getSimilarRowIndex(row) : ((IExpandableTreeTableModel)((Object)tableModel)).getRowIndex(row);
                int n5 = TableModelWrapperUtils.getRowAt(treeTable.getModel(), tableModel, n4);
                if (n5 < 0 || n5 >= n2) continue;
                var4_7.setRowHeight(n5, map.get(row));
            }
        }
        finally {
            var4_7.setFireEvent(true);
            treeTable.setRowHeights((RowHeights)var4_7);
        }
    }

    static void adjustSavedRowHeightsRowsInserted(int[] nArray, int n, int n2) {
        if (nArray == null || nArray.length < 2 || nArray.length % 2 != 0) {
            return;
        }
        int n3 = n2 - n + 1;
        for (int i = 2; i < nArray.length; i += 2) {
            if (nArray[i] < n) continue;
            int n4 = i;
            nArray[n4] = nArray[n4] + n3;
        }
    }

    static void adjustSavedRowHeightsRowsDeleted(int[] nArray, int n, int n2) {
        if (nArray == null || nArray.length < 2 || nArray.length % 2 != 0) {
            return;
        }
        int n3 = n2 - n + 1;
        for (int i = 2; i < nArray.length; i += 2) {
            if (nArray[i] > n2) {
                int n4 = i;
                nArray[n4] = nArray[n4] - n3;
                continue;
            }
            if (nArray[i] < n) continue;
            nArray[i] = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadRowHeights(JTable jTable, int[] nArray) {
        int n;
        int n2;
        if (nArray == null || nArray.length < 2 || nArray.length % 2 != 0) {
            if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                if (nArray == null) {
                    LOGGER_EVENT.fine("TableUtils \" Saved row heights are null.");
                } else {
                    LOGGER_EVENT.fine("TableUtils \" Saved row heights are not valid. It's length is " + nArray.length + ".");
                }
            }
            return;
        }
        RowHeights rowHeights = null;
        if (jTable instanceof JideTable) {
            if (((JideTable)jTable).isRowAutoResizes()) {
                ((JideTable)jTable).clearRowHeightsValidity();
                return;
            }
            rowHeights = ((JideTable)jTable).internalGetRowHeights();
            if (rowHeights != null) {
                rowHeights.setFireEvent(false);
                n2 = jTable.getRowCount();
                n = rowHeights.getRowCount();
                if (n2 > n) {
                    rowHeights.insertRows(n, n2 - n, nArray[1]);
                } else if (n2 < n) {
                    rowHeights.removeRows(n2, n - n2);
                }
                rowHeights.setFireEvent(true);
            }
        }
        jTable.setRowHeight(nArray[1]);
        if (nArray.length == 2) {
            if (jTable instanceof JideTable && rowHeights != null) {
                ((JideTable)jTable).setRowHeights(rowHeights);
            }
            return;
        }
        n2 = jTable.getRowCount();
        if (!(jTable instanceof JideTable)) {
            for (n = 2; n < nArray.length; n += 2) {
                int n3 = TableModelWrapperUtils.getRowAt(jTable.getModel(), nArray[n]);
                if (n3 < 0 || n3 >= n2) continue;
                jTable.setRowHeight(n3, nArray[n + 1]);
            }
            return;
        }
        if (rowHeights == null) {
            rowHeights = ((JideTable)jTable).getRowHeights();
        }
        rowHeights.setFireEvent(false);
        try {
            for (n = 0; n < n2; ++n) {
                rowHeights.setRowHeight(n, nArray[1]);
            }
            for (n = 2; n < nArray.length; n += 2) {
                int n4 = TableModelWrapperUtils.getRowAt(jTable.getModel(), nArray[n]);
                if (n4 < 0 || n4 >= n2) continue;
                rowHeights.setRowHeight(n4, nArray[n + 1]);
            }
        }
        finally {
            rowHeights.setFireEvent(true);
            ((JideTable)jTable).setRowHeights(rowHeights);
        }
    }

    public static int[] saveSelection(JTable jTable) {
        return TableUtils.saveTableSelection(jTable);
    }

    private static int[] saveTableSelection(JTable jTable) {
        int[] nArray = null;
        TableModel tableModel = jTable.getModel();
        int n = jTable.getRowCount();
        int n2 = jTable.getColumnCount();
        if (jTable instanceof JideTable && ((JideTable)jTable).isNonContiguousCellSelection()) {
            TableSelectionModel tableSelectionModel = ((JideTable)jTable).getTableSelectionModel();
            if (!tableSelectionModel.isSelectionEmpty()) {
                int[] nArray2 = new int[2 * n * n2 + 4];
                int n3 = 0;
                nArray2[n3++] = TableModelWrapperUtils.getActualRowAt(tableModel, tableSelectionModel.getLeadRowIndex());
                nArray2[n3++] = TableModelWrapperUtils.getActualColumnAt(tableModel, tableSelectionModel.getLeadColumnIndex());
                nArray2[n3++] = TableModelWrapperUtils.getActualRowAt(tableModel, tableSelectionModel.getAnchorRowIndex());
                nArray2[n3++] = TableModelWrapperUtils.getActualColumnAt(tableModel, tableSelectionModel.getAnchorColumnIndex());
                for (int i = tableSelectionModel.getMinSelectedRowIndex(); i <= tableSelectionModel.getMaxSelectedRowIndex() && i < n; ++i) {
                    for (int j = tableSelectionModel.getMinSelectedColumnIndex(); j <= tableSelectionModel.getMaxSelectedColumnIndex() && j < n2; ++j) {
                        if (!tableSelectionModel.isSelected(i, j)) continue;
                        nArray2[n3++] = TableModelWrapperUtils.getActualRowAt(tableModel, i);
                        nArray2[n3++] = TableModelWrapperUtils.getActualColumnAt(tableModel, j);
                    }
                }
                nArray = new int[n3];
                System.arraycopy(nArray2, 0, nArray, 0, n3);
            }
        } else {
            ListSelectionModel listSelectionModel = jTable.getColumnModel().getSelectionModel();
            ListSelectionModel listSelectionModel2 = jTable.getSelectionModel();
            if (jTable.getColumnSelectionAllowed() && !jTable.getRowSelectionAllowed()) {
                int[] nArray3 = jTable.getSelectedColumns();
                if (nArray3.length > 0) {
                    nArray = new int[nArray3.length + 4];
                    nArray[0] = TableModelWrapperUtils.getActualRowAt(tableModel, listSelectionModel2.getLeadSelectionIndex());
                    nArray[1] = TableModelWrapperUtils.getActualColumnAt(tableModel, listSelectionModel.getLeadSelectionIndex());
                    nArray[2] = TableModelWrapperUtils.getActualRowAt(tableModel, listSelectionModel2.getAnchorSelectionIndex());
                    nArray[3] = TableModelWrapperUtils.getActualColumnAt(tableModel, listSelectionModel.getAnchorSelectionIndex());
                    for (int i = 0; i < nArray3.length; ++i) {
                        nArray[4 + i] = TableModelWrapperUtils.getActualColumnAt(tableModel, nArray3[i]);
                    }
                }
            } else if (!jTable.getColumnSelectionAllowed() && jTable.getRowSelectionAllowed()) {
                int[] nArray4 = jTable.getSelectedRows();
                if (nArray4.length > 0) {
                    nArray = new int[nArray4.length + 4];
                    nArray[0] = TableModelWrapperUtils.getActualRowAt(tableModel, listSelectionModel2.getLeadSelectionIndex());
                    nArray[1] = TableModelWrapperUtils.getActualColumnAt(tableModel, listSelectionModel.getLeadSelectionIndex());
                    nArray[2] = TableModelWrapperUtils.getActualRowAt(tableModel, listSelectionModel2.getAnchorSelectionIndex());
                    nArray[3] = TableModelWrapperUtils.getActualColumnAt(tableModel, listSelectionModel.getAnchorSelectionIndex());
                    for (int i = 0; i < nArray4.length; ++i) {
                        nArray[4 + i] = TableModelWrapperUtils.getActualRowAt(tableModel, nArray4[i]);
                    }
                }
            } else if (!listSelectionModel2.isSelectionEmpty()) {
                int[] nArray5 = new int[2 * n * n2];
                int n4 = 0;
                for (int i = listSelectionModel2.getMinSelectionIndex(); i <= listSelectionModel2.getMaxSelectionIndex() && i < n; ++i) {
                    for (int j = listSelectionModel.getMinSelectionIndex(); j <= listSelectionModel.getMaxSelectionIndex() && j < n2; ++j) {
                        if (!jTable.isCellSelected(i, j)) continue;
                        nArray5[n4++] = TableModelWrapperUtils.getActualRowAt(tableModel, i);
                        nArray5[n4++] = TableModelWrapperUtils.getActualColumnAt(tableModel, j);
                    }
                }
                nArray = new int[n4 + 4];
                nArray[0] = TableModelWrapperUtils.getActualRowAt(tableModel, listSelectionModel2.getLeadSelectionIndex());
                nArray[1] = TableModelWrapperUtils.getActualColumnAt(tableModel, listSelectionModel.getLeadSelectionIndex());
                nArray[2] = TableModelWrapperUtils.getActualRowAt(tableModel, listSelectionModel2.getAnchorSelectionIndex());
                nArray[3] = TableModelWrapperUtils.getActualColumnAt(tableModel, listSelectionModel.getAnchorSelectionIndex());
                System.arraycopy(nArray5, 0, nArray, 4, n4);
            }
        }
        return nArray == null ? new int[]{} : nArray;
    }

    static void adjustSavedSelectionRowsInserted(JTable jTable, int[] nArray, int n, int n2) {
        block8: {
            int n3;
            block10: {
                block9: {
                    block7: {
                        if (nArray == null || nArray.length == 0) {
                            return;
                        }
                        n3 = n2 - n + 1;
                        if (!(jTable instanceof JideTable) || !((JideTable)jTable).isNonContiguousCellSelection()) break block7;
                        for (int i = 0; i < nArray.length; ++i) {
                            if (i % 2 != 0 || nArray[i] < n) continue;
                            int n4 = i;
                            nArray[n4] = nArray[n4] + n3;
                        }
                        break block8;
                    }
                    if (!jTable.getColumnSelectionAllowed() || jTable.getRowSelectionAllowed()) break block9;
                    if (nArray.length < 4) break block8;
                    if (nArray[0] >= n) {
                        nArray[0] = nArray[0] + n3;
                    }
                    if (nArray[2] < n) break block8;
                    nArray[2] = nArray[2] + n3;
                    break block8;
                }
                if (jTable.getColumnSelectionAllowed() || !jTable.getRowSelectionAllowed()) break block10;
                if (nArray.length < 4) break block8;
                if (nArray[0] >= n) {
                    nArray[0] = nArray[0] + n3;
                }
                if (nArray[2] >= n) {
                    nArray[2] = nArray[2] + n3;
                }
                for (int i = 4; i < nArray.length; ++i) {
                    if (nArray[i] < n) continue;
                    int n5 = i;
                    nArray[n5] = nArray[n5] + n3;
                }
                break block8;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (i % 2 != 0 || nArray[i] < n) continue;
                int n6 = i;
                nArray[n6] = nArray[n6] + n3;
            }
        }
    }

    static void adjustSavedSelectionRowsDeleted(JTable jTable, int[] nArray, int n, int n2) {
        block17: {
            int n3;
            block20: {
                block18: {
                    block19: {
                        block16: {
                            if (nArray == null || nArray.length == 0) {
                                return;
                            }
                            n3 = n2 - n + 1;
                            if (!(jTable instanceof JideTable) || !((JideTable)jTable).isNonContiguousCellSelection()) break block16;
                            for (int i = 0; i < nArray.length; ++i) {
                                if (i % 2 != 0) continue;
                                if (nArray[i] > n2) {
                                    int n4 = i;
                                    nArray[n4] = nArray[n4] - n3;
                                    continue;
                                }
                                if (nArray[i] < n) continue;
                                nArray[i] = -1;
                            }
                            break block17;
                        }
                        if (!jTable.getColumnSelectionAllowed() || jTable.getRowSelectionAllowed()) break block18;
                        if (nArray.length < 4) break block17;
                        if (nArray[0] > n2) {
                            nArray[0] = nArray[0] - n3;
                        } else if (nArray[0] >= n) {
                            nArray[0] = -1;
                        }
                        if (nArray[2] <= n2) break block19;
                        nArray[2] = nArray[2] - n3;
                        break block17;
                    }
                    if (nArray[2] < n) break block17;
                    nArray[2] = -1;
                    break block17;
                }
                if (jTable.getColumnSelectionAllowed() || !jTable.getRowSelectionAllowed()) break block20;
                if (nArray.length < 4) break block17;
                if (nArray[0] > n2) {
                    nArray[0] = nArray[0] - n3;
                } else if (nArray[0] >= n) {
                    nArray[0] = -1;
                }
                if (nArray[2] > n2) {
                    nArray[2] = nArray[2] - n3;
                } else if (nArray[2] >= n) {
                    nArray[2] = -1;
                }
                for (int i = 4; i < nArray.length; ++i) {
                    if (nArray[i] > n2) {
                        int n5 = i;
                        nArray[n5] = nArray[n5] - n3;
                        continue;
                    }
                    if (nArray[i] < n) continue;
                    nArray[i] = -1;
                }
                break block17;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (i % 2 != 0) continue;
                if (nArray[i] > n2) {
                    int n6 = i;
                    nArray[n6] = nArray[n6] - n3;
                    continue;
                }
                if (nArray[i] < n) continue;
                nArray[i] = -1;
            }
        }
    }

    public static void loadSelection(JTable jTable, int[] nArray) {
        TableUtils.loadSelection(jTable, nArray, jTable.getAutoscrolls());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadSelection(JTable jTable, int[] nArray, boolean bl) {
        int n;
        int n2;
        if (nArray == null) return;
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = TableUtils.saveSelection(jTable);
        if (JideSwingUtilities.equals(nArray2, nArray, true)) {
            boolean bl2 = true;
            if (jTable instanceof JideTable && ((JideTable)jTable).isNonContiguousCellSelection()) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (i % 2 != 0 || nArray[i] < 0) continue;
                    return;
                }
            } else if (jTable.getColumnSelectionAllowed() && !jTable.getRowSelectionAllowed()) {
                if (nArray.length >= 4) {
                    if (nArray[0] >= 0) return;
                    if (nArray[2] >= 0) {
                        return;
                    }
                }
            } else if (!jTable.getColumnSelectionAllowed() && jTable.getRowSelectionAllowed()) {
                if (nArray.length >= 4) {
                    if (nArray[0] >= 0 || nArray[2] >= 0) {
                        bl2 = false;
                    }
                    for (int i = 4; i < nArray.length; ++i) {
                        if (nArray[i] < 0) continue;
                        return;
                    }
                }
            } else {
                for (int i = 0; i < nArray.length; ++i) {
                    if (i % 2 != 0 || nArray[i] < 0) continue;
                    return;
                }
            }
            if (!bl2) return;
            jTable.clearSelection();
            return;
        }
        int[] nArray3 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        TableModel tableModel = jTable.getModel();
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
        if (jTable instanceof JideTable && ((JideTable)jTable).isNonContiguousCellSelection()) {
            int n3;
            int n4;
            if (tableModel instanceof RowTableModelWrapper) {
                for (n4 = 0; n4 < nArray3.length; n4 += 2) {
                    n3 = nArray3[n4];
                    nArray3[n4] = TableModelWrapperUtils.getRowAt(tableModel, n3);
                }
            }
            if (tableModel instanceof ColumnTableModelWrapper) {
                for (n4 = 0; n4 < nArray3.length; n4 += 2) {
                    n3 = nArray3[n4 + 1];
                    nArray3[n4] = TableModelWrapperUtils.getColumnAt(tableModel, n3);
                }
            }
            TableSelectionModel tableSelectionModel = ((JideTable)jTable).getTableSelectionModel();
            tableSelectionModel.setValueAdjusting(true);
            listSelectionModel.setValueIsAdjusting(true);
            listSelectionModel2.setValueIsAdjusting(true);
            try {
                tableSelectionModel.clearSelection();
                tableSelectionModel.setAnchorSelection(nArray3[2], nArray3[3]);
                listSelectionModel.setAnchorSelectionIndex(nArray3[2]);
                listSelectionModel2.setAnchorSelectionIndex(nArray3[3]);
                n3 = 0;
                for (int i = 4; i < nArray3.length; i += 2) {
                    int n5 = nArray3[i];
                    int n6 = nArray3[i + 1];
                    if (nArray3[0] == n5 && nArray3[1] == n6) {
                        n3 = 1;
                        continue;
                    }
                    if (!TableUtils.isRowValid(jTable, n5) || !TableUtils.isColumnValid(jTable, n6)) continue;
                    tableSelectionModel.addSelection(n5, n6);
                }
                if (n3 == 0) return;
                tableSelectionModel.addSelection(nArray3[0], nArray3[1]);
                tableSelectionModel.moveLeadSelection(nArray3[0], nArray3[1]);
                listSelectionModel.addSelectionInterval(nArray3[0], nArray3[0]);
                listSelectionModel2.addSelectionInterval(nArray3[1], nArray3[1]);
                return;
            }
            finally {
                tableSelectionModel.setValueAdjusting(false);
                listSelectionModel.setValueIsAdjusting(false);
                listSelectionModel2.setValueIsAdjusting(false);
            }
        }
        if (jTable.getColumnSelectionAllowed() && !jTable.getRowSelectionAllowed()) {
            int n7;
            int n8;
            if (tableModel instanceof ColumnTableModelWrapper) {
                for (n8 = 0; n8 < nArray3.length; ++n8) {
                    if (n8 == 0 || n8 == 2 || (n7 = nArray3[n8]) == -1) continue;
                    nArray3[n8] = TableModelWrapperUtils.getColumnAt(tableModel, n7);
                }
            }
            if (tableModel instanceof RowTableModelWrapper) {
                n8 = nArray3[0];
                if (n8 != -1) {
                    nArray3[0] = TableModelWrapperUtils.getRowAt(tableModel, n8);
                }
                if ((n8 = nArray3[2]) != -1) {
                    nArray3[2] = TableModelWrapperUtils.getRowAt(tableModel, n8);
                }
            }
            listSelectionModel2.clearSelection();
            listSelectionModel.clearSelection();
            n8 = nArray3[0];
            n7 = nArray3[1];
            int n9 = nArray3[2];
            int n10 = nArray3[3];
            listSelectionModel2.setValueIsAdjusting(true);
            listSelectionModel.setValueIsAdjusting(true);
            try {
                boolean bl3 = false;
                for (int i = 0; i < nArray3.length - 4; ++i) {
                    int n11 = nArray3[i + 4];
                    if (n7 != n11 && TableUtils.isColumnValid(jTable, n11)) {
                        listSelectionModel2.addSelectionInterval(n11, n11);
                        continue;
                    }
                    if (n7 != n11) continue;
                    bl3 = true;
                }
                if (TableUtils.isColumnValid(jTable, n7)) {
                    if (bl3) {
                        listSelectionModel2.addSelectionInterval(n7, n7);
                    }
                    listSelectionModel2.setAnchorSelectionIndex(n10);
                }
                if (!TableUtils.isRowValid(jTable, n8)) return;
                if (bl3) {
                    listSelectionModel.addSelectionInterval(n8, n8);
                }
                listSelectionModel.setAnchorSelectionIndex(n9);
                return;
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
                listSelectionModel2.setValueIsAdjusting(false);
            }
        }
        if (!jTable.getColumnSelectionAllowed() && jTable.getRowSelectionAllowed()) {
            int n12;
            int n13;
            if (tableModel instanceof RowTableModelWrapper) {
                for (n13 = 0; n13 < nArray3.length; ++n13) {
                    if (n13 == 1 || n13 == 3 || (n12 = nArray3[n13]) == -1) continue;
                    nArray3[n13] = TableModelWrapperUtils.getRowAt(tableModel, n12);
                }
            }
            if (tableModel instanceof ColumnTableModelWrapper) {
                n13 = nArray3[1];
                if (n13 != -1) {
                    nArray3[1] = TableModelWrapperUtils.getColumnAt(tableModel, n13);
                }
                if ((n13 = nArray3[3]) != -1) {
                    nArray3[3] = TableModelWrapperUtils.getColumnAt(tableModel, n13);
                }
            }
            listSelectionModel.setValueIsAdjusting(true);
            listSelectionModel2.setValueIsAdjusting(true);
            try {
                listSelectionModel.clearSelection();
                n13 = nArray3[0];
                n12 = nArray3[1];
                int n14 = nArray3[2];
                int n15 = nArray3[3];
                boolean bl4 = false;
                for (int i = 0; i < nArray3.length - 4; ++i) {
                    int n16 = nArray3[i + 4];
                    if (n13 != n16 && TableUtils.isRowValid(jTable, n16)) {
                        listSelectionModel.addSelectionInterval(n16, n16);
                        continue;
                    }
                    if (n13 != n16) continue;
                    bl4 = true;
                }
                if (TableUtils.isRowValid(jTable, n13)) {
                    if (bl4) {
                        listSelectionModel.addSelectionInterval(n13, n13);
                    }
                    listSelectionModel.setAnchorSelectionIndex(n14);
                }
                if (TableUtils.isColumnValid(jTable, n12)) {
                    if (bl4) {
                        listSelectionModel2.addSelectionInterval(n12, n12);
                    }
                    listSelectionModel2.setAnchorSelectionIndex(n15);
                }
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
                listSelectionModel2.setValueIsAdjusting(false);
            }
            if (!bl) return;
            TableUtils.ensureRowSelectionVisible(jTable);
            return;
        }
        if (tableModel instanceof RowTableModelWrapper) {
            for (n2 = 0; n2 < nArray3.length; n2 += 2) {
                n = nArray3[n2];
                nArray3[n2] = TableModelWrapperUtils.getRowAt(tableModel, n);
            }
        }
        if (tableModel instanceof ColumnTableModelWrapper) {
            for (n2 = 0; n2 < nArray3.length; n2 += 2) {
                n = nArray3[n2 + 1];
                nArray3[n2] = TableModelWrapperUtils.getColumnAt(tableModel, n);
            }
        }
        listSelectionModel.clearSelection();
        listSelectionModel2.clearSelection();
        n2 = nArray3[0];
        n = nArray3[1];
        int n17 = nArray3[2];
        int n18 = nArray3[3];
        listSelectionModel.setValueIsAdjusting(true);
        listSelectionModel2.setValueIsAdjusting(true);
        boolean bl5 = false;
        for (int i = 0; i < nArray3.length - 4; i += 2) {
            int n19 = nArray3[i + 4];
            int n20 = nArray3[i + 5];
            if (n19 != n2 || n20 != n) {
                if (TableUtils.isRowValid(jTable, n19)) {
                    listSelectionModel.addSelectionInterval(n19, n19);
                }
                if (!TableUtils.isColumnValid(jTable, n20)) continue;
                listSelectionModel2.addSelectionInterval(n20, n20);
                continue;
            }
            bl5 = true;
        }
        if (bl5 && TableUtils.isRowValid(jTable, n2)) {
            listSelectionModel.addSelectionInterval(n2, n2);
            listSelectionModel.setAnchorSelectionIndex(n17);
        }
        if (bl5 && TableUtils.isColumnValid(jTable, n)) {
            listSelectionModel2.addSelectionInterval(n, n);
            listSelectionModel2.setAnchorSelectionIndex(n18);
        }
        listSelectionModel.setValueIsAdjusting(false);
    }

    private static boolean isColumnValid(JTable jTable, int n) {
        return n >= 0 && n < jTable.getColumnCount();
    }

    private static boolean isRowValid(JTable jTable, int n) {
        return n >= 0 && n < jTable.getRowCount();
    }

    public static Row[] saveSelection(TreeTable treeTable) {
        TableModel tableModel = treeTable.getTreeTableModel();
        if (treeTable.isNonContiguousCellSelection()) {
            int[] nArray = TableUtils.saveTableSelection(treeTable);
            Row[] rowArray = new Row[nArray.length];
            if (tableModel instanceof IExpandableTreeTableModel) {
                for (int i = 0; i < nArray.length; i += 2) {
                    rowArray[i] = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(nArray[i]);
                    rowArray[i + 1] = new ColumnSelectionRow(nArray[i + 1]);
                }
            }
            return rowArray;
        }
        int[] nArray = treeTable.getSelectedRows();
        if (nArray.length == 0) {
            return new Row[0];
        }
        Row[] rowArray = new Row[nArray.length + 1];
        if (tableModel instanceof IExpandableTreeTableModel) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                int n2 = TableModelWrapperUtils.getActualRowAt(treeTable.getModel(), n, tableModel);
                if (tableModel instanceof DefaultGroupTableModel) {
                    rowArray[i] = ((DefaultGroupTableModel)tableModel).getRowAt(n2, true);
                    if (!(rowArray[i] instanceof IndexReferenceRow)) continue;
                    int n3 = ((IndexReferenceRow)rowArray[i]).getRowIndex();
                    int n4 = TableModelWrapperUtils.getActualRowAt(((DefaultGroupTableModel)tableModel).getActualModel(), n3);
                    rowArray[i] = new IndexReferenceRow((DefaultGroupTableModel)tableModel, ((IndexReferenceRow)rowArray[i]).getTableModel(), n4);
                    continue;
                }
                rowArray[i] = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(n2);
            }
            rowArray[nArray.length] = new ColumnSelectionRow(treeTable.getSelectedColumn());
        }
        return rowArray;
    }

    public static void loadSelection(TreeTable treeTable, Row[] rowArray) {
        TableUtils.loadSelection(treeTable, rowArray, treeTable.getAutoscrolls());
    }

    public static void loadSelection(TreeTable treeTable, Row[] rowArray, boolean bl) {
        TableUtils.loadSelection(treeTable, rowArray, bl, false);
    }

    public static void loadSelection(TreeTable treeTable, Row[] rowArray, boolean bl, boolean bl2) {
        TableUtils.loadSelection(treeTable, rowArray, bl, bl2, false);
    }

    static void loadSelection(TreeTable treeTable, Row[] rowArray, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (rowArray == null || rowArray.length == 0) {
            return;
        }
        if (bl2 && JideSwingUtilities.equals(rowArray, object = TableUtils.saveSelection(treeTable), true)) {
            return;
        }
        object = treeTable.getTreeTableModel();
        if (!bl3) {
            treeTable.getSelectionModel().clearSelection();
        }
        if (object instanceof IExpandableTreeTableModel) {
            if (treeTable.isNonContiguousCellSelection()) {
                int[] nArray = new int[rowArray.length];
                Arrays.fill(nArray, -1);
                for (int i = 0; i < nArray.length; ++i) {
                    int n;
                    int n2;
                    Row row = rowArray[i];
                    if (row == null) continue;
                    if (row instanceof ColumnSelectionRow) {
                        nArray[i] = ((ColumnSelectionRow)row).getSelectedColumn();
                        continue;
                    }
                    if (object instanceof DefaultGroupTableModel) {
                        if (row instanceof IndexReferenceRow) {
                            n2 = ((IndexReferenceRow)row).getRowIndex();
                            int n3 = TableModelWrapperUtils.getRowAt(((DefaultGroupTableModel)object).getActualModel(), n2);
                            if (n3 < 0) continue;
                            row = new IndexReferenceRow((DefaultGroupTableModel)object, ((IndexReferenceRow)row).getTableModel(), n3);
                        }
                        n = ((DefaultGroupTableModel)object).getSimilarRowIndex(row);
                    } else {
                        n = ((IExpandableTreeTableModel)object).getRowIndex(row);
                    }
                    if (n != -1) {
                        nArray[i] = n;
                        continue;
                    }
                    n2 = -1;
                    for (Row row2 = (Row)((Object)row.getParent()); row2 != null && (n2 = ((IExpandableTreeTableModel)object).getRowIndex(row2)) == -1; row2 = (Row)((Object)row2.getParent())) {
                    }
                    if (n2 == -1) continue;
                    nArray[i] = n2;
                }
                TableUtils.loadSelection((JTable)treeTable, nArray, bl);
            } else {
                treeTable.getSelectionModel().setValueIsAdjusting(true);
                for (Row row : rowArray) {
                    int n;
                    int n4;
                    if (row == null) continue;
                    if (object instanceof DefaultGroupTableModel) {
                        if (row instanceof IndexReferenceRow) {
                            n4 = ((IndexReferenceRow)row).getRowIndex();
                            int n5 = TableModelWrapperUtils.getRowAt(((DefaultGroupTableModel)object).getActualModel(), n4);
                            if (n5 < 0) continue;
                            row = new IndexReferenceRow((DefaultGroupTableModel)object, ((IndexReferenceRow)row).getTableModel(), n5);
                        }
                        n = ((DefaultGroupTableModel)object).getSimilarRowIndex(row);
                    } else {
                        n = ((IExpandableTreeTableModel)object).getRowIndex(row);
                    }
                    if (n != -1) {
                        if (bl3 && treeTable.getSelectionModel().isSelectedIndex(n)) continue;
                        n4 = TableModelWrapperUtils.getRowAt(treeTable.getModel(), (TableModel)object, n);
                        treeTable.getSelectionModel().addSelectionInterval(n4, n4);
                        continue;
                    }
                    if (!treeTable.isSelectParentRowWhenCollapsing()) continue;
                    n4 = -1;
                    for (Row row3 = (Row)((Object)row.getParent()); row3 != null && (n4 = ((IExpandableTreeTableModel)object).getRowIndex(row3)) == -1; row3 = (Row)((Object)row3.getParent())) {
                    }
                    if (n4 == -1) continue;
                    int n6 = TableModelWrapperUtils.getRowAt(treeTable.getModel(), (TableModel)object, n4);
                    treeTable.getSelectionModel().addSelectionInterval(n6, n6);
                }
                if (rowArray.length > 0 && rowArray[rowArray.length - 1] instanceof ColumnSelectionRow) {
                    int n = ((ColumnSelectionRow)rowArray[rowArray.length - 1]).getSelectedColumn();
                    if (n >= 0 && n < treeTable.getColumnCount()) {
                        if (n != treeTable.getSelectedColumn()) {
                            treeTable.getColumnModel().getSelectionModel().setSelectionInterval(n, n);
                        }
                    } else {
                        treeTable.getColumnModel().getSelectionModel().clearSelection();
                    }
                }
                treeTable.getSelectionModel().setValueIsAdjusting(false);
            }
        }
        if (bl) {
            TableUtils.ensureRowSelectionVisible(treeTable);
        }
    }

    private static int getIndexOf(String[] stringArray, int n, Object object) {
        for (int i = 0; i < n && i * 6 + 2 < stringArray.length; ++i) {
            String string = stringArray[i * 6 + 2];
            if (!string.equals(object)) continue;
            return i;
        }
        return -1;
    }

    private static int getIndexOf(TableModel tableModel, String string) {
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            Object object = tableModel.getColumnName(i);
            if (tableModel instanceof ColumnIdentifierTableModel) {
                object = ((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(i);
                object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
                object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
                object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_GROUP_TABLE_COUNT_COLUMN);
            }
            if (!JideSwingUtilities.equals(object, string)) continue;
            return i;
        }
        return -1;
    }

    private static Object getColumnIdentifier(TableModel tableModel, int n) {
        return tableModel instanceof ColumnIdentifierTableModel ? ((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(n) : tableModel.getColumnName(n);
    }

    private static int[] getReverseIndices(int[] nArray) {
        int n;
        int[] nArray2 = new int[nArray.length];
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            nArray2[n] = -1;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] < 0) {
                nArray2[--n2] = n;
                continue;
            }
            if (nArray[n] >= n2) {
                if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                LOGGER_EVENT.fine("TableUtils \" View index should not be larger than visible column count.");
                continue;
            }
            nArray2[nArray[n]] = n;
        }
        return nArray2;
    }

    public static Object eraseIdentifierFlag(Object object, String string) {
        if (!(object instanceof String)) {
            return object;
        }
        int n = ((String)object).indexOf(string);
        if (n != -1) {
            object = ((String)object).substring(0, n);
        }
        return object;
    }

    private static String getTableColumnWidthString(JTable jTable) {
        StringBuffer stringBuffer = new StringBuffer();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            Object object = tableColumn.getIdentifier();
            object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
            object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
            stringBuffer.append(object).append('\t');
            stringBuffer.append(i).append('\t');
            stringBuffer.append(tableColumn.getMaxWidth()).append('\t');
            stringBuffer.append(tableColumn.getMinWidth()).append('\t');
            stringBuffer.append(tableColumn.getPreferredWidth()).append('\t');
            stringBuffer.append(tableColumn.getWidth()).append('\t');
        }
        return new String(stringBuffer);
    }

    public static String getTablePreferenceByName(JTable jTable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = jTable.getModel().getColumnCount();
        stringBuffer.append(n).append('\t');
        stringBuffer.append(jTable.getWidth()).append('\t');
        stringBuffer.append(TableUtils.getTableColumnWidthString(jTable));
        TableColumnSnapshot tableColumnSnapshot = (TableColumnSnapshot)jTable.getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT);
        if (tableColumnSnapshot == null) {
            tableColumnSnapshot = new TableColumnSnapshot();
        }
        tableColumnSnapshot.record(jTable, true, false);
        stringBuffer.append('\t').append('\t');
        stringBuffer.append(tableColumnSnapshot.toString());
        tableColumnSnapshot.removePreferenceSaved();
        if (tableColumnSnapshot.getSize() == 0) {
            tableColumnSnapshot = null;
        }
        jTable.putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
        return new String(stringBuffer.deleteCharAt(stringBuffer.length() - 1));
    }

    public static String getTablePreferenceByName(TableScrollPane tableScrollPane) {
        TableColumnSnapshot tableColumnSnapshot;
        StringBuffer stringBuffer = new StringBuffer();
        JTable jTable = tableScrollPane.getRowHeaderTable();
        JTable jTable2 = tableScrollPane.getMainTable();
        JTable jTable3 = tableScrollPane.getRowFooterTable();
        if (jTable2 == null) {
            return "";
        }
        int n = jTable2.getColumnCount();
        if (jTable != null) {
            n += jTable.getColumnCount();
        }
        if (jTable3 != null) {
            n += jTable3.getColumnCount();
        }
        stringBuffer.append(n).append('\t');
        stringBuffer.append(jTable2.getWidth()).append('\t');
        if (jTable != null && jTable.getColumnCount() != 0) {
            stringBuffer.append(TableUtils.getTableColumnWidthString(jTable));
        }
        if (jTable2.getColumnCount() != 0) {
            stringBuffer.append(TableUtils.getTableColumnWidthString(jTable2));
        }
        if (jTable3 != null && jTable3.getColumnCount() != 0) {
            stringBuffer.append(TableUtils.getTableColumnWidthString(jTable3));
        }
        if ((tableColumnSnapshot = (TableColumnSnapshot)jTable2.getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT)) == null) {
            tableColumnSnapshot = new TableColumnSnapshot();
        }
        tableColumnSnapshot.record(tableScrollPane, true);
        stringBuffer.append('\t').append('\t');
        stringBuffer.append(tableColumnSnapshot.toString());
        tableColumnSnapshot.removePreferenceSaved();
        if (tableColumnSnapshot.getSize() == 0) {
            tableColumnSnapshot = null;
        }
        jTable2.putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
        return new String(stringBuffer.deleteCharAt(stringBuffer.length() - 1));
    }

    private static String parsePreference(String string) {
        string = string.replaceAll(PREV_COLUMN_PROPERTY_GROUP_TABLE_COUNT_COLUMN, COLUMN_PROPERTY_GROUP_TABLE_COUNT_COLUMN);
        string = string.replaceAll(PREV_COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS, COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
        string = string.replaceAll(PREV_COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS, COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
        return string;
    }

    public static boolean setTablePreferenceByName(JTable jTable, String string) {
        return TableUtils.setTablePreferenceByName(jTable, string, true);
    }

    public static boolean setTablePreferenceByName(JTable jTable, String string, boolean bl) {
        return TableUtils.setTablePreferenceByName(jTable, string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setTablePreferenceByName(JTable jTable, String string, boolean bl, boolean bl2) {
        String string2;
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        if ((string = TableUtils.parsePreference(string)).equals(string2 = TableUtils.getTablePreferenceByName(jTable))) {
            return false;
        }
        String[] stringArray = string.split("\t\t\t");
        TableColumnSnapshot tableColumnSnapshot = null;
        if (stringArray.length >= 2) {
            tableColumnSnapshot = new TableColumnSnapshot(stringArray[1]);
            tableColumnSnapshot.record(jTable, true, false);
        }
        if (!(tableColumnSnapshot != null && tableColumnSnapshot.isInPreferenceState() || (tableColumnSnapshot = (TableColumnSnapshot)jTable.getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT)) != null)) {
            tableColumnSnapshot = new TableColumnSnapshot();
        }
        String[] stringArray2 = stringArray[0].split("\t");
        try {
            int n;
            boolean bl3;
            int n2 = Integer.valueOf(stringArray2[0]);
            int n3 = jTable.getModel().getColumnCount();
            TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), DefaultGroupTableModel.class);
            boolean bl4 = bl3 = !(tableModel instanceof DefaultGroupTableModel) || !((DefaultGroupTableModel)tableModel).isKeepColumnOrder();
            if (!bl3) {
                boolean bl5 = false;
                return bl5;
            }
            if (tableColumnSnapshot.isInPreferenceState()) {
                TableUtils.adjustColumnOrderAndWidth(jTable, null, tableColumnSnapshot, stringArray2, n2, bl, bl2);
            } else {
                int n4;
                int n5;
                int n6;
                int n7;
                for (n = 0; n < n3; ++n) {
                    n7 = jTable.convertColumnIndexToView(n);
                    n6 = TableUtils.getIndexOf(stringArray2, n2, TableUtils.getColumnIdentifier(jTable.getModel(), n));
                    if (n6 == -1 || n7 == -1) continue;
                    n5 = n6 * 6 + 2 + 1;
                    int n8 = n4 = n5 >= stringArray2.length ? -1 : Integer.valueOf(stringArray2[n5]);
                    if (n4 != -1) continue;
                    TableColumnChooser.hideColumn(jTable, n, false);
                }
                for (n = 0; n < n2; ++n) {
                    n7 = jTable.convertColumnIndexToView(n);
                    n6 = TableUtils.getIndexOf(stringArray2, n2, TableUtils.getColumnIdentifier(jTable.getModel(), n));
                    if (n6 == -1 || n7 != -1) continue;
                    n5 = n6 * 6 + 2 + 1;
                    int n9 = n4 = n5 >= stringArray2.length ? -1 : Integer.valueOf(stringArray2[n5]);
                    if (n4 == -1) continue;
                    TableColumnChooser.showColumn(jTable, n, n7, false);
                }
                for (n = n2 - 1; n >= 0; --n) {
                    n7 = jTable.convertColumnIndexToView(n);
                    n6 = TableUtils.getIndexOf(stringArray2, n2, TableUtils.getColumnIdentifier(jTable.getModel(), n));
                    if (n6 == -1) continue;
                    n5 = n6 * 6 + 2 + 1;
                    int n10 = n4 = n5 >= stringArray2.length ? -1 : Integer.valueOf(stringArray2[n5]);
                    if (n7 == n4) continue;
                    jTable.moveColumn(n7, Math.min(n4, jTable.getColumnCount() - 1));
                }
                block9: for (n = 0; n < n2 && (n7 = n * 6 + 2 + 1) < stringArray2.length; ++n) {
                    n6 = Integer.valueOf(stringArray2[n7]);
                    if (n6 == -1) continue;
                    for (n5 = 0; n5 < jTable.getColumnModel().getColumnCount(); ++n5) {
                        int n11;
                        TableColumn tableColumn = jTable.getColumnModel().getColumn(n5);
                        if (tableColumn.getModelIndex() != n || (n11 = TableUtils.getIndexOf(stringArray2, n2, TableUtils.getColumnIdentifier(jTable.getModel(), n))) == -1) continue;
                        int n12 = Integer.valueOf(stringArray2[n11 * 6 + 2 + 2]);
                        int n13 = Integer.valueOf(stringArray2[n11 * 6 + 2 + 3]);
                        int n14 = Integer.valueOf(stringArray2[n11 * 6 + 2 + 4]);
                        int n15 = Integer.valueOf(stringArray2[n11 * 6 + 2 + 5]);
                        tableColumn.setMaxWidth(n12);
                        tableColumn.setMinWidth(n13);
                        tableColumn.setPreferredWidth(n14);
                        tableColumn.setWidth(n15);
                        continue block9;
                    }
                }
            }
            n = 1;
            return n != 0;
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            tableColumnSnapshot.removePreferenceSaved();
            if (tableColumnSnapshot.getSize() == 0) {
                tableColumnSnapshot = null;
            }
            jTable.putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
        }
        return false;
    }

    private static void clearTableColumnAndGetIdentifierList(JTable jTable, List<Object> list, List<TableColumn> list2, boolean bl) {
        Object object;
        Object object2;
        int n;
        Object object3;
        if (jTable instanceof GroupTable && (object3 = (DefaultGroupTableModel)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), DefaultGroupTableModel.class)) != null && ((DefaultGroupTableModel)object3).isDisplayGroupColumns()) {
            for (n = 0; n < ((DefaultGroupTableModel)object3).getGroupColumnCount(); ++n) {
                object2 = ((DefaultGroupTableModel)object3).getGroupColumnIdentifier(n);
                object = new TableColumn(n + (((DefaultGroupTableModel)object3).isDisplayCountColumn() ? 1 : 0));
                list.add(object2);
                list2.add((TableColumn)object);
            }
        }
        object3 = jTable.getColumnModel();
        for (n = 0; n < jTable.getModel().getColumnCount(); ++n) {
            object2 = TableUtils.eraseIdentifierFlag(TableUtils.getColumnIdentifier(jTable.getModel(), n), COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
            if (list.contains(object2 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS)) continue;
            int n2 = -1;
            for (int i = object3.getColumnCount() - 1; i >= 0; --i) {
                if (!JideSwingUtilities.equals(object2, TableUtils.eraseIdentifierFlag(object3.getColumn(i).getIdentifier(), COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS))) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                object = (TableColumn)jTable.getClientProperty("TableColumnIdentifier:" + object2);
                if (object == null) {
                    object = (TableColumn)jTable.getClientProperty("TableColumnIdentifier:" + object2 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
                }
                if (object == null) {
                    if (bl) continue;
                    object = new TableColumn(n);
                }
            } else {
                object = object3.getColumn(n2);
            }
            if (((TableColumn)object).getModelIndex() != n) {
                ((TableColumn)object).setModelIndex(n);
            }
            if (COLUMN_PROPERTY_GROUP_TABLE_COUNT_COLUMN.equals(object2)) {
                list.add(0, object2);
                list2.add(0, (TableColumn)object);
                continue;
            }
            list.add(object2);
            list2.add((TableColumn)object);
        }
        for (n = object3.getColumnCount() - 1; n >= 0; --n) {
            object2 = object3.getColumn(n);
            object = TableUtils.eraseIdentifierFlag(((TableColumn)object2).getIdentifier(), COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
            if (!list.contains(object) && !list.contains(object + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS)) {
                list.add(object);
                list2.add((TableColumn)object2);
            }
            jTable.removeColumn((TableColumn)object2);
        }
        for (n = list.size() - 1; n >= 0; --n) {
            object2 = list.get(n);
            if (object2 instanceof String) continue;
            list.remove(n);
            list.add(n, object2 == null ? "" : object2.toString());
        }
    }

    public static boolean setTablePreferenceByName(TableScrollPane tableScrollPane, String string) {
        return TableUtils.setTablePreferenceByName(tableScrollPane, string, true);
    }

    public static boolean setTablePreferenceByName(TableScrollPane tableScrollPane, String string, boolean bl) {
        return TableUtils.setTablePreferenceByName(tableScrollPane, string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setTablePreferenceByName(TableScrollPane tableScrollPane, String string, boolean bl, boolean bl2) {
        String string2;
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        if ((string = TableUtils.parsePreference(string)).equals(string2 = TableUtils.getTablePreferenceByName(tableScrollPane))) {
            return false;
        }
        String[] stringArray = string.split("\t\t\t");
        JTable jTable = tableScrollPane.getMainTable();
        TableColumnSnapshot tableColumnSnapshot = null;
        if (stringArray.length >= 2) {
            tableColumnSnapshot = new TableColumnSnapshot(stringArray[1]);
            tableColumnSnapshot.record(tableScrollPane, true);
        }
        if (!(tableColumnSnapshot != null && tableColumnSnapshot.isInPreferenceState() || (tableColumnSnapshot = (TableColumnSnapshot)jTable.getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT)) != null)) {
            tableColumnSnapshot = new TableColumnSnapshot();
        }
        String[] stringArray2 = stringArray[0].split("\t");
        try {
            boolean bl3;
            int n = Integer.valueOf(stringArray2[0]);
            TableModel tableModel = TableModelWrapperUtils.getActualTableModel(tableScrollPane.getTableModel(), DefaultGroupTableModel.class);
            boolean bl4 = bl3 = !(tableModel instanceof DefaultGroupTableModel) || !((DefaultGroupTableModel)tableModel).isKeepColumnOrder();
            if (tableColumnSnapshot.isInPreferenceState() && bl3) {
                TableUtils.adjustColumnOrderAndWidth(tableScrollPane, null, tableColumnSnapshot, stringArray2, n, bl, bl2);
            } else if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                LOGGER_EVENT.fine("TableUtils \" This is a new interface for TableScrollPane, which should always have column order information.");
            }
            boolean bl5 = true;
            return bl5;
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            tableColumnSnapshot.removePreferenceSaved();
            if (tableColumnSnapshot.getSize() == 0) {
                tableColumnSnapshot = null;
            }
            jTable.putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
        }
        return false;
    }

    public static void adjustColumnOrderAndWidth(JTable jTable, Map<String, Integer> map, TableColumnSnapshot tableColumnSnapshot, String[] stringArray, int n, boolean bl, boolean bl2) {
        int n2;
        int[] nArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<TableColumn> arrayList2 = new ArrayList<TableColumn>();
        TableUtils.clearTableColumnAndGetIdentifierList(jTable, arrayList, arrayList2, bl);
        if (tableColumnSnapshot != null) {
            nArray = tableColumnSnapshot.SearchViewIndicesInSavedPreference(arrayList, bl2);
        } else if (map != null) {
            nArray = TableUtils.getViewIndices(map, arrayList);
        } else {
            return;
        }
        int[] nArray2 = TableUtils.getReverseIndices(nArray);
        for (int i = 0; i < arrayList.size() && i < nArray2.length; ++i) {
            n2 = nArray2[i];
            if (n2 < 0 || n2 >= arrayList.size()) {
                if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                LOGGER_EVENT.fine("TableUtils \" Reverse index should always be valid.");
                continue;
            }
            Object e = arrayList.get(n2);
            TableColumn tableColumn = (TableColumn)arrayList2.get(n2);
            int n3 = nArray[n2];
            if (n3 == -1) {
                TableUtils.updateClientPropertyForColumn(jTable, e, tableColumn);
                continue;
            }
            if (jTable.getClientProperty("TableColumnIdentifier:" + e) != null) {
                TableUtils.updateClientPropertyForColumn(jTable, e, null);
            }
            jTable.addColumn(tableColumn);
        }
        HashMap<TableColumnModel, TableColumnModelListener[]> hashMap = new HashMap<TableColumnModel, TableColumnModelListener[]>();
        TableUtils.saveListeners(hashMap, jTable);
        for (n2 = 0; n2 < arrayList.size() && n2 < nArray2.length; ++n2) {
            int n4 = nArray2[n2];
            if (n4 < 0 || n4 >= arrayList.size()) {
                if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                LOGGER_EVENT.fine("TableUtils \" Reverse index should always be valid.");
                continue;
            }
            int n5 = nArray[n4];
            if (n5 == -1) continue;
            Object object = arrayList.get(n4);
            TableColumn tableColumn = (TableColumn)arrayList2.get(n4);
            int n6 = TableUtils.getIndexOf(stringArray, n, object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS));
            if (n6 == -1) continue;
            int n7 = Integer.valueOf(stringArray[n6 * 6 + 2 + 2]);
            int n8 = Integer.valueOf(stringArray[n6 * 6 + 2 + 3]);
            int n9 = Integer.valueOf(stringArray[n6 * 6 + 2 + 4]);
            int n10 = Integer.valueOf(stringArray[n6 * 6 + 2 + 5]);
            tableColumn.setMaxWidth(n7);
            tableColumn.setMinWidth(n8);
            tableColumn.setPreferredWidth(n9);
            tableColumn.setWidth(n10);
        }
        TableUtils.restoreListeners(hashMap, jTable);
    }

    static void updateClientPropertyForColumn(JTable jTable, Object object, TableColumn tableColumn) {
        ArrayList arrayList = jTable.getClientProperty("HiddenIdentifiersList");
        if (!(arrayList instanceof List)) {
            arrayList = new ArrayList();
        }
        if (tableColumn == null) {
            ((List)arrayList).remove(object);
        } else {
            ((List)arrayList).add(object);
        }
        jTable.putClientProperty("HiddenIdentifiersList", arrayList);
        jTable.putClientProperty("TableColumnIdentifier:" + object, tableColumn);
    }

    public static void adjustColumnOrderAndWidth(TableScrollPane tableScrollPane, Map<String, Integer> map, TableColumnSnapshot tableColumnSnapshot, String[] stringArray, int n, boolean bl, boolean bl2) {
        Object object;
        int[] nArray;
        int n2;
        JTable jTable;
        Object object2;
        Object object3;
        int n3;
        JTable jTable2 = tableScrollPane.getRowHeaderTable();
        JTable jTable3 = tableScrollPane.getMainTable();
        JTable jTable4 = tableScrollPane.getRowFooterTable();
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (MultiTableModelUtils.getColumnCount(tableScrollPane.getTableModel(), 1, 0) != 0) {
            arrayList.add(jTable2);
        }
        if (MultiTableModelUtils.getColumnCount(tableScrollPane.getTableModel(), 0, 0) != 0) {
            arrayList.add(jTable3);
        }
        if (MultiTableModelUtils.getColumnCount(tableScrollPane.getTableModel(), 2, 0) != 0) {
            arrayList.add(jTable4);
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList<JTable> arrayList4 = new ArrayList<JTable>();
        MultiTableModel multiTableModel = tableScrollPane.getTableModel();
        TableColumnModel tableColumnModel = tableScrollPane.getMainTable().getColumnModel();
        TableColumnModel tableColumnModel2 = tableScrollPane.getRowHeaderTable().getColumnModel();
        TableColumnModel tableColumnModel3 = tableScrollPane.getRowFooterTable().getColumnModel();
        block5: for (n3 = 0; n3 < multiTableModel.getColumnCount(); ++n3) {
            TableColumn tableColumn;
            object3 = TableUtils.eraseIdentifierFlag(TableUtils.getColumnIdentifier(multiTableModel, n3), COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
            if (arrayList2.contains(object3 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS)) continue;
            switch (multiTableModel.getColumnType(n3)) {
                case 1: {
                    object2 = tableColumnModel2;
                    jTable = tableScrollPane.getRowHeaderTable();
                    break;
                }
                case 0: {
                    object2 = tableColumnModel;
                    jTable = tableScrollPane.getMainTable();
                    break;
                }
                case 2: {
                    object2 = tableColumnModel3;
                    jTable = tableScrollPane.getRowFooterTable();
                    break;
                }
                default: {
                    continue block5;
                }
            }
            n2 = -1;
            for (int i = object2.getColumnCount() - 1; i >= 0; --i) {
                if (!JideSwingUtilities.equals(object3, TableUtils.eraseIdentifierFlag(object2.getColumn(i).getIdentifier(), COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS))) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                tableColumn = (TableColumn)jTable3.getClientProperty("TableColumnIdentifier:" + object3);
                if (tableColumn == null) {
                    tableColumn = (TableColumn)jTable3.getClientProperty("TableColumnIdentifier:" + object3 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
                }
                if (tableColumn == null && jTable3 != jTable && (tableColumn = (TableColumn)jTable.getClientProperty("TableColumnIdentifier:" + object3)) == null) {
                    tableColumn = (TableColumn)jTable.getClientProperty("TableColumnIdentifier:" + object3 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
                }
                if (tableColumn == null) {
                    if (bl) continue;
                    tableColumn = new TableColumn(n3);
                }
            } else {
                tableColumn = object2.getColumn(n2);
            }
            if (tableColumn.getModelIndex() != n3) {
                tableColumn.setModelIndex(n3);
            }
            if (COLUMN_PROPERTY_GROUP_TABLE_COUNT_COLUMN.equals(object3)) {
                arrayList2.add(0, object3);
                arrayList3.add(0, tableColumn);
                arrayList4.add(0, jTable);
                continue;
            }
            arrayList2.add(object3);
            arrayList3.add(tableColumn);
            arrayList4.add(jTable);
        }
        for (n3 = tableColumnModel2.getColumnCount() - 1; n3 >= 0; --n3) {
            object3 = tableColumnModel2.getColumn(n3);
            object2 = TableUtils.eraseIdentifierFlag(((TableColumn)object3).getIdentifier(), COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
            if (!arrayList2.contains(object2) && !arrayList2.contains(object2 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS)) {
                arrayList2.add(object2);
                arrayList3.add(object3);
                arrayList4.add(tableScrollPane.getRowHeaderTable());
            }
            tableColumnModel2.removeColumn((TableColumn)object3);
        }
        for (n3 = tableColumnModel.getColumnCount() - 1; n3 >= 0; --n3) {
            object3 = tableColumnModel.getColumn(n3);
            object2 = TableUtils.eraseIdentifierFlag(((TableColumn)object3).getIdentifier(), COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
            if (!arrayList2.contains(object2) && !arrayList2.contains(object2 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS)) {
                arrayList2.add(object2);
                arrayList3.add(object3);
                arrayList4.add(tableScrollPane.getMainTable());
            }
            tableColumnModel.removeColumn((TableColumn)object3);
        }
        for (n3 = tableColumnModel3.getColumnCount() - 1; n3 >= 0; --n3) {
            object3 = tableColumnModel3.getColumn(n3);
            object2 = TableUtils.eraseIdentifierFlag(((TableColumn)object3).getIdentifier(), COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
            if (!arrayList2.contains(object2) && !arrayList2.contains(object2 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS)) {
                arrayList2.add(object2);
                arrayList3.add(object3);
                arrayList4.add(tableScrollPane.getRowFooterTable());
            }
            tableColumnModel3.removeColumn((TableColumn)object3);
        }
        for (n3 = arrayList2.size() - 1; n3 >= 0; --n3) {
            object3 = arrayList2.get(n3);
            if (object3 instanceof String) continue;
            arrayList2.remove(n3);
            arrayList2.add(n3, object3 == null ? "" : object3.toString());
        }
        for (n3 = 0; n3 < tableScrollPane.getModel().getColumnCount(); ++n3) {
            object3 = TableUtils.eraseIdentifierFlag(TableUtils.getColumnIdentifier(tableScrollPane.getModel(), n3), COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
            if (arrayList2.contains(object3 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS) || arrayList2.contains(object3)) continue;
            object2 = (TableColumn)tableScrollPane.getMainTable().getClientProperty("TableColumnIdentifier:" + object3);
            if (object2 == null) {
                object2 = (TableColumn)tableScrollPane.getMainTable().getClientProperty("TableColumnIdentifier:" + object3 + COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
            }
            if (object2 == null || ((TableColumn)object2).getModelIndex() == n3) continue;
            ((TableColumn)object2).setModelIndex(n3);
        }
        if (tableColumnSnapshot != null) {
            nArray = tableColumnSnapshot.SearchViewIndicesInSavedPreference(arrayList2, bl2);
        } else if (map != null) {
            nArray = TableUtils.getViewIndices(map, arrayList2);
        } else {
            return;
        }
        object3 = TableUtils.getReverseIndices(nArray);
        int n4 = 0;
        jTable = (JTable)arrayList.get(n4);
        for (int i = 0; i < arrayList2.size() && i < ((Object)object3).length; ++i) {
            int n5;
            n2 = (int)object3[i];
            if (n2 < 0 || n2 >= arrayList2.size()) {
                if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                LOGGER_EVENT.fine("TableUtils \" Reverse index should always be valid.");
                continue;
            }
            Object e = arrayList2.get(n2);
            TableColumn tableColumn = (TableColumn)arrayList3.get(n2);
            object = (JTable)arrayList4.get(n2);
            if (object != jTable) {
                n4 = n4 + 1 >= arrayList.size() || object != arrayList.get(n4 + 1) ? arrayList.indexOf(object) : ++n4;
                jTable = object;
            }
            if ((n5 = nArray[n2]) == -1) {
                if (e instanceof String && ((String)e).contains(COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS)) {
                    TableUtils.updateClientPropertyForColumn(jTable2, e, tableColumn);
                    continue;
                }
                TableUtils.updateClientPropertyForColumn(jTable, e, tableColumn);
                continue;
            }
            if (((JComponent)object).getClientProperty("TableColumnIdentifier:" + e) != null) {
                TableUtils.updateClientPropertyForColumn((JTable)object, e, null);
            }
            jTable.addColumn(tableColumn);
        }
        HashMap<TableColumnModel, TableColumnModelListener[]> hashMap = new HashMap<TableColumnModel, TableColumnModelListener[]>();
        TableUtils.saveListeners(arrayList, hashMap);
        for (n2 = 0; n2 < arrayList2.size() && n2 < ((Object)object3).length; ++n2) {
            int n6;
            Object object4 = object3[n2];
            if (object4 < 0 || object4 >= arrayList2.size()) {
                if (!LOGGER_EVENT.isLoggable(Level.FINE)) continue;
                LOGGER_EVENT.fine("TableUtils \" Reverse index should always be valid.");
                continue;
            }
            int n7 = nArray[object4];
            if (n7 == -1) continue;
            object = arrayList2.get((int)object4);
            TableColumn tableColumn = (TableColumn)arrayList3.get((int)object4);
            object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
            if (stringArray == null || (n6 = TableUtils.getIndexOf(stringArray, n, object)) == -1) continue;
            int n8 = Integer.valueOf(stringArray[n6 * 6 + 2 + 2]);
            int n9 = Integer.valueOf(stringArray[n6 * 6 + 2 + 3]);
            int n10 = Integer.valueOf(stringArray[n6 * 6 + 2 + 4]);
            int n11 = Integer.valueOf(stringArray[n6 * 6 + 2 + 5]);
            tableColumn.setMaxWidth(n8);
            tableColumn.setMinWidth(n9);
            tableColumn.setPreferredWidth(n10);
            tableColumn.setWidth(n11);
        }
        TableUtils.restoreListeners(arrayList, hashMap);
        tableScrollPane.resizeTableToFit(jTable2, true);
        tableScrollPane.resizeTableToFit(jTable4, true);
    }

    private static void saveListeners(List<JTable> list, Map<TableColumnModel, TableColumnModelListener[]> map) {
        for (JTable jTable : list) {
            TableUtils.saveListeners(map, jTable);
        }
    }

    private static void saveListeners(Map<TableColumnModel, TableColumnModelListener[]> map, JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        if (!map.containsKey(tableColumnModel) && tableColumnModel instanceof DefaultTableColumnModel) {
            TableColumnModelListener[] tableColumnModelListenerArray;
            for (TableColumnModelListener tableColumnModelListener : tableColumnModelListenerArray = ((DefaultTableColumnModel)tableColumnModel).getColumnModelListeners()) {
                tableColumnModel.removeColumnModelListener(tableColumnModelListener);
            }
            map.put(tableColumnModel, tableColumnModelListenerArray);
        }
    }

    private static void restoreListeners(List<JTable> list, Map<TableColumnModel, TableColumnModelListener[]> map) {
        for (JTable jTable : list) {
            TableUtils.restoreListeners(map, jTable);
        }
    }

    private static void restoreListeners(Map<TableColumnModel, TableColumnModelListener[]> map, JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        if (map.containsKey(tableColumnModel)) {
            TableColumnModelListener[] tableColumnModelListenerArray = map.get(tableColumnModel);
            TableColumn tableColumn = null;
            if (tableColumnModel.getColumnCount() > 0) {
                tableColumn = tableColumnModel.getColumn(0);
                tableColumn.setWidth(tableColumn.getWidth() + 1);
            }
            for (TableColumnModelListener tableColumnModelListener : tableColumnModelListenerArray) {
                tableColumnModel.addColumnModelListener(tableColumnModelListener);
            }
            if (tableColumn != null) {
                tableColumn.setWidth(tableColumn.getWidth() - 1);
            }
        }
    }

    private static int[] getViewIndices(Map<String, Integer> map, List<Object> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)TableUtils.eraseIdentifierFlag(list.get(i), COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
            Integer n = map.get(string);
            nArray[i] = n == null ? -1 : n;
        }
        return nArray;
    }

    public static boolean setTableColumnWidthByName(JTable jTable, String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        String string2 = TableUtils.getTablePreferenceByName(jTable);
        if (string.equals(string2)) {
            return false;
        }
        String[] stringArray = string.split("\t\t\t");
        String[] stringArray2 = stringArray[0].split("\t");
        try {
            int n = Integer.valueOf(stringArray2[0]);
            block4: for (int i = 0; i < n; ++i) {
                int n2 = Integer.valueOf(stringArray2[i * 6 + 2 + 1]);
                if (n2 == -1) continue;
                for (int j = 0; j < jTable.getColumnModel().getColumnCount(); ++j) {
                    int n3;
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(j);
                    if (tableColumn.getModelIndex() != i) continue;
                    try {
                        n3 = TableUtils.getIndexOf(stringArray2, n, TableUtils.getColumnIdentifier(jTable.getModel(), i));
                    }
                    catch (Exception exception) {
                        n3 = -1;
                    }
                    if (n3 == -1) continue;
                    int n4 = Integer.valueOf(stringArray2[n3 * 6 + 2 + 2]);
                    int n5 = Integer.valueOf(stringArray2[n3 * 6 + 2 + 3]);
                    int n6 = Integer.valueOf(stringArray2[n3 * 6 + 2 + 4]);
                    int n7 = Integer.valueOf(stringArray2[n3 * 6 + 2 + 5]);
                    tableColumn.setMaxWidth(n4);
                    tableColumn.setMinWidth(n5);
                    tableColumn.setPreferredWidth(n6);
                    tableColumn.setWidth(n7);
                    continue block4;
                }
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean setTableColumnWidthByName(TableScrollPane tableScrollPane, String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        String string2 = TableUtils.getTablePreferenceByName(tableScrollPane);
        if (string.equals(string2)) {
            return false;
        }
        String[] stringArray = string.split("\t\t\t");
        String[] stringArray2 = stringArray[0].split("\t");
        try {
            int n = Integer.valueOf(stringArray2[0]);
            block4: for (int i = 0; i < n; ++i) {
                JTable[] jTableArray;
                int n2 = Integer.valueOf(stringArray2[i * 6 + 2 + 1]);
                if (n2 == -1) continue;
                for (JTable jTable : jTableArray = TableColumnChooser.getAllTables(tableScrollPane.getMainTable())) {
                    boolean bl = false;
                    for (int j = 0; j < jTable.getColumnModel().getColumnCount(); ++j) {
                        int n3;
                        TableColumn tableColumn = jTable.getColumnModel().getColumn(j);
                        if (tableColumn.getModelIndex() != i) continue;
                        try {
                            n3 = TableUtils.getIndexOf(stringArray2, n, TableUtils.getColumnIdentifier(jTable.getModel(), i));
                        }
                        catch (Exception exception) {
                            n3 = -1;
                        }
                        if (n3 == -1) continue;
                        int n4 = Integer.valueOf(stringArray2[n3 * 6 + 2 + 2]);
                        int n5 = Integer.valueOf(stringArray2[n3 * 6 + 2 + 3]);
                        int n6 = Integer.valueOf(stringArray2[n3 * 6 + 2 + 4]);
                        int n7 = Integer.valueOf(stringArray2[n3 * 6 + 2 + 5]);
                        tableColumn.setMaxWidth(n4);
                        tableColumn.setMinWidth(n5);
                        tableColumn.setPreferredWidth(n6);
                        tableColumn.setWidth(n7);
                        bl = true;
                        break;
                    }
                    if (bl) continue block4;
                }
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Deprecated
    public static String getTablePreference(JTable jTable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = jTable.getModel().getColumnCount();
        stringBuffer.append(n).append(':');
        stringBuffer.append(jTable.getWidth()).append(':');
        block0: for (int i = 0; i < n; ++i) {
            int n2 = jTable.convertColumnIndexToView(i);
            if (n2 != -1) {
                for (int j = 0; j < jTable.getColumnModel().getColumnCount(); ++j) {
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(j);
                    if (tableColumn.getModelIndex() != i) continue;
                    stringBuffer.append(n2).append(':');
                    stringBuffer.append(tableColumn.getMaxWidth()).append(':');
                    stringBuffer.append(tableColumn.getMinWidth()).append(':');
                    stringBuffer.append(tableColumn.getPreferredWidth()).append(':');
                    stringBuffer.append(tableColumn.getWidth()).append(':');
                    continue block0;
                }
                continue;
            }
            stringBuffer.append(n2).append(':');
            stringBuffer.append(-1).append(':');
            stringBuffer.append(-1).append(':');
            stringBuffer.append(-1).append(':');
            stringBuffer.append(-1).append(':');
        }
        return new String(stringBuffer.deleteCharAt(stringBuffer.length() - 1));
    }

    @Deprecated
    public static boolean setTablePreference(JTable jTable, String string) {
        if (string == null) {
            return false;
        }
        String string2 = TableUtils.getTablePreference(jTable);
        if (string.equals(string2)) {
            return false;
        }
        String[] stringArray = string.split(":");
        try {
            int n;
            int n2;
            int n3;
            int n4 = Integer.valueOf(stringArray[0]);
            int n5 = jTable.getModel().getColumnCount();
            if (n5 != n4) {
                return false;
            }
            int[] nArray = new int[n4];
            Arrays.fill(nArray, -1);
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = Integer.valueOf(stringArray[n3 * 5 + 2]);
                if (n2 != (n = jTable.convertColumnIndexToView(n3))) {
                    if (n2 == -1) {
                        TableColumnChooser.hideColumn(jTable, n3, false);
                    } else if (n == -1) {
                        TableColumnChooser.showColumn(jTable, n3, n, false);
                    }
                }
                if (n2 <= -1) continue;
                nArray[n2] = n3;
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                n = jTable.convertColumnIndexToView(n2);
                if (n2 == -1 || n == -1 || n == n3) continue;
                jTable.moveColumn(n, n3);
            }
            block4: for (n3 = n4 - 1; n3 >= 0; --n3) {
                n2 = Integer.valueOf(stringArray[n3 * 5 + 2]);
                if (n2 == -1) continue;
                for (n = 0; n < jTable.getColumnModel().getColumnCount(); ++n) {
                    TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
                    if (tableColumn.getModelIndex() != n3) continue;
                    int n6 = Integer.valueOf(stringArray[n3 * 5 + 2 + 1]);
                    int n7 = Integer.valueOf(stringArray[n3 * 5 + 2 + 2]);
                    int n8 = Integer.valueOf(stringArray[n3 * 5 + 2 + 3]);
                    int n9 = Integer.valueOf(stringArray[n3 * 5 + 2 + 4]);
                    tableColumn.setMaxWidth(n6);
                    tableColumn.setMinWidth(n7);
                    tableColumn.setPreferredWidth(n8);
                    tableColumn.setWidth(n9);
                    continue block4;
                }
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String getFilterableTableModelPreference(IFilterableTableModel iFilterableTableModel) {
        if (iFilterableTableModel == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iFilterableTableModel.isAndMode() ? "1" : "0").append('\t');
        stringBuffer.append(iFilterableTableModel.isAdjusting() ? "1" : "0").append('\t');
        stringBuffer.append(iFilterableTableModel.isFilteringPaused() ? "1" : "0").append('\t');
        stringBuffer.append(iFilterableTableModel.isFiltersApplied() ? "1" : "0").append('\t').append('\t').append('\t');
        List<IFilterableTableModel.FilterItem> list = iFilterableTableModel.getFilterItems();
        for (IFilterableTableModel.FilterItem filterItem : list) {
            Object object;
            if (filterItem == null || filterItem.getFilter() == null) continue;
            int n = filterItem.getColumn();
            if (n < 0) {
                if (n == -1) {
                    object = "All$$$$$Columns";
                } else {
                    if (n != -2) continue;
                    object = "Any$$$$$Columns";
                }
            } else {
                object = iFilterableTableModel instanceof ColumnIdentifierTableModel ? ((ColumnIdentifierTableModel)((Object)iFilterableTableModel)).getColumnIdentifier(n) : iFilterableTableModel.getColumnName(n);
            }
            stringBuffer.append(object).append('\t').append('\t');
            Filter filter = filterItem.getFilter();
            Class<Object> clazz = n >= 0 ? iFilterableTableModel.getColumnClass(n) : Object.class;
            ConverterContext converterContext = n >= 0 && iFilterableTableModel instanceof ContextSensitiveTableModel ? ((ContextSensitiveTableModel)((Object)iFilterableTableModel)).getConverterContextAt(0, n) : null;
            stringBuffer.append(FilterUtils.getFilterPreference(filter, clazz, converterContext)).append('\t').append('\t').append('\t');
        }
        return stringBuffer.toString();
    }

    public static boolean setFilterableTableModelPreference(IFilterableTableModel iFilterableTableModel, String string) {
        int n;
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            if (iFilterableTableModel.hasFilter()) {
                iFilterableTableModel.clearFilters();
                iFilterableTableModel.refresh();
            }
            return true;
        }
        String[] stringArray = string.split("\t\t\t");
        if (stringArray.length <= 0) {
            return false;
        }
        String[] stringArray2 = stringArray[0].split("\t");
        if (stringArray2.length < 4) {
            return false;
        }
        IFilterableTableModel.FilterItem[] filterItemArray = new IFilterableTableModel.FilterItem[stringArray.length - 1];
        String string2 = "\t\t";
        for (n = 1; n < stringArray.length; ++n) {
            String string3;
            int n2;
            Object[] objectArray = stringArray[n].split(string2);
            if (objectArray.length < 5) {
                return false;
            }
            try {
                n2 = Integer.valueOf((String)objectArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
                if ("All$$$$$Columns".equals(objectArray[0])) {
                    n2 = -1;
                }
                if ("Any$$$$$Columns".equals(objectArray[0])) {
                    n2 = -2;
                }
                for (int i = 0; i < iFilterableTableModel.getColumnCount(); ++i) {
                    String string4 = string3 = iFilterableTableModel instanceof ColumnIdentifierTableModel ? "" + ((ColumnIdentifierTableModel)((Object)iFilterableTableModel)).getColumnIdentifier(i) : iFilterableTableModel.getColumnName(i);
                    if (!((String)objectArray[0]).equals(string3)) continue;
                    n2 = i;
                    break;
                }
                if (n2 < 0) continue;
            }
            String string5 = stringArray[n].substring(stringArray[n].indexOf(string2) + string2.length());
            Class<Object> clazz = n2 >= 0 ? iFilterableTableModel.getColumnClass(n2) : Object.class;
            string3 = n2 >= 0 && iFilterableTableModel instanceof ContextSensitiveTableModel ? ((ContextSensitiveTableModel)((Object)iFilterableTableModel)).getConverterContextAt(0, n2) : null;
            Filter filter = FilterUtils.setFilterPreference(string5, clazz, (ConverterContext)((Object)string3));
            if (filter == null) {
                return false;
            }
            if (filter instanceof ObjectGrouperSupport || filter instanceof NotFilter && ((NotFilter)filter).getFilter() instanceof ObjectGrouperSupport) {
                String string6;
                Filter filter2 = null;
                if (filter instanceof ObjectGrouperSupport) {
                    filter2 = filter;
                } else if (filter instanceof NotFilter && ((NotFilter)filter).getFilter() instanceof ObjectGrouperSupport) {
                    filter2 = ((NotFilter)filter).getFilter();
                }
                if (filter2 instanceof ObjectGrouperSupport && (string6 = ((ObjectGrouperSupport)((Object)filter2)).getObjectGrouperName()) != null) {
                    ObjectGrouper objectGrouper;
                    int n3;
                    TableModel tableModel = TableModelWrapperUtils.getActualTableModel(iFilterableTableModel, GroupableTableModel.class);
                    if (!(tableModel instanceof GroupableTableModel) || (n3 = TableModelWrapperUtils.getActualColumnAt((TableModel)iFilterableTableModel, n2, tableModel)) < 0) continue;
                    GrouperContext grouperContext = tableModel != null && n3 >= 0 ? ((GroupableTableModel)tableModel).getGrouperContext(n3) : null;
                    ObjectGrouper objectGrouper2 = objectGrouper = tableModel != null && n3 >= 0 ? ObjectGrouperManager.getGrouper(tableModel.getColumnClass(n3), grouperContext) : null;
                    if (objectGrouper == null || !string6.equals(objectGrouper.getName())) continue;
                    ((ObjectGrouperSupport)((Object)filter2)).setObjectGrouper(objectGrouper);
                    String[] stringArray3 = string5.split("\t\t");
                    if (stringArray3.length < 4) continue;
                    filter2.setPreference(stringArray3[3], objectGrouper.getType(), objectGrouper.getConverterContext());
                }
            }
            if (filter instanceof AbstractFilter && !((AbstractFilter)filter).isFilterValid()) continue;
            filterItemArray[n - 1] = new IFilterableTableModel.FilterItem(n2, filter);
        }
        iFilterableTableModel.clearFilters();
        n = filterItemArray.length <= 0 ? 1 : 0;
        for (IFilterableTableModel.FilterItem filterItem : filterItemArray) {
            if (filterItem == null) continue;
            iFilterableTableModel.addFilter(filterItem);
            n = 1;
        }
        if (n == 0) {
            return false;
        }
        iFilterableTableModel.setAndMode("1".equals(stringArray2[0]));
        iFilterableTableModel.setAdjusting("1".equals(stringArray2[1]));
        iFilterableTableModel.setFilteringPaused("1".equals(stringArray2[2]));
        iFilterableTableModel.setFiltersApplied("1".equals(stringArray2[3]));
        return true;
    }

    public static String getSortableTablePreference(SortableTable sortableTable) {
        return TableUtils.getSortableTablePreference(sortableTable, false);
    }

    public static String getSortableTablePreference(SortableTable sortableTable, boolean bl) {
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        int n = list.size();
        char c = bl ? (char)'\t' : ':';
        stringBuffer.append(n).append(c);
        for (ISortableTableModel.SortItem sortItem : list) {
            Object object = iSortableTableModel.getColumnName(sortItem.getColumn());
            if (iSortableTableModel instanceof ColumnIdentifierTableModel) {
                object = ((ColumnIdentifierTableModel)((Object)iSortableTableModel)).getColumnIdentifier(sortItem.getColumn());
                object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_HEADER_TABLE_MODEL_COLUMNS);
                object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
                object = TableUtils.eraseIdentifierFlag(object, COLUMN_PROPERTY_GROUP_TABLE_COUNT_COLUMN);
            }
            stringBuffer.append(bl ? object : "" + sortItem.getColumn()).append(c);
            stringBuffer.append(sortItem.isAscending() ? 0 : 1).append(c);
        }
        return new String(stringBuffer.deleteCharAt(stringBuffer.length() - 1));
    }

    public static boolean setSortableTablePreference(SortableTable sortableTable, String string) {
        return TableUtils.setSortableTablePreference(sortableTable, string, false);
    }

    public static boolean setSortableTablePreference(SortableTable sortableTable, String string, boolean bl) {
        if (string == null) {
            return false;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            return false;
        }
        if (string.length() == 0) {
            iSortableTableModel.reset();
            return true;
        }
        String[] stringArray = string.split(bl ? "\t" : ":");
        try {
            int n = Integer.valueOf(stringArray[0]);
            ArrayList<ISortableTableModel.SortItem> arrayList = new ArrayList<ISortableTableModel.SortItem>();
            for (int i = 0; i < n; ++i) {
                int n2;
                if (bl) {
                    String string2 = stringArray[i * 2 + 1];
                    n2 = TableUtils.getIndexOf(iSortableTableModel, string2);
                } else {
                    n2 = Integer.valueOf(stringArray[i * 2 + 1]);
                }
                if (n2 >= iSortableTableModel.getColumnCount() || n2 < 0) continue;
                int n3 = Integer.valueOf(stringArray[i * 2 + 1 + 1]);
                ISortableTableModel.SortItem sortItem = new ISortableTableModel.SortItem(n2);
                sortItem.setAscending(n3 == 0);
                arrayList.add(sortItem);
            }
            iSortableTableModel.setSortingColumns(arrayList);
            if (sortableTable.getTableHeader() != null) {
                sortableTable.getTableHeader().repaint();
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static void synchronizeTableRowSelection(final JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        for (JTable jTable : jTableArray) {
            Object object = jTable.getClientProperty("TableUtils.rowSelectionModel");
            jTable.putClientProperty("TableUtils.rowSelectionModel", null);
            if (!(object instanceof PropertyChangeListener)) continue;
            jTable.removePropertyChangeListener("selectionModel", (PropertyChangeListener)object);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ListSelectionModel listSelectionModel = jTableArray[0].getSelectionModel();
                for (int i = 1; i < jTableArray.length; ++i) {
                    JTable jTable = jTableArray[i];
                    jTable.setSelectionModel(listSelectionModel);
                }
            }
        };
        propertyChangeListener.propertyChange(null);
        for (JTable jTable : jTableArray) {
            jTable.addPropertyChangeListener("selectionModel", propertyChangeListener);
            jTable.putClientProperty("TableUtils.rowSelectionModel", propertyChangeListener);
        }
    }

    public static void unsynchronizeTableRowSelection(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        for (JTable jTable : jTableArray) {
            Object object = jTable.getClientProperty("TableUtils.rowSelectionModel");
            jTable.putClientProperty("TableUtils.rowSelectionModel", null);
            if (!(object instanceof PropertyChangeListener)) continue;
            jTable.removePropertyChangeListener("selectionModel", (PropertyChangeListener)object);
        }
        for (JTable jTable : jTableArray) {
            jTable.setSelectionModel(new DefaultListSelectionModel());
        }
    }

    public static void unifyTableRowSelection(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        ListSelectionModelGroup listSelectionModelGroup = new ListSelectionModelGroup();
        for (JTable jTable : jTableArray) {
            listSelectionModelGroup.add(jTable.getSelectionModel());
            jTable.putClientProperty("TableUtils.unifyTableRowSelection.group", listSelectionModelGroup);
        }
    }

    public static void ununifyTableRowSelection(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        for (JTable jTable : jTableArray) {
            Object object = jTable.getClientProperty("TableUtils.ununifyTableRowSelection.group");
            if (!(object instanceof ListSelectionModelGroup)) continue;
            ((ListSelectionModelGroup)object).remove(jTable.getSelectionModel());
            jTable.putClientProperty("TableUtils.ununifyTableRowSelection.group", null);
        }
    }

    public static void unifyTableColumnSelection(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        ListSelectionModelGroup listSelectionModelGroup = new ListSelectionModelGroup();
        for (JTable jTable : jTableArray) {
            listSelectionModelGroup.add(jTable.getColumnModel().getSelectionModel());
            jTable.putClientProperty("TableUtils.unifyTableColumnSelection.group", listSelectionModelGroup);
        }
    }

    public static void ununifyTableColumnSelection(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        for (JTable jTable : jTableArray) {
            Object object = jTable.getClientProperty("TableUtils.unifyTableColumnSelection.group");
            if (!(object instanceof ListSelectionModelGroup)) continue;
            ((ListSelectionModelGroup)object).remove(jTable.getColumnModel().getSelectionModel());
            jTable.putClientProperty("TableUtils.unifyTableColumnSelection.group", null);
        }
        for (JTable jTable : jTableArray) {
            jTable.getColumnModel().setSelectionModel(new DefaultListSelectionModel());
        }
    }

    public static void unifyTableNonContiguousCellSelection(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        TableSelectionModelGroup tableSelectionModelGroup = new TableSelectionModelGroup();
        for (JTable jTable : jTableArray) {
            if (!(jTable instanceof JideTable) || !((JideTable)jTable).isNonContiguousCellSelection() || jTable.getClientProperty("TableUtils.unifyTableNonConfiguousCellSelection.group") != null) continue;
            tableSelectionModelGroup.add(((JideTable)jTable).getTableSelectionModel());
            jTable.putClientProperty("TableUtils.unifyTableNonConfiguousCellSelection.group", tableSelectionModelGroup);
        }
    }

    public static void ununifyTableNonContiguousCellSelection(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        for (JTable jTable : jTableArray) {
            Object object;
            if (!(jTable instanceof JideTable) || !((JideTable)jTable).isNonContiguousCellSelection() || !((object = jTable.getClientProperty("TableUtils.unifyTableNonConfiguousCellSelection.group")) instanceof TableSelectionModelGroup)) continue;
            ((TableSelectionModelGroup)object).remove(((JideTable)jTable).getTableSelectionModel());
            jTable.putClientProperty("TableUtils.unifyTableNonConfiguousCellSelection.group", null);
        }
    }

    public static void unifyTableCellSelection(JTable[] jTableArray) {
        TableUtils.unifyTableCellSelection(jTableArray, null);
    }

    public static void unifyTableCellSelection(JTable[] jTableArray, JTable jTable) {
        if (jTableArray.length <= 1) {
            return;
        }
        MixedTableSelectionModelGroup mixedTableSelectionModelGroup = new MixedTableSelectionModelGroup();
        for (JTable jTable2 : jTableArray) {
            Object object;
            if (jTable2 instanceof JideTable && ((JideTable)jTable2).isNonContiguousCellSelection()) {
                if (jTable2.getClientProperty("TableUtils.unifyTableCellSelection.group") != null) continue;
                object = ((JideTable)jTable2).getTableSelectionModel();
                mixedTableSelectionModelGroup.add(object);
                if (jTable2 == jTable) {
                    mixedTableSelectionModelGroup.setStayModel(object);
                }
                jTable2.putClientProperty("TableUtils.unifyTableCellSelection.group", mixedTableSelectionModelGroup);
                continue;
            }
            if (jTable2.getRowSelectionAllowed()) {
                object = jTable2.getSelectionModel();
                mixedTableSelectionModelGroup.add(object);
                if (jTable2 == jTable) {
                    mixedTableSelectionModelGroup.setStayModel(object);
                }
                jTable2.putClientProperty("TableUtils.unifyTableCellSelection.group", mixedTableSelectionModelGroup);
                continue;
            }
            if (!jTable2.getColumnSelectionAllowed()) continue;
            object = jTable2.getColumnModel().getSelectionModel();
            mixedTableSelectionModelGroup.add(object);
            if (jTable2 == jTable) {
                mixedTableSelectionModelGroup.setStayModel(object);
            }
            jTable2.putClientProperty("TableUtils.unifyTableCellSelection.group", mixedTableSelectionModelGroup);
        }
    }

    public static void ununifyTableCellSelection(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        for (JTable jTable : jTableArray) {
            Object object = jTable.getClientProperty("TableUtils.unifyTableCellSelection.group");
            if (!(object instanceof MixedTableSelectionModelGroup)) continue;
            if (jTable instanceof JideTable) {
                ((MixedTableSelectionModelGroup)object).remove(((JideTable)jTable).getTableSelectionModel());
            }
            ((MixedTableSelectionModelGroup)object).remove(jTable.getSelectionModel());
            ((MixedTableSelectionModelGroup)object).remove(jTable.getColumnModel().getSelectionModel());
            jTable.putClientProperty("TableUtils.unifyTableCellSelection.group", null);
        }
    }

    public static void unifyTableCellEditing(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        for (JTable jTable : jTableArray) {
            jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }
    }

    public static void ununifyTableCellEditing(JTable[] jTableArray) {
        if (jTableArray.length <= 1) {
            return;
        }
        for (JTable jTable : jTableArray) {
            jTable.putClientProperty("terminateEditOnFocusLost", Boolean.FALSE);
        }
    }

    public static void synchronizeRowHeight(final JTable[] jTableArray) {
        JTable[] jTableArray2 = jTableArray;
        int n = jTableArray2.length;
        for (int i = 0; i < n; ++i) {
            JTable jTable;
            final JTable jTable2 = jTable = jTableArray2[i];
            jTable2.addPropertyChangeListener("rowHeight", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TableUtils.applyRowHeight(jTable2.getRowHeight(), jTableArray, jTable2);
                }
            });
        }
    }

    public static void synchronizeRowHeights(final JTable[] jTableArray) {
        final RowHeightChangeListener rowHeightChangeListener = new RowHeightChangeListener(){

            @Override
            public void rowHeightChanged(RowHeightChangeEvent rowHeightChangeEvent) {
                if (rowHeightChangeEvent.getType() == 0) {
                    for (int i = rowHeightChangeEvent.getFirstRow(); i <= rowHeightChangeEvent.getLastRow(); ++i) {
                        JideTable jideTable;
                        int n;
                        int n2 = ((RowHeights)rowHeightChangeEvent.getSource()).getRowHeight(i);
                        int n3 = -1;
                        for (n = 0; n < jTableArray.length; ++n) {
                            if (!(jTableArray[n] instanceof JideTable)) continue;
                            jideTable = (JideTable)jTableArray[n];
                            if (rowHeightChangeEvent.getSource() != jideTable.getRowHeights() && !jideTable.isFitted(i)) continue;
                            boolean bl = jideTable.isRowAutoResizes();
                            if (bl) {
                                jideTable.setRowAutoResizes(false, false);
                            }
                            int n4 = jideTable.getRowHeight(i);
                            if (bl) {
                                jideTable.setRowAutoResizes(bl, false);
                            }
                            if (n4 <= n2) continue;
                            n2 = n4;
                            n3 = n;
                        }
                        for (n = 0; n < jTableArray.length; ++n) {
                            if (!(jTableArray[n] instanceof JideTable)) continue;
                            jideTable = (JideTable)jTableArray[n];
                            if (n3 == n) {
                                jideTable.setFitted(i);
                                continue;
                            }
                            jideTable.getRowHeights().setFireEvent(false);
                            jideTable.setRowHeight(i, n2);
                            jideTable.getRowHeights().setFireEvent(true);
                            jideTable.removeFitted(i);
                        }
                    }
                }
            }
        };
        final boolean bl = jTableArray.length > 0 && jTableArray[0].getClientProperty("TableSplitPane.Parent") != null;
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                JTable jTable;
                int n;
                int n2 = 1;
                int n3 = -1;
                for (n = 0; n < jTableArray.length; ++n) {
                    int n4;
                    jTable = jTableArray[n];
                    int n5 = n4 = jTable.getTableHeader() != null ? jTable.getTableHeader().getPreferredSize().height : 0;
                    if (n4 <= n2) continue;
                    n2 = n4;
                    n3 = n;
                }
                for (n = 0; n < jTableArray.length; ++n) {
                    jTable = jTableArray[n];
                    JTableHeader jTableHeader = jTable.getTableHeader();
                    if (jTableHeader == null || n3 == n || jTableHeader.getPreferredSize().height == n2) continue;
                    if (jTableHeader instanceof DraggingTableHeader) {
                        ((DraggingTableHeader)jTableHeader).setPreferredHeight(n2);
                        continue;
                    }
                    jTableHeader.setPreferredSize(new Dimension(jTableHeader.getPreferredSize().width, n2));
                }
            }
        };
        final TableColumnModelListener tableColumnModelListener = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                TableUtils.invalidateTableHeader(jTableArray);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                TableUtils.invalidateTableHeader(jTableArray);
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        };
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (bl && "tableHeader".equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getNewValue() instanceof JTableHeader) {
                        ((JTableHeader)propertyChangeEvent.getNewValue()).addComponentListener(componentAdapter);
                    }
                    if (propertyChangeEvent.getOldValue() instanceof JTableHeader) {
                        ((JTableHeader)propertyChangeEvent.getOldValue()).removeComponentListener(componentAdapter);
                    }
                } else if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
                    if (propertyChangeEvent.getNewValue() instanceof TableColumnModel) {
                        ((TableColumnModel)propertyChangeEvent.getNewValue()).addColumnModelListener(tableColumnModelListener);
                    }
                    if (propertyChangeEvent.getOldValue() instanceof TableColumnModel) {
                        ((TableColumnModel)propertyChangeEvent.getOldValue()).removeColumnModelListener(tableColumnModelListener);
                    }
                }
            }
        };
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getNewValue() instanceof RowHeights) {
                    ((RowHeights)propertyChangeEvent.getNewValue()).addRowHeightChangeListener(rowHeightChangeListener);
                }
                if (propertyChangeEvent.getOldValue() instanceof RowHeights) {
                    ((RowHeights)propertyChangeEvent.getOldValue()).removeRowHeightChangeListener(rowHeightChangeListener);
                }
            }
        };
        for (JTable jTable : jTableArray) {
            if (jTable instanceof JideTable) {
                JideTable jideTable = (JideTable)jTable;
                jTable.addPropertyChangeListener("rowHeights", propertyChangeListener2);
                if (jideTable.isVariousRowHeights()) {
                    jideTable.getRowHeights().addRowHeightChangeListener(rowHeightChangeListener);
                }
            }
            jTable.getColumnModel().addColumnModelListener(tableColumnModelListener);
            jTable.addPropertyChangeListener(propertyChangeListener);
            if (!bl || jTable.getTableHeader() == null) continue;
            jTable.getTableHeader().addComponentListener(componentAdapter);
        }
        if (bl) {
            componentAdapter.componentResized(null);
        }
    }

    private static void invalidateTableHeader(JTable[] jTableArray) {
        for (JTable jTable : jTableArray) {
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader == null) continue;
            if (jTableHeader instanceof DraggingTableHeader) {
                ((DraggingTableHeader)jTableHeader).setPreferredHeight(-1);
                continue;
            }
            jTableHeader.setPreferredSize(null);
        }
    }

    public static void synchronizeTableColumnSelection(JTable jTable, JTable jTable2) {
        if (jTable.getColumnCount() != jTable2.getColumnCount()) {
            throw new IllegalArgumentException("master table must have the same column count as slave.");
        }
        TableUtils.unsynchronizeTableColumnSelection(jTable, jTable2);
        jTable.addPropertyChangeListener("columnModel", new SyncColumnSelectionPropertyChangeListener(jTable, jTable2));
    }

    public static void unsynchronizeTableColumnSelection(JTable jTable, JTable jTable2) {
        PropertyChangeListener[] propertyChangeListenerArray;
        for (PropertyChangeListener propertyChangeListener : propertyChangeListenerArray = jTable.getPropertyChangeListeners("columnModel")) {
            if (!(propertyChangeListener instanceof SyncColumnSelectionPropertyChangeListener) || ((SyncColumnSelectionPropertyChangeListener)propertyChangeListener).getSlave() != jTable2) continue;
            jTable.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private static void applyIndex(SortableTableModel sortableTableModel, JTable[] jTableArray, JTable jTable) {
        int[] nArray = sortableTableModel.getIndexes();
        if (nArray.length == 0) {
            nArray = null;
        }
        for (JTable jTable2 : jTableArray) {
            if (jTable2 == jTable) continue;
            SortableTable sortableTable = (SortableTable)jTable2;
            TableModel tableModel = sortableTable.getModel();
            if (tableModel != sortableTableModel && tableModel instanceof ISortableTableModel) {
                ((SortableTableModel)tableModel).setIndexes(nArray);
                ((SortableTableModel)tableModel).fireTableDataChanged();
            }
            if (sortableTable.getTableHeader() == null) continue;
            sortableTable.getTableHeader().repaint();
        }
    }

    private static void applyRowHeight(int n, JTable[] jTableArray, JTable jTable) {
        for (JTable jTable2 : jTableArray) {
            if (jTable2 == jTable || n == jTable2.getRowHeight()) continue;
            jTable2.setRowHeight(n);
        }
    }

    public static void synchronizeTables(JTable[] jTableArray) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (JTable jTable : jTableArray) {
            if (jTable instanceof JideTable && bl && !((JideTable)jTable).isNonContiguousCellSelection()) {
                bl = false;
                continue;
            }
            if (bl2 && !jTable.getRowSelectionAllowed()) {
                bl2 = false;
            }
            if (!bl3 || jTable.getColumnSelectionAllowed()) continue;
            bl3 = false;
        }
        if (bl) {
            TableUtils.synchronizeTables(jTableArray, false, false, true);
        } else {
            TableUtils.synchronizeTables(jTableArray, bl2, bl3, false);
        }
    }

    public static void synchronizeTables(JTable[] jTableArray, boolean bl, boolean bl2) {
        TableUtils.synchronizeTables(jTableArray, bl, bl2, false);
    }

    public static void synchronizeTables(JTable[] jTableArray, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            TableUtils.unifyTableNonContiguousCellSelection(jTableArray);
        } else {
            TableUtils.unifyTableColumnSelection(jTableArray);
            if (bl && !bl2) {
                TableUtils.synchronizeTableRowSelection(jTableArray);
            }
        }
        TableUtils.unifyTableCellEditing(jTableArray);
        TableUtils.synchronizeRowHeights(jTableArray);
        TableUtils.synchronizeRowHeight(jTableArray);
        TableUtils.synchronizeSorting(jTableArray);
        TableUtils.synchronizeDropLocation(jTableArray);
    }

    public static void synchronizeDropLocation(final JTable[] jTableArray) {
        final PropertyChangeListener[] propertyChangeListenerArray = new PropertyChangeListener[]{null};
        propertyChangeListenerArray[0] = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = propertyChangeEvent.getSource();
                if (object instanceof JTable && ((JTable)object).getDragEnabled()) {
                    int n = ((JTable)object).getSelectedColumn();
                    for (JTable jTable : jTableArray) {
                        if (jTable == object || jTable == null || jTable.getColumnCount() <= 0) continue;
                        jTable.removePropertyChangeListener("dropLocation", propertyChangeListenerArray[0]);
                        ReflectionUtils.callAnyWithoutException(jTable, JTable.class, "setDropLocation", new Class[]{TransferHandler.DropLocation.class, Object.class, Boolean.TYPE}, new Object[]{((JTable)object).getDropLocation(), null, false});
                        jTable.addPropertyChangeListener("dropLocation", propertyChangeListenerArray[0]);
                    }
                    if (n != -1) {
                        ((JTable)object).getColumnModel().getSelectionModel().setSelectionInterval(n, n);
                    }
                }
            }
        };
        for (JTable jTable : jTableArray) {
            jTable.removePropertyChangeListener("dropLocation", propertyChangeListenerArray[0]);
            jTable.addPropertyChangeListener("dropLocation", propertyChangeListenerArray[0]);
        }
    }

    public static void synchronizeSorting(final JTable[] jTableArray) {
        for (JTable jTable : jTableArray) {
            if (!(jTable instanceof SortableTable)) continue;
            final SortableTable sortableTable = (SortableTable)jTable;
            TableModel tableModel = sortableTable.getModel();
            final SortListener sortListener = new SortListener(){

                @Override
                public void sortChanging(SortEvent sortEvent) {
                }

                @Override
                public void sortChanged(SortEvent sortEvent) {
                    if (sortEvent.getSource() instanceof SortableTableModel) {
                        SortableTableModel sortableTableModel = (SortableTableModel)sortEvent.getSource();
                        TableUtils.applyIndex(sortableTableModel, jTableArray, sortableTable);
                    }
                }
            };
            if (tableModel instanceof ISortableTableModel) {
                ((ISortableTableModel)tableModel).addSortListener(sortListener);
            }
            sortableTable.addPropertyChangeListener("model", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() instanceof ISortableTableModel) {
                        ((ISortableTableModel)propertyChangeEvent.getNewValue()).addSortListener(sortListener);
                    }
                }
            });
        }
    }

    static void synchronizeNavigationKeysForVerticalTables(JTable[] jTableArray) {
        for (int i = 0; i < jTableArray.length; ++i) {
            JTable jTable = jTableArray[i];
            Action action = TableUtils.getAction(jTable, "selectNextColumnCell");
            SelectNextColumnCellActionForVerticalTables selectNextColumnCellActionForVerticalTables = i != jTableArray.length - 1 ? new SelectNextColumnCellActionForVerticalTables(action, "selectNextColumnCell", jTable, jTableArray[i + 1], false) : new SelectNextColumnCellActionForVerticalTables(action, "selectNextColumnCell", jTable, jTableArray[0], true);
            TableUtils.setAction(jTable, "selectNextColumnCell", selectNextColumnCellActionForVerticalTables, action);
            Action action2 = TableUtils.getAction(jTable, "selectNextColumn");
            SelectNextColumnCellActionForVerticalTables selectNextColumnCellActionForVerticalTables2 = i != jTableArray.length - 1 ? new SelectNextColumnCellActionForVerticalTables(action2, "selectNextColumn", jTable, jTableArray[i + 1], false) : new SelectNextColumnCellActionForVerticalTables(action2, "selectNextColumn", jTable, jTableArray[0], true);
            TableUtils.setAction(jTable, "selectNextColumn", selectNextColumnCellActionForVerticalTables2, action);
            Action action3 = TableUtils.getAction(jTable, "selectPreviousColumnCell");
            SelectPreviousColumnCellActionForVerticalTables selectPreviousColumnCellActionForVerticalTables = i != 0 ? new SelectPreviousColumnCellActionForVerticalTables(action3, "selectPreviousColumnCell", jTable, jTableArray[i - 1], true) : new SelectPreviousColumnCellActionForVerticalTables(action3, "selectPreviousColumnCell", jTable, jTableArray[jTableArray.length - 1], true);
            TableUtils.setAction(jTable, "selectPreviousColumnCell", selectPreviousColumnCellActionForVerticalTables, action3);
            Action action4 = TableUtils.getAction(jTable, "selectPreviousColumn");
            SelectPreviousColumnCellActionForVerticalTables selectPreviousColumnCellActionForVerticalTables2 = i != 0 ? new SelectPreviousColumnCellActionForVerticalTables(action4, "selectPreviousColumn", jTable, jTableArray[i - 1], true) : new SelectPreviousColumnCellActionForVerticalTables(action4, "selectPreviousColumn", jTable, jTableArray[jTableArray.length - 1], true);
            TableUtils.setAction(jTable, "selectPreviousColumn", selectPreviousColumnCellActionForVerticalTables2, action4);
            Action action5 = TableUtils.getAction(jTable, "selectNextRowCell");
            SelectNextRowCellAction selectNextRowCellAction = i != jTableArray.length - 1 ? new SelectNextRowCellAction(action5, "selectNextRowCell", jTable, jTableArray[i + 1]) : new SelectNextRowCellAction(action5, "selectNextRowCell", jTable, jTableArray[0]);
            TableUtils.setAction(jTable, "selectNextRowCell", selectNextRowCellAction, action5);
            Action action6 = TableUtils.getAction(jTable, "selectNextRow");
            SelectNextRowCellAction selectNextRowCellAction2 = i != jTableArray.length - 1 ? new SelectNextRowCellAction(action6, "selectNextRow", jTable, jTableArray[i + 1]) : new SelectNextRowCellAction(action6, "selectNextRow", jTable, jTableArray[0]);
            TableUtils.setAction(jTable, "selectNextRow", selectNextRowCellAction2, action6);
            Action action7 = TableUtils.getAction(jTable, "selectPreviousRowCell");
            SelectPreviousRowCellAction selectPreviousRowCellAction = i != 0 ? new SelectPreviousRowCellAction(action7, "selectPreviousRowCell", jTable, jTableArray[i - 1]) : new SelectPreviousRowCellAction(action7, "selectPreviousRowCell", jTable, jTableArray[jTableArray.length - 1]);
            TableUtils.setAction(jTable, "selectPreviousRowCell", selectPreviousRowCellAction, action7);
            Action action8 = TableUtils.getAction(jTable, "selectPreviousRow");
            SelectPreviousRowCellAction selectPreviousRowCellAction2 = i != 0 ? new SelectPreviousRowCellAction(action8, "selectPreviousRow", jTable, jTableArray[i - 1]) : new SelectPreviousRowCellAction(action8, "selectPreviousRow", jTable, jTableArray[jTableArray.length - 1]);
            TableUtils.setAction(jTable, "selectPreviousRow", selectPreviousRowCellAction2, action8);
        }
    }

    static void unsynchronizeNavigationKeysForVerticalTables(JTable[] jTableArray) {
        for (JTable jTable : jTableArray) {
            TableUtils.resetAction(jTable, "selectNextColumnCell");
            TableUtils.resetAction(jTable, "selectNextColumn");
            TableUtils.resetAction(jTable, "selectPreviousColumnCell");
            TableUtils.resetAction(jTable, "selectPreviousColumn");
            TableUtils.resetAction(jTable, "selectNextRowCell");
            TableUtils.resetAction(jTable, "selectNextRow");
            TableUtils.resetAction(jTable, "selectPreviousRowCell");
            TableUtils.resetAction(jTable, "selectPreviousRow");
        }
    }

    private static JTable getFirstValidTable(JTable[] jTableArray) {
        for (JTable jTable : jTableArray) {
            if (jTable == null || jTable.getColumnCount() <= 0 || jTable.getRowCount() <= 0) continue;
            return jTable;
        }
        return null;
    }

    private static JTable getLastValidTable(JTable[] jTableArray) {
        for (int i = jTableArray.length - 1; i >= 0; --i) {
            JTable jTable = jTableArray[i];
            if (jTable == null || jTable.getColumnCount() <= 0 || jTable.getRowCount() <= 0) continue;
            return jTable;
        }
        return null;
    }

    public static void synchronizeNavigationKeys(JTable[][] jTableArray) {
        AbstractAction abstractAction;
        int n;
        Object object;
        if (jTableArray == null) {
            return;
        }
        int n2 = -1;
        JTable[][] jTableArray2 = jTableArray;
        int n3 = jTableArray2.length;
        for (int i = 0; i < n3; ++i) {
            object = jTableArray2[i];
            if (object == null) continue;
            if (n2 == -1) {
                n2 = ((JTable[])object).length;
                continue;
            }
            if (n2 == ((JTable[])object).length) continue;
            throw new IllegalArgumentException("The length of each table row should be the same.");
        }
        if (n2 <= 0) {
            return;
        }
        for (n = 0; n < jTableArray.length; ++n) {
            JTable[] jTableArray3 = jTableArray[n];
            if (jTableArray3 == null) continue;
            TableUtils.synchronizeNavigationKeys(jTableArray3);
            JTable jTable = TableUtils.getLastValidTable(jTableArray3);
            if (jTable != null) {
                TableUtils.resetAction(jTable, "selectNextColumnCell");
                object = TableUtils.getAction(jTable, "selectNextColumnCell");
                abstractAction = new SelectNextColumnCellAction((Action)object, "selectNextColumnCell", jTable, jTableArray3[0], TableUtils.getFirstValidTable(jTableArray[(n + 1) % jTableArray.length]), true);
                TableUtils.setAction(jTable, "selectNextColumnCell", abstractAction, (Action)object);
            }
            if ((jTable = TableUtils.getFirstValidTable(jTableArray3)) == null) continue;
            TableUtils.resetAction(jTable, "selectPreviousColumnCell");
            object = TableUtils.getAction(jTable, "selectPreviousColumnCell");
            abstractAction = new SelectPreviousColumnCellAction((Action)object, "selectPreviousColumnCell", jTable, jTableArray3[n2 - 1], TableUtils.getLastValidTable(jTableArray[n == 0 ? jTableArray.length - 1 : n - 1]), true);
            TableUtils.setAction(jTable, "selectPreviousColumnCell", abstractAction, (Action)object);
        }
        for (n = 0; n < n2; ++n) {
            for (n3 = 0; n3 < jTableArray.length; ++n3) {
                AbstractAction abstractAction2;
                JTable jTable = jTableArray[n3][n];
                if (jTable == null) continue;
                object = TableUtils.getAction(jTable, "selectNextRowCell");
                abstractAction = n3 != jTableArray.length - 1 ? new SelectNextRowCellAction((Action)object, "selectNextRowCell", jTable, jTableArray[n3 + 1][n]) : new SelectNextRowCellAction((Action)object, "selectNextRowCell", jTable, null);
                TableUtils.setAction(jTable, "selectNextRowCell", abstractAction, (Action)object);
                Action action = TableUtils.getAction(jTable, "selectNextRow");
                SelectNextRowCellAction selectNextRowCellAction = n3 != jTableArray.length - 1 ? new SelectNextRowCellAction(action, "selectNextRow", jTable, jTableArray[n3 + 1][n]) : new SelectNextRowCellAction(action, "selectNextRow", jTable, null);
                TableUtils.setAction(jTable, "selectNextRow", selectNextRowCellAction, action);
                Action action2 = TableUtils.getAction(jTable, "selectPreviousRowCell");
                SelectPreviousRowCellAction selectPreviousRowCellAction = n3 != 0 ? new SelectPreviousRowCellAction(action2, "selectPreviousRowCell", jTable, jTableArray[n3 - 1][n]) : new SelectPreviousRowCellAction(action2, "selectPreviousRowCell", jTable, null);
                TableUtils.setAction(jTable, "selectPreviousRowCell", selectPreviousRowCellAction, action2);
                Action action3 = TableUtils.getAction(jTable, "selectPreviousRow");
                SelectPreviousRowCellAction selectPreviousRowCellAction2 = n3 != 0 ? new SelectPreviousRowCellAction(action3, "selectPreviousRow", jTable, jTableArray[n3 - 1][n]) : new SelectPreviousRowCellAction(action3, "selectPreviousRow", jTable, null);
                TableUtils.setAction(jTable, "selectPreviousRow", selectPreviousRowCellAction2, action3);
                JTable[] jTableArray4 = new JTable[jTableArray.length];
                for (int i = 0; i < jTableArray.length; ++i) {
                    jTableArray4[i] = jTableArray[i][n];
                }
                if (n3 != 0) {
                    Action action4 = TableUtils.getAction(jTable, "selectFirstRow");
                    abstractAction2 = new SelectFirstRowCellAction(action4, jTable, jTableArray4);
                    TableUtils.setAction(jTable, "selectFirstRow", abstractAction2, action4);
                }
                if (n3 == jTableArray.length - 1) continue;
                Action action5 = TableUtils.getAction(jTable, "selectLastRow");
                abstractAction2 = new SelectLastRowCellAction(action5, jTable, jTableArray4);
                TableUtils.setAction(jTable, "selectLastRow", abstractAction2, action5);
            }
        }
    }

    public static void unsynchronizeNavigationKeys(JTable[][] jTableArray) {
        JTable[][] jTableArray2 = jTableArray;
        int n = jTableArray2.length;
        for (int i = 0; i < n; ++i) {
            JTable[] jTableArray3;
            for (JTable jTable : jTableArray3 = jTableArray2[i]) {
                if (jTable == null) continue;
                TableUtils.resetAction(jTable, "selectNextColumnCell");
                TableUtils.resetAction(jTable, "selectNextColumn");
                TableUtils.resetAction(jTable, "selectPreviousColumnCell");
                TableUtils.resetAction(jTable, "selectPreviousColumn");
                TableUtils.resetAction(jTable, "selectFirstColumn");
                TableUtils.resetAction(jTable, "selectLastColumn");
                TableUtils.resetAction(jTable, "selectNextRowCell");
                TableUtils.resetAction(jTable, "selectNextRow");
                TableUtils.resetAction(jTable, "selectPreviousRowCell");
                TableUtils.resetAction(jTable, "selectPreviousRow");
                TableUtils.resetAction(jTable, "selectFirstRow");
                TableUtils.resetAction(jTable, "selectLastRow");
            }
        }
    }

    public static void synchronizeNavigationKeys(JTable[] jTableArray) {
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        for (EventListener eventListener : jTableArray) {
            if (eventListener == null) continue;
            arrayList.add((JTable)eventListener);
        }
        if (arrayList.size() <= 1) {
            return;
        }
        JTable[] jTableArray2 = arrayList.toArray(new JTable[arrayList.size()]);
        for (int i = 0; i < jTableArray2.length; ++i) {
            AbstractAction abstractAction;
            Action action;
            EventListener eventListener;
            JTable jTable = jTableArray2[i];
            eventListener = TableUtils.getAction(jTable, "selectNextColumnCell");
            SelectNextColumnCellAction selectNextColumnCellAction = i != jTableArray2.length - 1 ? new SelectNextColumnCellAction((Action)eventListener, "selectNextColumnCell", jTable, jTableArray2[i + 1], null, false) : new SelectNextColumnCellAction((Action)eventListener, "selectNextColumnCell", jTable, jTableArray2[0], null, true);
            TableUtils.setAction(jTable, "selectNextColumnCell", selectNextColumnCellAction, (Action)eventListener);
            Action action2 = TableUtils.getAction(jTable, "selectNextColumn");
            SelectNextColumnCellAction selectNextColumnCellAction2 = i != jTableArray2.length - 1 ? new SelectNextColumnCellAction(action2, "selectNextColumn", jTable, jTableArray2[i + 1], null, false) : new SelectNextColumnCellAction(action2, "selectNextColumn", jTable, null, null, false);
            TableUtils.setAction(jTable, "selectNextColumn", selectNextColumnCellAction2, action2);
            Action action3 = TableUtils.getAction(jTable, "selectPreviousColumnCell");
            SelectPreviousColumnCellAction selectPreviousColumnCellAction = i != 0 ? new SelectPreviousColumnCellAction(action3, "selectPreviousColumnCell", jTable, jTableArray2[i - 1], null, false) : new SelectPreviousColumnCellAction(action3, "selectPreviousColumnCell", jTable, jTableArray2[jTableArray2.length - 1], null, true);
            TableUtils.setAction(jTable, "selectPreviousColumnCell", selectPreviousColumnCellAction, action3);
            Action action4 = TableUtils.getAction(jTable, "selectPreviousColumn");
            SelectPreviousColumnCellAction selectPreviousColumnCellAction2 = i != 0 ? new SelectPreviousColumnCellAction(action4, "selectPreviousColumn", jTable, jTableArray2[i - 1], null, false) : new SelectPreviousColumnCellAction(action4, "selectPreviousColumn", jTable, null, null, false);
            TableUtils.setAction(jTable, "selectPreviousColumn", selectPreviousColumnCellAction2, action4);
            if (i != 0) {
                action = TableUtils.getAction(jTable, "selectFirstColumn");
                abstractAction = new SelectFirstColumnCellAction(action, jTable, jTableArray2);
                TableUtils.setAction(jTable, "selectFirstColumn", abstractAction, action);
            }
            if (i == jTableArray2.length - 1) continue;
            action = TableUtils.getAction(jTable, "selectLastColumn");
            abstractAction = new SelectLastColumnCellAction(action, jTable, jTableArray2);
            TableUtils.setAction(jTable, "selectLastColumn", abstractAction, action);
        }
    }

    public static void unsynchronizeNavigationKeys(JTable[] jTableArray) {
        for (JTable jTable : jTableArray) {
            TableUtils.resetAction(jTable, "selectNextColumnCell");
            TableUtils.resetAction(jTable, "selectNextColumn");
            TableUtils.resetAction(jTable, "selectPreviousColumnCell");
            TableUtils.resetAction(jTable, "selectPreviousColumn");
            TableUtils.resetAction(jTable, "selectFirstColumn");
            TableUtils.resetAction(jTable, "selectLastColumn");
        }
    }

    private static Action getAction(JComponent jComponent, String string) {
        return jComponent.getActionMap().get(string);
    }

    private static void setAction(JComponent jComponent, String string, Action action, Action action2) {
        jComponent.getActionMap().put(string, action);
        jComponent.putClientProperty("SynchronizeNavigationKeys." + string, action2);
    }

    private static void resetAction(JComponent jComponent, String string) {
        Object object = jComponent.getClientProperty("SynchronizeNavigationKeys." + string);
        if (object instanceof Action) {
            jComponent.getActionMap().put(string, (Action)object);
            jComponent.putClientProperty("SynchronizeNavigationKeys." + string, null);
        }
    }

    protected static int nextRow(JTable jTable, JTable jTable2) {
        TableScrollPane tableScrollPane;
        int n;
        Object object;
        int n2 = jTable.getSelectedRow();
        if (n2 < 0 && (object = jTable.getClientProperty("TableScrollPane.Parent")) instanceof TableScrollPane && (n = (tableScrollPane = (TableScrollPane)object).getSelectedRow()) >= 0) {
            if (jTable == tableScrollPane.getColumnHeaderTable() || jTable == tableScrollPane.getRowHeaderColumnHeaderTable() || jTable == tableScrollPane.getRowFooterColumnHeaderTable()) {
                n2 = n;
            } else {
                n -= tableScrollPane.getColumnHeaderTable() == null ? 0 : tableScrollPane.getColumnHeaderTable().getRowCount();
                n2 = jTable == tableScrollPane.getMainTable() || jTable == tableScrollPane.getRowHeaderTable() || jTable == tableScrollPane.getRowFooterTable() ? n : (n -= tableScrollPane.getMainTable() == null ? 0 : tableScrollPane.getMainTable().getRowCount());
            }
        }
        int n3 = n2 >= jTable2.getRowCount() - 1 || n2 < 0 ? 0 : n2 + 1;
        return n3;
    }

    protected static int previousRow(JTable jTable, JTable jTable2) {
        TableScrollPane tableScrollPane;
        int n;
        Object object;
        int n2 = jTable.getSelectedRow();
        if (n2 < 0 && (object = jTable.getClientProperty("TableScrollPane.Parent")) instanceof TableScrollPane && (n = (tableScrollPane = (TableScrollPane)object).getSelectedRow()) >= 0) {
            if (jTable == tableScrollPane.getColumnHeaderTable() || jTable == tableScrollPane.getRowHeaderColumnHeaderTable() || jTable == tableScrollPane.getRowFooterColumnHeaderTable()) {
                n2 = n;
            } else {
                n -= tableScrollPane.getColumnHeaderTable() == null ? 0 : tableScrollPane.getColumnHeaderTable().getRowCount();
                n2 = jTable == tableScrollPane.getMainTable() || jTable == tableScrollPane.getRowHeaderTable() || jTable == tableScrollPane.getRowFooterTable() ? n : (n -= tableScrollPane.getMainTable() == null ? 0 : tableScrollPane.getMainTable().getRowCount());
            }
        }
        int n3 = n2 <= 0 ? jTable2.getRowCount() - 1 : n2 - 1;
        return n3;
    }

    public static void synchronizeTableColumn(JTable jTable, JTable jTable2) {
        TableUtils.synchronizeTableColumn(jTable, jTable2, true);
    }

    public static void synchronizeTableColumnWidth(JTable[] jTableArray) {
        for (JTable jTable : jTableArray) {
            for (JTable jTable2 : jTableArray) {
                if (jTable == jTable2) continue;
                TableUtils.synchronizeTableColumn(jTable, jTable2, false);
            }
        }
    }

    static void synchronizeTableColumn(JTable jTable, JTable jTable2, boolean bl) {
        if (jTable.getColumnCount() != jTable2.getColumnCount()) {
            throw new IllegalArgumentException("master table must have the same column count as slave.");
        }
        TableUtils.unsynchronizeTableColumn(jTable, jTable2);
        TableUtils.synchronizeTableColumnSelection(jTable, jTable2);
        jTable.addComponentListener(new SyncTableComponentListener(jTable, jTable2));
        jTable.getColumnModel().addColumnModelListener(new SyncColumnsAddRemoveColumnModelListener(jTable, jTable2));
        if (bl) {
            jTable2.getColumnModel().setSelectionModel(jTable.getColumnModel().getSelectionModel());
        }
    }

    public static void unsynchronizeTableColumn(JTable jTable, JTable jTable2) {
        TableUtils.unsynchronizeTableColumnSelection(jTable, jTable2);
        ComponentListener[] componentListenerArray = jTable.getComponentListeners();
        EventListener[] eventListenerArray = componentListenerArray;
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ComponentListener componentListener = eventListenerArray[i];
            if (!(componentListener instanceof SyncTableComponentListener) || ((SyncTableComponentListener)componentListener).getSlave() != jTable2) continue;
            jTable.removeComponentListener(componentListener);
        }
        if (jTable.getColumnModel() instanceof DefaultTableColumnModel) {
            for (EventListener eventListener : eventListenerArray = ((DefaultTableColumnModel)jTable.getColumnModel()).getColumnModelListeners()) {
                if (!(eventListener instanceof SyncColumnsAddRemoveColumnModelListener) || ((SyncColumnsAddRemoveColumnModelListener)eventListener).getSlave() != jTable2) continue;
                jTable.getColumnModel().removeColumnModelListener((TableColumnModelListener)eventListener);
            }
        }
    }

    public static void synchronizeTableColumnWidth(JTable jTable, JTable jTable2) {
        if (jTable.getColumnCount() != jTable2.getColumnCount()) {
            throw new IllegalArgumentException("master table must have the same column count as slave.");
        }
        jTable.addComponentListener(new SyncTableComponentListener(jTable, jTable2));
        jTable.getColumnModel().addColumnModelListener(new SyncColumnsColumnModelListener(jTable, jTable2));
    }

    public static void synchronizeTableAndColumnsWidth(JTable jTable, JTable jTable2) {
        TableUtils.syncTable(jTable, jTable2);
        TableUtils.synchronizeTableColumnWidthNow(jTable, jTable2);
    }

    private static void syncTable(JTable jTable, JTable jTable2) {
        if (jTable.getWidth() != jTable2.getWidth()) {
            jTable2.setSize(new Dimension(jTable.getWidth(), jTable2.getHeight()));
        }
    }

    public static void synchronizeTableColumnWidthNow(JTable jTable, JTable jTable2) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableColumnModel tableColumnModel2 = jTable2.getColumnModel();
        TableColumnModelListener[] tableColumnModelListenerArray = null;
        if (tableColumnModel instanceof DefaultTableColumnModel && (tableColumnModelListenerArray = ((DefaultTableColumnModel)tableColumnModel2).getColumnModelListeners()) != null) {
            for (TableColumnModelListener tableColumnModelListener : tableColumnModelListenerArray) {
                if (jTable.getAutoResizeMode() != 0 && tableColumnModelListener == jTable2) continue;
                tableColumnModel2.removeColumnModelListener(tableColumnModelListener);
            }
        }
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableColumn tableColumn;
            int n = tableColumnModel.getColumn(i).getPreferredWidth();
            if (i >= tableColumnModel2.getColumnCount() || (tableColumn = tableColumnModel2.getColumn(i)).getPreferredWidth() == n) continue;
            tableColumn.setMinWidth(tableColumnModel.getColumn(i).getMinWidth());
            tableColumn.setMaxWidth(tableColumnModel.getColumn(i).getMaxWidth());
            tableColumn.setPreferredWidth(n);
        }
        if (tableColumnModelListenerArray != null) {
            for (TableColumnModelListener tableColumnModelListener : tableColumnModelListenerArray) {
                if (jTable.getAutoResizeMode() != 0 && tableColumnModelListener == jTable2) continue;
                tableColumnModel2.addColumnModelListener(tableColumnModelListener);
            }
        }
    }

    public static int getAutoResizeExtraWidth() {
        return _autoResizeExtraWidth;
    }

    public static void setAutoResizeExtraWidth(int n) {
        _autoResizeExtraWidth = n;
    }

    public static int autoResizeColumn(JTable jTable, int n) {
        return TableUtils.autoResizeColumn(jTable, n, !Boolean.FALSE.equals(jTable.getClientProperty(CLIENT_PROPERTY_AUTO_RESIZE_CONSIDER_HEADER)));
    }

    public static int autoResizeColumn(JTable jTable, int n, boolean bl) {
        return TableUtils.autoResizeColumn(jTable, n, bl, Boolean.TRUE.equals(jTable.getClientProperty(CLIENT_PROPERTY_AUTO_RESIZE_CONSIDER_VISIBLE_ROWS_ONLY)));
    }

    public static int autoResizeColumn(JTable jTable, int n, boolean bl, boolean bl2) {
        return TableUtils.autoResizeColumn(jTable, n, bl, bl2, -1);
    }

    public static int autoResizeColumn(JTable jTable, int n, boolean bl, boolean bl2, int n2) {
        return TableUtils.autoResizeColumn(jTable, n, bl, bl2, n2, -1);
    }

    public static int autoResizeColumn(JTable jTable, int n, boolean bl, boolean bl2, int n2, int n3) {
        return TableUtils.autoResizeColumn(jTable, n, bl, bl2, n2, n3, !Boolean.FALSE.equals(jTable.getClientProperty(CLIENT_PROPERTY_AUTO_RESIZE_HIGH_PERFORMANCE)));
    }

    public static int autoResizeColumn(JTable jTable, int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3) {
        return TableUtils.autoResizeColumn(jTable, n, bl, bl2, n2, n3, bl3, !Boolean.FALSE.equals(jTable.getClientProperty(CLIENT_PROPERTY_AUTO_RESIZE_RESPECT_COLUMN_WIDTH_TABLE_MODEL)));
    }

    public static int autoResizeColumn(JTable jTable, int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4) {
        int n4;
        JTable[] jTableArray;
        TableScrollPane tableScrollPane;
        int n5;
        int n6;
        int n7;
        if (jTable == null) {
            throw new IllegalArgumentException("table can't be null");
        }
        if (n < 0 || n > jTable.getColumnCount()) {
            throw new IllegalArgumentException("invalid col " + n);
        }
        TableModel tableModel = jTable.getModel();
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, ColumnWidthTableModel.class);
        if (tableModel2 != null && bl4 && (n7 = ((ColumnWidthTableModel)((Object)tableModel2)).getPreferredWidth(TableModelWrapperUtils.getActualColumnAt(tableModel, n6 = jTable.convertColumnIndexToModel(n), tableModel2))) > 0) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            tableColumn.setPreferredWidth(n7);
            tableColumn.setWidth(n7);
            jTable.sizeColumnsToFit(-1);
            if (jTable.getTableHeader() != null) {
                jTable.getTableHeader().repaint();
            }
            return n7;
        }
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int[] nArray = new int[tableColumnModel.getColumnCount()];
        for (n5 = 0; n5 < nArray.length; ++n5) {
            nArray[n5] = tableColumnModel.getColumn(n5).getWidth();
        }
        n5 = TableUtils.calculateColumnWidth(jTable, n, bl, bl2, bl3, nArray);
        if (jTable.getClientProperty("TableScrollPane.Parent") != null && (tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent")) != null) {
            jTableArray = tableScrollPane.getOtherTablesInSameColumn(jTable);
            for (n4 = 0; n4 < jTableArray.length; ++n4) {
                JTable jTable2 = jTableArray[n4];
                n5 = Math.max(n5, TableUtils.calculateColumnWidth(jTable2, n, bl, bl2, bl3, nArray));
            }
        }
        int n8 = Math.max(n2, n5);
        jTableArray = tableColumnModel.getColumn(n);
        n4 = -1;
        if (n8 >= 0) {
            n4 = n8 + _autoResizeExtraWidth;
            if (n3 > 0 && n3 < n4) {
                n4 = n3;
            }
            jTableArray.setPreferredWidth(n4);
            jTableArray.setWidth(n4);
        }
        jTable.sizeColumnsToFit(-1);
        if (jTable.getTableHeader() != null) {
            jTable.getTableHeader().repaint();
        }
        if (n8 >= 0) {
            return n4;
        }
        return -1;
    }

    public static int[] autoResizeAllColumns(JTable jTable) {
        return TableUtils.autoResizeAllColumns(jTable, !Boolean.FALSE.equals(jTable.getClientProperty(CLIENT_PROPERTY_AUTO_RESIZE_CONSIDER_HEADER)));
    }

    public static int[] autoResizeAllColumns(JTable jTable, boolean bl) {
        return TableUtils.autoResizeAllColumns(jTable, null, bl);
    }

    public static int[] autoResizeAllColumns(JTable jTable, int[] nArray, boolean bl) {
        return TableUtils.autoResizeAllColumns(jTable, nArray, bl, Boolean.TRUE.equals(jTable.getClientProperty(CLIENT_PROPERTY_AUTO_RESIZE_CONSIDER_VISIBLE_ROWS_ONLY)));
    }

    public static int[] autoResizeAllColumns(JTable jTable, int[] nArray, boolean bl, boolean bl2) {
        return TableUtils.autoResizeAllColumns(jTable, nArray, null, bl, bl2);
    }

    public static int[] autoResizeAllColumns(JTable jTable, int[] nArray, int[] nArray2, boolean bl, boolean bl2) {
        return TableUtils.autoResizeAllColumns(jTable, nArray, nArray2, bl, bl2, !Boolean.FALSE.equals(jTable.getClientProperty(CLIENT_PROPERTY_AUTO_RESIZE_HIGH_PERFORMANCE)));
    }

    public static int[] autoResizeAllColumns(JTable jTable, int[] nArray, int[] nArray2, boolean bl, boolean bl2, boolean bl3) {
        return TableUtils.autoResizeAllColumns(jTable, nArray, nArray2, bl, bl2, bl3, !Boolean.FALSE.equals(jTable.getClientProperty(CLIENT_PROPERTY_AUTO_RESIZE_RESPECT_COLUMN_WIDTH_TABLE_MODEL)));
    }

    public static int[] autoResizeAllColumns(JTable jTable, int[] nArray, int[] nArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return TableUtils.autoResizeAllColumns(jTable, nArray, nArray2, bl, bl2, bl3, bl4, false);
    }

    public static int[] autoResizeAllColumns(final JTable jTable, int[] nArray, int[] nArray2, final boolean bl, final boolean bl2, final boolean bl3, boolean bl4, boolean bl5) {
        int n;
        final TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableModel tableModel = jTable.getModel();
        final int[] nArray3 = new int[tableColumnModel.getColumnCount()];
        Arrays.fill(nArray3, -1);
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, ColumnWidthTableModel.class);
        if (tableModel2 != null && bl4) {
            for (n = tableColumnModel.getColumnCount() - 1; n >= 0; --n) {
                int n2 = jTable.convertColumnIndexToModel(n);
                nArray3[n] = ((ColumnWidthTableModel)((Object)tableModel2)).getPreferredWidth(TableModelWrapperUtils.getActualColumnAt(tableModel, n2, tableModel2));
            }
        }
        for (n = tableColumnModel.getColumnCount() - 1; n >= 0; --n) {
            if (nArray3[n] > 0) continue;
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            if (nArray != null && n < nArray.length && nArray[n] > 0 && nArray2 != null && n < nArray2.length && nArray2[n] > 0 && nArray[n] >= nArray2[n]) {
                nArray3[n] = nArray[n];
                continue;
            }
            final int n3 = n;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    nArray3[n3] = TableUtils.calculateColumnWidth(jTable, n3, bl, bl2, bl3, nArray3);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException interruptedException) {
                    nArray3[n] = 75;
                }
                catch (InvocationTargetException invocationTargetException) {
                    nArray3[n] = 75;
                }
            }
            if (nArray != null && n >= 0 && n < nArray.length && nArray[n] > 0) {
                nArray3[n] = Math.max(nArray3[n], nArray[n]);
            }
            if (nArray2 != null && n >= 0 && n < nArray2.length && nArray2[n] > 0) {
                nArray3[n] = Math.min(nArray3[n], nArray2[n]);
            }
            if (!bl) continue;
            nArray3[n] = Math.min(nArray3[n], tableColumn.getMaxWidth());
        }
        for (n = 0; n < tableColumnModel.getColumnCount(); ++n) {
            if (nArray3[n] < 0) continue;
            int n4 = n;
            nArray3[n4] = nArray3[n4] + _autoResizeExtraWidth;
        }
        if (!bl5) {
            if (jTable instanceof JideTable) {
                ((JideTable)jTable).setAutoResizeColumnWidths(nArray3);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                        if (nArray3[i] < 0) continue;
                        TableColumn tableColumn = tableColumnModel.getColumn(i);
                        tableColumn.setPreferredWidth(nArray3[i]);
                        tableColumn.setWidth(nArray3[i]);
                    }
                    if (jTable.getTableHeader() != null) {
                        jTable.getTableHeader().repaint();
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        return nArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int calculateColumnWidth(JTable jTable, int n, boolean bl, boolean bl2, boolean bl3, int[] nArray) {
        Object object;
        Object object2;
        int n2;
        int n3;
        TableHeaderCellDecorator[] tableHeaderCellDecoratorArray;
        JTableHeader jTableHeader = jTable.getTableHeader();
        int n4 = jTable.getRowCount();
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        int n5 = -1;
        if (bl && jTableHeader != null) {
            Serializable serializable;
            Object object3;
            if (jTableHeader.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate() != null) {
                object3 = ((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate();
                n5 = ((TableHeaderUIDelegate)object3).getPreferredWidth(n);
            } else {
                object3 = tableColumn.getHeaderRenderer();
                if (object3 == null) {
                    object3 = jTableHeader.getDefaultRenderer();
                }
                if (object3 != null) {
                    serializable = object3.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, -1, n);
                    n5 = Math.max(n5, ((Component)serializable).getPreferredSize().width + jTable.getIntercellSpacing().width);
                    if (jTableHeader instanceof SortableTableHeader) {
                        TableHeaderCellDecorator[] tableHeaderCellDecoratorArray2 = tableHeaderCellDecoratorArray = ((SortableTableHeader)jTableHeader).getCellDecorators();
                        n3 = tableHeaderCellDecoratorArray2.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            object2 = tableHeaderCellDecoratorArray2[n2];
                            if (object2 instanceof FilterableTableHeaderCellDecorator) {
                                jTableHeader.putClientProperty("TableHeaderUIDelegate.filterCellDecoratorProperties", new int[]{n, n});
                            }
                            try {
                                object = object2.getInsets(null, jTableHeader, n, jTableHeader.getHeaderRect(n));
                                if (object == null) continue;
                                n5 += ((Insets)object).left + ((Insets)object).right;
                                continue;
                            }
                            finally {
                                jTableHeader.putClientProperty("TableHeaderUIDelegate.filterCellDecoratorProperties", null);
                            }
                        }
                    }
                }
            }
            n5 = Math.max(n5, tableColumn.getMinWidth());
            if (jTableHeader instanceof NestedTableHeader && nArray != null && nArray.length >= jTable.getColumnCount() && (object3 = ((NestedTableHeader)jTableHeader).getColumnGroups(tableColumn)) != null) {
                while (object3.hasMoreElements()) {
                    serializable = (TableColumnGroup)object3.nextElement();
                    if (n != ((TableColumnGroup)serializable).getColumnIndex()) continue;
                    int n6 = ((TableColumnGroup)serializable).getLastColumnIndex();
                    int n7 = ((TableColumnGroup)serializable).getPreferredWidth(jTable);
                    for (n3 = n6; n3 > n; --n3) {
                        n7 -= nArray[n3];
                    }
                    if (n7 <= n5) continue;
                    n5 = n7;
                }
            }
        }
        try {
            int n8;
            int n9;
            if (bl2) {
                tableHeaderCellDecoratorArray = jTable.getVisibleRect();
                n9 = jTable.rowAtPoint(new Point(tableHeaderCellDecoratorArray.x, tableHeaderCellDecoratorArray.y + tableHeaderCellDecoratorArray.height - 1));
                if (n9 < 0) {
                    n9 = n4 - 1;
                }
                if ((n8 = jTable.rowAtPoint(new Point(tableHeaderCellDecoratorArray.x, tableHeaderCellDecoratorArray.y))) < 0) {
                    n8 = 0;
                }
            } else {
                n9 = n4 - 1;
                n8 = 0;
            }
            if (bl3) {
                tableHeaderCellDecoratorArray = null;
                for (int i = n9; i >= n8; --i) {
                    if (tableHeaderCellDecoratorArray == null) {
                        tableHeaderCellDecoratorArray = jTable.getCellRenderer(i, n);
                        continue;
                    }
                    if (tableHeaderCellDecoratorArray == jTable.getCellRenderer(i, n)) continue;
                    bl3 = false;
                    break;
                }
            }
            if (bl3) {
                CellSpan cellSpan;
                int n10 = 0;
                int n11 = -1;
                for (n3 = n9; n3 >= n8; --n3) {
                    int n12;
                    Object object4 = jTable.getValueAt(n3, n);
                    if (jTable instanceof ContextSensitiveTable) {
                        object = ((ContextSensitiveTable)jTable).convertElementToString(object4, n3, n);
                        n12 = object == null ? 0 : ((String)object).length();
                    } else {
                        int n13 = n12 = object4 == null ? 0 : object4.toString().length();
                    }
                    if (jTable instanceof CellSpanTable && ((CellSpanTable)jTable).isCellSpanOn() && (object = ((CellSpanTable)jTable).getCellSpanAt(n3, n)) != null) {
                        n12 /= ((CellSpan)object).getColumnSpan();
                    }
                    if (n12 <= n10) continue;
                    n10 = n12;
                    n11 = n3;
                }
                n3 = 0;
                if (n11 >= 0 && n11 < jTable.getRowCount()) {
                    TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n11, n);
                    Component component = jTable.prepareRenderer(tableCellRenderer, n11, n);
                    component.setSize(new Dimension(0, 0));
                    if (component instanceof TreeExpandablePanel) {
                        ((TreeExpandablePanel)component).setColumnWidth(-1);
                    }
                    n3 = component.getPreferredSize().width + jTable.getIntercellSpacing().width;
                    if (jTable instanceof JideTable) {
                        ((JideTable)jTable).releaseRendererComponent(tableCellRenderer, n11, n, component);
                    }
                }
                if (jTable instanceof CellSpanTable && ((CellSpanTable)jTable).isCellSpanOn() && (cellSpan = ((CellSpanTable)jTable).getCellSpanAt(n11, n)) != null && cellSpan.getColumnSpan() > 1) {
                    for (int i = cellSpan.getColumn() + cellSpan.getColumnSpan() - 1; i > n; --i) {
                        n3 -= nArray[i];
                    }
                    n3 /= n - cellSpan.getColumn() + 1;
                }
                n5 = Math.max(n5, n3);
                if (jTable instanceof TreeTable) {
                    int n14 = ((TreeTable)jTable).getIndent(((TreeTable)jTable).getRowAt(n11));
                    int n15 = -1;
                    for (int i = 0; i < jTable.getRowCount(); ++i) {
                        Row row = ((TreeTable)jTable).getRowAt(i);
                        n15 = Math.max(n15, ((TreeTable)jTable).getIndent(row));
                    }
                    n5 += n15 - n14;
                }
            } else {
                for (int i = n9; i >= n8; --i) {
                    Component component;
                    TableCellRenderer tableCellRenderer;
                    if (jTable instanceof CellSpanTable && ((CellSpanTable)jTable).isCellSpanOn()) {
                        object2 = ((CellSpanTable)jTable).getCellSpanAt(i, n);
                        if (object2 != null && (((CellSpan)object2).getRow() != i || n < ((CellSpan)object2).getColumn() || n >= ((CellSpan)object2).getColumn() + ((CellSpan)object2).getColumnSpan())) continue;
                        tableCellRenderer = jTable.getCellRenderer(i, n);
                        component = jTable.prepareRenderer(tableCellRenderer, i, n);
                        component.setSize(new Dimension(0, 0));
                        if (component instanceof TreeExpandablePanel) {
                            ((TreeExpandablePanel)component).setColumnWidth(-1);
                        }
                        n2 = component.getPreferredSize().width + jTable.getIntercellSpacing().width;
                        if (object2 != null && ((CellSpan)object2).getColumnSpan() > 1) {
                            for (int j = ((CellSpan)object2).getColumn() + ((CellSpan)object2).getColumnSpan() - 1; j > n; --j) {
                                n2 -= nArray[j];
                            }
                            n2 /= n - ((CellSpan)object2).getColumn() + 1;
                        }
                    } else {
                        tableCellRenderer = jTable.getCellRenderer(i, n);
                        component = jTable.prepareRenderer(tableCellRenderer, i, n);
                        component.setSize(new Dimension(0, 0));
                        if (component instanceof TreeExpandablePanel) {
                            ((TreeExpandablePanel)component).setColumnWidth(-1);
                        }
                        n2 = component.getPreferredSize().width + jTable.getIntercellSpacing().width;
                    }
                    n5 = Math.max(n5, n2);
                    if (!(jTable instanceof JideTable)) continue;
                    ((JideTable)jTable).releaseRendererComponent(tableCellRenderer, i, n, component);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n5;
    }

    public static boolean isTableColumnResizable(JTable jTable, TableColumn tableColumn) {
        return tableColumn != null && (jTable.getTableHeader() == null || jTable.getTableHeader().getResizingAllowed()) && tableColumn.getResizable();
    }

    public static int autoResizeRow(JTable jTable, int n) {
        return TableUtils.autoResizeRow(jTable, n, -1);
    }

    public static int autoResizeRow(JTable jTable, int n, int n2) {
        int[] nArray = new int[]{n2};
        if ((nArray = TableUtils.autoResizeRows(jTable, n, n, nArray)) != null) {
            if (nArray.length == 1) {
                return nArray[0];
            }
            if (nArray.length == jTable.getRowCount() && n < nArray.length) {
                return nArray[n];
            }
        }
        return -1;
    }

    public static int[] autoResizeRows(JTable jTable, int n, int n2) {
        return TableUtils.autoResizeRows(jTable, n, n2, null);
    }

    public static int[] autoResizeRows(final JTable jTable, int n, int n2, int[] nArray) {
        int n3;
        JTable[] jTableArray;
        int n4;
        if (nArray != null && nArray.length != n2 - n + 1) {
            return new int[0];
        }
        if (n > n2 || n < 0 || n2 >= jTable.getRowCount()) {
            return new int[0];
        }
        if (jTable instanceof JideTable && !((JideTable)jTable).isVariousRowHeights()) {
            n = 0;
            n2 = jTable.getRowCount() - 1;
        }
        final int[] nArray2 = new int[n2 - n + 1];
        int n5 = 1;
        if (nArray == null) {
            for (n4 = n; n4 <= n2; ++n4) {
                nArray2[n4 - n] = TableUtils.calculateRowHeight(jTable, n4, 1);
                if (nArray2[n4 - n] <= n5) continue;
                n5 = nArray2[n4 - n];
            }
        } else {
            for (n4 = n; n4 <= n2; ++n4) {
                nArray2[n4 - n] = TableUtils.calculateRowHeight(jTable, n4, n4 - n >= nArray.length ? 1 : nArray[n4 - n]);
                if (nArray2[n4 - n] <= n5) continue;
                n5 = nArray2[n4 - n];
            }
        }
        if ((jTableArray = TableColumnChooser.getAllTables(jTable)) != null && jTableArray.length > 1) {
            for (n3 = n; n3 <= n2; ++n3) {
                for (JTable jTable2 : jTableArray) {
                    int n6;
                    if (jTable2 == jTable || (n6 = TableUtils.calculateRowHeight(jTable2, n3, 1)) <= nArray2[n3 - n]) continue;
                    nArray2[n3 - n] = n6;
                    if (nArray2[n3 - n] <= n5) continue;
                    n5 = nArray2[n3 - n];
                }
            }
        }
        n3 = n;
        final int n7 = n2;
        final int n8 = n5;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!(jTable instanceof JideTable) || ((JideTable)jTable).isVariousRowHeights()) {
                    for (int i = n3; i <= n7; ++i) {
                        jTable.setRowHeight(i, nArray2[i - n3]);
                        if (!(jTable instanceof JideTable) || !((JideTable)jTable).isRowHeightChanged(i, nArray2[i - n3])) continue;
                        ((JideTable)jTable).getRowHeights().setRowHeight(i, nArray2[i - n3]);
                    }
                } else {
                    jTable.setRowHeight(n8);
                }
                if (jTable instanceof HierarchicalTable) {
                    jTable.doLayout();
                } else {
                    jTable.revalidate();
                    jTable.repaint();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
        return nArray2;
    }

    public static int[] autoResizeAllRows(JTable jTable) {
        return TableUtils.autoResizeAllRows(jTable, null);
    }

    public static int[] autoResizeAllRows(JTable jTable, int[] nArray) {
        return TableUtils.autoResizeRows(jTable, 0, jTable.getRowCount() - 1, nArray);
    }

    protected static int calculateRowHeight(JTable jTable, int n, int n2) {
        int n3;
        if (!(jTable instanceof JideTable)) {
            int n4 = jTable.getRowHeight(n);
            if (n4 == 0) {
                n4 = jTable.getRowHeight();
            }
            n3 = jTable.getRowHeight();
            int n5 = jTable.getColumnCount();
            for (int i = 0; i < n5; ++i) {
                int n6;
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, i);
                Component component = jTable.prepareRenderer(tableCellRenderer, n, i);
                int n7 = jTable.getCellRect((int)n, (int)i, (boolean)false).width;
                if (component instanceof TreeExpandablePanel) {
                    ((TreeExpandablePanel)component).setColumnWidth(n7);
                }
                if (component.getPreferredSize().width != n7) {
                    component.setBounds(0, 0, n7, n4);
                }
                if ((n6 = component.getPreferredSize().height) <= n3) continue;
                n3 = n6;
            }
            n3 = n5 > 0 ? (n3 += jTable.getIntercellSpacing().height) : n4;
        } else {
            n3 = ((JideTable)jTable).calculateRowHeight(n);
        }
        n2 = Math.max(1, n2);
        return Math.max(n3, n2);
    }

    public static boolean stopCellEditingForAll(JTable jTable) {
        if (jTable == null) {
            return false;
        }
        Object object = jTable.getClientProperty("TableScrollPane.Parent");
        if (object instanceof TableScrollPane) {
            JTable[] jTableArray;
            TableScrollPane tableScrollPane = (TableScrollPane)object;
            for (JTable jTable2 : jTableArray = tableScrollPane.getAllChildTables()) {
                if (!jTable2.isEditing() || jTable2.getCellEditor().stopCellEditing()) continue;
                if (jTable2.getCellEditor() != null) {
                    jTable2.getCellEditor().cancelCellEditing();
                }
                return false;
            }
        }
        return true;
    }

    public static void ensureRowSelectionVisible(JTable jTable) {
        int n = jTable.getSelectionModel().getMaxSelectionIndex();
        if (n != -1) {
            TableUtils.ensureRowVisible(jTable, n);
        }
        int n2 = jTable.getSelectionModel().getMinSelectionIndex();
        if (n != -1 && n != n2) {
            TableUtils.ensureRowVisible(jTable, n2);
        }
    }

    public static void ensureRowVisible(JTable jTable, int n) {
        JideSwingUtilities.ensureRowVisible(jTable, n);
    }

    public static int findColumnIndex(TableModel tableModel, String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            if (!string.equals(tableModel.getColumnName(i))) continue;
            return i;
        }
        return -1;
    }

    public static int[] findColumnIndexes(TableModel tableModel, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            nArray[i] = TableUtils.findColumnIndex(tableModel, string);
        }
        return nArray;
    }

    public static int getViewPositionForRow(JTable jTable, int n) {
        Rectangle rectangle = jTable.getVisibleRect();
        Rectangle rectangle2 = jTable.getCellRect(n, 0, false);
        return rectangle2.y - rectangle.y;
    }

    public static void setViewPositionForRow(JTable jTable, int n, int n2) {
        Component component = JideSwingUtilities.getScrollPane(jTable);
        if (component instanceof JScrollPane) {
            Point point = ((JScrollPane)component).getViewport().getViewPosition();
            Rectangle rectangle = jTable.getCellRect(n, 0, false);
            point.y = rectangle.y - n2;
            if (point.y < 0) {
                point.y = 0;
            }
            ((JScrollPane)component).getViewport().setViewPosition(point);
        }
    }

    public static void saveColumnOrders(JTable jTable, boolean bl) {
        TableColumnSnapshot tableColumnSnapshot;
        TableScrollPane tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent");
        if (tableScrollPane != null) {
            TableUtils.saveColumnOrders(tableScrollPane);
            if (tableScrollPane.getMainTable() == jTable) {
                return;
            }
        }
        if ((tableColumnSnapshot = (TableColumnSnapshot)jTable.getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT)) == null) {
            tableColumnSnapshot = new TableColumnSnapshot();
        }
        tableColumnSnapshot.record(jTable, false, bl);
        jTable.putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
    }

    public static void clearColumnOrdersMemory(JTable jTable) {
        TableColumnSnapshot tableColumnSnapshot;
        TableScrollPane tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent");
        if (tableScrollPane != null) {
            TableUtils.clearColumnOrdersMemory(tableScrollPane);
            if (jTable == tableScrollPane.getMainTable()) {
                return;
            }
        }
        if ((tableColumnSnapshot = (TableColumnSnapshot)jTable.getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT)) == null) {
            return;
        }
        List<Object> list = tableColumnSnapshot.constructNewShot(jTable, false);
        tableColumnSnapshot.remove(list);
        if (tableColumnSnapshot.getSize() <= 0) {
            tableColumnSnapshot = null;
        }
        jTable.putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
    }

    public static void saveDefaultColumnOrders(TableScrollPane tableScrollPane, TableModel tableModel) {
        TableColumnSnapshot tableColumnSnapshot = (TableColumnSnapshot)tableScrollPane.getMainTable().getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT);
        if (tableColumnSnapshot == null) {
            tableColumnSnapshot = new TableColumnSnapshot();
        }
        tableColumnSnapshot.recordDefault(tableModel);
        tableScrollPane.getMainTable().putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
    }

    public static void saveDefaultColumnOrders(GroupTable groupTable) {
        TableModel tableModel;
        TableColumnSnapshot tableColumnSnapshot = (TableColumnSnapshot)groupTable.getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT);
        if (tableColumnSnapshot == null) {
            tableColumnSnapshot = new TableColumnSnapshot();
        }
        if ((tableModel = TableModelWrapperUtils.getActualTableModel(groupTable.getModel(), DefaultGroupTableModel.class)) == null) {
            if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                LOGGER_EVENT.fine("TableUtils \" GroupTable should have wrapped a DefaultGroupTableModel.");
            }
            return;
        }
        tableColumnSnapshot.recordDefault(tableModel);
        groupTable.putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
    }

    public static void saveColumnOrders(TableScrollPane tableScrollPane) {
        TableColumnSnapshot tableColumnSnapshot = (TableColumnSnapshot)tableScrollPane.getMainTable().getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT);
        if (tableColumnSnapshot == null) {
            tableColumnSnapshot = new TableColumnSnapshot();
        }
        tableColumnSnapshot.record(tableScrollPane, false);
        tableScrollPane.getMainTable().putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
    }

    public static void clearColumnOrdersMemory(TableScrollPane tableScrollPane) {
        TableColumnSnapshot tableColumnSnapshot = (TableColumnSnapshot)tableScrollPane.getMainTable().getClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT);
        if (tableColumnSnapshot == null) {
            return;
        }
        List<Object> list = tableColumnSnapshot.constructNewShot(tableScrollPane, false);
        tableColumnSnapshot.remove(list);
        if (tableColumnSnapshot.getSize() <= 0) {
            tableColumnSnapshot = null;
        }
        tableScrollPane.getMainTable().putClientProperty(CLIENT_PROPERTY_TABLE_COLUMN_SNAPSHOT, tableColumnSnapshot);
    }

    public static TableColumn getResizingColumn(JTable jTable, Point point, int n) {
        int n2;
        if (n == -1) {
            return null;
        }
        int n3 = jTable.rowAtPoint(point);
        if (n3 == -1) {
            return null;
        }
        Rectangle rectangle = jTable.getCellRect(n3, n, true);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return null;
        }
        int n4 = rectangle.x + rectangle.width / 2;
        if (jTable.getComponentOrientation().isLeftToRight()) {
            n2 = point.x < n4 ? n - 1 : n;
        } else {
            int n5 = n2 = point.x < n4 ? n : n - 1;
        }
        if (n2 == -1) {
            return null;
        }
        if (n2 == jTable.getColumnCount() - 1 && jTable.getAutoResizeMode() != 0) {
            return null;
        }
        return jTable.getColumnModel().getColumn(n2);
    }

    private static abstract class SyncWeakListener {
        protected final WeakReference _masterRef;
        protected final WeakReference _slaveRef;

        public SyncWeakListener(JTable jTable, JTable jTable2) {
            this._masterRef = new WeakReference<JTable>(jTable);
            this._slaveRef = new WeakReference<JTable>(jTable2);
        }

        public JTable getMaster() {
            return (JTable)this._masterRef.get();
        }

        public JTable getSlave() {
            return (JTable)this._slaveRef.get();
        }

        abstract void removeListener(JTable var1);

        public boolean isValid() {
            JTable jTable = this.getMaster();
            JTable jTable2 = this.getSlave();
            if (jTable2 == null && jTable != null) {
                this.removeListener(jTable);
            } else if (jTable2 != null && jTable == null) {
                this._slaveRef.clear();
            } else if (jTable2 != null) {
                return true;
            }
            return false;
        }
    }

    private static class SyncColumnsAddRemoveColumnModelListener
    extends SyncWeakListener
    implements TableColumnModelListener {
        private SyncColumnsAddRemoveColumnModelListener(JTable jTable, JTable jTable2) {
            super(jTable, jTable2);
        }

        @Override
        void removeListener(JTable jTable) {
            jTable.getColumnModel().removeColumnModelListener(this);
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            if (this.isValid()) {
                TableUtils.synchronizeTableColumnWidthNow(this.getMaster(), this.getSlave());
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            if (this.isValid() && !Boolean.FALSE.equals(this.getMaster().getClientProperty("TableScrollPane.AutoUpdateFooterTableColumns"))) {
                int n = tableColumnModelEvent.getToIndex();
                if (n >= this.getMaster().getColumnModel().getColumnCount()) {
                    return;
                }
                TableColumn tableColumn = this.getMaster().getColumnModel().getColumn(n);
                JTable jTable = this.getSlave();
                TableModel tableModel = jTable.getModel();
                Object object = jTable.getClientProperty("TableScrollPane.AutoUpdateFooterTableColumns");
                try {
                    jTable.putClientProperty("TableScrollPane.AutoUpdateFooterTableColumns", Boolean.FALSE);
                    int n2 = tableColumn.getModelIndex();
                    int n3 = -1;
                    TableModel tableModel2 = this.getMaster().getModel();
                    Object object2 = tableModel2 instanceof ColumnIdentifierTableModel ? ((ColumnIdentifierTableModel)((Object)tableModel2)).getColumnIdentifier(n2) : tableModel2.getColumnName(n2);
                    for (int i = tableModel.getColumnCount() - 1; i >= 0; --i) {
                        if (!JideSwingUtilities.equals(tableModel instanceof ColumnIdentifierTableModel ? ((ColumnIdentifierTableModel)((Object)tableModel)).getColumnIdentifier(i) : tableModel.getColumnName(i), object2)) continue;
                        n3 = i;
                        break;
                    }
                    Object object3 = tableColumn.getIdentifier() == null ? tableColumn.getHeaderValue() : tableColumn.getIdentifier();
                    object3 = TableUtils.eraseIdentifierFlag(object3, TableUtils.COLUMN_PROPERTY_DATA_TABLE_MODEL_COLUMNS);
                    if (n3 >= 0) {
                        TableColumnChooser.showColumn(jTable, "" + object3, n3, n);
                    }
                }
                finally {
                    jTable.putClientProperty("TableScrollPane.AutoUpdateFooterTableColumns", object);
                }
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (this.isValid() && !Boolean.FALSE.equals(this.getMaster().getClientProperty("TableScrollPane.AutoUpdateFooterTableColumns")) && tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                Object object = this.getSlave().getClientProperty("TableScrollPane.AutoUpdateFooterTableColumns");
                try {
                    this.getSlave().putClientProperty("TableScrollPane.AutoUpdateFooterTableColumns", Boolean.FALSE);
                    this.getSlave().moveColumn(tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
                }
                finally {
                    this.getSlave().putClientProperty("TableScrollPane.AutoUpdateFooterTableColumns", object);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            if (this.isValid() && !Boolean.FALSE.equals(this.getMaster().getClientProperty("TableScrollPane.AutoUpdateFooterTableColumns"))) {
                int n = tableColumnModelEvent.getFromIndex();
                Object object = this.getSlave().getClientProperty("TableScrollPane.AutoUpdateFooterTableColumns");
                try {
                    this.getSlave().putClientProperty("TableScrollPane.AutoUpdateFooterTableColumns", Boolean.FALSE);
                    if (n >= 0 && n < this.getSlave().getColumnModel().getColumnCount()) {
                        TableColumnChooser.hideColumn(this.getSlave(), this.getSlave().convertColumnIndexToModel(n), false);
                    }
                }
                finally {
                    this.getSlave().putClientProperty("TableScrollPane.AutoUpdateFooterTableColumns", object);
                }
            }
        }
    }

    private static class SyncColumnsColumnModelListener
    extends SyncWeakListener
    implements TableColumnModelListener {
        private SyncColumnsColumnModelListener(JTable jTable, JTable jTable2) {
            super(jTable, jTable2);
        }

        @Override
        void removeListener(JTable jTable) {
            jTable.getColumnModel().removeColumnModelListener(this);
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            if (this.isValid()) {
                TableUtils.synchronizeTableColumnWidthNow(this.getMaster(), this.getSlave());
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }
    }

    private static class SyncTableComponentListener
    extends SyncWeakListener
    implements ComponentListener {
        private SyncTableComponentListener(JTable jTable, JTable jTable2) {
            super(jTable, jTable2);
        }

        @Override
        void removeListener(JTable jTable) {
            jTable.removeComponentListener(this);
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (this.isValid()) {
                TableUtils.syncTable(this.getMaster(), this.getSlave());
            }
        }
    }

    private static class SyncColumnSelectionPropertyChangeListener
    extends SyncWeakListener
    implements PropertyChangeListener {
        private SyncColumnSelectionPropertyChangeListener(JTable jTable, JTable jTable2) {
            super(jTable, jTable2);
        }

        @Override
        void removeListener(JTable jTable) {
            jTable.removePropertyChangeListener("columnModel", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.isValid()) {
                this.getSlave().getColumnModel().setSelectionModel(this.getMaster().getColumnModel().getSelectionModel());
            }
        }
    }

    static class MultipleTableTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = -6979344936177363559L;

        MultipleTableTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTable) {
                JTable jTable = (JTable)jComponent;
                Object object = jTable.getClientProperty("TableScrollPane.Parent");
                if (object instanceof TableAdapter) {
                    int[] nArray;
                    int n;
                    int[] nArray2;
                    int n2;
                    TableAdapter tableAdapter = (TableAdapter)object;
                    if (!tableAdapter.getRowSelectionAllowed() && !tableAdapter.getColumnSelectionAllowed()) {
                        return null;
                    }
                    if (!tableAdapter.getRowSelectionAllowed()) {
                        n2 = tableAdapter.getRowCount();
                        nArray2 = new int[n2];
                        for (n = 0; n < n2; ++n) {
                            nArray2[n] = n;
                        }
                    } else {
                        nArray2 = tableAdapter.getSelectedRows();
                    }
                    if (!tableAdapter.getColumnSelectionAllowed()) {
                        n2 = tableAdapter.getColumnCount();
                        nArray = new int[n2];
                        for (n = 0; n < n2; ++n) {
                            nArray[n] = n;
                        }
                    } else {
                        nArray = tableAdapter.getSelectedColumns();
                    }
                    if (nArray2 == null || nArray == null || nArray2.length == 0 || nArray.length == 0) {
                        return null;
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append("<html>\n<body>\n<table>\n");
                    for (int n3 : nArray2) {
                        stringBuffer2.append("<tr>\n");
                        for (int n4 : nArray) {
                            Object object2 = tableAdapter.getValueAt(n3, n4);
                            String string = object2 == null ? "" : object2.toString();
                            stringBuffer.append(string).append("\t");
                            stringBuffer2.append("  <td>").append(string).append("</td>\n");
                        }
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1).append("\n");
                        stringBuffer2.append("</tr>\n");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    stringBuffer2.append("</table>\n</body>\n</html>");
                    return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
                }
                return new BasicTransferable("", "");
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    private static class SelectPreviousRowCellAction
    extends AbstractAction {
        private final Action _action;
        JTable _table;
        private JTable _prevTable;
        private String _actionName;
        private static final long serialVersionUID = -3899743934176313755L;

        SelectPreviousRowCellAction(Action action, String string, JTable jTable, JTable jTable2) {
            this._action = action;
            this._actionName = string;
            this._prevTable = jTable2;
            this._table = jTable;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.triggerToPreviousTable() && this._prevTable != null && this._prevTable.getRowCount() > 0) {
                try {
                    if (this._table.isEditing() && !this._table.getCellEditor().stopCellEditing()) {
                        return;
                    }
                    if (!TableUtils.stopCellEditingForAll(this._table)) {
                        return;
                    }
                }
                catch (EditingNotStoppedException editingNotStoppedException) {
                    return;
                }
                this._prevTable.requestFocus();
                if (this._table instanceof JideTable && this._prevTable instanceof JideTable) {
                    ((JideTable)this._prevTable).inheritEditingFieldsFrom((JideTable)this._table);
                }
                this._prevTable.changeSelection(this._prevTable.getRowCount() - 1, this._table.getSelectedColumn(), false, false);
                if (this._prevTable instanceof JideTable) {
                    ((JideTable)this._prevTable).clearEditingFields();
                }
            } else if (this.triggerToPreviousTable() && this._prevTable != null && this._prevTable.getRowCount() == 0) {
                this._prevTable.getActionMap().get(this._actionName).actionPerformed(actionEvent);
            } else {
                this._action.actionPerformed(actionEvent);
            }
        }

        boolean triggerToPreviousTable() {
            return this._table.getSelectedRow() == 0;
        }
    }

    private static class SelectNextRowCellAction
    extends AbstractAction {
        private final Action _action;
        JTable _table;
        private JTable _nextTable;
        private String _actionName;
        private static final long serialVersionUID = 2923129252213398932L;

        SelectNextRowCellAction(Action action, String string, JTable jTable, JTable jTable2) {
            this._action = action;
            this._actionName = string;
            this._nextTable = jTable2;
            this._table = jTable;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.triggerToNextTable() && this._nextTable != null && this._nextTable.getRowCount() > 0) {
                try {
                    if (this._table.isEditing() && !this._table.getCellEditor().stopCellEditing()) {
                        return;
                    }
                    if (!TableUtils.stopCellEditingForAll(this._table)) {
                        return;
                    }
                }
                catch (EditingNotStoppedException editingNotStoppedException) {
                    return;
                }
                this._nextTable.requestFocus();
                if (this._table instanceof JideTable && this._nextTable instanceof JideTable) {
                    ((JideTable)this._nextTable).inheritEditingFieldsFrom((JideTable)this._table);
                }
                this._nextTable.changeSelection(0, this._table.getSelectedColumn(), false, false);
                if (this._nextTable instanceof JideTable) {
                    ((JideTable)this._nextTable).clearEditingFields();
                }
            } else if (this.triggerToNextTable() && this._nextTable != null && this._nextTable.getRowCount() == 0) {
                this._nextTable.getActionMap().get(this._actionName).actionPerformed(actionEvent);
            } else {
                this._action.actionPerformed(actionEvent);
            }
        }

        boolean triggerToNextTable() {
            return this._table.getSelectedRow() == this._table.getRowCount() - 1;
        }
    }

    private static final class SelectLastColumnCellAction
    extends AbstractAction {
        private final Action _action;
        private JTable[] _tables;
        private JTable _table;
        private static final long serialVersionUID = -5877245537172413615L;

        private SelectLastColumnCellAction(Action action, JTable jTable, JTable[] jTableArray) {
            this._action = action;
            this._table = jTable;
            this._tables = jTableArray;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this._table.isEditing() && !this._table.getCellEditor().stopCellEditing()) {
                    return;
                }
                if (!TableUtils.stopCellEditingForAll(this._table)) {
                    return;
                }
            }
            catch (EditingNotStoppedException editingNotStoppedException) {
                return;
            }
            boolean bl = false;
            for (int i = this._tables.length - 1; i >= 0; --i) {
                JTable jTable = this._tables[i];
                if (jTable == null || jTable.getColumnCount() <= 0) continue;
                jTable.requestFocus();
                if (jTable instanceof JideTable && this._table instanceof JideTable) {
                    ((JideTable)jTable).inheritEditingFieldsFrom((JideTable)this._table);
                }
                jTable.changeSelection(this._table.getSelectedRow(), jTable.getColumnCount() - 1, false, false);
                if (jTable instanceof JideTable) {
                    ((JideTable)jTable).clearEditingFields();
                }
                bl = true;
                break;
            }
            if (!bl) {
                this._action.actionPerformed(actionEvent);
            }
        }
    }

    private static final class SelectFirstColumnCellAction
    extends AbstractAction {
        private final Action _action;
        private JTable[] _tables;
        private JTable _table;
        private static final long serialVersionUID = -4897243937176413715L;

        private SelectFirstColumnCellAction(Action action, JTable jTable, JTable[] jTableArray) {
            this._action = action;
            this._table = jTable;
            this._tables = jTableArray;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this._table.isEditing() && !this._table.getCellEditor().stopCellEditing()) {
                    return;
                }
                if (!TableUtils.stopCellEditingForAll(this._table)) {
                    return;
                }
            }
            catch (EditingNotStoppedException editingNotStoppedException) {
                return;
            }
            boolean bl = false;
            for (JTable jTable : this._tables) {
                if (jTable == null || jTable.getColumnCount() <= 0) continue;
                jTable.requestFocus();
                if (jTable instanceof JideTable && this._table instanceof JideTable) {
                    ((JideTable)jTable).inheritEditingFieldsFrom((JideTable)this._table);
                }
                jTable.changeSelection(this._table.getSelectedRow(), 0, false, false);
                if (jTable instanceof JideTable) {
                    ((JideTable)jTable).clearEditingFields();
                }
                bl = true;
                break;
            }
            if (!bl) {
                this._action.actionPerformed(actionEvent);
            }
        }
    }

    private static final class SelectLastRowCellAction
    extends AbstractAction {
        private final Action _action;
        private JTable[] _tables;
        private JTable _table;
        private static final long serialVersionUID = -4897243937176413715L;

        private SelectLastRowCellAction(Action action, JTable jTable, JTable[] jTableArray) {
            this._action = action;
            this._table = jTable;
            this._tables = jTableArray;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this._table.isEditing() && !this._table.getCellEditor().stopCellEditing()) {
                    return;
                }
                if (!TableUtils.stopCellEditingForAll(this._table)) {
                    return;
                }
            }
            catch (EditingNotStoppedException editingNotStoppedException) {
                return;
            }
            boolean bl = false;
            for (int i = this._tables.length - 1; i >= 0; --i) {
                JTable jTable = this._tables[i];
                if (jTable == null || jTable.getRowCount() <= 0) continue;
                jTable.requestFocus();
                if (jTable instanceof JideTable && this._table instanceof JideTable) {
                    ((JideTable)jTable).inheritEditingFieldsFrom((JideTable)this._table);
                }
                jTable.changeSelection(jTable.getRowCount() - 1, this._table.getSelectedColumn(), false, false);
                if (jTable instanceof JideTable) {
                    ((JideTable)jTable).clearEditingFields();
                }
                bl = true;
                break;
            }
            if (!bl) {
                this._action.actionPerformed(actionEvent);
            }
        }
    }

    private static final class SelectFirstRowCellAction
    extends AbstractAction {
        private final Action _action;
        private JTable[] _tables;
        private JTable _table;
        private static final long serialVersionUID = -4897243937176413715L;

        private SelectFirstRowCellAction(Action action, JTable jTable, JTable[] jTableArray) {
            this._action = action;
            this._table = jTable;
            this._tables = jTableArray;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this._table.isEditing() && !this._table.getCellEditor().stopCellEditing()) {
                    return;
                }
                if (!TableUtils.stopCellEditingForAll(this._table)) {
                    return;
                }
            }
            catch (EditingNotStoppedException editingNotStoppedException) {
                return;
            }
            boolean bl = false;
            for (JTable jTable : this._tables) {
                if (jTable == null || jTable.getRowCount() <= 0) continue;
                jTable.requestFocus();
                if (jTable instanceof JideTable && this._table instanceof JideTable) {
                    ((JideTable)jTable).inheritEditingFieldsFrom((JideTable)this._table);
                }
                jTable.changeSelection(0, this._table.getSelectedColumn(), false, false);
                if (jTable instanceof JideTable) {
                    ((JideTable)jTable).clearEditingFields();
                }
                bl = true;
                break;
            }
            if (!bl) {
                this._action.actionPerformed(actionEvent);
            }
        }
    }

    private static class SelectPreviousColumnCellAction
    extends AbstractAction {
        private final Action _action;
        JTable _table;
        private JTable _prevTable;
        private JTable _prevRowLastTable;
        private boolean _lastTable;
        private String _actionName;
        private static final long serialVersionUID = -3899743934176313755L;

        SelectPreviousColumnCellAction(Action action, String string, JTable jTable, JTable jTable2, JTable jTable3, boolean bl) {
            this._action = action;
            this._actionName = string;
            this._prevTable = jTable2;
            this._prevRowLastTable = jTable3;
            this._table = jTable;
            this._lastTable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Row row;
            int n2;
            boolean bl = this.triggerToPreviousTable();
            JTable jTable = this.getPreviousTable();
            if (bl && jTable != null && !"\t".equals(actionEvent.getActionCommand()) && this._table instanceof TreeTable && ((n2 = ((TreeTable)this._table).getExpandableColumn()) == -1 || this._table.convertColumnIndexToView(n2) == 0) && (row = ((TreeTable)this._table).getRowAt(n = this._table.getSelectedRow())) instanceof Expandable && ((Expandable)((Object)row)).isExpanded()) {
                this._action.actionPerformed(actionEvent);
                return;
            }
            if (bl && jTable != null && jTable.getColumnCount() > 0) {
                try {
                    if (this._table.isEditing() && !this._table.getCellEditor().stopCellEditing()) {
                        return;
                    }
                    if (!TableUtils.stopCellEditingForAll(this._table)) {
                        return;
                    }
                }
                catch (EditingNotStoppedException editingNotStoppedException) {
                    return;
                }
                jTable.requestFocus();
                if (this._table instanceof JideTable && jTable instanceof JideTable) {
                    ((JideTable)jTable).inheritEditingFieldsFrom((JideTable)this._table);
                }
                if (this._lastTable) {
                    jTable.changeSelection(this._prevTable == jTable ? TableUtils.previousRow(this._table, jTable) : jTable.getRowCount() - 1, jTable.getColumnCount() - 1, false, false);
                } else {
                    n2 = this._table.getSelectedRow();
                    if (n2 < 0) {
                        n2 = this._table.getEditingRow();
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    jTable.changeSelection(n2, jTable.getColumnCount() - 1, false, false);
                }
                if (jTable instanceof JideTable) {
                    ((JideTable)jTable).clearEditingFields();
                }
            } else if (bl && jTable != null && jTable.getColumnCount() == 0) {
                Action action = jTable.getActionMap().get(this._actionName);
                if (action instanceof SelectPreviousColumnCellAction && ((SelectPreviousColumnCellAction)action).getPreviousTable() == null) {
                    this._action.actionPerformed(actionEvent);
                } else {
                    n = ((SelectPreviousColumnCellAction)action)._lastTable;
                    ((SelectPreviousColumnCellAction)action)._lastTable |= this._lastTable;
                    try {
                        action.actionPerformed(actionEvent);
                    }
                    finally {
                        ((SelectPreviousColumnCellAction)action)._lastTable = n;
                    }
                }
            } else {
                this._action.actionPerformed(actionEvent);
            }
        }

        boolean triggerToPreviousTable() {
            return this._table.getColumnCount() <= 0 || this._table.getSelectedColumn() == 0;
        }

        JTable getPreviousTable() {
            if (!this.triggerToPreviousTable()) {
                return null;
            }
            if (this._prevRowLastTable != null && this._table.getSelectedRow() == 0) {
                return this._prevRowLastTable;
            }
            return this._prevTable;
        }
    }

    private static class SelectNextColumnCellAction
    extends AbstractAction {
        private final Action _action;
        JTable _table;
        private JTable _nextTable;
        private JTable _nextRowFirstTable;
        private boolean _newRow;
        private String _actionName;
        private static final long serialVersionUID = 2923129252213398932L;

        SelectNextColumnCellAction(Action action, String string, JTable jTable, JTable jTable2, JTable jTable3, boolean bl) {
            this._action = action;
            this._actionName = string;
            this._nextTable = jTable2;
            this._table = jTable;
            this._newRow = bl;
            if (bl) {
                this._nextRowFirstTable = jTable3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Row row;
            int n2;
            boolean bl = this.triggerToNextTable();
            JTable jTable = this.getNextTable();
            if (bl && jTable != null && !"\t".equals(actionEvent.getActionCommand()) && this._table instanceof TreeTable && ((n2 = ((TreeTable)this._table).getExpandableColumn()) == -1 && this._table.getSelectedColumn() == 0 || n2 != -1 && this._table.convertColumnIndexToView(n2) == this._table.getSelectedColumn()) && (row = ((TreeTable)this._table).getRowAt(n = this._table.getSelectedRow())) instanceof Expandable && !((Expandable)((Object)row)).isExpanded() && ((Expandable)((Object)row)).hasChildren() && ((Expandable)((Object)row)).isExpandable()) {
                this._action.actionPerformed(actionEvent);
                return;
            }
            if (bl && jTable != null && jTable.getColumnCount() > 0) {
                try {
                    if (this._table.isEditing() && !this._table.getCellEditor().stopCellEditing()) {
                        return;
                    }
                    if (!TableUtils.stopCellEditingForAll(this._table)) {
                        return;
                    }
                }
                catch (EditingNotStoppedException editingNotStoppedException) {
                    return;
                }
                jTable.requestFocus();
                if (this._table instanceof JideTable && jTable instanceof JideTable) {
                    ((JideTable)jTable).inheritEditingFieldsFrom((JideTable)this._table);
                }
                if (this._newRow) {
                    jTable.changeSelection(jTable == this._nextTable ? TableUtils.nextRow(this._table, jTable) : 0, 0, false, false);
                } else {
                    n2 = this._table.getSelectedRow();
                    if (n2 < 0) {
                        n2 = this._table.getEditingRow();
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    jTable.changeSelection(n2, 0, false, false);
                }
                if (jTable instanceof JideTable) {
                    ((JideTable)jTable).clearEditingFields();
                }
            } else if (bl && jTable != null && jTable.getColumnCount() == 0) {
                Action action = jTable.getActionMap().get(this._actionName);
                if (action instanceof SelectNextColumnCellAction && ((SelectNextColumnCellAction)action).getNextTable() == null) {
                    this._action.actionPerformed(actionEvent);
                } else {
                    n = ((SelectNextColumnCellAction)action)._newRow;
                    ((SelectNextColumnCellAction)action)._newRow |= this._newRow;
                    try {
                        action.actionPerformed(actionEvent);
                    }
                    finally {
                        ((SelectNextColumnCellAction)action)._newRow = n;
                    }
                }
            } else {
                this._action.actionPerformed(actionEvent);
            }
        }

        boolean triggerToNextTable() {
            return this._table.getColumnCount() <= 0 || this._table.getSelectedColumn() == this._table.getColumnCount() - 1;
        }

        JTable getNextTable() {
            if (!this.triggerToNextTable()) {
                return null;
            }
            if (this._nextRowFirstTable != null && this._table.getSelectedRow() == this._table.getRowCount() - 1) {
                return this._nextRowFirstTable;
            }
            return this._nextTable;
        }
    }

    private static class SelectPreviousColumnCellActionForVerticalTables
    extends SelectPreviousColumnCellAction {
        private static final long serialVersionUID = 5506933004482175576L;

        SelectPreviousColumnCellActionForVerticalTables(Action action, String string, JTable jTable, JTable jTable2, boolean bl) {
            super(action, string, jTable, jTable2, null, bl);
        }

        @Override
        boolean triggerToPreviousTable() {
            return this._table.getSelectedColumn() == 0 && this._table.getSelectedRow() == 0 || this._table.getEditingColumn() == 0 && this._table.getEditingRow() == 0;
        }
    }

    private static class SelectNextColumnCellActionForVerticalTables
    extends SelectNextColumnCellAction {
        private static final long serialVersionUID = 692849464306906379L;

        SelectNextColumnCellActionForVerticalTables(Action action, String string, JTable jTable, JTable jTable2, boolean bl) {
            super(action, string, jTable, jTable2, null, bl);
        }

        @Override
        boolean triggerToNextTable() {
            return this._table.getSelectedColumn() == this._table.getColumnCount() - 1 && this._table.getSelectedRow() == this._table.getRowCount() - 1 || this._table.getEditingColumn() == this._table.getColumnCount() - 1 && this._table.getEditingRow() == this._table.getRowCount() - 1;
        }
    }

    public static class ColumnSelectionRow
    extends DefaultExpandableRow {
        int _selectedColumn;

        public ColumnSelectionRow(int n) {
            this._selectedColumn = n;
        }

        public boolean equals(Object object) {
            return object instanceof ColumnSelectionRow && ((ColumnSelectionRow)object).getSelectedColumn() == this._selectedColumn;
        }

        public int getSelectedColumn() {
            return this._selectedColumn;
        }

        @Override
        public Object getValueAt(int n) {
            return null;
        }
    }
}

