/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DefaultMultiTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.JideTableTransferHandler;
import com.jidesoft.grid.ListSelectionModelGroup;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.MultiTableModelUtils;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.SortableTreeTableModel;
import com.jidesoft.grid.TableAdapter;
import com.jidesoft.grid.TableCustomizer;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPanePrintable;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import sun.swing.PrintingStatus;

public class TableScrollPane
extends JideScrollPane
implements TableAdapter {
    protected MultiTableModel _originalTableModel;
    protected MultiTableModel _originalFooterTableModel;
    protected MultiTableModel _originalHeaderTableModel;
    protected JTable _mainTable;
    protected JTable _rowHeaderTable;
    protected JTable _rowFooterTable;
    protected JTable _columnFooterTable;
    protected JTable _rowHeaderColumnFooterTable;
    protected JTable _rowFooterColumnFooterTable;
    protected JTable _columnHeaderTable;
    protected JTable _rowHeaderColumnHeaderTable;
    protected JTable _rowFooterColumnHeaderTable;
    private boolean _sortable;
    private boolean _sync;
    private TableCustomizer _tableCustomizer;
    private boolean _allowMultiSelectionInDifferentTable = false;
    private ListSelectionModelGroup _mainGroup;
    private ListSelectionModelGroup _rowHeaderGroup;
    private ListSelectionModelGroup _rowFooterGroup;
    private boolean _selfCreatedSortableTableModel = false;
    private TableModelListener _listener;
    private Throwable printError;
    public static final String TABLE_KEY = "TableScrollPane.TableKey";
    public static final String TABLESCROLLPANE_KEY = "TableScrollPane.Parent";
    public static final String MAIN_TABLE = "TableScrollPane.MainTable";
    public static final String ROWHEADER_TABLE = "TableScrollPane.RowHeaderTable";
    public static final String ROWFOOTER_TABLE = "TableScrollPane.RowFooterTable";
    public static final String COLUMNFOOTER_TABLE = "TableScrollPane.ColumnFooterTable";
    public static final String ROWHEADER_COLUMNFOOTER_TABLE = "TableScrollPane.RowHeaderColumnFooterTable";
    public static final String ROWFOOTER_COLUMNFOOTER_TABLE = "TableScrollPane.RowFooterColumnFooterTable";
    public static final String COLUMNHEADER_TABLE = "TableScrollPane.ColumnHeaderTable";
    public static final String ROWHEADER_COLUMNHEADER_TABLE = "TableScrollPane.RowHeaderColumnHeaderTable";
    public static final String ROWFOOTER_COLUMNHEADER_TABLE = "TableScrollPane.RowFooterColumnHeaderTable";
    public static final String PROPERTY_TABLE_MODEL = "tableModel";
    public static final String AUTO_UPDATE_FOOTER_TABLE_COLUMNS = "TableScrollPane.AutoUpdateFooterTableColumns";
    private static final Logger LOGGER_EVENT;
    private boolean _batching = false;
    protected boolean _rowSelectionAllowed = true;
    protected boolean _columnSelectionAllowed = false;
    protected boolean _nonContiguousCellSelectionAllowed = false;
    boolean _avoidSelectionChange = false;

    public TableScrollPane() {
        this((MultiTableModel)new DefaultMultiTableModel(), null, false);
    }

    public TableScrollPane(MultiTableModel multiTableModel) {
        this(multiTableModel, null, false);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2) {
        this(multiTableModel, multiTableModel2, false);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, boolean bl) {
        this(multiTableModel, multiTableModel2, bl, true);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3) {
        this(multiTableModel, multiTableModel2, multiTableModel3, false, true);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, boolean bl) {
        this(multiTableModel, multiTableModel2, multiTableModel3, bl, true);
    }

    public TableScrollPane(MultiTableModel multiTableModel, boolean bl) {
        this(multiTableModel, null, bl, true);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, boolean bl, boolean bl2) {
        this(multiTableModel, null, multiTableModel2, bl, 0, bl2);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, boolean bl, boolean bl2) {
        this(multiTableModel, multiTableModel2, multiTableModel3, bl, 0, bl2);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, boolean bl, int n, boolean bl2) {
        this(multiTableModel, null, multiTableModel2, bl, n, bl2);
    }

    public TableScrollPane(MultiTableModel multiTableModel, MultiTableModel multiTableModel2, MultiTableModel multiTableModel3, boolean bl, int n, boolean bl2) {
        this.setColumnHeadersHeightUnified(true);
        this.setColumnFootersHeightUnified(true);
        this.setSortable(bl);
        this._sync = bl2;
        if (multiTableModel == null) {
            throw new IllegalArgumentException("tableModel parameter can not be null.");
        }
        this.setTableModel(multiTableModel, n);
        this.setFooterTableModel(multiTableModel3, n);
        this.setHeaderTableModel(multiTableModel2, n);
        TableUtils.unifyTableCellEditing(this.getAllChildTables());
        this.synchronizeNavigationKey();
    }

    private void unsynchronizeNavigationKey() {
        JTable[] jTableArray = new JTable[]{this._rowHeaderColumnHeaderTable, this._columnHeaderTable, this._rowFooterColumnHeaderTable};
        JTable[] jTableArray2 = new JTable[]{this._rowHeaderTable, this._mainTable, this._rowFooterTable};
        JTable[] jTableArray3 = new JTable[]{this._rowHeaderColumnFooterTable, this._columnFooterTable, this._rowFooterColumnFooterTable};
        JTable[][] jTableArray4 = new JTable[][]{jTableArray, jTableArray2, jTableArray3};
        TableUtils.unsynchronizeNavigationKeys(jTableArray4);
    }

    private void synchronizeNavigationKey() {
        JTable[] jTableArray = new JTable[]{this._rowHeaderColumnHeaderTable, this._columnHeaderTable, this._rowFooterColumnHeaderTable};
        JTable[] jTableArray2 = new JTable[]{this._rowHeaderTable, this._mainTable, this._rowFooterTable};
        JTable[] jTableArray3 = new JTable[]{this._rowHeaderColumnFooterTable, this._columnFooterTable, this._rowFooterColumnFooterTable};
        JTable[][] jTableArray4 = new JTable[][]{jTableArray, jTableArray2, jTableArray3};
        TableUtils.synchronizeNavigationKeys(jTableArray4);
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (tableModel instanceof MultiTableModel) {
            this.setTableModel((MultiTableModel)tableModel);
        }
    }

    public void setTableModel(MultiTableModel multiTableModel) {
        this.unsynchronizeNavigationKey();
        this.setTableModel(multiTableModel, 0);
        this.synchronizeNavigationKey();
    }

    private void setTableModel(MultiTableModel multiTableModel, int n) {
        MultiTableModel multiTableModel2 = this._originalTableModel;
        if (this._originalTableModel != multiTableModel) {
            TableModel tableModel;
            if (this._selfCreatedSortableTableModel && (tableModel = SortableTableModel.getSortableModel(this.getMainTable().getModel())) instanceof TableModelWrapperImpl && !TableModelWrapperUtils.isActualTableModel(tableModel, multiTableModel) && !TableModelWrapperUtils.isActualTableModel(multiTableModel, tableModel)) {
                ((TableModelWrapperImpl)tableModel).setActualModel(null, false);
            }
            if (this._originalTableModel != null && this._listener != null) {
                this._originalTableModel.removeTableModelListener(this._listener);
            }
            this._originalTableModel = multiTableModel;
            if (this._listener == null) {
                this._listener = new TableModelListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        if (tableModelEvent.getColumn() == -1 && tableModelEvent.getFirstRow() == -1) {
                            try {
                                TableScrollPane.this.setBatching(true);
                                TableScrollPane.this.refreshColumns();
                                TableScrollPane.this.setBatching(false);
                            }
                            catch (Throwable throwable) {
                                TableScrollPane.this.setBatching(false);
                                for (JTable jTable : TableScrollPane.this.getAllChildTablesList()) {
                                    jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                                    TableScrollPane.this.resizeTableToFit(jTable, jTable != TableScrollPane.this.getMainTable() && jTable != TableScrollPane.this.getColumnFooterTable() && jTable != TableScrollPane.this.getColumnHeaderTable());
                                }
                                throw throwable;
                            }
                            for (JTable jTable : TableScrollPane.this.getAllChildTablesList()) {
                                jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                                TableScrollPane.this.resizeTableToFit(jTable, jTable != TableScrollPane.this.getMainTable() && jTable != TableScrollPane.this.getColumnFooterTable() && jTable != TableScrollPane.this.getColumnHeaderTable());
                            }
                        }
                    }
                };
            }
            if (multiTableModel != null) {
                multiTableModel.addTableModelListener(this._listener);
                tableModel = this.createSortableTableModel(multiTableModel, this.isSortable());
                if (TableModelWrapperUtils.isActualTableModel(multiTableModel, tableModel)) {
                    tableModel = multiTableModel;
                }
                this.createTables(tableModel, this.isSortable(), n, this._sync);
                this.firePropertyChange(PROPERTY_TABLE_MODEL, multiTableModel2, multiTableModel);
                this.resynchronizeTablesSelection();
            }
        }
    }

    boolean isBatching() {
        return this._batching;
    }

    void setBatching(boolean bl) {
        this._batching = bl;
    }

    protected TableModel createSortableTableModel(MultiTableModel multiTableModel, boolean bl) {
        TableModel tableModel;
        this._selfCreatedSortableTableModel = false;
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(multiTableModel, IExpandableTreeTableModel.class);
        if (tableModel2 instanceof IExpandableTreeTableModel && bl) {
            SortableTreeTableModel sortableTreeTableModel = TableModelWrapperUtils.getActualTableModel(multiTableModel, SortableTreeTableModel.class);
            if (sortableTreeTableModel instanceof SortableTreeTableModel) {
                tableModel = sortableTreeTableModel;
            } else {
                tableModel = new SortableTreeTableModel(multiTableModel);
                this._selfCreatedSortableTableModel = true;
            }
        } else {
            TableModel tableModel3 = TableModelWrapperUtils.getActualTableModel(multiTableModel, SortableTableModel.class);
            if (!(tableModel3 instanceof ISortableTableModel) && bl) {
                tableModel = new SortableTableModel(multiTableModel);
                this._selfCreatedSortableTableModel = true;
            } else {
                tableModel = tableModel3 != null ? tableModel3 : multiTableModel;
            }
        }
        return tableModel;
    }

    public MultiTableModel getTableModel() {
        return this.getModel();
    }

    @Override
    public MultiTableModel getModel() {
        return this._originalTableModel;
    }

    public void setFooterTableModel(MultiTableModel multiTableModel) {
        this.unsynchronizeNavigationKey();
        this.setFooterTableModel(multiTableModel, 0);
        this.synchronizeNavigationKey();
    }

    private void setFooterTableModel(MultiTableModel multiTableModel, int n) {
        if (multiTableModel != null) {
            this._originalFooterTableModel = multiTableModel;
            this.createFooterTables(multiTableModel, n, this._sync);
            this.resynchronizeTablesSelection();
        }
    }

    public void setHeaderTableModel(MultiTableModel multiTableModel) {
        this.unsynchronizeNavigationKey();
        this.setHeaderTableModel(multiTableModel, 0);
        this.synchronizeNavigationKey();
    }

    private void setHeaderTableModel(MultiTableModel multiTableModel, int n) {
        if (multiTableModel != null) {
            this._originalHeaderTableModel = multiTableModel;
            this.createHeaderTables(multiTableModel, n, this._sync);
            this.resynchronizeTablesSelection();
        }
    }

    public MultiTableModel getFooterTableModel() {
        return this._originalFooterTableModel;
    }

    public boolean isSortable() {
        return this._sortable;
    }

    public void setSortable(boolean bl) {
        boolean bl2 = this._sortable;
        if (bl2 != bl) {
            this._sortable = bl;
            if (this.getTableModel() != null) {
                this.setTableModel(this.getTableModel());
            }
        }
    }

    private void createTables(TableModel tableModel, boolean bl, int n, boolean bl2) {
        if (!(tableModel instanceof MultiTableModel)) {
            throw new IllegalArgumentException("The table model is not an instance of MultiTableModel.");
        }
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        this._mainTable = this.internalCreateTable(tableModel, 0, n, false, bl);
        this._mainTable.setFocusable(this._mainTable.getColumnCount() != 0);
        this.setViewportView(this._mainTable);
        this._rowHeaderTable = this.internalCreateTable(tableModel, 1, n, false, bl);
        this._rowHeaderTable.setFocusable(this._rowHeaderTable.getColumnCount() != 0);
        this.adjustPreferredScrollableViewportSize(this._rowHeaderTable, true);
        this.setRowHeaderView(this._rowHeaderTable);
        this.setCorner("UPPER_LEFT_CORNER", this._rowHeaderTable.getTableHeader());
        this._rowHeaderTable.addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TableScrollPane.this.setCorner("UPPER_LEFT_CORNER", TableScrollPane.this._rowHeaderTable.getTableHeader());
            }
        });
        arrayList.add(this._rowHeaderTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 1, n) == 0) {
            JideSwingUtilities.unsynchronizeView(this.getRowHeader(), this.getViewport());
            JideSwingUtilities.unsynchronizeView(this.getViewport(), this.getRowHeader());
        } else {
            JideSwingUtilities.synchronizeView(this.getRowHeader(), this.getViewport(), 1);
            JideSwingUtilities.synchronizeView(this.getViewport(), this.getRowHeader(), 1);
        }
        arrayList.add(this._mainTable);
        this._rowFooterTable = this.internalCreateTable(tableModel, 2, n, false, bl);
        this._rowFooterTable.setFocusable(this._rowFooterTable.getColumnCount() != 0);
        this.adjustPreferredScrollableViewportSize(this._rowFooterTable, true);
        this.setRowFooterView(this._rowFooterTable);
        this.setCorner("UPPER_RIGHT_CORNER", this._rowFooterTable.getTableHeader());
        this._rowFooterTable.addPropertyChangeListener("tableHeader", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TableScrollPane.this.setCorner("UPPER_RIGHT_CORNER", TableScrollPane.this._rowFooterTable.getTableHeader());
            }
        });
        if (MultiTableModelUtils.getColumnCount(tableModel, 2, n) == 0) {
            JideSwingUtilities.unsynchronizeView(this.getRowFooter(), this.getViewport());
            JideSwingUtilities.unsynchronizeView(this.getViewport(), this.getRowFooter());
        } else {
            JideSwingUtilities.synchronizeView(this.getRowFooter(), this.getViewport(), 1);
            JideSwingUtilities.synchronizeView(this.getViewport(), this.getRowFooter(), 1);
        }
        arrayList.add(this._rowFooterTable);
        if (bl2 && arrayList.size() > 1) {
            TableUtils.synchronizeTables(arrayList.toArray(new JTable[arrayList.size()]), this.getRowSelectionAllowed(), this.getColumnSelectionAllowed(), this.isNonContiguousCellSelectionAllowed());
        }
        for (JTable jTable : arrayList) {
            this.customizeTable(jTable);
        }
    }

    private void createFooterTables(TableModel tableModel, int n, boolean bl) {
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (MultiTableModelUtils.getColumnCount(tableModel, 0, n) != this._mainTable.getColumnCount() && LOGGER_EVENT.isLoggable(Level.FINE)) {
            LOGGER_EVENT.fine("TableScrollPane \" tableModel and footerTableModel must have the same column count.");
        }
        this._columnFooterTable = this.internalCreateTable(tableModel, 0, n, true, false);
        this.adjustPreferredScrollableViewportSize(this._columnFooterTable, false);
        this.setColumnFooterView(this._columnFooterTable);
        TableUtils.synchronizeTableColumn(this._mainTable, this._columnFooterTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 1, n) != 0) {
            this._rowHeaderColumnFooterTable = this.internalCreateTable(tableModel, 1, n, true, false);
            if (this._rowHeaderTable.getColumnCount() != this._rowHeaderColumnFooterTable.getColumnCount()) {
                throw new IllegalArgumentException("tableModel and footerTableModel must have the same column count.");
            }
            this.adjustPreferredScrollableViewportSize(this._rowHeaderColumnFooterTable, false);
            this.setCorner("LOWER_LEFT_CORNER", this._rowHeaderColumnFooterTable);
            arrayList.add(this._rowHeaderColumnFooterTable);
            TableUtils.synchronizeTableColumn(this._rowHeaderTable, this._rowHeaderColumnFooterTable);
        }
        arrayList.add(this._columnFooterTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 2, n) != 0) {
            this._rowFooterColumnFooterTable = this.internalCreateTable(tableModel, 2, n, true, false);
            if (this._rowFooterColumnFooterTable.getColumnCount() != this._rowFooterTable.getColumnCount()) {
                throw new IllegalArgumentException("tableModel and footerTableModel must have the same column count.");
            }
            this.adjustPreferredScrollableViewportSize(this._rowFooterColumnFooterTable, true);
            this.setCorner("LOWER_RIGHT_CORNER", this._rowFooterColumnFooterTable);
            arrayList.add(this._rowFooterColumnFooterTable);
            TableUtils.synchronizeTableColumn(this._rowFooterTable, this._rowFooterColumnFooterTable);
        }
        if (!this.isAllowMultiSelectionInDifferentTable()) {
            this.installTableSelectionGroup();
        }
        if (bl && arrayList.size() > 1) {
            TableUtils.synchronizeTables(arrayList.toArray(new JTable[arrayList.size()]));
        }
        for (JTable jTable : arrayList) {
            this.customizeTable(jTable);
        }
    }

    private void createHeaderTables(TableModel tableModel, int n, boolean bl) {
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (MultiTableModelUtils.getColumnCount(tableModel, 0, n) != this._mainTable.getColumnCount() && LOGGER_EVENT.isLoggable(Level.FINE)) {
            LOGGER_EVENT.fine("TableScrollPane \" tableModel and headerTableModel must have the same column count.");
        }
        this._columnHeaderTable = this.internalCreateTable(tableModel, 0, n, true, false);
        this.adjustPreferredScrollableViewportSize(this._columnHeaderTable, false);
        this.setSubColumnHeaderView(this._columnHeaderTable);
        TableUtils.synchronizeTableColumn(this._mainTable, this._columnHeaderTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 1, n) != 0) {
            this._rowHeaderColumnHeaderTable = this.internalCreateTable(tableModel, 1, n, true, false);
            if (this._rowHeaderTable.getColumnCount() != this._rowHeaderColumnHeaderTable.getColumnCount()) {
                throw new IllegalArgumentException("tableModel and headerTableModel must have the same column count.");
            }
            this.adjustPreferredScrollableViewportSize(this._rowHeaderColumnHeaderTable, false);
            this.setCorner("SUB_UPPER_LEFT", this._rowHeaderColumnHeaderTable);
            arrayList.add(this._rowHeaderColumnHeaderTable);
            TableUtils.synchronizeTableColumn(this._rowHeaderTable, this._rowHeaderColumnHeaderTable);
        }
        arrayList.add(this._columnHeaderTable);
        if (MultiTableModelUtils.getColumnCount(tableModel, 2, n) != 0) {
            this._rowFooterColumnHeaderTable = this.internalCreateTable(tableModel, 2, n, true, false);
            if (this._rowFooterColumnHeaderTable.getColumnCount() != this._rowFooterTable.getColumnCount()) {
                throw new IllegalArgumentException("tableModel and headerTableModel must have the same column count.");
            }
            this.adjustPreferredScrollableViewportSize(this._rowFooterColumnHeaderTable, true);
            this.setCorner("SUB_UPPER_RIGHT", this._rowFooterColumnHeaderTable);
            arrayList.add(this._rowFooterColumnHeaderTable);
            TableUtils.synchronizeTableColumn(this._rowFooterTable, this._rowFooterColumnHeaderTable);
        }
        if (!this.isAllowMultiSelectionInDifferentTable()) {
            this.installTableSelectionGroup();
        }
        if (bl && arrayList.size() > 1) {
            TableUtils.synchronizeTables(arrayList.toArray(new JTable[arrayList.size()]));
        }
        for (JTable jTable : arrayList) {
            this.customizeTable(jTable);
        }
    }

    protected void customizeTable(JTable jTable) {
    }

    public JTable getMainTable() {
        return this._mainTable;
    }

    public JTable getRowHeaderTable() {
        return this._rowHeaderTable;
    }

    public JTable getRowFooterTable() {
        return this._rowFooterTable;
    }

    public JTable getColumnFooterTable() {
        return this._columnFooterTable;
    }

    public JTable getRowHeaderColumnFooterTable() {
        return this._rowHeaderColumnFooterTable;
    }

    public JTable getRowFooterColumnFooterTable() {
        return this._rowFooterColumnFooterTable;
    }

    public JTable getColumnHeaderTable() {
        return this._columnHeaderTable;
    }

    public JTable getRowHeaderColumnHeaderTable() {
        return this._rowHeaderColumnHeaderTable;
    }

    public JTable getRowFooterColumnHeaderTable() {
        return this._rowFooterColumnHeaderTable;
    }

    @Deprecated
    protected JTable createTable(TableModel tableModel, boolean bl, int n, int n2) {
        return this.createTable(tableModel, bl, n, false, n2);
    }

    protected JTable createTable(TableModel tableModel, boolean bl, int n, boolean bl2, int n2) {
        JTable jTable = this.createTable(tableModel, bl, n);
        String string = null;
        switch (n) {
            case 0: {
                string = bl2 ? (tableModel == this._originalFooterTableModel ? COLUMNFOOTER_TABLE : COLUMNHEADER_TABLE) : MAIN_TABLE;
                break;
            }
            case 1: {
                string = bl2 ? (tableModel == this._originalFooterTableModel ? ROWHEADER_COLUMNFOOTER_TABLE : ROWHEADER_COLUMNHEADER_TABLE) : ROWHEADER_TABLE;
                break;
            }
            case 2: {
                string = bl2 ? (tableModel == this._originalFooterTableModel ? ROWFOOTER_COLUMNFOOTER_TABLE : ROWFOOTER_COLUMNHEADER_TABLE) : ROWFOOTER_TABLE;
            }
        }
        jTable.putClientProperty(TABLE_KEY, string);
        jTable.putClientProperty("TableSplitPane.index", n2);
        jTable.putClientProperty(TABLESCROLLPANE_KEY, this);
        jTable.setAutoResizeMode(256);
        if (jTable instanceof SortableTable) {
            ((SortableTable)jTable).setSortable(bl);
        }
        return jTable;
    }

    protected JTable createTable(TableModel tableModel, boolean bl, int n) {
        return this.createTable(tableModel, bl);
    }

    protected JTable createTable(TableModel tableModel, boolean bl) {
        return new SortableTable(tableModel);
    }

    public boolean isEditing() {
        if (this.getMainTable() != null && this.getMainTable().isEditing()) {
            return true;
        }
        if (this.getRowHeaderTable() != null && this.getRowHeaderTable().isEditing()) {
            return true;
        }
        if (this.getRowFooterTable() != null && this.getRowFooterTable().isEditing()) {
            return true;
        }
        if (this.getColumnFooterTable() != null && this.getColumnFooterTable().isEditing()) {
            return true;
        }
        if (this.getRowHeaderColumnFooterTable() != null && this.getRowHeaderColumnFooterTable().isEditing()) {
            return true;
        }
        if (this.getRowFooterColumnFooterTable() != null && this.getRowFooterColumnFooterTable().isEditing()) {
            return true;
        }
        if (this.getColumnHeaderTable() != null && this.getColumnHeaderTable().isEditing()) {
            return true;
        }
        if (this.getRowHeaderColumnHeaderTable() != null && this.getRowHeaderColumnHeaderTable().isEditing()) {
            return true;
        }
        return this.getRowFooterColumnHeaderTable() != null && this.getRowFooterColumnHeaderTable().isEditing();
    }

    public JTable getEditingTable() {
        if (this.getMainTable() != null && this.getMainTable().isEditing()) {
            return this.getMainTable();
        }
        if (this.getRowHeaderTable() != null && this.getRowHeaderTable().isEditing()) {
            return this.getRowHeaderTable();
        }
        if (this.getRowFooterTable() != null && this.getRowFooterTable().isEditing()) {
            return this.getRowFooterTable();
        }
        if (this.getColumnFooterTable() != null && this.getColumnFooterTable().isEditing()) {
            return this.getColumnFooterTable();
        }
        if (this.getRowHeaderColumnFooterTable() != null && this.getRowHeaderColumnFooterTable().isEditing()) {
            return this.getRowHeaderColumnFooterTable();
        }
        if (this.getRowFooterColumnFooterTable() != null && this.getRowFooterColumnFooterTable().isEditing()) {
            return this.getRowFooterColumnFooterTable();
        }
        return null;
    }

    public JTable[] getAllChildTables() {
        List<JTable> list = this.getAllChildTablesList();
        if (list.size() > 0) {
            return list.toArray(new JTable[list.size()]);
        }
        return new JTable[0];
    }

    JTable[] getOtherTablesInSameColumn(JTable jTable) {
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (jTable == this.getMainTable()) {
            if (this.getColumnFooterTable() != null) {
                arrayList.add(this.getColumnFooterTable());
            }
            if (this.getColumnHeaderTable() != null) {
                arrayList.add(this.getColumnHeaderTable());
            }
        } else if (jTable == this.getColumnHeaderTable()) {
            if (this.getMainTable() != null) {
                arrayList.add(this.getMainTable());
            }
            if (this.getColumnFooterTable() != null) {
                arrayList.add(this.getColumnFooterTable());
            }
        } else if (jTable == this.getColumnFooterTable()) {
            if (this.getMainTable() != null) {
                arrayList.add(this.getMainTable());
            }
            if (this.getColumnHeaderTable() != null) {
                arrayList.add(this.getColumnHeaderTable());
            }
        } else if (jTable == this.getRowHeaderTable()) {
            if (this.getRowHeaderColumnFooterTable() != null) {
                arrayList.add(this.getRowHeaderColumnFooterTable());
            }
            if (this.getRowHeaderColumnHeaderTable() != null) {
                arrayList.add(this.getRowHeaderColumnHeaderTable());
            }
        } else if (jTable == this.getRowHeaderColumnHeaderTable()) {
            if (this.getRowHeaderTable() != null) {
                arrayList.add(this.getRowHeaderTable());
            }
            if (this.getRowHeaderColumnFooterTable() != null) {
                arrayList.add(this.getRowHeaderColumnFooterTable());
            }
        } else if (jTable == this.getRowHeaderColumnFooterTable()) {
            if (this.getRowHeaderTable() != null) {
                arrayList.add(this.getRowHeaderTable());
            }
            if (this.getRowHeaderColumnHeaderTable() != null) {
                arrayList.add(this.getRowHeaderColumnHeaderTable());
            }
        } else if (jTable == this.getRowFooterTable()) {
            if (this.getRowFooterColumnFooterTable() != null) {
                arrayList.add(this.getRowFooterColumnFooterTable());
            }
            if (this.getRowFooterColumnHeaderTable() != null) {
                arrayList.add(this.getRowFooterColumnHeaderTable());
            }
        } else if (jTable == this.getRowFooterColumnHeaderTable()) {
            if (this.getRowFooterTable() != null) {
                arrayList.add(this.getRowFooterTable());
            }
            if (this.getRowFooterColumnFooterTable() != null) {
                arrayList.add(this.getRowFooterColumnFooterTable());
            }
        } else if (jTable == this.getRowFooterColumnFooterTable()) {
            if (this.getRowFooterTable() != null) {
                arrayList.add(this.getRowFooterTable());
            }
            if (this.getRowFooterColumnHeaderTable() != null) {
                arrayList.add(this.getRowFooterColumnHeaderTable());
            }
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new JTable[arrayList.size()]);
        }
        return new JTable[0];
    }

    List<JTable> getAllChildTablesList() {
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (this.getMainTable() != null) {
            arrayList.add(this.getMainTable());
        }
        if (this.getRowHeaderTable() != null) {
            arrayList.add(this.getRowHeaderTable());
        }
        if (this.getRowFooterTable() != null) {
            arrayList.add(this.getRowFooterTable());
        }
        if (this.getColumnFooterTable() != null) {
            arrayList.add(this.getColumnFooterTable());
        }
        if (this.getRowHeaderColumnFooterTable() != null) {
            arrayList.add(this.getRowHeaderColumnFooterTable());
        }
        if (this.getRowFooterColumnFooterTable() != null) {
            arrayList.add(this.getRowFooterColumnFooterTable());
        }
        if (this.getColumnHeaderTable() != null) {
            arrayList.add(this.getColumnHeaderTable());
        }
        if (this.getRowHeaderColumnHeaderTable() != null) {
            arrayList.add(this.getRowHeaderColumnHeaderTable());
        }
        if (this.getRowFooterColumnHeaderTable() != null) {
            arrayList.add(this.getRowFooterColumnHeaderTable());
        }
        return arrayList;
    }

    public TableCellEditor getCellEditor() {
        JTable jTable = this.getEditingTable();
        if (jTable != null) {
            return jTable.getCellEditor();
        }
        return null;
    }

    private JTable internalCreateTable(TableModel tableModel, int n, int n2, boolean bl, boolean bl2) {
        JTable jTable = this.createTable(tableModel, bl2, n, bl, n2);
        TransferHandler transferHandler = jTable.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource || transferHandler instanceof JideTableTransferHandler) {
            jTable.setTransferHandler(new TableUtils.MultipleTableTransferHandler());
        }
        this.removeExtraColumns(jTable, n, n2);
        TableCustomizer tableCustomizer = this.getTableCustomizer();
        if (tableCustomizer != null) {
            tableCustomizer.customize(jTable);
        }
        return jTable;
    }

    protected void removeExtraColumns(final JTable jTable, final int n, final int n2) {
        jTable.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MultiTableModelUtils.removeExtraColumns(jTable, n, n2);
            }
        });
        final TableColumnModelListener tableColumnModelListener = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                MultiTableModelUtils.removeExtraColumns(jTable, n, n2, tableColumnModelEvent.getToIndex());
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        };
        jTable.getColumnModel().addColumnModelListener(tableColumnModelListener);
        jTable.addPropertyChangeListener("columnModel", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((TableColumnModel)propertyChangeEvent.getOldValue()).removeColumnModelListener(tableColumnModelListener);
                ((TableColumnModel)propertyChangeEvent.getNewValue()).addColumnModelListener(tableColumnModelListener);
            }
        });
        MultiTableModelUtils.removeExtraColumns(jTable, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshColumns() {
        Object object;
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (this.getRowHeaderTable() != null) {
            arrayList.add(this.getRowHeaderTable());
            this.getRowHeaderTable().setFocusable(this.getRowHeaderTable().getColumnCount() != 0);
        }
        if (this.getMainTable() != null) {
            arrayList.add(this.getMainTable());
            this.getMainTable().setFocusable(this.getMainTable().getColumnCount() != 0);
        }
        if (this.getRowFooterTable() != null) {
            arrayList.add(this.getRowFooterTable());
            this.getRowFooterTable().setFocusable(this.getRowFooterTable().getColumnCount() != 0);
        }
        try {
            int n = 0;
            Object object22 = this.getClientProperty("TableSplitPane.index");
            if (object22 instanceof Integer) {
                n = (Integer)object22;
            }
            MultiTableModelUtils.refreshColumns(arrayList.toArray(new JTable[arrayList.size()]), n);
        }
        finally {
            for (JTable jTable : arrayList) {
                this.resizeTableToFit(jTable, true);
            }
        }
        arrayList.clear();
        if (this.getRowHeaderColumnFooterTable() != null) {
            arrayList.add(this.getRowHeaderColumnFooterTable());
            this.getRowHeaderColumnFooterTable().setFocusable(this.getRowHeaderColumnFooterTable().getColumnCount() != 0);
        }
        if (this.getColumnFooterTable() != null) {
            arrayList.add(this.getColumnFooterTable());
            this.getColumnFooterTable().setFocusable(this.getColumnFooterTable().getColumnCount() != 0);
        }
        if (this.getRowFooterColumnFooterTable() != null) {
            arrayList.add(this.getRowFooterColumnFooterTable());
            this.getRowFooterColumnFooterTable().setFocusable(this.getRowFooterColumnFooterTable().getColumnCount() != 0);
        }
        try {
            int n = 0;
            Object object2 = this.getClientProperty("TableSplitPane.index");
            if (object2 instanceof Integer) {
                n = (Integer)object2;
            }
            MultiTableModelUtils.refreshColumns(arrayList.toArray(new JTable[arrayList.size()]), n);
        }
        finally {
            for (JTable jTable : arrayList) {
                this.resizeTableToFit(jTable, false);
            }
        }
        if (this.getMainTable() != null && this.getColumnFooterTable() != null) {
            object = this.getMainTable();
            JTable jTable = this.getColumnFooterTable();
            TableUtils.synchronizeTableAndColumnsWidth((JTable)object, jTable);
        }
        if (this.getRowHeaderTable() != null && this.getRowHeaderColumnFooterTable() != null) {
            object = this.getRowHeaderTable();
            JTable jTable = this.getRowHeaderColumnFooterTable();
            TableUtils.synchronizeTableAndColumnsWidth((JTable)object, jTable);
        }
        if (this.getRowFooterTable() != null && this.getRowFooterColumnFooterTable() != null) {
            object = this.getRowFooterTable();
            JTable jTable = this.getRowFooterColumnFooterTable();
            TableUtils.synchronizeTableAndColumnsWidth((JTable)object, jTable);
        }
    }

    private void adjustPreferredScrollableViewportSize(final JTable jTable, final boolean bl) {
        jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
        jTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                TableScrollPane.this.resizeTableToFit(jTable, bl);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                if (!TableScrollPane.this.isBatching()) {
                    jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                    TableScrollPane.this.resizeTableToFit(jTable, bl);
                }
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                if (!TableScrollPane.this.isBatching()) {
                    jTable.setPreferredScrollableViewportSize(jTable.getPreferredSize());
                    TableScrollPane.this.resizeTableToFit(jTable, bl);
                }
            }
        });
    }

    void resizeTableToFit(JTable jTable, boolean bl) {
        Dimension dimension = jTable.getPreferredScrollableViewportSize();
        Dimension dimension2 = jTable.getPreferredSize();
        if (!JideSwingUtilities.equals(dimension2, dimension)) {
            jTable.setPreferredScrollableViewportSize(dimension2);
        }
        Container container = jTable.getParent();
        if (bl && container instanceof JViewport) {
            container.setPreferredSize(dimension2);
            container.invalidate();
        }
    }

    public void resizeRowHeaderTableToFit() {
        JTable jTable = this.getRowHeaderTable();
        if (jTable != null) {
            Dimension dimension = jTable.getPreferredSize();
            jTable.setPreferredScrollableViewportSize(dimension);
            if (jTable.getParent() instanceof JViewport) {
                Container container = jTable.getParent();
                if (container instanceof JComponent) {
                    container.setPreferredSize(dimension);
                }
                container.invalidate();
            }
        }
    }

    public TableCustomizer getTableCustomizer() {
        return this._tableCustomizer;
    }

    public void setTableCustomizer(TableCustomizer tableCustomizer) {
        this._tableCustomizer = tableCustomizer;
    }

    @Override
    public void setRowSelectionAllowed(boolean bl) {
        boolean bl2 = this._rowSelectionAllowed;
        this._rowSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("rowSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    @Override
    public boolean getRowSelectionAllowed() {
        return this._rowSelectionAllowed || this.isNonContiguousCellSelectionAllowed();
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
        boolean bl2 = this._columnSelectionAllowed;
        this._columnSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("columnSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this._columnSelectionAllowed || this.isNonContiguousCellSelectionAllowed();
    }

    @Override
    public void setCellSelectionEnabled(boolean bl) {
        boolean bl2 = this.getCellSelectionEnabled();
        this.setRowSelectionAllowed(bl);
        this.setColumnSelectionAllowed(bl);
        this.firePropertyChange("cellSelectionEnabled", bl2, bl);
        this.resynchronizeTablesSelection();
    }

    @Override
    public boolean getCellSelectionEnabled() {
        return this.getRowSelectionAllowed() && this.getColumnSelectionAllowed();
    }

    public void setNonContiguousCellSelectionAllowed(boolean bl) {
        boolean bl2 = this._nonContiguousCellSelectionAllowed;
        this._nonContiguousCellSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("nonContiguousCellSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    public boolean isNonContiguousCellSelectionAllowed() {
        return this._nonContiguousCellSelectionAllowed;
    }

    protected void resynchronizeTablesSelection() {
        JTable[] jTableArray = this.getAllChildTables();
        ArrayList<JTable> arrayList = new ArrayList<JTable>();
        if (this.getRowHeaderTable() != null) {
            arrayList.add(this.getRowHeaderTable());
        }
        if (this.getMainTable() != null) {
            arrayList.add(this.getMainTable());
        }
        if (this.getRowFooterTable() != null) {
            arrayList.add(this.getRowFooterTable());
        }
        JTable[] jTableArray2 = arrayList.toArray(new JTable[arrayList.size()]);
        for (JTable jTable : jTableArray) {
            if (jTable instanceof JideTable) {
                ((JideTable)jTable).setNonContiguousCellSelection(this.isNonContiguousCellSelectionAllowed());
            }
            jTable.setColumnSelectionAllowed(this.getColumnSelectionAllowed());
            jTable.setRowSelectionAllowed(this.getRowSelectionAllowed());
        }
        if (this.isNonContiguousCellSelectionAllowed()) {
            TableUtils.unifyTableNonContiguousCellSelection(jTableArray);
            TableUtils.ununifyTableColumnSelection(jTableArray2);
            TableUtils.unsynchronizeTableRowSelection(jTableArray2);
        } else {
            TableUtils.ununifyTableNonContiguousCellSelection(jTableArray);
            TableUtils.unifyTableColumnSelection(jTableArray2);
            if (this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
                TableUtils.synchronizeTableRowSelection(jTableArray2);
                TableUtils.ununifyTableRowSelection(jTableArray);
            } else if (!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
                TableUtils.unsynchronizeTableRowSelection(jTableArray2);
                TableUtils.unifyTableRowSelection(jTableArray);
            } else {
                TableUtils.unsynchronizeTableRowSelection(jTableArray2);
            }
        }
    }

    @Override
    public int getRowCount() {
        int n = 0;
        if (this.getColumnHeaderTable() != null) {
            n += this.getColumnHeaderTable().getRowCount();
        }
        if (this.getMainTable() != null) {
            n += this.getMainTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null) {
            n += this.getColumnFooterTable().getRowCount();
        }
        return n;
    }

    int getRowHeight(int n) {
        if (this.getColumnHeaderTable() != null) {
            if (n < this.getColumnHeaderTable().getRowCount()) {
                return this.getColumnHeaderTable().getRowHeight(n);
            }
            n -= this.getColumnHeaderTable().getRowCount();
        }
        if (this.getMainTable() != null) {
            if (n < this.getMainTable().getRowCount()) {
                return this.getMainTable().getRowHeight(n);
            }
            n -= this.getMainTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null) {
            if (n < this.getColumnFooterTable().getRowCount()) {
                return this.getColumnFooterTable().getRowHeight(n);
            }
            n -= this.getColumnFooterTable().getRowCount();
        }
        return this.getMainTable().getRowHeight();
    }

    int getColumnWidth(int n) {
        if (this.getRowHeaderTable() != null) {
            if (n < this.getRowHeaderTable().getColumnCount()) {
                return this.getRowHeaderTable().getColumnModel().getColumn(n).getWidth();
            }
            n -= this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            if (n < this.getMainTable().getColumnCount()) {
                return this.getMainTable().getColumnModel().getColumn(n).getWidth();
            }
            n -= this.getMainTable().getColumnCount();
        }
        if (this.getColumnFooterTable() != null) {
            if (n < this.getColumnFooterTable().getColumnCount()) {
                return this.getColumnFooterTable().getColumnModel().getColumn(n).getWidth();
            }
            n -= this.getColumnFooterTable().getColumnCount();
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        int n = 0;
        if (this.getRowHeaderTable() != null) {
            n += this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            n += this.getMainTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null) {
            n += this.getRowFooterTable().getColumnCount();
        }
        return n;
    }

    public boolean isAllowMultiSelectionInDifferentTable() {
        return this._allowMultiSelectionInDifferentTable;
    }

    public void setAllowMultiSelectionInDifferentTable(boolean bl) {
        if (this._allowMultiSelectionInDifferentTable != bl) {
            this._allowMultiSelectionInDifferentTable = bl;
            if (this.isAllowMultiSelectionInDifferentTable()) {
                this.uninstallTableSelectionGroup();
            } else {
                this.installTableSelectionGroup();
            }
        }
    }

    private void uninstallTableSelectionGroup() {
        if (this._mainGroup != null) {
            if (this._mainTable != null) {
                this._mainGroup.remove(this._mainTable.getSelectionModel());
            }
            if (this._columnHeaderTable != null) {
                this._mainGroup.remove(this._columnHeaderTable.getSelectionModel());
            }
            if (this._columnFooterTable != null) {
                this._mainGroup.remove(this._columnFooterTable.getSelectionModel());
            }
            this._mainGroup = null;
        }
        if (this._rowHeaderGroup != null) {
            if (this._rowHeaderTable != null) {
                this._rowHeaderGroup.remove(this._rowHeaderTable.getSelectionModel());
            }
            if (this._rowHeaderColumnFooterTable != null) {
                this._rowHeaderGroup.remove(this._rowHeaderColumnFooterTable.getSelectionModel());
            }
            if (this._rowHeaderColumnHeaderTable != null) {
                this._rowHeaderGroup.remove(this._rowHeaderColumnHeaderTable.getSelectionModel());
            }
            this._rowHeaderGroup = null;
        }
        if (this._rowFooterGroup != null) {
            if (this._rowFooterTable != null) {
                this._rowFooterGroup.remove(this._rowFooterTable.getSelectionModel());
            }
            if (this._rowFooterColumnFooterTable != null) {
                this._rowFooterGroup.remove(this._rowFooterColumnFooterTable.getSelectionModel());
            }
            if (this._rowFooterColumnHeaderTable != null) {
                this._rowFooterGroup.remove(this._rowFooterColumnHeaderTable.getSelectionModel());
            }
            this._rowFooterGroup = null;
        }
    }

    private void installTableSelectionGroup() {
        int n = 0;
        if (this._mainTable != null) {
            ++n;
        }
        if (this._columnFooterTable != null) {
            ++n;
        }
        if (this._columnHeaderTable != null) {
            ++n;
        }
        if (n >= 2 && this._mainGroup == null) {
            this._mainGroup = new ListSelectionModelGroup();
            if (this._mainTable != null) {
                this._mainGroup.add(this._mainTable.getSelectionModel());
            }
            if (this._columnFooterTable != null) {
                this._mainGroup.add(this._columnFooterTable.getSelectionModel());
            }
            if (this._columnHeaderTable != null) {
                this._mainGroup.add(this._columnHeaderTable.getSelectionModel());
            }
        }
        n = 0;
        if (this._rowHeaderTable != null) {
            ++n;
        }
        if (this._rowHeaderColumnFooterTable != null) {
            ++n;
        }
        if (this._rowHeaderColumnHeaderTable != null) {
            ++n;
        }
        if (n >= 2 && this._rowHeaderGroup == null) {
            this._rowHeaderGroup = new ListSelectionModelGroup();
            if (this._rowHeaderTable != null) {
                this._rowHeaderGroup.add(this._rowHeaderTable.getSelectionModel());
            }
            if (this._rowHeaderColumnFooterTable != null) {
                this._rowHeaderGroup.add(this._rowHeaderColumnFooterTable.getSelectionModel());
            }
            if (this._rowHeaderColumnHeaderTable != null) {
                this._rowHeaderGroup.add(this._rowHeaderColumnHeaderTable.getSelectionModel());
            }
        }
        n = 0;
        if (this._rowFooterTable != null) {
            ++n;
        }
        if (this._rowFooterColumnFooterTable != null) {
            ++n;
        }
        if (this._rowFooterColumnHeaderTable != null) {
            ++n;
        }
        if (n >= 2 && this._rowFooterGroup == null) {
            this._rowFooterGroup = new ListSelectionModelGroup();
            if (this._rowFooterTable != null) {
                this._rowFooterGroup.add(this._rowFooterTable.getSelectionModel());
            }
            if (this._rowFooterColumnFooterTable != null) {
                this._rowFooterGroup.add(this._rowFooterColumnFooterTable.getSelectionModel());
            }
            if (this._rowFooterColumnHeaderTable != null) {
                this._rowFooterGroup.add(this._rowFooterColumnHeaderTable.getSelectionModel());
            }
        }
    }

    public TablePosition getTableAtColumn(int n) {
        if (this.getRowHeaderTable() != null) {
            if (n < this.getRowHeaderTable().getColumnCount()) {
                return new TablePosition(this.getRowHeaderTable(), -1, n);
            }
            n -= this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            if (n < this.getMainTable().getColumnCount()) {
                return new TablePosition(this.getMainTable(), -1, n);
            }
            n -= this.getMainTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null && n < this.getRowFooterTable().getColumnCount()) {
            return new TablePosition(this.getRowFooterTable(), -1, n);
        }
        return null;
    }

    public TablePosition getTableAtRow(int n) {
        if (this.getColumnHeaderTable() != null) {
            if (n < this.getColumnHeaderTable().getRowCount()) {
                return new TablePosition(this.getColumnHeaderTable(), n, -1);
            }
            n -= this.getColumnHeaderTable().getRowCount();
        }
        if (this.getMainTable() != null) {
            if (n < this.getMainTable().getRowCount()) {
                return new TablePosition(this.getMainTable(), n, -1);
            }
            n -= this.getMainTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null && n < this.getColumnFooterTable().getRowCount()) {
            return new TablePosition(this.getColumnFooterTable(), n, -1);
        }
        return null;
    }

    public TablePosition getTableAtCell(int n, int n2) {
        TablePosition tablePosition = this.getTableAtColumn(n2);
        TablePosition tablePosition2 = this.getTableAtRow(n);
        if (tablePosition.table == tablePosition2.table) {
            return new TablePosition(tablePosition.table, tablePosition2.row, tablePosition.column);
        }
        if (tablePosition.table == this.getMainTable() && tablePosition2.table == this.getColumnFooterTable()) {
            return new TablePosition(this.getColumnFooterTable(), tablePosition2.row, tablePosition.column);
        }
        if (tablePosition.table == this.getMainTable() && tablePosition2.table == this.getColumnHeaderTable()) {
            return new TablePosition(this.getColumnHeaderTable(), tablePosition2.row, tablePosition.column);
        }
        if (tablePosition.table == this.getRowHeaderTable() && tablePosition2.table == this.getMainTable()) {
            return new TablePosition(this.getRowHeaderTable(), tablePosition2.row, tablePosition.column);
        }
        if (tablePosition.table == this.getRowHeaderTable() && tablePosition2.table == this.getColumnFooterTable() && this.getRowHeaderColumnFooterTable() != null) {
            return new TablePosition(this.getRowHeaderColumnFooterTable(), tablePosition2.row, tablePosition.column);
        }
        if (tablePosition.table == this.getRowHeaderTable() && tablePosition2.table == this.getColumnHeaderTable() && this.getRowHeaderColumnHeaderTable() != null) {
            return new TablePosition(this.getRowHeaderColumnHeaderTable(), tablePosition2.row, tablePosition.column);
        }
        if (tablePosition.table == this.getRowFooterTable() && tablePosition2.table == this.getMainTable()) {
            return new TablePosition(this.getRowFooterTable(), tablePosition2.row, tablePosition.column);
        }
        if (tablePosition.table == this.getRowFooterTable() && tablePosition2.table == this.getColumnFooterTable() && this.getRowFooterColumnFooterTable() != null) {
            return new TablePosition(this.getRowFooterColumnFooterTable(), tablePosition2.row, tablePosition.column);
        }
        if (tablePosition.table == this.getRowFooterTable() && tablePosition2.table == this.getColumnHeaderTable() && this.getRowFooterColumnHeaderTable() != null) {
            return new TablePosition(this.getRowFooterColumnHeaderTable(), tablePosition2.row, tablePosition.column);
        }
        return null;
    }

    @Override
    public String getColumnName(int n) {
        TablePosition tablePosition = this.getTableAtColumn(n);
        return tablePosition != null ? tablePosition.table.getColumnName(tablePosition.column) : "";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        TablePosition tablePosition = this.getTableAtColumn(n);
        return tablePosition != null ? tablePosition.table.getColumnClass(tablePosition.column) : null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TablePosition tablePosition = this.getTableAtCell(n, n2);
        return tablePosition != null ? tablePosition.table.getValueAt(tablePosition.row, tablePosition.column) : null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        TablePosition tablePosition = this.getTableAtCell(n, n2);
        if (tablePosition != null) {
            tablePosition.table.setValueAt(object, tablePosition.row, tablePosition.column);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        TablePosition tablePosition = this.getTableAtCell(n, n2);
        return tablePosition != null ? Boolean.valueOf(tablePosition.table.isCellEditable(tablePosition.row, tablePosition.column)) : null;
    }

    @Override
    public int getSelectedRow() {
        int n;
        int n2 = 0;
        if (this.getColumnHeaderTable() != null && (n = this.getColumnHeaderTable().getSelectedRow()) != -1) {
            return n;
        }
        if (this.getRowHeaderColumnHeaderTable() != null && (n = this.getRowHeaderColumnHeaderTable().getSelectedRow()) != -1) {
            return n;
        }
        if (this.getRowFooterColumnHeaderTable() != null && (n = this.getRowFooterColumnHeaderTable().getSelectedRow()) != -1) {
            return n;
        }
        if (this.getColumnHeaderTable() != null) {
            n2 += this.getColumnHeaderTable().getRowCount();
        } else if (this.getRowHeaderColumnHeaderTable() != null) {
            n2 += this.getRowHeaderColumnHeaderTable().getRowCount();
        } else if (this.getRowFooterColumnHeaderTable() != null) {
            n2 += this.getRowFooterColumnHeaderTable().getRowCount();
        }
        if (this.getMainTable() != null && (n = this.getMainTable().getSelectedRow()) != -1) {
            return n + n2;
        }
        if (this.getRowHeaderTable() != null && (n = this.getRowHeaderTable().getSelectedRow()) != -1) {
            return n + n2;
        }
        if (this.getRowFooterTable() != null && (n = this.getRowFooterTable().getSelectedRow()) != -1) {
            return n + n2;
        }
        if (this.getMainTable() != null) {
            n2 += this.getMainTable().getRowCount();
        } else if (this.getRowHeaderTable() != null) {
            n2 += this.getRowHeaderTable().getRowCount();
        } else if (this.getRowFooterTable() != null) {
            n2 += this.getRowFooterTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null && (n = this.getColumnFooterTable().getSelectedRow()) != -1) {
            return n + n2;
        }
        if (this.getRowHeaderColumnFooterTable() != null && (n = this.getRowHeaderColumnFooterTable().getSelectedRow()) != -1) {
            return n + n2;
        }
        if (this.getRowFooterColumnFooterTable() != null && (n = this.getRowFooterColumnFooterTable().getSelectedRow()) != -1) {
            return n + n2;
        }
        return -1;
    }

    @Override
    public int getSelectedColumn() {
        int n;
        int n2 = 0;
        if (this.getRowHeaderTable() != null && (n = this.getRowHeaderTable().getSelectedColumn()) != -1) {
            return n;
        }
        if (this.getRowHeaderColumnHeaderTable() != null && (n = this.getRowHeaderColumnHeaderTable().getSelectedColumn()) != -1) {
            return n;
        }
        if (this.getRowHeaderColumnFooterTable() != null && (n = this.getRowHeaderColumnFooterTable().getSelectedColumn()) != -1) {
            return n;
        }
        if (this.getRowHeaderTable() != null) {
            n2 += this.getRowHeaderTable().getColumnCount();
        } else if (this.getRowHeaderColumnHeaderTable() != null) {
            n2 += this.getRowHeaderColumnHeaderTable().getColumnCount();
        } else if (this.getRowHeaderColumnFooterTable() != null) {
            n2 += this.getRowHeaderColumnFooterTable().getColumnCount();
        }
        if (this.getMainTable() != null && (n = this.getMainTable().getSelectedColumn()) != -1) {
            return n2 + n;
        }
        if (this.getColumnFooterTable() != null && (n = this.getColumnFooterTable().getSelectedColumn()) != -1) {
            return n2 + n;
        }
        if (this.getColumnHeaderTable() != null && (n = this.getColumnHeaderTable().getSelectedColumn()) != -1) {
            return n2 + n;
        }
        if (this.getMainTable() != null) {
            n2 += this.getMainTable().getColumnCount();
        } else if (this.getColumnFooterTable() != null) {
            n2 += this.getColumnFooterTable().getColumnCount();
        } else if (this.getColumnHeaderTable() != null) {
            n2 += this.getColumnHeaderTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null && (n = this.getRowFooterTable().getSelectedColumn()) != -1) {
            return n2 + n;
        }
        if (this.getRowFooterColumnFooterTable() != null && (n = this.getRowFooterColumnFooterTable().getSelectedColumn()) != -1) {
            return n2 + n;
        }
        if (this.getRowFooterColumnHeaderTable() != null && (n = this.getRowFooterColumnHeaderTable().getSelectedColumn()) != -1) {
            return n2 + n;
        }
        return -1;
    }

    @Override
    public int[] getSelectedRows() {
        int n;
        int n2;
        int n3 = 0;
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        int[] nArray3 = new int[]{};
        if (this.getColumnHeaderTable() != null) {
            nArray = this.getColumnHeaderTable().getSelectedRows();
            n3 += this.getColumnHeaderTable().getRowCount();
        }
        if (this.getRowHeaderColumnHeaderTable() != null) {
            nArray2 = this.getRowHeaderColumnHeaderTable().getSelectedRows();
            if (this.getColumnHeaderTable() == null) {
                n3 += this.getRowHeaderColumnHeaderTable().getRowCount();
            }
        }
        if (this.getRowFooterColumnHeaderTable() != null) {
            nArray3 = this.getRowFooterColumnHeaderTable().getSelectedRows();
            if (this.getColumnHeaderTable() == null && this.getRowHeaderColumnHeaderTable() == null) {
                n3 += this.getRowFooterColumnHeaderTable().getRowCount();
            }
        }
        int[] nArray4 = TableScrollPane.union(nArray, nArray2, nArray3);
        if (this.getMainTable() != null) {
            nArray = this.getMainTable().getSelectedRows();
            n2 = 0;
            while (n2 < nArray.length) {
                int n4 = n2++;
                nArray[n4] = nArray[n4] + n3;
            }
        }
        if (this.getRowHeaderTable() != null) {
            nArray2 = this.getRowHeaderTable().getSelectedRows();
            n2 = 0;
            while (n2 < nArray2.length) {
                int n5 = n2++;
                nArray2[n5] = nArray2[n5] + n3;
            }
        }
        if (this.getRowFooterTable() != null) {
            nArray3 = this.getRowFooterTable().getSelectedRows();
            n2 = 0;
            while (n2 < nArray3.length) {
                int n6 = n2++;
                nArray3[n6] = nArray3[n6] + n3;
            }
        }
        if (this.getMainTable() != null) {
            n3 += this.getMainTable().getRowCount();
        }
        if (this.getRowHeaderTable() != null && this.getMainTable() == null) {
            n3 += this.getRowHeaderTable().getRowCount();
        }
        if (this.getRowFooterTable() != null && this.getMainTable() == null && this.getRowHeaderTable() == null) {
            n3 += this.getRowFooterTable().getRowCount();
        }
        int[] nArray5 = TableScrollPane.union(nArray, nArray2, nArray3);
        nArray = new int[]{};
        nArray2 = new int[]{};
        nArray3 = new int[]{};
        if (this.getColumnFooterTable() != null) {
            nArray = this.getColumnFooterTable().getSelectedRows();
            n = 0;
            while (n < nArray.length) {
                int n7 = n++;
                nArray[n7] = nArray[n7] + n3;
            }
        }
        if (this.getRowHeaderColumnFooterTable() != null) {
            nArray2 = this.getRowHeaderColumnFooterTable().getSelectedRows();
            n = 0;
            while (n < nArray2.length) {
                int n8 = n++;
                nArray2[n8] = nArray2[n8] + n3;
            }
        }
        if (this.getRowFooterColumnFooterTable() != null) {
            nArray3 = this.getRowFooterColumnFooterTable().getSelectedRows();
            n = 0;
            while (n < nArray3.length) {
                int n9 = n++;
                nArray3[n9] = nArray3[n9] + n3;
            }
        }
        int[] nArray6 = TableScrollPane.union(nArray, nArray2, nArray3);
        return TableScrollPane.concat(nArray4, nArray5, nArray6);
    }

    @Override
    public int convertColumnIndexToView(int n) {
        if (n < 0 || n >= this.getModel().getColumnCount()) {
            return -1;
        }
        int n2 = this.getModel().getColumnType(n);
        int n3 = 0;
        if (this.getRowHeaderTable() != null) {
            if (n2 == 1) {
                return this.getRowHeaderTable().convertColumnIndexToView(n);
            }
            n3 += this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            if (n2 == 0) {
                return n3 + this.getMainTable().convertColumnIndexToView(n);
            }
            n3 += this.getMainTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null && n2 == 2) {
            return n3 + this.getRowFooterTable().convertColumnIndexToView(n);
        }
        return -1;
    }

    @Override
    public int convertColumnIndexToModel(int n) {
        int n2;
        if (n < 0 || n >= this.getColumnCount()) {
            return -1;
        }
        if (this.getRowHeaderTable() != null) {
            n2 = this.getRowHeaderTable().getColumnCount();
            if (n < n2) {
                return this.getRowHeaderTable().convertColumnIndexToModel(n);
            }
            n -= n2;
        }
        if (this.getMainTable() != null) {
            n2 = this.getMainTable().getColumnCount();
            if (n < n2) {
                return this.getMainTable().convertColumnIndexToModel(n);
            }
            n -= n2;
        }
        if (this.getRowFooterTable() != null && n < (n2 = this.getRowFooterTable().getColumnCount())) {
            return this.getRowFooterTable().convertColumnIndexToModel(n);
        }
        return -1;
    }

    static int[] concat(int[] ... nArray) {
        int n = 0;
        for (int[] nArray2 : nArray) {
            n += nArray2.length;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        for (int[] nArray4 : nArray) {
            System.arraycopy(nArray4, 0, nArray3, n2, nArray4.length);
            n2 += nArray4.length;
        }
        return nArray3;
    }

    static int[] union(int[] ... nArray) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int[][] object = nArray;
        int n = object.length;
        for (int iterator = 0; iterator < n; ++iterator) {
            int[] nArray2;
            for (int n2 : nArray2 = object[iterator]) {
                treeSet.add(n2);
            }
        }
        int[] nArray3 = new int[treeSet.size()];
        n = 0;
        for (Integer n3 : treeSet) {
            nArray3[n] = n3;
            ++n;
        }
        return nArray3;
    }

    @Override
    public int[] getSelectedColumns() {
        int n;
        int n2 = 0;
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        int[] nArray3 = new int[]{};
        if (this.getRowHeaderTable() != null) {
            nArray = this.getRowHeaderTable().getSelectedColumns();
            n2 += this.getRowHeaderTable().getColumnCount();
        }
        if (this.getMainTable() != null) {
            nArray2 = this.getMainTable().getSelectedColumns();
            n = 0;
            while (n < nArray2.length) {
                int n3 = n++;
                nArray2[n3] = nArray2[n3] + n2;
            }
            n2 += this.getMainTable().getColumnCount();
        }
        if (this.getRowFooterTable() != null) {
            nArray3 = this.getRowFooterTable().getSelectedColumns();
            n = 0;
            while (n < nArray3.length) {
                int n4 = n++;
                nArray3[n4] = nArray3[n4] + n2;
            }
        }
        int[] nArray4 = new int[nArray.length + nArray2.length + nArray3.length];
        System.arraycopy(nArray, 0, nArray4, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray4, nArray.length, nArray2.length);
        System.arraycopy(nArray3, 0, nArray4, nArray.length + nArray2.length, nArray3.length);
        return nArray4;
    }

    @Override
    public int getSelectedRowCount() {
        return this.getSelectedRows().length;
    }

    @Override
    public int getSelectedColumnCount() {
        return this.getSelectedColumns().length;
    }

    @Override
    public boolean isRowSelected(int n) {
        if (this.getMainTable() != null) {
            if (n < this.getMainTable().getRowCount()) {
                return this.getMainTable().isRowSelected(n) || this.getRowHeaderTable() != null && this.getRowHeaderTable().isRowSelected(n) || this.getRowFooterTable() != null && this.getRowFooterTable().isRowSelected(n);
            }
            n -= this.getMainTable().getRowCount();
        }
        if (this.getColumnFooterTable() != null && n < this.getColumnFooterTable().getRowCount()) {
            return this.getColumnFooterTable().isRowSelected(n) || this.getRowHeaderColumnFooterTable() != null && this.getRowHeaderColumnFooterTable().isRowSelected(n) || this.getRowFooterColumnFooterTable() != null && this.getRowFooterColumnFooterTable().isRowSelected(n);
        }
        return false;
    }

    @Override
    public boolean isColumnSelected(int n) {
        TablePosition tablePosition = this.getTableAtColumn(n);
        return tablePosition != null && tablePosition.table.isColumnSelected(tablePosition.column);
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        TablePosition tablePosition = this.getTableAtCell(n, n2);
        return tablePosition != null && tablePosition.table != null && tablePosition.table.isCellSelected(tablePosition.row, tablePosition.column);
    }

    @Override
    public void clearSelection() {
        if (this.getRowHeaderTable() != null) {
            this.getRowHeaderTable().clearSelection();
        }
        if (this.getMainTable() != null) {
            this.getMainTable().clearSelection();
        }
        if (this.getColumnFooterTable() != null) {
            this.getColumnFooterTable().clearSelection();
        }
        if (this.getRowFooterTable() != null) {
            this.getRowFooterTable().clearSelection();
        }
        if (this.getRowFooterColumnFooterTable() != null) {
            this.getRowFooterColumnFooterTable().clearSelection();
        }
        if (this.getRowHeaderColumnFooterTable() != null) {
            this.getRowHeaderColumnFooterTable().clearSelection();
        }
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        TablePosition tablePosition = this.getTableAtCell(n, n2);
        if (this.isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner())) {
            tablePosition.table.requestFocus();
        }
        tablePosition.table.changeSelection(tablePosition.row, tablePosition.column, bl, bl2);
    }

    public boolean print() throws PrinterException {
        return this.print(JTable.PrintMode.FIT_WIDTH);
    }

    public boolean print(JTable.PrintMode printMode) throws PrinterException {
        return this.print(printMode, null, null);
    }

    public boolean print(JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        boolean bl = !GraphicsEnvironment.isHeadless();
        return this.print(printMode, messageFormat, messageFormat2, bl, null, bl);
    }

    public boolean print(JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2, boolean bl, PrintRequestAttributeSet printRequestAttributeSet, boolean bl2) throws PrinterException, HeadlessException {
        return this.print(printMode, messageFormat, messageFormat2, bl, printRequestAttributeSet, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean print(JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2, boolean bl, PrintRequestAttributeSet printRequestAttributeSet, boolean bl2, PrintService printService) throws PrinterException, HeadlessException {
        Throwable throwable;
        PrintingStatus printingStatus;
        boolean bl3 = GraphicsEnvironment.isHeadless();
        if (bl3) {
            if (bl) {
                throw new HeadlessException("Can't show print dialog.");
            }
            if (bl2) {
                throw new HeadlessException("Can't run interactively.");
            }
        }
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        Printable printable = this.getPrintable(printMode, messageFormat, messageFormat2);
        if (bl2) {
            printable = new ThreadSafePrintable(printable);
            printingStatus = PrintingStatus.createPrintingStatus(this, printerJob);
            printable = printingStatus.createNotificationPrintable(printable);
        } else {
            printingStatus = null;
        }
        printerJob.setPrintable(printable);
        if (printService != null) {
            printerJob.setPrintService(printService);
        }
        if (bl && !printerJob.printDialog(printRequestAttributeSet)) {
            return false;
        }
        if (!bl2) {
            printerJob.print(printRequestAttributeSet);
            return true;
        }
        this.printError = null;
        final Object object = new Object();
        final PrintRequestAttributeSet printRequestAttributeSet2 = printRequestAttributeSet;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    printerJob.print(printRequestAttributeSet2);
                }
                catch (Throwable throwable) {
                    Object object2 = object;
                    synchronized (object2) {
                        TableScrollPane.this.printError = throwable;
                    }
                }
                finally {
                    printingStatus.dispose();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        printingStatus.showModal(true);
        Object object2 = object;
        synchronized (object2) {
            throwable = this.printError;
            this.printError = null;
        }
        if (throwable != null) {
            if (throwable instanceof PrinterAbortException) {
                return false;
            }
            if (throwable instanceof PrinterException) {
                throw (PrinterException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
        return true;
    }

    public Printable getPrintable(JTable.PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) {
        return new TableScrollPanePrintable(this, printMode, messageFormat, messageFormat2);
    }

    int getHeaderHeight() {
        int n = 0;
        JTableHeader jTableHeader = this.getRowHeaderTableHeader();
        if (jTableHeader != null) {
            n = Math.max(n, jTableHeader.getHeight());
        }
        if ((jTableHeader = this.getMainTableHeader()) != null) {
            n = Math.max(n, jTableHeader.getHeight());
        }
        if ((jTableHeader = this.getRowFooterTableHeader()) != null) {
            n = Math.max(n, jTableHeader.getHeight());
        }
        return n;
    }

    JTableHeader getRowHeaderTableHeader() {
        JTable jTable = this.getRowHeaderTable();
        if (!(jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible() || (jTable = this.getRowHeaderColumnHeaderTable()) != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible())) {
            jTable = this.getRowHeaderColumnFooterTable();
        }
        if (jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible()) {
            return jTable.getTableHeader();
        }
        return null;
    }

    JTableHeader getMainTableHeader() {
        JTable jTable = this.getMainTable();
        if (!(jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible() || (jTable = this.getColumnHeaderTable()) != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible())) {
            jTable = this.getColumnFooterTable();
        }
        if (jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible()) {
            return jTable.getTableHeader();
        }
        return null;
    }

    JTableHeader getRowFooterTableHeader() {
        JTable jTable = this.getRowFooterTable();
        if (!(jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible() || (jTable = this.getRowFooterColumnHeaderTable()) != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible())) {
            jTable = this.getRowFooterColumnFooterTable();
        }
        if (jTable != null && jTable.getTableHeader() != null && jTable.getTableHeader().isVisible()) {
            return jTable.getTableHeader();
        }
        return null;
    }

    int getTotalColumnWidth() {
        int n = 0;
        n += this.getRowHeaderTableWidth();
        n += this.getMainTableWidth();
        return n += this.getRowFooterTableWidth();
    }

    int getRowHeaderTableWidth() {
        int n = 0;
        JTable jTable = this.getRowHeaderTable();
        if (jTable == null && (jTable = this.getRowHeaderColumnHeaderTable()) == null) {
            jTable = this.getRowHeaderColumnFooterTable();
        }
        if (jTable != null) {
            n = jTable.getColumnModel().getTotalColumnWidth();
        }
        return n;
    }

    int getMainTableWidth() {
        int n = 0;
        JTable jTable = this.getMainTable();
        if (jTable == null && (jTable = this.getColumnHeaderTable()) == null) {
            jTable = this.getColumnFooterTable();
        }
        if (jTable != null) {
            n = jTable.getColumnModel().getTotalColumnWidth();
        }
        return n;
    }

    int getRowFooterTableWidth() {
        int n = 0;
        JTable jTable = this.getRowFooterTable();
        if (jTable == null && (jTable = this.getRowFooterColumnHeaderTable()) == null) {
            jTable = this.getRowFooterColumnFooterTable();
        }
        if (jTable != null) {
            n = jTable.getColumnModel().getTotalColumnWidth();
        }
        return n;
    }

    int getColumnHeaderTableHeight() {
        int n = 0;
        JTable jTable = this.getColumnHeaderTable();
        if (jTable == null && (jTable = this.getRowHeaderColumnHeaderTable()) == null) {
            jTable = this.getRowFooterColumnHeaderTable();
        }
        if (jTable != null) {
            n = jTable.getHeight();
        }
        return n;
    }

    int getMainTableHeight() {
        int n = 0;
        JTable jTable = this.getMainTable();
        if (jTable == null && (jTable = this.getRowHeaderTable()) == null) {
            jTable = this.getRowFooterTable();
        }
        if (jTable != null) {
            n = jTable.getHeight();
        }
        return n;
    }

    int getColumnFooterTableHeight() {
        int n = 0;
        JTable jTable = this.getColumnFooterTable();
        if (jTable == null && (jTable = this.getRowHeaderColumnFooterTable()) == null) {
            jTable = this.getRowFooterColumnFooterTable();
        }
        if (jTable != null) {
            n = jTable.getHeight();
        }
        return n;
    }

    boolean isAvoidSelectionChange() {
        return this._avoidSelectionChange;
    }

    void setAvoidSelectionChange(boolean bl) {
        this._avoidSelectionChange = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(TableScrollPane.class.getName(), 4);
        }
        LOGGER_EVENT = Logger.getLogger(TableScrollPane.class.getName());
    }

    private class ThreadSafePrintable
    implements Printable {
        private Printable printDelegate;
        private int retVal;
        private Throwable retThrowable;

        public ThreadSafePrintable(Printable printable) {
            this.printDelegate = printable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int print(final Graphics graphics, final PageFormat pageFormat, final int n) throws PrinterException {
            Runnable runnable;
            Runnable runnable2 = runnable = new Runnable(){

                @Override
                public synchronized void run() {
                    try {
                        ThreadSafePrintable.this.retVal = ThreadSafePrintable.this.printDelegate.print(graphics, pageFormat, n);
                    }
                    catch (Throwable throwable) {
                        ThreadSafePrintable.this.retThrowable = throwable;
                    }
                    finally {
                        this.notifyAll();
                    }
                }
            };
            synchronized (runnable2) {
                this.retVal = -1;
                this.retThrowable = null;
                SwingUtilities.invokeLater(runnable);
                while (this.retVal == -1 && this.retThrowable == null) {
                    try {
                        runnable.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.retThrowable != null) {
                    if (this.retThrowable instanceof PrinterException) {
                        throw (PrinterException)this.retThrowable;
                    }
                    if (this.retThrowable instanceof RuntimeException) {
                        throw (RuntimeException)this.retThrowable;
                    }
                    if (this.retThrowable instanceof Error) {
                        throw (Error)this.retThrowable;
                    }
                    throw new AssertionError((Object)this.retThrowable);
                }
                return this.retVal;
            }
        }
    }

    public static class TablePosition {
        JTable table;
        int row = -1;
        int column = 1;

        public TablePosition(JTable jTable, int n, int n2) {
            this.table = jTable;
            this.row = n;
            this.column = n2;
        }

        public JTable getTable() {
            return this.table;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

