/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.TablePopupMenuCustomizer;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;

public class TablePopupMenuInstaller
extends MouseAdapter {
    private JTable _table;
    public static final String CLIENT_PROPERTY_POPUP_MENU_INSTALLER = "TablePopupMenuInstaller";
    List<TablePopupMenuCustomizer> _customizers;

    public TablePopupMenuInstaller(JTable jTable) {
        this._table = jTable;
        this.installListeners();
    }

    public void addTablePopupMenuCustomizer(TablePopupMenuCustomizer tablePopupMenuCustomizer) {
        if (this._customizers == null) {
            this._customizers = new ArrayList<TablePopupMenuCustomizer>();
        }
        this._customizers.add(tablePopupMenuCustomizer);
    }

    public void removeTablePopupMenuCustomizer(TablePopupMenuCustomizer tablePopupMenuCustomizer) {
        if (this._customizers != null) {
            this._customizers.remove(tablePopupMenuCustomizer);
        }
    }

    public TablePopupMenuCustomizer[] getTablePopupMenuCustomizers() {
        return this._customizers != null ? this._customizers.toArray(new TablePopupMenuCustomizer[this._customizers.size()]) : new TablePopupMenuCustomizer[]{};
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        JTable jTable = (JTable)mouseEvent.getComponent();
        JPopupMenu jPopupMenu = this.createPopupMenu();
        jPopupMenu.setComponentOrientation(jTable.getComponentOrientation());
        int n = TablePopupMenuInstaller.getClickingRow(jTable, mouseEvent.getPoint());
        int n2 = TablePopupMenuInstaller.getClickingColumn(jTable, mouseEvent.getPoint());
        this.customizeMenuItems(jTable, jPopupMenu, n, n2);
        if (jPopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, jTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    protected void customizeMenuItems(JTable jTable, JPopupMenu jPopupMenu, int n, int n2) {
        TablePopupMenuCustomizer[] tablePopupMenuCustomizerArray;
        for (TablePopupMenuCustomizer tablePopupMenuCustomizer : tablePopupMenuCustomizerArray = this.getTablePopupMenuCustomizers()) {
            TablePopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            tablePopupMenuCustomizer.customizePopupMenu(jTable, jPopupMenu, n, n2);
        }
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n = jPopupMenu.getComponentCount();
        if (n > 0 && !(jPopupMenu.getComponent(n - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }

    public void installListeners() {
        this._table.addMouseListener(this);
        this.updateClientProperty(this._table, this);
    }

    public void uninstallListeners() {
        this._table.removeMouseListener(this);
        this.updateClientProperty(this._table, null);
    }

    public static TablePopupMenuInstaller getTablePopupMenuInstaller(JTable jTable) {
        Object object = jTable.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
        if (object instanceof TablePopupMenuInstaller) {
            return (TablePopupMenuInstaller)object;
        }
        return null;
    }

    private void updateClientProperty(JTable jTable, TablePopupMenuInstaller tablePopupMenuInstaller) {
        if (jTable != null) {
            Object object = jTable.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
            if (object instanceof TablePopupMenuInstaller && object != this) {
                ((TablePopupMenuInstaller)object).uninstallListeners();
            }
            jTable.putClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER, tablePopupMenuInstaller);
        }
    }

    private static int getClickingColumn(JTable jTable, Point point) {
        return jTable.columnAtPoint(point);
    }

    private static int getClickingRow(JTable jTable, Point point) {
        return jTable.rowAtPoint(point);
    }
}

