/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.GroupTableHeader;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;

public class TableHeaderPopupMenuInstaller
extends MouseAdapter
implements PropertyChangeListener {
    private JTable _table;
    public static final String CLIENT_PROPERTY_POPUP_MENU_INSTALLER = "TableHeaderPopupMenuInstaller";
    List<TableHeaderPopupMenuCustomizer> _customizers;

    public TableHeaderPopupMenuInstaller(JTable jTable) {
        this._table = jTable;
        this.installListeners();
    }

    public void addTableHeaderPopupMenuCustomizer(TableHeaderPopupMenuCustomizer tableHeaderPopupMenuCustomizer) {
        if (this._customizers == null) {
            this._customizers = new ArrayList<TableHeaderPopupMenuCustomizer>();
        }
        this._customizers.add(tableHeaderPopupMenuCustomizer);
    }

    public void removeTableHeaderPopupMenuCustomizer(TableHeaderPopupMenuCustomizer tableHeaderPopupMenuCustomizer) {
        if (this._customizers != null) {
            this._customizers.remove(tableHeaderPopupMenuCustomizer);
        }
    }

    public TableHeaderPopupMenuCustomizer[] getTableHeaderPopupMenuCustomizers() {
        return this._customizers != null ? this._customizers.toArray(new TableHeaderPopupMenuCustomizer[this._customizers.size()]) : new TableHeaderPopupMenuCustomizer[]{};
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getComponent();
        jTableHeader.setDraggedColumn(null);
        if (jTableHeader instanceof NestedTableHeader && !((NestedTableHeader)jTableHeader).isMouseOnOriginalTableHeader(mouseEvent.getPoint())) {
            return;
        }
        JPopupMenu jPopupMenu = this.createPopupMenu();
        int n = TableHeaderPopupMenuInstaller.getClickingColumn(jTableHeader, mouseEvent.getPoint());
        this.customizeMenuItems(jTableHeader, jPopupMenu, n);
        if (jPopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, jTableHeader, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    protected void customizeMenuItems(JTableHeader jTableHeader, JPopupMenu jPopupMenu, int n) {
        TableHeaderPopupMenuCustomizer[] tableHeaderPopupMenuCustomizerArray;
        for (TableHeaderPopupMenuCustomizer tableHeaderPopupMenuCustomizer : tableHeaderPopupMenuCustomizerArray = this.getTableHeaderPopupMenuCustomizers()) {
            TableHeaderPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            tableHeaderPopupMenuCustomizer.customizePopupMenu(jTableHeader, jPopupMenu, n);
        }
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n = jPopupMenu.getComponentCount();
        if (n > 0 && !(jPopupMenu.getComponent(n - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }

    public void installListeners() {
        JTableHeader jTableHeader = this._table.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.addMouseListener(this);
        }
        this._table.addPropertyChangeListener("tableHeader", this);
        this.updateClientProperty(this._table, this);
    }

    public void uninstallListeners() {
        JTableHeader jTableHeader = this._table.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.removeMouseListener(this);
        }
        this._table.removePropertyChangeListener("tableHeader", this);
        this.updateClientProperty(this._table, null);
    }

    public static TableHeaderPopupMenuInstaller getTableHeaderPopupMenuInstaller(JTable jTable) {
        Object object = jTable.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
        if (object instanceof TableHeaderPopupMenuInstaller) {
            return (TableHeaderPopupMenuInstaller)object;
        }
        return null;
    }

    private void updateClientProperty(JTable jTable, TableHeaderPopupMenuInstaller tableHeaderPopupMenuInstaller) {
        if (jTable != null) {
            Object object = jTable.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
            if (object instanceof TableHeaderPopupMenuInstaller && object != this) {
                ((TableHeaderPopupMenuInstaller)object).uninstallListeners();
            }
            jTable.putClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER, tableHeaderPopupMenuInstaller);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("tableHeader".equals(propertyChangeEvent.getPropertyName())) {
            JTableHeader jTableHeader;
            if (propertyChangeEvent.getOldValue() instanceof JTableHeader) {
                jTableHeader = (JTableHeader)propertyChangeEvent.getOldValue();
                jTableHeader.removeMouseListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof JTableHeader) {
                jTableHeader = (JTableHeader)propertyChangeEvent.getNewValue();
                jTableHeader.addMouseListener(this);
            }
        }
    }

    private static int getClickingColumn(JTableHeader jTableHeader, Point point) {
        GroupModelProvider groupModelProvider;
        for (int i = 0; i < jTableHeader.getColumnModel().getColumnCount(); ++i) {
            Rectangle rectangle = jTableHeader.getHeaderRect(i);
            if (!rectangle.contains(point)) continue;
            return i;
        }
        if (jTableHeader instanceof GroupTableHeader && (groupModelProvider = ((GroupTableHeader)jTableHeader).getGroupTableModel()) != null) {
            int n = groupModelProvider.getGroupColumnCount();
            for (int i = 0; i < n; ++i) {
                Rectangle rectangle = ((GroupTableHeader)jTableHeader).getGroupedHeaderRect(i);
                if (!rectangle.contains(point)) continue;
                return -2 - i;
            }
        }
        return -1;
    }
}

