/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.TableComboBox;
import com.jidesoft.combobox.TableComboBoxSearchable;
import com.jidesoft.combobox.TableExComboBox;
import com.jidesoft.combobox.TableExComboBoxSearchable;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.RegexFilter;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.ShrinkSearchableSupport;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.swing.Searchable;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class TableComboBoxShrinkSearchableSupport
extends ShrinkSearchableSupport {
    private FilterableTableModel _filterableTableModel;

    public TableComboBoxShrinkSearchableSupport(Searchable searchable) {
        super(searchable);
        if (this._searchable == null || !(this._searchable instanceof TableComboBoxSearchable) && !(this._searchable instanceof TableExComboBoxSearchable)) {
            throw new IllegalArgumentException("The searchable instance should be TableComboBoxSearchable or TableExComboBoxSearchable for TableComboBoxShrinkSearchableSupport");
        }
    }

    @Override
    protected boolean needReinstallFilterableModel(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getSource() == this._searchable.getComponent() && propertyChangeEvent.getNewValue() != this._filterableTableModel;
    }

    @Override
    public void installFilterableModel() {
        Component component = this._searchable.getComponent();
        if (component instanceof TableComboBox) {
            if (!this._searchable.isSearchableListenerInstalled(this)) {
                this._searchable.addSearchableListener(this);
            }
            this._filterableTableModel = this.createFilterableTableModel(((TableComboBox)component).getTableModel());
            component.removePropertyChangeListener("model", this);
            ((TableComboBox)component).setTableModel(this._filterableTableModel);
            component.addPropertyChangeListener("model", this);
        } else if (component instanceof TableExComboBox) {
            if (!this._searchable.isSearchableListenerInstalled(this)) {
                this._searchable.addSearchableListener(this);
            }
            this._filterableTableModel = this.createFilterableTableModel(((TableExComboBox)component).getTableModel());
            component.removePropertyChangeListener("model", this);
            ((TableExComboBox)component).setTableModel(this._filterableTableModel);
            component.addPropertyChangeListener("model", this);
        }
    }

    protected FilterableTableModel createFilterableTableModel(TableModel tableModel) {
        return new FilterableTableModel(tableModel);
    }

    @Override
    public void uninstallFilterableModel() {
        this._searchable.getComponent().removePropertyChangeListener("model", this);
        if (this._filterableTableModel != null) {
            this._searchable.removeSearchableListener(this);
            Component component = this._searchable.getComponent();
            if (component instanceof TableComboBox) {
                ((TableComboBox)component).setTableModel(this._filterableTableModel.getActualModel());
            } else if (component instanceof TableExComboBox) {
                ((TableExComboBox)component).setTableModel(this._filterableTableModel.getActualModel());
            }
            this._filterableTableModel = null;
        }
    }

    @Override
    protected void applyFilter(String string) {
        Object object;
        if (this._filterableTableModel == null) {
            return;
        }
        this._filterableTableModel.clearFilters();
        if (this._searchable.isWildcardEnabled() && (object = this._searchable.getWildcardSupport()) != null) {
            string = object.convert(string);
        }
        object = new WildcardFilter(string){
            private static final long serialVersionUID = 5215940611349559393L;

            @Override
            protected String convertElementToString(Object object) {
                Object object2 = this.getObjectGrouper() == null ? object : this.getObjectGrouper().getValue(object);
                String string = TableComboBoxShrinkSearchableSupport.this.convertElementToString(object2);
                if (string == null) {
                    string = super.convertElementToString(object);
                }
                return string != null ? string : ObjectConverterManager.toString(object2);
            }

            @Override
            protected Pattern createRegexPattern() {
                return Pattern.compile(this.isBeginWith() ? "^" + this.getPattern() : this.getPattern(), this.isCaseSensitive() ? 0 : 2);
            }
        };
        ((RegexFilter)object).setBeginWith(this._searchable.isFromStart());
        ((RegexFilter)object).setEndWith(false);
        ((RegexFilter)object).setCaseSensitive(this._searchable.isCaseSensitive());
        int[] nArray = this.getSearchColumnIndices();
        if (nArray != null && nArray.length > 0) {
            for (int n : nArray) {
                this._filterableTableModel.addFilter(n, (Filter)object);
            }
        } else {
            this._filterableTableModel.addFilter((Filter)object);
        }
        boolean bl = this._searchable.isHideSearchPopupOnEvent();
        this._searchable.setHideSearchPopupOnEvent(false);
        this._filterableTableModel.setFiltersApplied(true);
        this._searchable.setHideSearchPopupOnEvent(bl);
    }

    private int[] getSearchColumnIndices() {
        if (this._searchable instanceof TableComboBoxSearchable) {
            Component component;
            int[] nArray = ((TableComboBoxSearchable)this._searchable).getSearchColumnIndices();
            if (nArray == null && (component = this._searchable.getComponent()) instanceof TableComboBox) {
                nArray = new int[]{((TableComboBox)component).getValueColumnIndex()};
            }
            return nArray;
        }
        if (this._searchable instanceof TableExComboBoxSearchable) {
            Component component;
            int[] nArray = ((TableExComboBoxSearchable)this._searchable).getSearchColumnIndices();
            if (nArray == null && (component = this._searchable.getComponent()) instanceof TableExComboBox) {
                nArray = new int[]{((TableExComboBox)component).getValueColumnIndex()};
            }
            return nArray;
        }
        return null;
    }

    private boolean isColumnSelectionAllowed() {
        JTable jTable = this.getTable();
        int[] nArray = this.getSearchColumnIndices();
        return nArray != null && nArray.length == 1 && jTable.getColumnSelectionAllowed() && !jTable.getRowSelectionAllowed();
    }

    private JTable getTable() {
        Component component = this._searchable.getComponent();
        return component instanceof TableComboBox ? ((TableComboBox)component).getTable() : ((TableExComboBox)component).getTable();
    }

    private boolean isRowSelectionAllowed() {
        JTable jTable = this.getTable();
        int[] nArray = this.getSearchColumnIndices();
        return (nArray == null || nArray.length == 1) && !jTable.getColumnSelectionAllowed() && jTable.getRowSelectionAllowed();
    }

    @Override
    protected int getActualIndexAt(int n) {
        if (this._filterableTableModel == null || n < 0) {
            return n;
        }
        if (this.isColumnSelectionAllowed()) {
            return n;
        }
        if (this.isRowSelectionAllowed()) {
            return TableModelWrapperUtils.getActualRowAt(this.getTable().getModel(), n);
        }
        int n2 = this._filterableTableModel.getColumnCount();
        int n3 = TableModelWrapperUtils.getActualRowAt(this.getTable().getModel(), n / n2);
        int n4 = n % n2;
        if (n3 >= 0) {
            return n3 * n2 + n4;
        }
        return -1;
    }

    @Override
    protected int getVisualIndexAt(int n) {
        if (this._filterableTableModel == null || n < 0) {
            return n;
        }
        if (this.isColumnSelectionAllowed()) {
            return n;
        }
        if (this.isRowSelectionAllowed()) {
            return TableModelWrapperUtils.getRowAt(this.getTable().getModel(), n);
        }
        int n2 = this._filterableTableModel.getColumnCount();
        int n3 = TableModelWrapperUtils.getRowAt(this.getTable().getModel(), n / n2);
        int n4 = n % n2;
        if (n3 >= 0) {
            return n3 * n2 + n4;
        }
        return -1;
    }
}

