/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.NestedTableHeaderUIDelegate;
import com.jidesoft.plaf.TableHeaderUIDelegate;
import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnGroup
extends TableColumn
implements PropertyChangeListener {
    protected Vector _columns;
    protected int margin = 0;
    protected TableColumnGroup _parent = null;
    private JTableHeader _tableHeader;
    private TableColumnModelListener _listener;
    private String _toolTipText;
    private static final long serialVersionUID = 6692294013634571000L;
    private Map<Object, Integer> _columnNameMap;

    public TableColumnGroup(String string) {
        this((TableCellRenderer)null, string);
    }

    public TableColumnGroup(TableCellRenderer tableCellRenderer, String string) {
        this.setHeaderValue(string);
        this.setHeaderRenderer(tableCellRenderer);
        this._columns = new Vector();
        this._listener = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                TableColumnGroup.this.clearColumnMap();
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                TableColumnGroup.this.clearColumnMap();
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        };
    }

    public TableColumnGroup(JTableHeader jTableHeader, String string) {
        this._tableHeader = jTableHeader;
        this.setHeaderValue(string);
        this._columns = new Vector();
    }

    public JTableHeader getTableHeader() {
        if (this._tableHeader == null) {
            if (this.getParent() != null) {
                return this.getParent().getTableHeader();
            }
            return null;
        }
        return this._tableHeader;
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this._tableHeader != null) {
            this._tableHeader.getTable().getColumnModel().removeColumnModelListener(this._listener);
        }
        this._tableHeader = jTableHeader;
        if (this._tableHeader != null) {
            this._tableHeader.addPropertyChangeListener("table", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("table".equals(propertyChangeEvent.getPropertyName()) && TableColumnGroup.this._tableHeader != null && TableColumnGroup.this._tableHeader.getTable() != null) {
                        TableColumnGroup.this._tableHeader.getTable().getColumnModel().addColumnModelListener(TableColumnGroup.this._listener);
                    }
                }
            });
            if (this._tableHeader.getTable() != null) {
                this._tableHeader.getTable().getColumnModel().addColumnModelListener(this._listener);
            }
        }
    }

    @Override
    public void setHeaderValue(Object object) {
        TableHeaderUIDelegate tableHeaderUIDelegate;
        super.setHeaderValue(object);
        if (this._tableHeader != null && this._tableHeader.getUI() instanceof DelegateTableHeaderUI && (tableHeaderUIDelegate = ((DelegateTableHeaderUI)((Object)this._tableHeader.getUI())).getHeaderUIDelegate()) instanceof BasicCellStyleTableHeaderUIDelegate) {
            ((BasicCellStyleTableHeaderUIDelegate)tableHeaderUIDelegate).invalidateCache(true);
        }
    }

    @Override
    protected TableCellRenderer createDefaultHeaderRenderer() {
        if (this.getTableHeader() != null) {
            return this.getTableHeader().getDefaultRenderer();
        }
        JTableHeader jTableHeader = new JTableHeader();
        return jTableHeader.getDefaultRenderer();
    }

    Vector getColumnGroups(TableColumn tableColumn, Vector vector) {
        vector.addElement(this);
        if (this._columns.contains(tableColumn) && this.isVisibleColumn(tableColumn)) {
            return vector;
        }
        Enumeration enumeration = this._columns.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Object e = enumeration.nextElement();
            if (!(e instanceof TableColumnGroup) || (vector2 = ((TableColumnGroup)e).getColumnGroups(tableColumn, (Vector)vector.clone())) == null) continue;
            return vector2;
        }
        return null;
    }

    @Override
    public TableCellRenderer getHeaderRenderer() {
        TableCellRenderer tableCellRenderer = super.getHeaderRenderer();
        if (tableCellRenderer == null && this.getParent() != null) {
            return this.getParent().getHeaderRenderer();
        }
        return tableCellRenderer;
    }

    public TableCellRenderer getDefaultHeaderRenderer() {
        TableCellRenderer tableCellRenderer = this.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getTableHeader().getDefaultRenderer();
        }
        return tableCellRenderer;
    }

    public Dimension getSize(JTable jTable) {
        Object object;
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader instanceof NestedTableHeader && jTableHeader.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate() instanceof NestedTableHeaderUIDelegate) {
            return ((NestedTableHeaderUIDelegate)((Object)((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate())).getSize(this);
        }
        int n = 0;
        Enumeration enumeration = this._columns.elements();
        this.generateColumnMapIfNecessary(jTable);
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof TableColumnGroup) {
                n += ((TableColumnGroup)object).getSize((JTable)jTable).width;
                continue;
            }
            if (!(object instanceof TableColumn) || !this.isVisibleColumn((TableColumn)object)) continue;
            TableColumn tableColumn = (TableColumn)object;
            n += tableColumn.getWidth();
            n += this.margin;
        }
        object = this.getDefaultHeaderRenderer().getTableCellRendererComponent(jTable, this.getHeaderValue(), false, false, 0, -1);
        int n2 = ((Component)object).getPreferredSize().height;
        return new Dimension(n, n2);
    }

    int getPreferredWidth(JTable jTable) {
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader instanceof NestedTableHeader && jTableHeader.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate() instanceof NestedTableHeaderUIDelegate) {
            return ((NestedTableHeaderUIDelegate)((Object)((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate())).getPreferredWidth(this);
        }
        Component component = this.getDefaultHeaderRenderer().getTableCellRendererComponent(jTable, this.getHeaderValue(), false, false, 0, -1);
        return (int)component.getPreferredSize().getWidth();
    }

    private void generateColumnMapIfNecessary(JTable jTable) {
        if (this._columnNameMap == null && jTable != null) {
            this._columnNameMap = new HashMap<Object, Integer>();
            for (int i = jTable.getColumnModel().getColumnCount() - 1; i >= 0; --i) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
                int n = tableColumn.getWidth();
                this._columnNameMap.put(tableColumn.getIdentifier(), n);
            }
        }
    }

    void clearColumnMap() {
        this._columnNameMap = null;
        Enumeration enumeration = this._columns.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof TableColumnGroup)) continue;
            ((TableColumnGroup)e).clearColumnMap();
        }
    }

    public TableColumnGroup getParent() {
        return this._parent;
    }

    public int getColumnIndex() {
        return this.getColumnIndex(this);
    }

    public int getLastColumnIndex() {
        return this.getLastColumnIndex(this);
    }

    protected int getColumnIndex(TableColumnGroup tableColumnGroup) {
        List list = tableColumnGroup.getChildren();
        int n = Integer.MAX_VALUE;
        JTable jTable = null;
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTable = jTableHeader.getTable();
        }
        if (jTable != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Object e = list.get(i);
                int n2 = e instanceof TableColumnGroup ? this.getColumnIndex((TableColumnGroup)e) : (e instanceof TableColumn ? jTable.convertColumnIndexToView(((TableColumn)e).getModelIndex()) : Integer.MAX_VALUE);
                if (n2 >= n || n2 == -1) continue;
                n = n2;
            }
        }
        if (n == Integer.MAX_VALUE) {
            n = -1;
        }
        return n;
    }

    protected int getLastColumnIndex(TableColumnGroup tableColumnGroup) {
        List list = tableColumnGroup.getChildren();
        int n = -1;
        JTable jTable = null;
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTable = jTableHeader.getTable();
        }
        if (jTable != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                Object e = list.get(i);
                int n2 = e instanceof TableColumnGroup ? this.getLastColumnIndex((TableColumnGroup)e) : (e instanceof TableColumn ? jTable.convertColumnIndexToView(((TableColumn)e).getModelIndex()) : -1);
                if (n2 <= n) continue;
                n = n2;
            }
        }
        return n;
    }

    protected void setParent(TableColumnGroup tableColumnGroup) {
        this._parent = tableColumnGroup;
    }

    public List getChildren() {
        ArrayList arrayList = new ArrayList();
        if (this.getTableHeader() != null) {
            this.generateColumnMapIfNecessary(this.getTableHeader().getTable());
        }
        for (Object e : this._columns) {
            if (e instanceof TableColumn && !(e instanceof TableColumnGroup)) {
                if (!this.isVisibleColumn((TableColumn)e)) continue;
                arrayList.add(e);
                continue;
            }
            arrayList.add(e);
        }
        return arrayList;
    }

    public int getChildCount() {
        int n = this._columns.size();
        int n2 = 0;
        if (this.getTableHeader() != null) {
            this.generateColumnMapIfNecessary(this.getTableHeader().getTable());
        }
        while (n2 < this._columns.size()) {
            Object e = this._columns.get(n2);
            if (e instanceof TableColumn && !(e instanceof TableColumnGroup) && !this.isVisibleColumn((TableColumn)e)) {
                --n;
            }
            ++n2;
        }
        return n;
    }

    protected boolean isVisibleColumn(TableColumn tableColumn) {
        if (this._columnNameMap == null) {
            if (this.getTableHeader() == null) {
                return true;
            }
            TableColumnModel tableColumnModel = this.getTableHeader().getColumnModel();
            return TableColumnChooser.isVisibleColumn(tableColumnModel, tableColumn);
        }
        return this._columnNameMap.get(tableColumn.getIdentifier()) != null;
    }

    public void add(Object object) {
        if (object != null) {
            if (object instanceof TableColumnGroup) {
                ((TableColumnGroup)object).setParent(this);
            } else if (object instanceof TableColumn) {
                ((TableColumn)object).addPropertyChangeListener(this);
            }
            this._columns.add(object);
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader instanceof NestedTableHeader) {
                ((NestedTableHeader)jTableHeader).invalidateRowCountCache();
            }
        }
    }

    public void remove(Object object) {
        if (object != null) {
            if (object instanceof TableColumnGroup) {
                ((TableColumnGroup)object).setParent(null);
            } else if (object instanceof TableColumn) {
                ((TableColumn)object).removePropertyChangeListener(this);
            }
            this._columns.remove(object);
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader instanceof NestedTableHeader) {
                ((NestedTableHeader)jTableHeader).invalidateRowCountCache();
            }
        }
    }

    void removeAll() {
        if (this._columns == null) {
            return;
        }
        for (Object e : this._columns) {
            if (e instanceof TableColumnGroup) {
                ((TableColumnGroup)e).setParent(null);
                continue;
            }
            if (!(e instanceof TableColumn)) continue;
            ((TableColumn)e).removePropertyChangeListener(this);
        }
        this._columns.clear();
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader instanceof NestedTableHeader) {
            ((NestedTableHeader)jTableHeader).invalidateRowCountCache();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("identifier".equals(propertyChangeEvent.getPropertyName()) && this._columnNameMap != null) {
            Integer n = this._columnNameMap.get(propertyChangeEvent.getOldValue());
            this._columnNameMap.remove(propertyChangeEvent.getOldValue());
            this._columnNameMap.put(propertyChangeEvent.getNewValue(), n);
        }
    }

    public String getToolTipText() {
        return this._toolTipText;
    }

    public void setToolTipText(String string) {
        this._toolTipText = string;
    }
}

