/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class TableCellStyleEditor
extends JPanel {
    private TableModel _tableModel;
    private CellStyleEditor _cellStylePanel;
    private CellStyle[] _cellStyles;
    private JList _list;
    private int _selectedIndex = -1;

    public TableCellStyleEditor(TableModel tableModel) {
        this._tableModel = tableModel;
        this._cellStyles = new CellStyle[this._tableModel.getColumnCount()];
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(12, 12));
        this.add(this.createColumnListPanel(), "Before");
        this.add(this.createDefinitionPanel());
        this._cellStylePanel.setVisible(false);
    }

    private Component createColumnListPanel() {
        String[] stringArray = new String[this._tableModel.getColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this._tableModel.getColumnName(i);
        }
        this._list = new JList<String>(stringArray);
        this._list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (TableCellStyleEditor.this._selectedIndex != -1) {
                        ((TableCellStyleEditor)TableCellStyleEditor.this)._cellStyles[((TableCellStyleEditor)TableCellStyleEditor.this)._selectedIndex] = TableCellStyleEditor.this._cellStylePanel.getStyle();
                    }
                    TableCellStyleEditor.this._selectedIndex = TableCellStyleEditor.this._list.getSelectedIndex();
                    if (TableCellStyleEditor.this._selectedIndex != -1) {
                        TableCellStyleEditor.this._cellStylePanel.setStyle(TableCellStyleEditor.this._cellStyles[TableCellStyleEditor.this._selectedIndex]);
                        TableCellStyleEditor.this._cellStylePanel.setVisible(true);
                    }
                }
            }
        });
        return new JScrollPane(this._list);
    }

    private Component createDefinitionPanel() {
        this._cellStylePanel = new CellStyleEditor();
        return this._cellStylePanel;
    }

    public CellStyle[] getCellStyles() {
        int n = this._list.getSelectedIndex();
        if (n != -1) {
            this._cellStyles[n] = this._cellStylePanel.getStyle();
        }
        return this._cellStyles;
    }
}

