/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.spinner.SpinnerWheelSupport;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

public class SpinnerCellEditor
extends ContextSensitiveCellEditor
implements TableCellEditor,
ChangeListener {
    public static EditorContext CONTEXT = new EditorContext("Spinner");
    protected JSpinner _spinner;
    private static final long serialVersionUID = -2261305860140664189L;

    public SpinnerCellEditor() {
        this(new SpinnerNumberModel());
    }

    public SpinnerCellEditor(SpinnerModel spinnerModel) {
        this.setAutoStopCellEditing(false);
        this._spinner = this.createSpinner(spinnerModel);
    }

    protected void customizeSpinner() {
        this._spinner.setOpaque(false);
        this._spinner.setBorder(DEFAULT_CELL_EDITOR_BORDER);
    }

    protected JSpinner createSpinner(SpinnerModel spinnerModel) {
        JSpinner jSpinner = new JSpinner(spinnerModel){

            @Override
            protected JComponent createEditor(SpinnerModel spinnerModel) {
                if (spinnerModel instanceof SpinnerDateModel) {
                    return new JSpinner.DateEditor(this){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            if (SpinnerCellEditor.this.getEditorStyle() != 2) {
                                super.stateChanged(changeEvent);
                            }
                        }
                    };
                }
                if (spinnerModel instanceof SpinnerListModel) {
                    return new JSpinner.ListEditor(this){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            if (SpinnerCellEditor.this.getEditorStyle() != 2) {
                                super.stateChanged(changeEvent);
                            }
                        }
                    };
                }
                if (spinnerModel instanceof SpinnerNumberModel) {
                    return new JSpinner.NumberEditor(this){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            if (SpinnerCellEditor.this.getEditorStyle() != 2) {
                                super.stateChanged(changeEvent);
                            }
                        }
                    };
                }
                return new JSpinner.DefaultEditor(this){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        if (SpinnerCellEditor.this.getEditorStyle() != 2) {
                            super.stateChanged(changeEvent);
                        }
                    }
                };
            }
        };
        SpinnerWheelSupport.installMouseWheelSupport(jSpinner);
        return jSpinner;
    }

    @Override
    public Object getCellEditorValue() {
        try {
            this._spinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this._spinner.getValue();
    }

    public void setCellEditorValue(Object object) {
        this._spinner.setValue(object);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        JFormattedTextField jFormattedTextField;
        if (jTable != null) {
            this.customizeSpinner();
            JideSwingUtilities.installColorsAndFont(this._spinner, jTable.getBackground(), jTable.getForeground(), jTable.getFont());
        }
        this.setCellEditorValue(object);
        if (jTable != null && this.getSpinner() != null) {
            this.getSpinner().addChangeListener(this);
        }
        if (this.getSpinner() != null && this.getSpinner().getEditor() instanceof JSpinner.DefaultEditor && (jFormattedTextField = ((JSpinner.DefaultEditor)this.getSpinner().getEditor()).getTextField()) != null && this.getEditorStyle() != 0) {
            jFormattedTextField.setEditable(this.getEditorStyle() == 3);
        }
        return this._spinner;
    }

    public JSpinner getSpinner() {
        return this._spinner;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.isAutoStopCellEditing() && this.getSpinner() != null) {
            this.getSpinner().removeChangeListener(this);
            this.stopCellEditing();
        }
    }

    @Override
    public boolean isEditorStyleSupported(int n) {
        return true;
    }
}

