/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractGroupTableModel;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.IndexedRowTableModelWrapper;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.WrapperOfIndexdRowTableModelWrapper;
import com.jidesoft.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;

public class SortableTreeTableModel<T extends Row>
extends SortableTableModel
implements ITreeTableModel<T> {
    public static final int SORTABLE_NONE = 0;
    public static final int SORTABLE_ROOT_LEVEL = 1;
    public static final int SORTABLE_LEAF_LEVEL = 2;
    public static final int SORTABLE_NON_ROOT_LEVEL = 4;
    public static final int SORTABLE_NON_LEAF_LEVEL = 8;
    public static final int SORTABLE_ALL_LEVELS = 255;
    private int _defaultSortableOption = 255;
    private int[] _sortableOptions;
    public TableModel _actualTableModel;
    private List<ISortableTableModel.SortItem> _cachedSortingColumns;
    private static final long serialVersionUID = 1560212793146645991L;
    private static final Logger LOGGER_EVENT = Logger.getLogger(SortableTreeTableModel.class.getName());

    public SortableTreeTableModel(TableModel tableModel) {
        super(tableModel);
    }

    @Override
    protected void cacheComparators() {
        this._cachedSortingColumns = new ArrayList<ISortableTableModel.SortItem>();
        this._cachedSortingColumns.addAll(super.getSortingColumns());
        super.cacheComparators();
    }

    @Override
    public List<ISortableTableModel.SortItem> getSortingColumns() {
        if (this._cachedSortingColumns != null && this._cachedSortingColumns.size() > 0) {
            return this._cachedSortingColumns;
        }
        return super.getSortingColumns();
    }

    @Override
    protected void sort() {
        try {
            this._actualTableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
            super.sort();
        }
        finally {
            this._actualTableModel = null;
        }
    }

    @Override
    protected int compare(int n, int n2) {
        if (this._actualTableModel == null) {
            this._actualTableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
            if (this._actualTableModel == null) {
                return super.compare(n, n2);
            }
        }
        if (this._actualTableModel instanceof DefaultGroupTableModel && !((DefaultGroupTableModel)this._actualTableModel).hasGroupColumns()) {
            return super.compare(n, n2);
        }
        List<ISortableTableModel.SortItem> list = this.getSortingColumns();
        for (int i = 0; i < list.size(); ++i) {
            ISortableTableModel.SortItem sortItem = list.get(i);
            int n3 = sortItem.getColumn();
            if (n3 < 0 || n3 >= this.getColumnCount()) continue;
            int n4 = this.compare(n, n2, n3);
            if (n4 == Integer.MAX_VALUE) {
                return 1;
            }
            if (n4 == Integer.MIN_VALUE) {
                return -1;
            }
            if (n4 == 0) continue;
            return sortItem.isAscending() ? n4 : -n4;
        }
        return n < n2 ? -1 : 1;
    }

    @Override
    public int compare(int n, int n2, int n3) {
        if (this._actualTableModel == null) {
            this._actualTableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
            if (this._actualTableModel == null) {
                return super.compare(n, n2, n3);
            }
        }
        if (this._actualTableModel instanceof AbstractGroupTableModel && !((AbstractGroupTableModel)this._actualTableModel).isGroupEnabled()) {
            return super.compare(n, n2, n3);
        }
        int n4 = this.getSortableOption(n3);
        if (n4 == 0) {
            return 0;
        }
        if (!(this._actualTableModel instanceof IExpandableTreeTableModel)) {
            return 0;
        }
        IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)this._actualTableModel);
        Row row = iExpandableTreeTableModel.getRowAt(TableModelWrapperUtils.getActualRowAt(this._model, n, (TableModel)((Object)iExpandableTreeTableModel)));
        Row row2 = iExpandableTreeTableModel.getRowAt(TableModelWrapperUtils.getActualRowAt(this._model, n2, (TableModel)((Object)iExpandableTreeTableModel)));
        return this.compareRow(row, row2, iExpandableTreeTableModel, n4, n3);
    }

    protected boolean shouldCompare(int n, Row row, Row row2, boolean bl, boolean bl2, boolean bl3, int n2) {
        return bl && n == 1 || !bl && n == 4 || bl2 && bl3 && n == 2 || !bl2 && !bl3 && n == 8 || n == 255;
    }

    private int compareRow(Row row, Row row2, IExpandableTreeTableModel iExpandableTreeTableModel, int n, int n2) {
        boolean bl;
        int n3;
        if (row == null && row2 == null) {
            return 0;
        }
        if (row != null && row2 == null) {
            return 1;
        }
        if (row == null) {
            return -1;
        }
        int n4 = row.getLevel();
        if (n4 > (n3 = row2.getLevel())) {
            while (n4 != n3) {
                row = (Row)((Object)row.getParent());
                --n4;
                if (row != row2) continue;
                return Integer.MAX_VALUE;
            }
        } else if (n3 > n4) {
            while (n3 != n4) {
                row2 = (Row)((Object)row2.getParent());
                --n3;
                if (row2 != row) continue;
                return Integer.MIN_VALUE;
            }
        }
        if (row.getParent() != row2.getParent()) {
            return this.compareRow((Row)((Object)row.getParent()), (Row)((Object)row2.getParent()), iExpandableTreeTableModel, n, n2);
        }
        boolean bl2 = !(row instanceof Expandable) || !((Expandable)((Object)row)).hasChildren();
        boolean bl3 = !(row2 instanceof Expandable) || !((Expandable)((Object)row2)).hasChildren();
        boolean bl4 = bl = row.getParent() == iExpandableTreeTableModel.getRoot();
        if (this.shouldCompare(n, row, row2, bl, bl2, bl3, n2)) {
            Object object = this.getValueAt(row, n2);
            Object object2 = this.getValueAt(row2, n2);
            return this.compare(object, object2, n2);
        }
        return 0;
    }

    protected Object getValueAt(Row row, int n) {
        int n2;
        if (row == null) {
            return null;
        }
        int n3 = TableModelWrapperUtils.getActualColumnAt((TableModel)this, n, IExpandableTreeTableModel.class);
        if (n3 >= 0) {
            return row.getValueAt(n3);
        }
        if (this.getActualModel() instanceof ITreeTableModel && (n2 = ((ITreeTableModel)((Object)this.getActualModel())).getRowIndex(row)) >= 0 && n2 < this.getActualModel().getRowCount()) {
            return this.getActualModel().getValueAt(n2, n);
        }
        return null;
    }

    public int getDefaultSortableOption() {
        return this._defaultSortableOption;
    }

    public void setDefaultSortableOption(int n) {
        this._defaultSortableOption = n;
    }

    public void setSortableOption(int n, int n2) {
        if (this._sortableOptions == null || this._sortableOptions.length != this.getActualModel().getColumnCount()) {
            this._sortableOptions = new int[this.getActualModel().getColumnCount()];
            Arrays.fill(this._sortableOptions, -1);
        }
        if (this._sortableOptions != null && n >= 0 && n < this._sortableOptions.length) {
            this._sortableOptions[n] = n2;
        }
    }

    public int getSortableOption(int n) {
        if (this._sortableOptions != null && n >= 0 && n < this._sortableOptions.length) {
            int n2 = this._sortableOptions[n];
            if (n2 == -1) {
                return this.getDefaultSortableOption();
            }
            return n2;
        }
        return this.getDefaultSortableOption();
    }

    @Override
    protected int[] append(int n, int n2) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
        TableModel tableModel2 = TableModelWrapperUtils.getNextInnerTableModel(this);
        if (tableModel instanceof IExpandableTreeTableModel) {
            int n3;
            if (this._indexes == null) {
                return new int[]{n, n2};
            }
            Row row = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(TableModelWrapperUtils.getActualRowAt(tableModel2, n, IExpandableTreeTableModel.class));
            while (row == null && n < n2) {
                if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                    LOGGER_EVENT.fine("SortableTreeTableModel \" append() get invalid row index input " + n + ", " + n2 + ".");
                }
                row = ((IExpandableTreeTableModel)((Object)tableModel)).getRowAt(TableModelWrapperUtils.getActualRowAt(tableModel2, ++n, IExpandableTreeTableModel.class));
            }
            if (row == null) {
                if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                    LOGGER_EVENT.fine("SortableTreeTableModel \" append() have to return null array because the row is null.");
                }
                return new int[0];
            }
            Row row2 = (Row)((Object)row.getParent());
            if (row2 == null) {
                if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                    LOGGER_EVENT.fine("SortableTreeTableModel \" append() have to return null array because the parent is null.");
                }
                return new int[0];
            }
            int n4 = this.getRowIndex(row2);
            int n5 = n2 - n + 1;
            int n6 = n4 >= 0 && n4 < this.getRowCount() ? ("true".equals(SecurityUtils.getProperty("jide.sortableTableModel.append", "true")) ? n4 + TableModelWrapperUtils.getVisibleChildrenCount(this.getActualModel(), row2) - n5 + 1 : n4 + 1) : this.getRowCount();
            for (int i = 0; i < this._indexes.length; ++i) {
                n3 = this._indexes[i];
                if (n3 < n) continue;
                this._indexes[i] = n3 + n5;
            }
            int[] nArray = (int[])this._indexes.clone();
            this._indexes = new int[nArray.length + n5];
            System.arraycopy(nArray, 0, this._indexes, 0, n6);
            for (n3 = 0; n3 < n5; ++n3) {
                this._indexes[n6 + n3] = n + n3;
            }
            System.arraycopy(nArray, n6, this._indexes, n6 + n5, nArray.length - n6);
            return new int[]{n6, n6 + n5 - 1};
        }
        return super.append(n, n2);
    }

    @Override
    public Row getRowAt(int n) {
        IndexedRowTableModelWrapper indexedRowTableModelWrapper;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._model, ITreeTableModel.class);
        if (!(tableModel instanceof ITreeTableModel)) {
            return null;
        }
        ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
        int n2 = TableModelWrapperUtils.getActualRowAt((TableModel)this, n, tableModel);
        if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            n2 = indexedRowTableModelWrapper.getActualRowAt(n2);
        }
        return iTreeTableModel.getRowAt(n2);
    }

    @Override
    public int getRowIndex(T t) {
        IndexedRowTableModelWrapper indexedRowTableModelWrapper;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._model, ITreeTableModel.class);
        if (!(tableModel instanceof ITreeTableModel)) {
            return -1;
        }
        ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
        int n = iTreeTableModel.getRowIndex(t);
        if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            n = indexedRowTableModelWrapper.getVisualRowAt(n);
        }
        return this.getVisualRowAt(n);
    }

    @Override
    public Object getRoot() {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._model, ITreeTableModel.class);
        if (!(tableModel instanceof ITreeTableModel)) {
            return -1;
        }
        ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
        return iTreeTableModel.getRoot();
    }
}

