/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.SortEvent;
import com.jidesoft.grid.SortListener;
import com.jidesoft.grid.SortableTableHeader;
import com.jidesoft.grid.SortableTableHeaderMouseListener;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortableTable
extends CategorizedTable
implements SortListener {
    private boolean _init;
    private boolean _sortable = true;
    private boolean _showSortOrderNumber = true;
    public static final String SORTABLE_PROPERTY = "sortable";
    public static final String PROPERTY_SHOW_SORT_ORDER_NUMBER = "showSortOrderNumber";
    public static final String MULTICOLUMN_SORTABLE_PROPERTY = "multicolumn_sortable";
    private Color _sortArrowForeground;
    private Color _sortOrderForeground;
    private boolean _sortingEnabled = true;
    private SortableTableHeaderMouseListener _headerMouseListener;
    private boolean _preserveSelectionsAfterSorting = true;
    private boolean _ensureSelectedRowVisibleOnTogglingSort = true;
    private Color _arrowColor = null;
    private Icon _enabledAscendingImageIcon = null;
    private Icon _disabledAscendingImageIcon = null;
    private Icon _enabledDescendingImageIcon = null;
    private Icon _disabledDescendingImageIcon = null;
    private TableModel _selfCreatedSortableTableModel = null;

    public SortableTable() {
        this.internalSetSortable(this._sortable);
        this.initializeTable();
    }

    public SortableTable(TableModel tableModel) {
        super(tableModel);
        this.internalSetSortable(this._sortable);
        this.initializeTable();
    }

    public SortableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.internalSetSortable(this._sortable);
        this.initializeTable();
    }

    public SortableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.internalSetSortable(this._sortable);
        this.initializeTable();
    }

    public SortableTable(int n, int n2) {
        super(n, n2);
        this.internalSetSortable(this._sortable);
        this.initializeTable();
    }

    public SortableTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.internalSetSortable(this._sortable);
        this.initializeTable();
    }

    public SortableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.internalSetSortable(this._sortable);
        this.initializeTable();
    }

    private void initializeTable() {
        if (!this._init) {
            this._headerMouseListener = this.createSortableTableHeaderMouseListener();
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("model".equals(propertyChangeEvent.getPropertyName())) {
                        if (propertyChangeEvent.getOldValue() == propertyChangeEvent.getNewValue()) {
                            return;
                        }
                        if (propertyChangeEvent.getOldValue() instanceof SortableTableModel) {
                            ((SortableTableModel)propertyChangeEvent.getOldValue()).removeSortListener(SortableTable.this);
                        }
                        if (propertyChangeEvent.getNewValue() instanceof SortableTableModel) {
                            ((SortableTableModel)propertyChangeEvent.getNewValue()).addSortListener(SortableTable.this);
                        }
                    }
                }
            };
            this.addPropertyChangeListener("model", propertyChangeListener);
            this._init = true;
        }
    }

    protected SortableTableHeaderMouseListener createSortableTableHeaderMouseListener() {
        return new SortableTableHeaderMouseListener();
    }

    public SortableTableHeaderMouseListener getSortableHeaderMouseListener() {
        return this._headerMouseListener;
    }

    public boolean isMultiColumnSortable() {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        return iSortableTableModel == null || iSortableTableModel.isMultiColumnSortable();
    }

    public void setMultiColumnSortable(boolean bl) {
        boolean bl2 = this.isMultiColumnSortable();
        if (bl2 == bl) {
            return;
        }
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        if (iSortableTableModel != null) {
            iSortableTableModel.setMultiColumnSortable(bl);
            this.firePropertyChange(MULTICOLUMN_SORTABLE_PROPERTY, bl2, this.isMultiColumnSortable());
        }
    }

    public boolean isSortable() {
        return this._sortable;
    }

    public void setSortable(boolean bl) {
        boolean bl2 = this._sortable;
        if (bl2 == bl) {
            return;
        }
        this.internalSetSortable(bl);
        this.firePropertyChange(SORTABLE_PROPERTY, (Object)bl2, (Object)this._sortable);
    }

    public boolean isShowSortOrderNumber() {
        return this._showSortOrderNumber;
    }

    public void setShowSortOrderNumber(boolean bl) {
        boolean bl2 = this._showSortOrderNumber;
        if (bl2 != bl) {
            this._showSortOrderNumber = bl;
            this.firePropertyChange(PROPERTY_SHOW_SORT_ORDER_NUMBER, bl2, this._showSortOrderNumber);
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader != null) {
                jTableHeader.repaint();
            }
        }
    }

    private void internalSetSortable(boolean bl) {
        this._sortable = bl;
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        if (this._sortable && iSortableTableModel == null) {
            this.setModel(this.getModel());
        } else if (!this._sortable && iSortableTableModel != null) {
            if (this.getModel() instanceof ISortableTableModel) {
                ((ISortableTableModel)this.getModel()).removeSortListener(this);
                if (this.getModel() instanceof TableModelWrapper) {
                    super.setModel(((TableModelWrapper)((Object)this.getModel())).getActualModel());
                }
            } else {
                ISortableTableModel iSortableTableModel2 = (ISortableTableModel)TableModelWrapperUtils.getActualTableModel(this.getModel(), ISortableTableModel.class);
                if (iSortableTableModel2 != null) {
                    iSortableTableModel2.setSortable(bl);
                }
            }
        } else if (this._sortable) {
            iSortableTableModel.addSortListener(this);
        }
    }

    protected ISortableTableModel createSortableTableModel(TableModel tableModel) {
        return new SortableTableModel(tableModel);
    }

    @Override
    public void sortChanging(SortEvent sortEvent) {
    }

    @Override
    public void sortChanged(SortEvent sortEvent) {
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    protected boolean isReusable(ISortableTableModel iSortableTableModel, TableModel tableModel) {
        return true;
    }

    @Override
    public void setModel(TableModel tableModel) {
        ISortableTableModel iSortableTableModel = null;
        if (this._selfCreatedSortableTableModel != null && (iSortableTableModel = this.getSortableTableModel()) instanceof TableModelWrapperImpl && !TableModelWrapperUtils.isActualTableModel(iSortableTableModel, tableModel) && !TableModelWrapperUtils.isActualTableModel(tableModel, iSortableTableModel)) {
            ((TableModelWrapperImpl)((Object)iSortableTableModel)).setActualModel(null, false);
        }
        if (this.isSortable()) {
            ISortableTableModel iSortableTableModel2 = SortableTableModel.getSortableModel(tableModel);
            if (iSortableTableModel2 == null) {
                if (iSortableTableModel instanceof TableModelWrapperImpl && this.isReusable(iSortableTableModel, tableModel)) {
                    ((TableModelWrapperImpl)((Object)iSortableTableModel)).setActualModel(tableModel, false);
                } else {
                    this._selfCreatedSortableTableModel = null;
                    iSortableTableModel2 = this.createSortableTableModel(tableModel);
                    this._selfCreatedSortableTableModel = iSortableTableModel2;
                    super.setModel(iSortableTableModel2);
                }
            } else {
                super.setModel(tableModel);
            }
            if (iSortableTableModel2 != null) {
                iSortableTableModel2.removeSortListener(this);
                iSortableTableModel2.addSortListener(this);
            }
        } else {
            super.setModel(tableModel);
        }
    }

    public void sortColumn(String string) {
        this.sortColumn(string, true, true);
    }

    public void sortColumn(String string, boolean bl) {
        this.sortColumn(string, bl, true);
    }

    public void sortColumn(String string, boolean bl, boolean bl2) {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                if (!tableModel.getColumnName(i).equals(string)) continue;
                this.sortColumn(i, bl, bl2);
                break;
            }
        }
    }

    public void unsort() {
        ISortableTableModel iSortableTableModel;
        if (this.isEditing()) {
            this.removeEditor();
        }
        if ((iSortableTableModel = this.getSortableTableModel()) != null) {
            iSortableTableModel.reset();
        }
    }

    public void sortColumn(int n) {
        this.sortColumn(n, true);
    }

    public void sortColumn(int n, boolean bl) {
        this.sortColumn(n, bl, true);
    }

    public void sortColumn(int n, boolean bl, boolean bl2) {
        ISortableTableModel iSortableTableModel;
        if (this.isEditing()) {
            this.removeEditor();
        }
        if ((iSortableTableModel = this.getSortableTableModel()) != null) {
            iSortableTableModel.sortColumn(n, bl, bl2);
        }
    }

    public int getActualRowAt(int n) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ISortableTableModel) {
            return ((ISortableTableModel)tableModel).getActualRowAt(n);
        }
        return n;
    }

    public int getSortedRowAt(int n) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ISortableTableModel) {
            return ((ISortableTableModel)tableModel).getSortedRowAt(n);
        }
        return n;
    }

    protected ISortableTableModel getSortableTableModel() {
        return SortableTableModel.getSortableModel(this.getModel());
    }

    public boolean isOptimized() {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        return iSortableTableModel instanceof SortableTableModel && ((SortableTableModel)iSortableTableModel).isOptimized();
    }

    public void setOptimized(boolean bl) {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        if (iSortableTableModel instanceof SortableTableModel) {
            ((SortableTableModel)iSortableTableModel).setOptimized(bl);
        }
    }

    public boolean isAutoResort() {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        return iSortableTableModel instanceof SortableTableModel && ((SortableTableModel)iSortableTableModel).isAutoResort();
    }

    public void setAutoResort(boolean bl) {
        ISortableTableModel iSortableTableModel = this.getSortableTableModel();
        if (iSortableTableModel instanceof SortableTableModel) {
            ((SortableTableModel)iSortableTableModel).setAutoResort(bl);
        }
    }

    public void resort() {
        this.getSortableTableModel().resort();
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        if (this.isNestedTableHeader()) {
            return new NestedTableHeader(this);
        }
        return new SortableTableHeader(this.getColumnModel());
    }

    public Color getSortArrowForeground() {
        return this._sortArrowForeground;
    }

    public void setSortArrowForeground(Color color) {
        this._sortArrowForeground = color;
        if (this.getTableHeader() != null) {
            this.getTableHeader().invalidate();
            this.getTableHeader().repaint();
        }
    }

    public Color getSortOrderForeground() {
        return this._sortOrderForeground;
    }

    public void setSortOrderForeground(Color color) {
        this._sortOrderForeground = color;
        if (this.getTableHeader() != null) {
            this.getTableHeader().invalidate();
            this.getTableHeader().repaint();
        }
    }

    public boolean isSortingEnabled() {
        return this._sortingEnabled;
    }

    public void setSortingEnabled(boolean bl) {
        this._sortingEnabled = bl;
    }

    @Deprecated
    public boolean isPreserveSelectionsAfterSorting() {
        return this._preserveSelectionsAfterSorting;
    }

    @Deprecated
    public void setPreserveSelectionsAfterSorting(boolean bl) {
        this._preserveSelectionsAfterSorting = bl;
    }

    public Icon createSortIcon(boolean bl) {
        Icon icon = bl ? this.getAscendingIcon() : this.getDescendingIcon();
        if (icon instanceof UIResource) {
            return icon;
        }
        if (this.isEnabled()) {
            Color color;
            Color color2 = color = this.getSortArrowForeground() != null ? this.getSortArrowForeground() : UIDefaultsLookup.getColor("controlDkShadow");
            if (this._arrowColor != color) {
                this._enabledAscendingImageIcon = null;
                this._enabledDescendingImageIcon = null;
            }
            if (bl) {
                if (this._enabledAscendingImageIcon == null) {
                    this._enabledAscendingImageIcon = icon.equals(CategorizedTable.DEFAULT_ASCENDING_ICON) ? new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)) : icon;
                    this._arrowColor = color;
                }
                return this._enabledAscendingImageIcon;
            }
            if (this._enabledDescendingImageIcon == null) {
                this._enabledDescendingImageIcon = icon.equals(CategorizedTable.DEFAULT_DESCENDING_ICON) ? new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)) : icon;
                this._arrowColor = color;
            }
            return this._enabledDescendingImageIcon;
        }
        Color color = UIDefaultsLookup.getColor("controlShadow");
        if (bl) {
            if (this._disabledAscendingImageIcon == null) {
                this._disabledAscendingImageIcon = icon.equals(CategorizedTable.DEFAULT_ASCENDING_ICON) ? new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)) : icon;
            }
            return this._disabledAscendingImageIcon;
        }
        if (this._disabledDescendingImageIcon == null) {
            this._disabledDescendingImageIcon = icon.equals(CategorizedTable.DEFAULT_DESCENDING_ICON) ? new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)) : icon;
        }
        return this._disabledDescendingImageIcon;
    }

    public boolean isEnsureSelectedRowVisibleOnTogglingSort() {
        return this._ensureSelectedRowVisibleOnTogglingSort;
    }

    public void setEnsureSelectedRowVisibleOnTogglingSort(boolean bl) {
        this._ensureSelectedRowVisibleOnTogglingSort = bl;
    }
}

