/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.AbstractCalculatedColumn;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.GroupableTableModel;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.grouper.GrouperContext;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.grouper.ObjectGrouperManager;
import javax.swing.table.TableModel;

public class SingleColumn
extends AbstractCalculatedColumn {
    private static final long serialVersionUID = -4744312852166873520L;
    private int _columnIndex;

    public SingleColumn(TableModel tableModel, int n) {
        super(tableModel);
        this.setColumnIndex(n);
    }

    public SingleColumn(TableModel tableModel, String string) {
        super(tableModel);
        this.setColumnIndex(TableUtils.findColumnIndex(tableModel, string));
        if (this.getColumnIndex() == -1) {
            throw new IllegalArgumentException("There is no column in the table model that has the name \"" + string + "\"");
        }
    }

    public SingleColumn(TableModel tableModel, String string, String string2) {
        super(tableModel, string2);
        this.setColumnIndex(TableUtils.findColumnIndex(tableModel, string));
        if (this.getColumnIndex() == -1) {
            throw new IllegalArgumentException("There is no column in the table model that has the name \"" + string + "\"");
        }
    }

    public SingleColumn(TableModel tableModel, int n, String string) {
        super(tableModel, string);
        this.setColumnIndex(n);
    }

    public SingleColumn(TableModel tableModel, int n, String string, Class<?> clazz) {
        super(tableModel, string, clazz);
        this.setColumnIndex(n);
    }

    public SingleColumn(TableModel tableModel, String string, String string2, Class<?> clazz) {
        super(tableModel, string2, clazz);
        int n = TableUtils.findColumnIndex(tableModel, string);
        if (n == -1) {
            throw new IllegalArgumentException("There is no column in the table model that has the name \"" + string + "\"");
        }
        this.setColumnIndex(n);
    }

    public SingleColumn(TableModel tableModel, int n, ObjectGrouper objectGrouper) {
        super(tableModel, objectGrouper);
        this.setColumnIndex(n);
    }

    public SingleColumn(TableModel tableModel, int n, String string, ObjectGrouper objectGrouper) {
        super(tableModel, string, objectGrouper);
        this.setColumnIndex(n);
    }

    public SingleColumn(TableModel tableModel, String string, ObjectGrouper objectGrouper) {
        super(tableModel, objectGrouper);
        int n = TableUtils.findColumnIndex(tableModel, string);
        if (n == -1) {
            throw new IllegalArgumentException("There is no column in the table model that has the name \"" + string + "\"");
        }
        this.setColumnIndex(n);
    }

    public SingleColumn(TableModel tableModel, String string, String string2, ObjectGrouper objectGrouper) {
        super(tableModel, string2, objectGrouper);
        int n = TableUtils.findColumnIndex(tableModel, string);
        if (n == -1) {
            throw new IllegalArgumentException("There is no column in the table model that has the name \"" + string + "\"");
        }
        this.setColumnIndex(n);
    }

    public int getColumnIndex() {
        return this._columnIndex;
    }

    public void setColumnIndex(int n) {
        Object object;
        if (n == -1) {
            throw new IllegalArgumentException("columnIndex cannot be -1");
        }
        this._columnIndex = n;
        if (this.getObjectGrouper() == null && this.getActualModel() instanceof GroupableTableModel && (object = ((GroupableTableModel)this.getActualModel()).getGrouperContext(n)) != null) {
            this.setObjectGrouper(ObjectGrouperManager.getGrouper(this.getColumnClass(), (GrouperContext)object));
        }
        if (this.getObjectGrouper() == null) {
            if (this.getActualModel() instanceof ContextSensitiveTableModel) {
                object = ((ContextSensitiveTableModel)this.getActualModel()).getConverterContextAt(-1, n);
                EditorContext editorContext = ((ContextSensitiveTableModel)this.getActualModel()).getEditorContextAt(-1, n);
                this.setConverterContext((ConverterContext)object);
                this.setEditorContext(editorContext);
            } else {
                this.setConverterContext(null);
                this.setEditorContext(null);
            }
            this.setColumnClass(this.getActualModel().getColumnClass(n));
            if (this.getColumnName() == null) {
                this.setColumnName(this.getActualModel().getColumnName(n));
            }
        } else {
            object = this.getObjectGrouper();
            this.setConverterContext(object.getConverterContext());
            this.setColumnClass(object.getType());
            if (this.getColumnName() == null) {
                this.setColumnName(this.getActualModel().getColumnName(n) + (this.getObjectGrouper() == null ? "" : " (" + this.getObjectGrouper().getName() + ")"));
            }
        }
    }

    @Override
    public void setObjectGrouper(ObjectGrouper objectGrouper) {
        super.setObjectGrouper(objectGrouper);
        if (objectGrouper != null) {
            this.setConverterContext(objectGrouper.getConverterContext());
            this.setColumnClass(objectGrouper.getType());
            if (this.getColumnName() == null) {
                this.setColumnName(this.getActualModel().getColumnName(this.getColumnIndex()) + (this.getObjectGrouper() == null ? "" : " (" + this.getObjectGrouper().getName() + ")"));
            }
        }
    }

    @Override
    public Object getValueAt(int n) {
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        if (objectGrouper == null) {
            return this.getActualModel().getValueAt(n, this.getColumnIndex());
        }
        return SingleColumn.getGroupValue(objectGrouper, this.getActualModel().getValueAt(n, this.getColumnIndex()));
    }

    public void setValueAt(Object object, int n) {
        if (this.getObjectGrouper() == null) {
            this.getActualModel().setValueAt(object, n, this.getColumnIndex());
        }
    }

    public boolean isCellEditable(int n) {
        return this.getObjectGrouper() == null && this.getActualModel().isCellEditable(n, this.getColumnIndex());
    }

    @Override
    public int[] getDependingColumns() {
        return new int[]{this.getColumnIndex()};
    }

    @Override
    public Class<?> getCellClass(int n) {
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        if (objectGrouper != null) {
            return objectGrouper.getType();
        }
        TableModel tableModel = this.getActualModel();
        if (tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)tableModel).getCellClassAt(n, this.getColumnIndex());
        }
        return super.getCellClass(n);
    }

    @Override
    public ConverterContext getConverterContext(int n) {
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        if (objectGrouper != null) {
            return objectGrouper.getConverterContext();
        }
        TableModel tableModel = this.getActualModel();
        if (tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)tableModel).getConverterContextAt(n, this.getColumnIndex());
        }
        return super.getConverterContext(n);
    }

    @Override
    public EditorContext getEditorContext(int n) {
        TableModel tableModel = this.getActualModel();
        if (tableModel instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)tableModel).getEditorContextAt(n, this.getColumnIndex());
        }
        return super.getEditorContext(n);
    }
}

