/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SummaryGroupRow;
import com.jidesoft.grid.TreeTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class RootExpandableRow
extends DefaultExpandableRow {
    private IExpandableTreeTableModel _treeTableModel;

    public RootExpandableRow(IExpandableTreeTableModel iExpandableTreeTableModel) {
        this._treeTableModel = iExpandableTreeTableModel;
    }

    @Override
    public Object getValueAt(int n) {
        return null;
    }

    @Override
    public int getLevel() {
        return -1;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public boolean isExpanded() {
        return true;
    }

    @Override
    public Expandable getParent() {
        return null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public void notifyChildInserted(Object object, int n) {
        if (!this._treeTableModel.isAdjusting()) {
            if (n < 0 || n > this._treeTableModel.getRows(false).size()) {
                n = this._treeTableModel.getRows(false).size();
            }
            if (n >= 0) {
                if (object instanceof ExpandableRow && ((ExpandableRow)object).isExpanded()) {
                    ArrayList arrayList = new ArrayList();
                    if (this._treeTableModel instanceof TreeTableModel) {
                        ((TreeTableModel)this._treeTableModel).add(arrayList, (ExpandableRow)object);
                    } else {
                        this.add(arrayList, (ExpandableRow)object);
                    }
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        Row row = (Row)arrayList.get(i);
                        this._treeTableModel.getRows(false).add(n, row);
                    }
                    if (this._treeTableModel instanceof AbstractTableModel) {
                        ((AbstractTableModel)((Object)this._treeTableModel)).fireTableRowsInserted(n, n + arrayList.size() - 1);
                    }
                } else {
                    this._treeTableModel.getRows(false).add(n, object);
                    if (this._treeTableModel instanceof AbstractTableModel) {
                        ((AbstractTableModel)((Object)this._treeTableModel)).fireTableRowsInserted(n, n);
                    }
                }
            }
        }
    }

    private void add(List list, ExpandableRow expandableRow) {
        list.add(expandableRow);
        if (expandableRow.isExpanded() && expandableRow.hasChildren()) {
            int n = this._treeTableModel.getChildCount(expandableRow);
            for (int i = 0; i < n; ++i) {
                Row row = (Row)this._treeTableModel.getChild(expandableRow, i);
                if (row == null || this._treeTableModel instanceof TreeTableModel && ((TreeTableModel)this._treeTableModel).shouldBeFiltered(row)) continue;
                if (row instanceof ExpandableRow) {
                    this.add(list, (ExpandableRow)row);
                    continue;
                }
                list.add(row);
            }
        }
    }

    @Override
    public void notifyChildrenInserted(List list, int n) {
        if (this._treeTableModel.isAdjusting() || list == null || list.size() <= 0) {
            return;
        }
        if (n < 0 || n > this._treeTableModel.getRows(false).size()) {
            n = this._treeTableModel.getRows(false).size();
        }
        int n2 = n;
        int n3 = 0;
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof ExpandableRow) || !((ExpandableRow)e).isExpanded()) continue;
            for (int j = i - 1; j >= n3; --j) {
                this._treeTableModel.getRows(false).add(n2, list.get(j));
            }
            n2 += i - n3;
            n3 = i + 1;
            ArrayList arrayList = new ArrayList();
            if (this._treeTableModel instanceof TreeTableModel) {
                ((TreeTableModel)this._treeTableModel).add(arrayList, (ExpandableRow)e);
            } else {
                this.add(arrayList, (ExpandableRow)e);
            }
            for (int j = arrayList.size() - 1; j >= 0; --j) {
                Row row = (Row)arrayList.get(j);
                this._treeTableModel.getRows(false).add(n2, row);
            }
            n2 += arrayList.size();
        }
        if (n3 == 0) {
            this._treeTableModel.getRows(false).addAll(n, list);
        } else {
            for (int i = list.size() - 1; i >= n3; --i) {
                this._treeTableModel.getRows(false).add(n2, list.get(i));
            }
        }
        if (this._treeTableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)((Object)this._treeTableModel)).fireTableRowsInserted(n, n2 + list.size() - 1 - n3);
        }
    }

    @Override
    public void notifyChildDeleted(Object object) {
        int n;
        if (!this._treeTableModel.isAdjusting() && (n = this._treeTableModel.getRowIndex((Row)object)) != -1) {
            int n2 = this.deleteRowInTableModel((Row)object, n);
            if (this._treeTableModel instanceof AbstractTableModel) {
                ((AbstractTableModel)((Object)this._treeTableModel)).fireTableRowsDeleted(n, n + n2 - 1);
            }
        }
    }

    @Override
    public void notifyChildrenDeleted(List<? extends Row> list) {
        if (this._treeTableModel.isAdjusting() || list == null || list.size() <= 0) {
            return;
        }
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                if (!(object instanceof Row) && !(object2 instanceof Row)) {
                    return 0;
                }
                if (!(object instanceof Row)) {
                    return -1;
                }
                if (!(object2 instanceof Row)) {
                    return 1;
                }
                int n2 = RootExpandableRow.this._treeTableModel.getRowIndex((Row)object);
                if (n2 < (n = RootExpandableRow.this._treeTableModel.getRowIndex((Row)object2))) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }
        });
        List<Object> list2 = Arrays.asList(objectArray);
        int n = 0;
        while (n < list2.size()) {
            Object object;
            Object object2 = list2.get(n);
            if (!(object2 instanceof Row)) continue;
            int n2 = this._treeTableModel.getRowIndex((Row)object2);
            if (n2 < 0) {
                ++n;
                continue;
            }
            int n3 = this.deleteRowInTableModel((Row)object2, n2);
            ++n;
            while (n < list2.size() && n2 < ((TableModel)((Object)this._treeTableModel)).getRowCount() && (object = list2.get(n)) instanceof Row && object == this._treeTableModel.getRowAt(n2)) {
                n3 += this.deleteRowInTableModel((Row)object, n2);
                ++n;
            }
            if (!(this._treeTableModel instanceof AbstractTableModel)) continue;
            ((AbstractTableModel)((Object)this._treeTableModel)).fireTableRowsDeleted(n2, n2 + n3 - 1);
        }
    }

    private int deleteRowInTableModel(Row row, int n) {
        int n2;
        if (row instanceof ExpandableRow && ((ExpandableRow)row).isExpanded()) {
            int n3 = ((Expandable)((Object)row)).getNumberOfVisibleExpandable();
            for (int i = 0; i < n3; ++i) {
                this._treeTableModel.getRows(false).remove(n);
            }
            n2 = n3;
        } else {
            this._treeTableModel.getRows(false).remove(n);
            n2 = 1;
        }
        return n2;
    }

    @Override
    public void notifyChildUpdated(Object object) {
        int n;
        if (!this._treeTableModel.isAdjusting() && (n = this._treeTableModel.getRowIndex((Row)object)) != -1 && this._treeTableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)((Object)this._treeTableModel)).fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public void notifyChildrenUpdated(List<? extends Row> list) {
        if (this._treeTableModel.isAdjusting() || list == null || list.size() <= 0) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            Row row;
            Row row2 = list.get(n);
            int n2 = this._treeTableModel.getRowIndex(row2);
            if (n2 < 0) {
                ++n;
                continue;
            }
            int n3 = 0;
            ++n;
            ++n3;
            while (n < list.size() && n2 < ((TableModel)((Object)this._treeTableModel)).getRowCount() && (row = list.get(n)) == this._treeTableModel.getRowAt(n2 + n3)) {
                ++n;
            }
            if (!(this._treeTableModel instanceof AbstractTableModel)) continue;
            ((AbstractTableModel)((Object)this._treeTableModel)).fireTableRowsUpdated(n2, n2 + n3 - 1);
        }
    }

    @Override
    public void notifyCellUpdated(Object object, int n) {
        int n2;
        if (!this._treeTableModel.isAdjusting() && (n2 = this._treeTableModel.getRowIndex((Row)object)) != -1 && this._treeTableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)((Object)this._treeTableModel)).fireTableCellUpdated(n2, n);
        }
    }

    @Override
    public IExpandableTreeTableModel getExpandableTreeTableModel() {
        return this._treeTableModel;
    }

    public void invalidateSummaryCache() {
        int n = this.getChildrenCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getChildAt(i);
            if (!(object instanceof SummaryGroupRow)) continue;
            ((SummaryGroupRow)object).invalidateSummaryCache();
        }
    }
}

