/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellEditingSupport;
import com.jidesoft.grid.CellRolloverSupport;
import com.jidesoft.grid.JideTable;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class RolloverTableUtils {
    public static final String CLIENT_PROPERTY_ROLLOVER_AUTO_CELL_ACTION = "RolloverTableUtils.autoCellAction";
    public static final String CLIENT_PROPERTY_ROLLOVER_MOUSE_LISTENER = "RolloverTableUtils.rolloverMouseListener";
    public static final String CLIENT_PROPERTY_ROLLOVER_COLUMN_MODEL_LISTENER = "RolloverTableUtils.rolloverColumnModelListener";
    public static final String CLIENT_PROPERTY_ROLLOVER_PROPERTY_CHANGE_LISTENER = "RolloverTableUtils.rolloverPropertyChangeListener";

    public static void install(JTable jTable) {
        RolloverTableUtils.install(jTable, null);
    }

    public static void install(final JTable jTable, final AutoCellAction autoCellAction) {
        RolloverTableUtils.uninstall(jTable);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
                if (n >= 0) {
                    int n3;
                    boolean[] blArray = RolloverTableUtils.getCellAction(jTable, mouseEvent, n, n2, autoCellAction);
                    boolean bl = blArray[0];
                    boolean bl2 = blArray[1];
                    int n4 = jTable instanceof JideTable ? ((JideTable)jTable).getRolloverRow() : jTable.getEditingRow();
                    int n5 = n3 = jTable instanceof JideTable ? ((JideTable)jTable).getRolloverColumn() : jTable.getEditingColumn();
                    if (bl || bl2) {
                        if (n4 != n || n3 != n2) {
                            if (jTable instanceof JideTable && bl2) {
                                ((JideTable)jTable).rolloverCellAt(n, n2);
                            } else if (jTable.isCellEditable(n, n2)) {
                                jTable.editCellAt(n, n2);
                            }
                        }
                    } else {
                        RolloverTableUtils.cancelRollover(mouseEvent, jTable, autoCellAction);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }
        };
        jTable.addMouseListener(mouseInputAdapter);
        jTable.addMouseMotionListener(mouseInputAdapter);
        final TableColumnModelListener tableColumnModelListener = new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                RolloverTableUtils.cancelRollover(null, jTable, autoCellAction);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                RolloverTableUtils.cancelRollover(null, jTable, autoCellAction);
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                RolloverTableUtils.cancelRollover(null, jTable, autoCellAction);
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                RolloverTableUtils.cancelRollover(null, jTable, autoCellAction);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                RolloverTableUtils.cancelRollover(null, jTable, autoCellAction);
            }
        };
        jTable.getColumnModel().addColumnModelListener(tableColumnModelListener);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getOldValue() instanceof TableColumnModel) {
                    ((TableColumnModel)propertyChangeEvent.getOldValue()).removeColumnModelListener(tableColumnModelListener);
                }
                if (propertyChangeEvent.getNewValue() instanceof TableColumnModel) {
                    ((TableColumnModel)propertyChangeEvent.getNewValue()).addColumnModelListener(tableColumnModelListener);
                }
            }
        };
        jTable.addPropertyChangeListener("columnModel", propertyChangeListener);
        jTable.putClientProperty(CLIENT_PROPERTY_ROLLOVER_MOUSE_LISTENER, mouseInputAdapter);
        jTable.putClientProperty(CLIENT_PROPERTY_ROLLOVER_COLUMN_MODEL_LISTENER, tableColumnModelListener);
        jTable.putClientProperty(CLIENT_PROPERTY_ROLLOVER_PROPERTY_CHANGE_LISTENER, propertyChangeListener);
        jTable.putClientProperty(CLIENT_PROPERTY_ROLLOVER_AUTO_CELL_ACTION, autoCellAction);
    }

    private static void cancelRollover(MouseEvent mouseEvent, JTable jTable, AutoCellAction autoCellAction) {
        if (jTable instanceof JideTable ? ((JideTable)jTable).isRollover() : jTable.isEditing()) {
            int n = jTable instanceof JideTable ? ((JideTable)jTable).getRolloverRow() : jTable.getEditingRow();
            int n2 = jTable instanceof JideTable ? ((JideTable)jTable).getRolloverColumn() : jTable.getEditingColumn();
            boolean[] blArray = RolloverTableUtils.getCellAction(jTable, mouseEvent, n, n2, autoCellAction);
            if (jTable instanceof JideTable && blArray[1]) {
                ((JideTable)jTable).removeRolloverEditor();
            } else if (blArray[0]) {
                jTable.getCellEditor().stopCellEditing();
            }
        }
    }

    public static void cancelRollover(JTable jTable, MouseEvent mouseEvent) {
        if (jTable instanceof JideTable ? ((JideTable)jTable).isRollover() : jTable.isEditing()) {
            int n = jTable instanceof JideTable ? ((JideTable)jTable).getRolloverRow() : jTable.getEditingRow();
            int n2 = jTable instanceof JideTable ? ((JideTable)jTable).getRolloverColumn() : jTable.getEditingColumn();
            AutoCellAction autoCellAction = (AutoCellAction)jTable.getClientProperty(CLIENT_PROPERTY_ROLLOVER_AUTO_CELL_ACTION);
            boolean[] blArray = RolloverTableUtils.getCellAction(jTable, mouseEvent, n, n2, autoCellAction);
            if (jTable instanceof JideTable && blArray[1]) {
                ((JideTable)jTable).removeRolloverEditor();
            } else if (blArray[0]) {
                jTable.getCellEditor().stopCellEditing();
            }
        }
    }

    protected static boolean[] getCellAction(JTable jTable, MouseEvent mouseEvent, int n, int n2, AutoCellAction autoCellAction) {
        boolean bl = false;
        boolean bl2 = false;
        if (autoCellAction != null) {
            bl = autoCellAction.isEditable(jTable, mouseEvent, n, n2);
            bl2 = autoCellAction.isRollover(jTable, mouseEvent, n, n2);
        } else {
            TableCellEditor tableCellEditor = jTable.getCellEditor(n, n2);
            if (tableCellEditor instanceof CellEditingSupport && ((CellEditingSupport)((Object)tableCellEditor)).isEditable(jTable, mouseEvent, n, n2)) {
                bl = true;
            }
            if (tableCellEditor instanceof CellRolloverSupport && ((CellRolloverSupport)((Object)tableCellEditor)).isRollover(jTable, mouseEvent, n, n2)) {
                bl2 = true;
            }
        }
        return new boolean[]{bl, bl2};
    }

    public static void uninstall(JTable jTable) {
        Object object;
        Object object2;
        Object object3 = jTable.getClientProperty(CLIENT_PROPERTY_ROLLOVER_MOUSE_LISTENER);
        if (object3 != null) {
            if (object3 instanceof MouseListener) {
                jTable.removeMouseListener((MouseListener)object3);
            }
            if (object3 instanceof MouseMotionListener) {
                jTable.removeMouseMotionListener((MouseMotionListener)object3);
            }
        }
        if ((object2 = jTable.getClientProperty(CLIENT_PROPERTY_ROLLOVER_COLUMN_MODEL_LISTENER)) instanceof TableColumnModelListener) {
            jTable.getColumnModel().removeColumnModelListener((TableColumnModelListener)object2);
        }
        if ((object = jTable.getClientProperty(CLIENT_PROPERTY_ROLLOVER_PROPERTY_CHANGE_LISTENER)) instanceof PropertyChangeListener) {
            jTable.removePropertyChangeListener("columnModel", (PropertyChangeListener)object);
        }
        jTable.putClientProperty(CLIENT_PROPERTY_ROLLOVER_MOUSE_LISTENER, null);
        jTable.putClientProperty(CLIENT_PROPERTY_ROLLOVER_COLUMN_MODEL_LISTENER, null);
        jTable.putClientProperty(CLIENT_PROPERTY_ROLLOVER_PROPERTY_CHANGE_LISTENER, null);
        jTable.putClientProperty(CLIENT_PROPERTY_ROLLOVER_AUTO_CELL_ACTION, null);
    }

    public static void prepareCellEditorComponent(final Component component, final JTable jTable, final boolean bl, final int n, final int n2) {
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                jTable.changeSelection(n, n2, false, false);
                component.setBackground(bl ? jTable.getSelectionBackground() : jTable.getBackground());
            }
        };
        JideSwingUtilities.setRecursively(component, new JideSwingUtilities.Handler(){

            @Override
            public void action(Component component) {
                component.addMouseListener(mouseAdapter);
            }

            @Override
            public void postAction(Component component) {
            }

            @Override
            public boolean condition(Component component) {
                return true;
            }
        });
    }

    public static interface AutoCellAction {
        public boolean isEditable(JTable var1, MouseEvent var2, int var3, int var4);

        public boolean isRollover(JTable var1, MouseEvent var2, int var3, int var4);
    }
}

