/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.FilterListCellRenderer;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GridsResourceProvider;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.list.ListUtils;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.Position;

public class QuickFilterPane
extends JPanel {
    private TableModel _tableModel;
    private int[] _columnIndices;
    private String[] _displayNames;
    protected IFilterableTableModel[] _models;
    protected JList[] _lists;
    private int _visibleRowCount = 7;
    private final String _allItem = this.getResourceString("Search.allItem");
    protected final MessageFormat _allItemFormat = new MessageFormat(this._allItem);
    protected JTable _table;
    private TableScrollPane _tablePane;
    private boolean _useCheckBoxList;
    private boolean _autoUpdate = true;
    private Object[][] _possibleValues;
    private Vector[] _listModelValues;
    private boolean _useTableCellRenderer;
    private FilterableTableModel _displayTableModel;
    private Object[][] _previousPossibleValues;
    private Object[][] _previousSelectedValues;
    private boolean _adjusting;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addValue(Object object, int n) {
        Vector[] vectorArray = this._listModelValues;
        synchronized (this._listModelValues) {
            if (n < 0 || n >= this._listModelValues.length) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            if (this._listModelValues[n].contains(object)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            this._listModelValues[n].add(object);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    private boolean isAdjusting() {
        return this._adjusting;
    }

    private void setAdjusting(boolean bl) {
        this._adjusting = bl;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        for (Component component : this.getComponents()) {
            JideSwingUtilities.setEnabledRecursively(component, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateListsFromFilters() {
        for (JList jList : this._lists) {
            Filter[] filterArray;
            int n;
            IFilterableTableModel iFilterableTableModel;
            if (jList instanceof QuickFilterList) {
                iFilterableTableModel = ((QuickFilterList)jList)._filterableTableModel;
                n = ((QuickFilterList)jList)._column;
                if (iFilterableTableModel == null || n < 0 || !iFilterableTableModel.isFiltersApplied()) continue;
                filterArray = iFilterableTableModel.getFilters(n);
                try {
                    jList.getSelectionModel().removeListSelectionListener(((QuickFilterList)jList)._listSelectionListener);
                    if (filterArray == null || filterArray.length != 1 || !(filterArray[0] instanceof MultipleValuesFilter)) {
                        jList.setSelectedIndex(0);
                        continue;
                    }
                    ListUtils.loadSelectionByValues(jList, ((MultipleValuesFilter)filterArray[0]).getValues());
                    continue;
                }
                finally {
                    jList.getSelectionModel().addListSelectionListener(((QuickFilterList)jList)._listSelectionListener);
                }
            }
            if (!(jList instanceof QuickFilterCheckBoxList)) continue;
            iFilterableTableModel = ((QuickFilterCheckBoxList)jList)._filterableTableModel;
            n = ((QuickFilterCheckBoxList)jList)._column;
            if (iFilterableTableModel == null || n < 0 || !iFilterableTableModel.isFiltersApplied()) continue;
            filterArray = iFilterableTableModel.getFilters(n);
            try {
                jList.getSelectionModel().removeListSelectionListener(((QuickFilterCheckBoxList)jList)._listSelectionListener);
                if (filterArray == null || filterArray.length != 1 || !(filterArray[0] instanceof MultipleValuesFilter)) {
                    jList.setSelectedIndex(0);
                    continue;
                }
                ((CheckBoxList)jList).setSelectedObjects(((MultipleValuesFilter)filterArray[0]).getValues());
            }
            finally {
                jList.getSelectionModel().addListSelectionListener(((QuickFilterCheckBoxList)jList)._listSelectionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateListModelValues(IFilterableTableModel iFilterableTableModel, int n) {
        this._possibleValues[n] = this.getPossibleValues(iFilterableTableModel, n);
        Vector[] vectorArray = this._listModelValues;
        synchronized (this._listModelValues) {
            this._listModelValues[n] = new Vector();
            if (this._possibleValues[n].length > 1 && this._possibleValues[n][this._possibleValues[n].length - 1] instanceof ConverterContext) {
                Object[] objectArray = new Object[this._possibleValues[n].length >> 1];
                Object[] objectArray2 = new Object[this._possibleValues[n].length >> 1];
                System.arraycopy(this._possibleValues[n], 0, objectArray, 0, objectArray.length);
                System.arraycopy(this._possibleValues[n], objectArray.length, objectArray2, 0, objectArray2.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = ObjectConverterManager.toString(objectArray[i], iFilterableTableModel.getColumnClass(n), objectArray2[i] instanceof ConverterContext ? (ConverterContext)objectArray2[i] : null);
                }
                this._listModelValues[n].addAll(Arrays.asList(objectArray));
            } else {
                this._listModelValues[n].addAll(Arrays.asList(this._possibleValues[n]));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected ListModel createListModel(final IFilterableTableModel iFilterableTableModel, final int n) {
        this.updateListModelValues(iFilterableTableModel, n);
        return new AbstractListModel(){
            private static final long serialVersionUID = -2084319176700802788L;

            @Override
            public int getSize() {
                return QuickFilterPane.this._listModelValues == null || n < 0 || n >= QuickFilterPane.this._listModelValues.length || QuickFilterPane.this._listModelValues[n] == null ? 0 : QuickFilterPane.this._listModelValues[n].size() + 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object getElementAt(int n3) {
                Vector[] vectorArray = QuickFilterPane.this._listModelValues;
                synchronized (vectorArray) {
                    String string = null;
                    if (QuickFilterPane.this._listModelValues == null || n < 0 || n >= QuickFilterPane.this._listModelValues.length || QuickFilterPane.this._listModelValues[n] == null) {
                        string = "(All)";
                    } else if (n3 == 0) {
                        int n2 = QuickFilterPane.this._listModelValues[n].size();
                        String string2 = string = n2 == 1 ? QuickFilterPane.this._allItemFormat.format(new Object[]{n2, iFilterableTableModel.getColumnName(n)}) : QuickFilterPane.this._allItemFormat.format(new Object[]{n2, QuickFilterPane.this.getPluralForm(iFilterableTableModel.getColumnName(n))});
                    }
                    if (string != null) {
                        return QuickFilterPane.this.customizeDisplayedTextForAll(string);
                    }
                    return QuickFilterPane.this._listModelValues[n].get(n3 - 1);
                }
            }
        };
    }

    protected Object customizeDisplayedTextForAll(Object object) {
        return object;
    }

    protected void applyFilter(JList jList, IFilterableTableModel iFilterableTableModel, int n) {
        iFilterableTableModel.removeAllFilters(n);
        Object[] objectArray = null;
        if (jList instanceof CheckBoxList) {
            if (!((CheckBoxList)jList).getCheckBoxListSelectionModel().isSelectedIndex(0)) {
                if (this._possibleValues[n] != null && this._possibleValues[n].length > 1 && this._possibleValues[n][this._possibleValues[n].length - 1] instanceof ConverterContext) {
                    int[] nArray = ((CheckBoxList)jList).getCheckBoxListSelectedIndices();
                    objectArray = new Object[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        objectArray[i] = this._possibleValues[n][nArray[i] - 1];
                    }
                } else {
                    objectArray = ((CheckBoxList)jList).getCheckBoxListSelectedValues();
                }
            }
        } else if (!jList.isSelectedIndex(0)) {
            if (this._possibleValues[n] != null && this._possibleValues[n].length > 1 && this._possibleValues[n][this._possibleValues[n].length - 1] instanceof ConverterContext) {
                int[] nArray = jList.getSelectedIndices();
                objectArray = new Object[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    objectArray[i] = this._possibleValues[n][nArray[i] - 1];
                }
            } else {
                objectArray = jList.getSelectedValues();
            }
        }
        if (objectArray != null && objectArray.length > 0) {
            iFilterableTableModel.addFilter(n, this.createFilter(objectArray, iFilterableTableModel, n));
            if (this._previousSelectedValues != null && n >= 0 && n < this._previousSelectedValues.length) {
                this._previousSelectedValues[n] = objectArray;
            }
        }
        iFilterableTableModel.refresh();
    }

    protected Filter<Object> createFilter(Object[] objectArray, IFilterableTableModel iFilterableTableModel, int n) {
        return new MultipleValuesFilter<Object>(objectArray);
    }

    protected Object[] getPossibleValues(TableModel tableModel, int n) {
        if (tableModel instanceof IFilterableTableModel) {
            if (!((IFilterableTableModel)tableModel).isSameConverterAt(n)) {
                return ((IFilterableTableModel)tableModel).getPossibleValuesAndConverters(n, ObjectComparatorManager.getComparator(tableModel.getColumnClass(n)));
            }
            return ((IFilterableTableModel)tableModel).getPossibleValues(n, ObjectComparatorManager.getComparator(tableModel.getColumnClass(n)));
        }
        return new Object[0];
    }

    public QuickFilterPane() {
    }

    public QuickFilterPane(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public QuickFilterPane(TableModel tableModel, int[] nArray) {
        this(tableModel, nArray, null);
    }

    public QuickFilterPane(TableModel tableModel, int[] nArray, String[] stringArray) {
        this._columnIndices = nArray;
        this._displayNames = stringArray;
        this.verifyColumnIndices();
        this._tableModel = tableModel;
        if (this._tableModel != null) {
            this.initComponent();
            this.initPrevious();
        }
    }

    private void verifyColumnIndices() {
        if (this._displayNames != null && this._columnIndices != null && this._displayNames.length != this._columnIndices.length) {
            throw new IllegalArgumentException("The columnIndices and displayNames array should have the same length.");
        }
    }

    protected void initComponent() {
        if (this._tableModel == null) {
            return;
        }
        int n = this._columnIndices != null ? this._columnIndices.length : this._tableModel.getColumnCount();
        this._models = new FilterableTableModel[n];
        this._lists = new JList[n];
        TableModel tableModel = this._tableModel;
        Component[] componentArray = new Component[n];
        this._possibleValues = new Object[this._tableModel.getColumnCount()][];
        this._listModelValues = new Vector[this._tableModel.getColumnCount()];
        for (int i = 0; i < n; ++i) {
            int n2 = this._columnIndices != null ? this._columnIndices[i] : i;
            tableModel = this.createFilterableTableModel(tableModel, i);
            this._models[i] = (IFilterableTableModel)tableModel;
            this._lists[i] = this.createQuickFilterList(this._models[i], n2);
            String string = null;
            if (this._displayNames != null) {
                string = this._displayNames[i];
            } else if (this._tableModel != null) {
                string = this._tableModel.getColumnName(n2);
            }
            this._lists[i].setName(string);
            if (this._lists[i] instanceof CheckBoxList) {
                ((QuickFilterCheckBoxList)this._lists[i]).reset();
            } else {
                ((QuickFilterList)this._lists[i]).reset();
            }
            this._lists[i].setVisibleRowCount(this.getVisibleRowCount());
            componentArray[i] = this.createListComponent(this._lists[i], string);
        }
        Component component = this.createListsComponent(componentArray);
        this.setLayout(new BorderLayout(3, 3));
        this.add(component);
        FilterableTableModel filterableTableModel = this._displayTableModel;
        if (this._displayTableModel == null) {
            this._displayTableModel = new FilterableTableModel(this.getDisplayTableModel());
            if (this.getTable() != null) {
                this.getTable().setModel(this.getDisplayTableModel());
            }
            if (this.getTablePane() != null && this.getDisplayTableModel() instanceof MultiTableModel) {
                this.getTablePane().setTableModel((MultiTableModel)this.getDisplayTableModel());
            }
        } else {
            this._displayTableModel = null;
            filterableTableModel.setActualModel(this.getDisplayTableModel(), true);
            this._displayTableModel = filterableTableModel;
        }
    }

    private void initPrevious() {
        if (this._tableModel == null) {
            return;
        }
        this._previousPossibleValues = new Object[this._tableModel.getColumnCount()][];
        this._previousSelectedValues = new Object[this._tableModel.getColumnCount()][];
    }

    protected JList createQuickFilterList(IFilterableTableModel iFilterableTableModel, int n) {
        return this.isUseCheckBoxList() ? new QuickFilterCheckBoxList(iFilterableTableModel, n) : new QuickFilterList(iFilterableTableModel, n);
    }

    protected TableModel createFilterableTableModel(TableModel tableModel, int n) {
        if (TableModelWrapperUtils.getActualTableModel(tableModel) instanceof IExpandableTreeTableModel) {
            FilterableTreeTableModel filterableTreeTableModel = new FilterableTreeTableModel(tableModel){
                private static final long serialVersionUID = -8579609798686575111L;

                @Override
                protected boolean shouldPossibleValueBeIncluded(Object object, int n) {
                    return QuickFilterPane.this.shouldPossibleValueBeIncluded(this, object, n);
                }
            };
            filterableTreeTableModel.setAndMode(false);
            return filterableTreeTableModel;
        }
        FilterableTableModel filterableTableModel = new FilterableTableModel(tableModel){
            private static final long serialVersionUID = -4504917640643684754L;

            @Override
            protected boolean shouldPossibleValueBeIncluded(Object object, int n) {
                return QuickFilterPane.this.shouldPossibleValueBeIncluded(this, object, n);
            }
        };
        filterableTableModel.setAndMode(false);
        return filterableTableModel;
    }

    protected boolean shouldPossibleValueBeIncluded(FilterableTableModel filterableTableModel, Object object, int n) {
        if (object == null) {
            return false;
        }
        String string = ObjectConverterManager.toString(object, filterableTableModel.getCellClassAt(-1, n), filterableTableModel.getConverterContextAt(-1, n));
        return !"".equals(string);
    }

    protected Component createListsComponent(Component[] componentArray) {
        JideSplitPane jideSplitPane = new JideSplitPane(1);
        for (Component component : componentArray) {
            jideSplitPane.add(component);
        }
        return jideSplitPane;
    }

    protected Component createListComponent(JList jList, String string) {
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        JScrollPane jScrollPane = new JScrollPane(jList, 22, 31);
        JLabel jLabel = new JLabel(string);
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        jLabel.setHorizontalAlignment(0);
        jScrollPane.setColumnHeaderView(jLabel);
        jPanel.add(jScrollPane);
        jPanel.setPreferredSize(new Dimension(200, jPanel.getPreferredSize().height));
        return jPanel;
    }

    public void reset() {
        for (JList jList : this._lists) {
            if (jList instanceof QuickFilterCheckBoxList) {
                ((QuickFilterCheckBoxList)jList).reset();
                continue;
            }
            if (!(jList instanceof QuickFilterList)) continue;
            ((QuickFilterList)jList).reset();
        }
    }

    public void update() {
        for (JList jList : this._lists) {
            if (jList instanceof QuickFilterCheckBoxList) {
                ((QuickFilterCheckBoxList)jList).updateList();
                continue;
            }
            if (!(jList instanceof QuickFilterList)) continue;
            ((QuickFilterList)jList).updateList();
        }
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this._tableModel = tableModel;
        this.removeAll();
        this.initComponent();
        this.initPrevious();
        this.revalidate();
    }

    @Override
    public void removeAll() {
        if (this._lists != null) {
            for (JList jList : this._lists) {
                if (jList instanceof QuickFilterList) {
                    ((QuickFilterList)jList).dispose();
                    continue;
                }
                if (!(jList instanceof QuickFilterCheckBoxList)) continue;
                ((QuickFilterCheckBoxList)jList).dispose();
            }
        }
        super.removeAll();
    }

    public int[] getColumnIndices() {
        return this._columnIndices;
    }

    public void setColumnIndices(int[] nArray) {
        this._columnIndices = nArray;
        this.verifyColumnIndices();
        this.removeAll();
        this.initComponent();
        this.revalidate();
    }

    public String[] getDisplayNames() {
        return this._displayNames;
    }

    public void setDisplayNames(String[] stringArray) {
        this._displayNames = stringArray;
        this.verifyColumnIndices();
        this.removeAll();
        this.initComponent();
    }

    public TableModel getDisplayTableModel() {
        if (this._displayTableModel != null) {
            return this._displayTableModel;
        }
        if (this._models != null && this._models.length > 0) {
            return this._models[this._models.length - 1];
        }
        return this._tableModel;
    }

    public void setVisibleRowCount(int n) {
        int n2 = this._visibleRowCount;
        this._visibleRowCount = Math.max(0, n);
        if (this._lists != null) {
            this.removeAll();
            this.initComponent();
            for (JList jList : this._lists) {
                jList.setVisibleRowCount(this._visibleRowCount);
            }
        }
        this.firePropertyChange("visibleRowCount", n2, n);
    }

    public int getVisibleRowCount() {
        return this._visibleRowCount;
    }

    public JList getList(int n) {
        if (this._lists != null) {
            return this._lists[n];
        }
        return null;
    }

    protected String getResourceString(String string) {
        return GridResource.getResourceBundle(this.getLocale()).getString(string);
    }

    protected String getPluralForm(String string) {
        if (string.endsWith("s") || string.endsWith("sh") || string.endsWith("ch")) {
            return string + "es";
        }
        return string + "s";
    }

    public JTable getTable() {
        return this._table;
    }

    public void setTable(JTable jTable) {
        this._table = jTable;
    }

    public TableScrollPane getTablePane() {
        return this._tablePane;
    }

    public void setTablePane(TableScrollPane tableScrollPane) {
        this._tablePane = tableScrollPane;
    }

    public boolean isUseCheckBoxList() {
        return this._useCheckBoxList;
    }

    public void setUseCheckBoxList(boolean bl) {
        this._useCheckBoxList = bl;
        this.removeAll();
        this.initComponent();
        this.revalidate();
    }

    public boolean isAutoUpdate() {
        return this._autoUpdate;
    }

    public void setAutoUpdate(boolean bl) {
        this._autoUpdate = bl;
        if (this._autoUpdate) {
            this.update();
        }
    }

    public boolean isUseTableCellRenderer() {
        return this._useTableCellRenderer;
    }

    public void setUseTableCellRenderer(boolean bl) {
        this._useTableCellRenderer = bl;
    }

    private void savePreviousFilters() {
        if (this._previousPossibleValues == null || this._previousSelectedValues == null) {
            return;
        }
        if (this._columnIndices != null) {
            for (int i = 0; i < this._columnIndices.length; ++i) {
                this._previousPossibleValues[this._columnIndices[i]] = this._possibleValues[this._columnIndices[i]];
                if (this._lists[i] == null) continue;
                this._previousSelectedValues[this._columnIndices[i]] = ((CheckBoxList)this._lists[i]).getCheckBoxListSelectedValues();
            }
        } else {
            for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
                if (this._lists[i] == null) continue;
                this._previousSelectedValues[i] = ((CheckBoxList)this._lists[i]).getCheckBoxListSelectedValues();
            }
        }
    }

    static /* synthetic */ Object[][] access$902(QuickFilterPane quickFilterPane, Object[][] objectArray) {
        quickFilterPane._previousPossibleValues = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[][] access$1002(QuickFilterPane quickFilterPane, Object[][] objectArray) {
        quickFilterPane._previousSelectedValues = objectArray;
        return objectArray;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(QuickFilterPane.class.getName(), 4);
        }
    }

    public class QuickFilterCheckBoxList
    extends CheckBoxList
    implements GridsResourceProvider {
        private IFilterableTableModel _filterableTableModel;
        private int _column;
        protected TableModelListener _tableModelListener;
        protected ListSelectionListener _listSelectionListener;

        public QuickFilterCheckBoxList(IFilterableTableModel iFilterableTableModel, int n) {
            this.getCheckBoxListSelectionModel().setAllEntryConsidered(false);
            this.getCheckBoxListSelectionModel().setAllEntryIndex(0);
            this._filterableTableModel = iFilterableTableModel;
            this._column = n;
            this.populateList();
            if (QuickFilterPane.this._possibleValues[this._column] != null && QuickFilterPane.this._possibleValues[this._column].length > 1 && QuickFilterPane.this._possibleValues[this._column][QuickFilterPane.this._possibleValues[this._column].length - 1] instanceof ConverterContext) {
                this.setCellRenderer(new FilterListCellRenderer());
            } else if (this._filterableTableModel instanceof ContextSensitiveTableModel) {
                this.setCellRenderer(new FilterListCellRenderer(this._filterableTableModel.getColumnClass(this._column), ((ContextSensitiveTableModel)((Object)this._filterableTableModel)).getConverterContextAt(0, this._column)));
            } else {
                this.setCellRenderer(new FilterListCellRenderer(this._filterableTableModel.getColumnClass(this._column)));
            }
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (this._filterableTableModel instanceof ContextSensitiveTableModel && listCellRenderer instanceof FilterListCellRenderer && QuickFilterPane.this.isUseTableCellRenderer()) {
                int n2 = this._column;
                if (QuickFilterPane.this.getTable() != null) {
                    n2 = TableModelWrapperUtils.getColumnAt(QuickFilterPane.this.getTable().getModel(), this._filterableTableModel, this._column);
                }
                ((FilterListCellRenderer)listCellRenderer).setEditorContext(((ContextSensitiveTableModel)((Object)iFilterableTableModel)).getEditorContextAt(0, n2));
                ((FilterListCellRenderer)listCellRenderer).setTable(QuickFilterPane.this.getTable());
                ((FilterListCellRenderer)listCellRenderer).setColumnIndex(n2);
            }
            this._filterableTableModel.setFiltersApplied(true);
            this._tableModelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if ((QuickFilterPane.this.isAutoUpdate() && tableModelEvent.getColumn() == -1 || tableModelEvent.getColumn() == QuickFilterCheckBoxList.this._column) && QuickFilterCheckBoxList.this.updateList() && tableModelEvent instanceof CompoundTableModelEvent) {
                        ((CompoundTableModelEvent)tableModelEvent).consume();
                    }
                }
            };
            this._listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    try {
                        QuickFilterCheckBoxList.this.getCheckBoxListSelectionModel().removeListSelectionListener(QuickFilterCheckBoxList.this._listSelectionListener);
                        QuickFilterCheckBoxList.this._filterableTableModel.removeTableModelListener(QuickFilterCheckBoxList.this._tableModelListener);
                        boolean bl = QuickFilterPane.this.isAdjusting();
                        if (!QuickFilterPane.this.isAdjusting()) {
                            QuickFilterPane.this.setAdjusting(true);
                            QuickFilterPane.this.savePreviousFilters();
                        }
                        QuickFilterPane.this.applyFilter(QuickFilterCheckBoxList.this, QuickFilterCheckBoxList.this._filterableTableModel, QuickFilterCheckBoxList.this._column);
                        if (!bl) {
                            QuickFilterPane.access$902(QuickFilterPane.this, null);
                            QuickFilterPane.access$1002(QuickFilterPane.this, null);
                            QuickFilterPane.this.setAdjusting(false);
                        }
                    }
                    finally {
                        QuickFilterCheckBoxList.this.getCheckBoxListSelectionModel().addListSelectionListener(QuickFilterCheckBoxList.this._listSelectionListener);
                        QuickFilterCheckBoxList.this._filterableTableModel.addTableModelListener(QuickFilterCheckBoxList.this._tableModelListener);
                    }
                }
            };
            this._filterableTableModel.addTableModelListener(this._tableModelListener);
            this.getCheckBoxListSelectionModel().addListSelectionListener(this._listSelectionListener);
            SearchableUtils.installSearchable(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateList() {
            boolean bl = false;
            Object[] objectArray = null;
            Object[] objectArray2 = QuickFilterPane.this.getPossibleValues(this._filterableTableModel, this._column);
            if (QuickFilterPane.this._previousPossibleValues != null && QuickFilterPane.this._previousPossibleValues[this._column] != null && QuickFilterPane.this._previousSelectedValues != null && QuickFilterPane.this._previousSelectedValues[this._column] != null) {
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.addAll(Arrays.asList(QuickFilterPane.this._previousPossibleValues[this._column]));
                HashSet<Object> hashSet2 = new HashSet<Object>();
                hashSet2.addAll(Arrays.asList(QuickFilterPane.this._previousSelectedValues[this._column]));
                hashSet.removeAll(hashSet2);
                HashSet<Object> hashSet3 = new HashSet<Object>();
                hashSet3.addAll(Arrays.asList(objectArray2));
                hashSet3.removeAll(hashSet);
                objectArray = hashSet3.toArray();
                if (objectArray == null || objectArray.length == 0) {
                    objectArray = QuickFilterPane.this._previousSelectedValues[this._column];
                }
            } else if (this.getCheckBoxListSelectionModel().isSelectedIndex(0)) {
                bl = true;
            } else {
                objectArray = this.getCheckBoxListSelectedValues();
            }
            boolean bl2 = false;
            try {
                this.getCheckBoxListSelectionModel().removeListSelectionListener(this._listSelectionListener);
                this.populateList();
                if ((objectArray == null || objectArray.length == 0) && bl) {
                    this.getCheckBoxListSelectionModel().setSelectionInterval(0, 0);
                }
            }
            finally {
                this.getCheckBoxListSelectionModel().addListSelectionListener(this._listSelectionListener);
                if (objectArray != null && objectArray.length != 0) {
                    this.setSelectedObjects(objectArray);
                    bl2 = true;
                }
            }
            if (this.getCheckBoxListSelectedIndex() == -1) {
                this.setCheckBoxListSelectedIndex(0);
            }
            this.ensureIndexIsVisible(this.getCheckBoxListSelectedIndex());
            return bl2;
        }

        public void reset() {
            this.getCheckBoxListSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
            this.ensureIndexIsVisible(0);
        }

        @Override
        public int getNextMatch(String string, int n, Position.Bias bias) {
            return -1;
        }

        protected void populateList() {
            this.setModel(QuickFilterPane.this.createListModel(this._filterableTableModel, this._column));
        }

        void dispose() {
            this._filterableTableModel.removeTableModelListener(this._tableModelListener);
            this.getCheckBoxListSelectionModel().removeListSelectionListener(this._listSelectionListener);
        }

        @Override
        public String getResourceString(String string) {
            return QuickFilterPane.this.getResourceString(string);
        }
    }

    public class QuickFilterList
    extends JList
    implements GridsResourceProvider {
        private IFilterableTableModel _filterableTableModel;
        private int _column;
        protected TableModelListener _tableModelListener;
        protected ListSelectionListener _listSelectionListener;

        public QuickFilterList(IFilterableTableModel iFilterableTableModel, int n) {
            this._filterableTableModel = iFilterableTableModel;
            this._column = n;
            this.populateList();
            if (QuickFilterPane.this._possibleValues[this._column] != null && QuickFilterPane.this._possibleValues[this._column].length > 1 && QuickFilterPane.this._possibleValues[this._column][QuickFilterPane.this._possibleValues[this._column].length - 1] instanceof ConverterContext) {
                this.setCellRenderer(new FilterListCellRenderer());
            } else if (this._filterableTableModel instanceof ContextSensitiveTableModel) {
                this.setCellRenderer(new FilterListCellRenderer(this._filterableTableModel.getColumnClass(this._column), ((ContextSensitiveTableModel)((Object)this._filterableTableModel)).getConverterContextAt(0, this._column)));
            } else {
                this.setCellRenderer(new FilterListCellRenderer(this._filterableTableModel.getColumnClass(this._column)));
            }
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (this._filterableTableModel instanceof ContextSensitiveTableModel && listCellRenderer instanceof FilterListCellRenderer && QuickFilterPane.this.isUseTableCellRenderer()) {
                int n2 = this._column;
                if (QuickFilterPane.this.getTable() != null) {
                    n2 = TableModelWrapperUtils.getColumnAt(QuickFilterPane.this.getTable().getModel(), this._filterableTableModel, this._column);
                }
                ((FilterListCellRenderer)listCellRenderer).setEditorContext(((ContextSensitiveTableModel)((Object)iFilterableTableModel)).getEditorContextAt(0, n2));
                ((FilterListCellRenderer)listCellRenderer).setTable(QuickFilterPane.this.getTable());
                ((FilterListCellRenderer)listCellRenderer).setColumnIndex(n2);
            }
            this._filterableTableModel.setFiltersApplied(true);
            this._tableModelListener = new TableModelListener(){

                private void tableRowsInserted(TableModelEvent tableModelEvent) {
                    int n;
                    int n2 = QuickFilterList.this.getModel().getSize();
                    for (n = tableModelEvent.getFirstRow(); n <= tableModelEvent.getLastRow(); ++n) {
                        QuickFilterPane.this.addValue(QuickFilterList.this._filterableTableModel.getValueAt(n, QuickFilterList.this._column), QuickFilterList.this._column);
                    }
                    n = QuickFilterList.this.getModel().getSize();
                    if (n > n2) {
                        QuickFilterList.this.populateList();
                    }
                }

                private void tableNonRelatedCellUpdated(TableModelEvent tableModelEvent) {
                }

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (QuickFilterPane.this.isAutoUpdate()) {
                        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
                            QuickFilterList.this.updateList();
                            return;
                        }
                        if (tableModelEvent.getType() == 1) {
                            this.tableRowsInserted(tableModelEvent);
                            return;
                        }
                        if (tableModelEvent.getType() == 0 && tableModelEvent.getColumn() != -1 && tableModelEvent.getColumn() != QuickFilterList.this._column) {
                            this.tableNonRelatedCellUpdated(tableModelEvent);
                            return;
                        }
                        if (tableModelEvent instanceof CompoundTableModelEvent && ((CompoundTableModelEvent)tableModelEvent).getEvents() != null && ((CompoundTableModelEvent)tableModelEvent).getEvents().length > 0) {
                            boolean bl = false;
                            for (TableModelEvent tableModelEvent2 : ((CompoundTableModelEvent)tableModelEvent).getEvents()) {
                                if (tableModelEvent2.getType() == 1 || tableModelEvent2.getType() == 0 && tableModelEvent2.getColumn() != -1 && tableModelEvent2.getColumn() != QuickFilterList.this._column) continue;
                                bl = true;
                                break;
                            }
                            if (bl) {
                                QuickFilterList.this.updateList();
                            } else {
                                for (TableModelEvent tableModelEvent2 : ((CompoundTableModelEvent)tableModelEvent).getEvents()) {
                                    if (tableModelEvent2.getType() == 1) {
                                        this.tableRowsInserted(tableModelEvent2);
                                        continue;
                                    }
                                    if (tableModelEvent2.getType() != 0 || tableModelEvent2.getColumn() == -1 || tableModelEvent2.getColumn() == QuickFilterList.this._column) continue;
                                    this.tableNonRelatedCellUpdated(tableModelEvent2);
                                }
                            }
                            return;
                        }
                        QuickFilterList.this.updateList();
                    }
                }
            };
            this._listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    try {
                        QuickFilterList.this.removeListSelectionListener(QuickFilterList.this._listSelectionListener);
                        QuickFilterList.this._filterableTableModel.removeTableModelListener(QuickFilterList.this._tableModelListener);
                        if (QuickFilterList.this.isSelectedIndex(0) && listSelectionEvent.getFirstIndex() != listSelectionEvent.getLastIndex()) {
                            QuickFilterList.this.setSelectedIndex(0);
                        }
                        QuickFilterPane.this.applyFilter(QuickFilterList.this, QuickFilterList.this._filterableTableModel, QuickFilterList.this._column);
                    }
                    finally {
                        QuickFilterList.this._filterableTableModel.addTableModelListener(QuickFilterList.this._tableModelListener);
                        QuickFilterList.this.addListSelectionListener(QuickFilterList.this._listSelectionListener);
                    }
                }
            };
            this._filterableTableModel.addTableModelListener(this._tableModelListener);
            this.addListSelectionListener(this._listSelectionListener);
            SearchableUtils.installSearchable(this);
        }

        public void updateList() {
            boolean bl = false;
            Object[] objectArray = null;
            if (this.isSelectedIndex(0)) {
                bl = true;
            } else {
                objectArray = ListUtils.saveSelectionByValues(this);
            }
            try {
                this.removeListSelectionListener(this._listSelectionListener);
                this.populateList();
                if (bl) {
                    this.setSelectedIndex(0);
                } else if (objectArray != null && objectArray.length != 0) {
                    ListUtils.loadSelectionByValues(this, objectArray);
                }
            }
            finally {
                this.addListSelectionListener(this._listSelectionListener);
            }
            if (this.getSelectedIndex() == -1) {
                this.setSelectedIndex(0);
            }
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }

        public void reset() {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }

        @Override
        public int getNextMatch(String string, int n, Position.Bias bias) {
            return -1;
        }

        protected void populateList() {
            this.setModel(QuickFilterPane.this.createListModel(this._filterableTableModel, this._column));
        }

        void dispose() {
            this._filterableTableModel.removeTableModelListener(this._tableModelListener);
            this.removeListSelectionListener(this._listSelectionListener);
        }

        @Override
        public String getResourceString(String string) {
            return QuickFilterPane.this.getResourceString(string);
        }
    }
}

