/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableColumnGroup;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@Deprecated
public class NestedSortableTableHeader
extends NestedTableHeader {
    public static int V_GAP = 3;
    public static int H_GAP = 5;
    public static int ARROW_TEXT_GAP = 1;

    public NestedSortableTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintSortArrows(graphics);
    }

    @Override
    protected void paintSortArrows(Graphics graphics) {
        SortableTable sortableTable = null;
        if (this.getTable() instanceof SortableTable) {
            sortableTable = (SortableTable)this.getTable();
        }
        if (sortableTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            return;
        }
        TableColumn tableColumn = this.getDraggedColumn();
        for (int i = 0; i < list.size(); ++i) {
            ISortableTableModel.SortItem sortItem = list.get(i);
            int n = sortItem.getColumn();
            if (n < 0) continue;
            boolean bl = false;
            if (tableColumn != null && tableColumn.getModelIndex() == n) {
                bl = true;
            }
            n = sortableTable.convertColumnIndexToView(n);
            Rectangle rectangle = new Rectangle();
            if (n == -1) continue;
            boolean bl2 = sortItem.isAscending();
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                n2 += this.getColumnModel().getColumn(j).getWidth();
            }
            rectangle.x = n2;
            if (bl) {
                rectangle.x += this.getDraggedDistance();
            }
            TableColumn tableColumn2 = this.getColumnModel().getColumn(n);
            rectangle.width = tableColumn2.getWidth();
            Enumeration enumeration = this.getColumnGroups(tableColumn2);
            Dimension dimension = this.getSize();
            rectangle.y = this.getY();
            rectangle.height = this.getHeight();
            if (enumeration != null) {
                int n3 = 0;
                while (enumeration.hasMoreElements()) {
                    TableColumnGroup tableColumnGroup = (TableColumnGroup)enumeration.nextElement();
                    Rectangle rectangle2 = new Rectangle(rectangle);
                    Dimension dimension2 = tableColumnGroup.getSize(this.getTable());
                    rectangle2.width = dimension2.width;
                    rectangle2.height = dimension2.height;
                    rectangle.height = dimension.height - (n3 += rectangle2.height);
                    rectangle.y = n3;
                }
            }
            this.paintSortArrow(this, sortableTable, graphics, rectangle, i, bl2);
        }
    }

    @Override
    protected void paintSortArrow(JComponent jComponent, SortableTable sortableTable, Graphics graphics, Rectangle rectangle, int n, boolean bl) {
        Icon icon = this.createSortIcon(sortableTable, bl);
        int n2 = rectangle.height;
        int n3 = rectangle.y + (n2 - icon.getIconHeight()) / 2 - V_GAP;
        if (sortableTable.isMultiColumnSortable() && n != -1) {
            Font font = graphics.getFont();
            Font font2 = graphics.getFont().deriveFont(0, font.getSize() - 3);
            String string = "" + (n + 1);
            int n4 = SwingUtilities.computeStringWidth(this.getFontMetrics(font2), string);
            graphics.setFont(font2);
            Color color = graphics.getColor();
            graphics.setColor(sortableTable.getSortOrderForeground() != null ? sortableTable.getSortOrderForeground() : jComponent.getForeground());
            int n5 = rectangle.x + rectangle.width / 2 - (icon.getIconWidth() + ARROW_TEXT_GAP + n4) / 2;
            if (SystemInfo.isWindowsVistaAbove() && LookAndFeelFactory.isWindowsLookAndFeel(UIManager.getLookAndFeel())) {
                JideSwingUtilities.drawString(sortableTable, graphics, string, n5 + ARROW_TEXT_GAP + icon.getIconWidth(), rectangle.y + V_GAP + this.getFontMetrics(font2).getAscent() - 2);
            } else {
                JideSwingUtilities.drawString(sortableTable, graphics, string, rectangle.x + rectangle.width - n4 - H_GAP, n3 + icon.getIconHeight() / 2 + 1);
            }
            graphics.setColor(color);
            graphics.setFont(font);
            if (SystemInfo.isWindowsVistaAbove() && LookAndFeelFactory.isWindowsLookAndFeel(UIManager.getLookAndFeel())) {
                icon.paintIcon(this, graphics, n5, rectangle.y + V_GAP);
            } else {
                icon.paintIcon(this, graphics, rectangle.x + rectangle.width - icon.getIconWidth() - n4 - H_GAP - ARROW_TEXT_GAP, n3);
            }
        } else if (SystemInfo.isWindowsVistaAbove() && LookAndFeelFactory.isWindowsLookAndFeel(UIManager.getLookAndFeel())) {
            icon.paintIcon(this, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + V_GAP);
        } else {
            icon.paintIcon(this, graphics, rectangle.x + rectangle.width - icon.getIconWidth() - H_GAP, n3);
        }
    }

    @Override
    protected Icon createSortIcon(SortableTable sortableTable, boolean bl) {
        return sortableTable.createSortIcon(bl);
    }
}

