/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class NavigationHierarchicalTable
extends HierarchicalTable
implements NavigationComponent {
    private NavigationComponentHelper _helper;

    public NavigationHierarchicalTable() {
        this.initComponents();
    }

    public NavigationHierarchicalTable(TableModel tableModel) {
        super(tableModel);
        this.initComponents();
    }

    public NavigationHierarchicalTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.initComponents();
    }

    public NavigationHierarchicalTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.initComponents();
    }

    public NavigationHierarchicalTable(int n, int n2) {
        super(n, n2);
        this.initComponents();
    }

    public NavigationHierarchicalTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.initComponents();
    }

    public NavigationHierarchicalTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.initComponents();
    }

    private void initComponents() {
        this.setShowGrid(false);
        this.setAutoResizeMode(256);
        this.setFillsSelection(false);
        this.setFillsGrids(false);
        this._helper = this.createNavigationHelper();
        this._helper.setup(this);
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationHierarchicalTableHelper();
    }

    private Rectangle getRowBounds(int n) {
        return this.getCellRect(n, 0, false).union(this.getCellRect(n, this.getColumnCount() - 1, false));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.isPaintingForPrint()) {
            this._helper.paint(graphics, this);
        }
    }

    public int getNavigationRolloverRow() {
        return this._helper.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n) {
        int n2 = this._helper.getRolloverRow();
        if (n2 != n) {
            this._helper.setRolloverRow(n);
            Rectangle rectangle = this.getRowBounds(n2);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
            if ((rectangle = this.getRowBounds(n)) != null) {
                this.repaint(rectangle);
            }
        }
    }

    public class NavigationHierarchicalTableHelper
    extends NavigationComponentHelper {
        @Override
        public Rectangle getRowBounds(int n) {
            return NavigationHierarchicalTable.this.getRowBounds(n);
        }

        @Override
        public int rowAtPoint(Point point) {
            return NavigationHierarchicalTable.this.rowAtPoint(point);
        }

        @Override
        public int[] getSelectedRows() {
            return NavigationHierarchicalTable.this.getSelectedRows();
        }
    }
}

