/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.SqlFilterSupport;
import com.jidesoft.grid.AbstractTableFilter;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.TypeUtils;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class MultipleValuesFilter<T>
extends AbstractTableFilter<T>
implements SqlFilterSupport {
    private static final long serialVersionUID = -3510636566610920701L;
    private Set<T> _lookup;
    private boolean _splitArrayOrCollection = false;

    public MultipleValuesFilter() {
    }

    public MultipleValuesFilter(T[] TArray) {
        this(null, TArray);
    }

    public MultipleValuesFilter(String string, T[] TArray) {
        super(string);
        this.setValues(TArray);
    }

    @Override
    public boolean isValueFiltered(T t) {
        block5: {
            block4: {
                ObjectGrouper objectGrouper = this.getObjectGrouper();
                if (objectGrouper != null) {
                    return this._lookup != null && !this._lookup.contains(objectGrouper.getValue(t));
                }
                if (this._lookup == null) {
                    return false;
                }
                if (!this.isSplitArrayOrCollection() || t == null || !t.getClass().isArray()) break block4;
                int n = Array.getLength(t);
                for (int i = 0; i < n; ++i) {
                    Object object = Array.get(t, i);
                    if (!this._lookup.contains(object)) continue;
                    return false;
                }
                break block5;
            }
            if (!this.isSplitArrayOrCollection() || !(t instanceof Collection)) break block5;
            for (Object e : (Collection)t) {
                if (!this._lookup.contains(e)) continue;
                return false;
            }
        }
        return !this._lookup.contains(t);
    }

    public T[] getValues() {
        return this._lookup == null ? null : this._lookup.toArray();
    }

    public void setValues(T[] TArray) {
        if (TArray != null) {
            this._lookup = new HashSet<T>();
            this._lookup.addAll(Arrays.asList(TArray));
        }
    }

    @Override
    public String getName() {
        String string = super.getName();
        return string != null ? string : (this._lookup == null ? "" : "(" + this._lookup.size() + ")");
    }

    @Override
    public boolean stricterThan(Filter filter) {
        if (filter == null || this.getClass() != filter.getClass()) {
            return false;
        }
        if (this.getObjectGrouper() != ((MultipleValuesFilter)filter).getObjectGrouper()) {
            return false;
        }
        T[] TArray = this.getValues();
        T[] TArray2 = ((MultipleValuesFilter)filter).getValues();
        if (TArray == null || TArray2 == null || TArray.length > TArray2.length) {
            return false;
        }
        HashSet<T> hashSet = new HashSet<T>();
        hashSet.addAll(Arrays.asList(TArray2));
        for (T t : TArray) {
            if (hashSet.contains(t)) continue;
            if (t instanceof Number) {
                boolean bl = false;
                for (Object e : hashSet) {
                    if (!(e instanceof Number) || ((Number)e).doubleValue() != ((Number)t).doubleValue()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public String getOperator() {
        return " IN ";
    }

    @Override
    public String getPreference(Class<?> clazz, ConverterContext converterContext) {
        ObjectGrouper objectGrouper = this.getObjectGrouper();
        if (objectGrouper != null) {
            clazz = objectGrouper.getType();
            converterContext = objectGrouper.getConverterContext();
        }
        T[] TArray = this.getValues();
        StringBuffer stringBuffer = new StringBuffer();
        for (T t : TArray) {
            stringBuffer.append(t == null ? GridResource.getResourceBundle(Locale.getDefault()).getString("Filter.null") : ObjectConverterManager.toString(t, clazz, converterContext)).append('\t');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        if (objectGrouper != null) {
            stringBuffer.append('\r').append('\n').append(objectGrouper.getName());
        }
        return stringBuffer.toString();
    }

    @Override
    public Object[] setPreference(String string, Class<?> clazz, ConverterContext converterContext) {
        String[] stringArray = string.split("\r\n");
        this.setObjectGrouperName(stringArray.length >= 2 ? stringArray[1] : null);
        string = stringArray[0];
        String[] stringArray2 = string.split("\t");
        Object object = Array.newInstance(clazz, stringArray2.length);
        String string2 = GridResource.getResourceBundle(Locale.getDefault()).getString("Filter.null");
        for (int i = 0; i < stringArray2.length; ++i) {
            if (JideSwingUtilities.equals(string2, stringArray2[i])) {
                Array.set(object, i, null);
                continue;
            }
            Array.set(object, i, ObjectConverterManager.fromString(stringArray2[i], clazz, converterContext));
        }
        try {
            this.setValues((Object[])object);
        }
        catch (Exception exception) {
            if (TypeUtils.isPrimitive(clazz)) {
                clazz = TypeUtils.convertPrimitiveToWrapperType(clazz);
                object = Array.newInstance(clazz, stringArray2.length);
            } else if (TypeUtils.isPrimitiveWrapper(clazz)) {
                clazz = TypeUtils.convertWrapperToPrimitiveType(clazz);
                object = Array.newInstance(clazz, stringArray2.length);
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                Array.set(object, i, ObjectConverterManager.fromString(stringArray2[i], clazz, converterContext));
            }
            this.setValues((Object[])object);
        }
        return this.getValues();
    }

    @Override
    public boolean isFilterValid() {
        return this._lookup != null;
    }

    public boolean isSplitArrayOrCollection() {
        return this._splitArrayOrCollection;
    }

    public void setSplitArrayOrCollection(boolean bl) {
        this._splitArrayOrCollection = bl;
    }
}

