/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ConverterContextSupport;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.MultilineLabel;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.TableCellRenderer;

public class MultilineTableCellRenderer
extends MultilineLabel
implements ConverterContextSupport,
TableCellRenderer,
Serializable {
    public static final EditorContext CONTEXT = new EditorContext("Multiline");
    private ConverterContext _context;
    private Class<?> _class;
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final long serialVersionUID = -6513143877721040433L;

    public MultilineTableCellRenderer() {
        super("");
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            color = jTable.getSelectionBackground();
            if (LookAndFeelFactory.isGTKLnfInstalled() && LookAndFeelFactory.isLnfInUse("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") && color instanceof ColorUIResource) {
                color = new Color(color.getRGB());
            }
            super.setBackground(color);
        } else {
            super.setForeground(jTable.getForeground());
            super.setBackground(jTable.getBackground());
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            this.setBorder(UIDefaultsLookup.getBorder("Table.focusCellHighlightBorder"));
            if (!bl && jTable.isCellEditable(n, n2)) {
                color = UIDefaultsLookup.getColor("Table.focusCellForeground");
                if (color != null) {
                    super.setForeground(color);
                }
                if ((color = UIDefaultsLookup.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(color);
                }
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setValue(object);
        return this;
    }

    protected void setValue(Object object) {
        this.setText(object == null ? ObjectConverterManager.toString(object) : ObjectConverterManager.toString(object, object.getClass(), this.getConverterContext()));
    }

    @Override
    public void setConverterContext(ConverterContext converterContext) {
        this._context = converterContext;
    }

    @Override
    public ConverterContext getConverterContext() {
        return this._context;
    }

    @Override
    public Class<?> getType() {
        return this._class;
    }

    @Override
    public void setType(Class<?> clazz) {
        this._class = clazz;
    }

    public static class UIResource
    extends MultilineTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

