/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AbstractExpandable;
import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.Cell;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableCell;
import com.jidesoft.grid.HierarchicalTableSupport;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.Property;
import com.jidesoft.grid.PropertyTable;
import com.jidesoft.grid.TreeExpandablePanel;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class MarginExpandablePanel
extends TreeExpandablePanel {
    private Color _marginBackground = null;
    private boolean _paintMarginBackground = true;
    private Font _categoryFont;

    public MarginExpandablePanel(JTable jTable) {
        super(jTable);
    }

    @Deprecated
    public MarginExpandablePanel(JTable jTable, Icon icon, Icon icon2, Color color, Color color2) {
        super(jTable, icon, icon2, color, color2);
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        Rectangle rectangle;
        Component component;
        int n;
        Object object2;
        if (this._table != null) {
            this._categoryFont = this._table.getFont().deriveFont(1);
        }
        this.paintBackground(graphics);
        boolean bl = this._table.getComponentOrientation().isLeftToRight();
        boolean bl2 = this._table instanceof PropertyTable && ((PropertyTable)this._table).isHideMargin();
        int n2 = this._node.getLevel() * 16 + 1;
        int n3 = -1;
        if (this._table instanceof HierarchicalTableSupport) {
            n3 = ((HierarchicalTableSupport)((Object)this._table)).getHorizontalLegPosition(this.getHeight());
        } else if (this._table instanceof TreeTable) {
            n3 = ((TreeTable)this._table).getHorizontalLegPosition(this.getHeight());
        }
        if (n3 == -1) {
            n3 = this.getHeight() / 2;
        }
        boolean bl3 = this.isExpandIconVisible(this._table) && !bl2;
        boolean bl4 = this._node instanceof Expandable;
        if (bl4) {
            bl4 = this._node instanceof AbstractExpandable && ((Expandable)this._node).hasChildren() ? ((AbstractExpandable)this._node).hasVisibleChildren() : ((Expandable)this._node).hasChildren();
        }
        Icon icon = this.getIcon(this._node);
        if (bl3 && bl4 && icon != null) {
            object2 = new Rectangle();
            ((Rectangle)object2).x = bl ? n2 + (16 - icon.getIconWidth()) / 2 : this.getWidth() - n2 - icon.getIconWidth() - (16 - icon.getIconWidth()) / 2;
            n = -(this.getHeight() + 1) % 2;
            ((Rectangle)object2).y = n3 - icon.getIconHeight() / 2 + n;
            ((Rectangle)object2).width = icon.getIconWidth();
            ((Rectangle)object2).height = icon.getIconHeight();
            icon.paintIcon(this, graphics, ((Rectangle)object2).x, ((Rectangle)object2).y);
        }
        if (this._table instanceof PropertyTable && ((PropertyTable)this._table).getMarginRenderer() != null && (component = (object2 = ((PropertyTable)this._table).getMarginRenderer()).getTableCellRendererComponent(this._table, this._node, this.isSelected(), this.hasFocus(), -1, -1)) != null) {
            this.paintComponent(graphics, component, this._table, 0, 0, 16, this.getHeight(), true);
        }
        int n4 = n2 + (bl2 ? 0 : 16) + 0;
        n = this.getWidth() - n4;
        Rectangle rectangle2 = rectangle = bl ? new Rectangle(n4, 0, n, this.getHeight()) : new Rectangle(0, 0, n, this.getHeight());
        if (this._actualRenderer != null) {
            this._actualRenderer.applyComponentOrientation(this._table.getComponentOrientation());
            if (!(this._expandableCell == null || !this._expandableCell.isCategoryRow() || this._table instanceof PropertyTable && ((PropertyTable)this._table).isUseTableRendererForCategoryRow())) {
                if (this._categoryFont != null) {
                    this._actualRenderer.setFont(this._categoryFont);
                }
                if (this.isSelected() && !this._expandableCell.isCategoryRow()) {
                    this._actualRenderer.setForeground(this._table.getSelectionForeground());
                } else {
                    this._actualRenderer.setForeground(((CategorizedTable)this._table).getDisabledForeground());
                }
            }
            this.paintComponent(graphics, this._actualRenderer, this._table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        } else {
            if (this._expandableCell != null && this._expandableCell.isCategoryRow()) {
                if (this._categoryFont != null) {
                    graphics.setFont(this._categoryFont);
                }
                if (this.isSelected() && !this._expandableCell.isCategoryRow()) {
                    graphics.setColor(this._table.getSelectionForeground());
                } else {
                    graphics.setColor(((CategorizedTable)this._table).getDisabledForeground());
                }
            } else {
                graphics.setFont(this._table.getFont());
                if (this.isSelected() && !this._expandableCell.isCategoryRow()) {
                    graphics.setColor(this._table.getSelectionForeground());
                } else if (this._expandableCell != null && this._expandableCell.isEditable()) {
                    graphics.setColor(this._table.getForeground());
                } else {
                    graphics.setColor(((CategorizedTable)this._table).getDisabledForeground());
                }
            }
            if (!this._table.isEnabled()) {
                graphics.setColor(((CategorizedTable)this._table).getDisabledForeground());
            }
            object = graphics.getFontMetrics();
            int n5 = (this.getHeight() - ((FontMetrics)object).getHeight()) / 2 + ((FontMetrics)object).getAscent() + 1;
            String string = !this.shouldShowMargin(this._expandableCell) ? this._expandableCell.toString() : (this.isHasFocus() ? this._expandableCell.getFocusDisplayName() : this._expandableCell.getDisplayName());
            int n6 = SwingUtilities.computeStringWidth((FontMetrics)object, string);
            if (n6 > n) {
                int n7;
                String string2 = "...";
                int n8 = SwingUtilities.computeStringWidth((FontMetrics)object, string2);
                for (n7 = 0; n7 < string.length() && (n8 += ((FontMetrics)object).charWidth(string.charAt(n7))) <= n; ++n7) {
                }
                string = string.substring(0, n7) + string2;
                n6 = SwingUtilities.computeStringWidth((FontMetrics)object, string);
            }
            JideSwingUtilities.drawString(this._table, graphics, string, bl ? n4 : this.getWidth() - n4 - n6, n5);
        }
        if (this.isHasFocus()) {
            object = this.getBorder();
            if (object == null && this.isSelected()) {
                object = UIDefaultsLookup.getBorder("Table.focusSelectedCellHighlightBorder");
                this.setBackground(this._table.getSelectionBackground());
            }
            if (object == null) {
                object = UIDefaultsLookup.getBorder("Table.focusCellHighlightBorder");
            }
            try {
                if (object != null) {
                    if (this._expandableCell.isCategoryRow()) {
                        object.paintBorder(this, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    } else if (this.isPaintMarginBackground() && !bl2) {
                        object.paintBorder(this, graphics, 16, 0, this.getWidth() - 16, this.getHeight());
                    } else {
                        object.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBackground(null);
        }
    }

    protected Icon getIcon(Node node) {
        Icon icon = null;
        if (node instanceof Expandable && node instanceof Cell) {
            if (((Expandable)node).isExpanded()) {
                icon = ((Cell)((Object)node)).isCategoryRow() ? ((CategorizedTable)this._table).getCategoryExpandedIcon() : ((CategorizedTable)this._table).getExpandedIcon();
            } else {
                Icon icon2 = icon = ((Cell)((Object)node)).isCategoryRow() ? ((CategorizedTable)this._table).getCategoryCollapsedIcon() : ((CategorizedTable)this._table).getCollapsedIcon();
            }
            if (!((Expandable)node).isExpandable()) {
                icon = IconsFactory.createGrayImage(this, icon);
            }
        }
        return icon;
    }

    protected boolean shouldShowMargin(ExpandableCell expandableCell) {
        return !(expandableCell instanceof Property) || ((Property)this._expandableCell).getValue() == null;
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        boolean bl;
        boolean bl2 = this._table.getComponentOrientation().isLeftToRight();
        boolean bl3 = bl = this._table instanceof PropertyTable && ((PropertyTable)this._table).isHideMargin();
        if (this._expandableCell != null && this._expandableCell.isCategoryRow()) {
            if (this.isSelected() && !this._expandableCell.isCategoryRow()) {
                Color color = this._table.getSelectionBackground();
                if (this.isPaintMarginBackground() && this.shouldShowMargin(this._expandableCell) && !bl) {
                    if (bl2) {
                        graphics.setColor(this.getMarginBackground());
                        graphics.fillRect(0, 0, 16, this.getHeight());
                        graphics.setColor(color);
                        graphics.fillRect(16, 0, this.getWidth() - 16, this.getHeight());
                    } else {
                        graphics.setColor(this.getMarginBackground());
                        graphics.fillRect(this.getWidth() - 16, 0, 16, this.getHeight());
                        graphics.setColor(color);
                        graphics.fillRect(0, 0, this.getWidth() - 16, this.getHeight());
                    }
                } else {
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            } else if (this.isPaintMarginBackground()) {
                graphics.setColor(this.getMarginBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        } else {
            if (this.isPaintMarginBackground() && !bl) {
                graphics.setColor(this.getMarginBackground());
                if (bl2) {
                    graphics.fillRect(0, 0, 16, this.getHeight());
                } else {
                    graphics.fillRect(this.getWidth() - 16, 0, 16, this.getHeight());
                }
            }
            if (this.isPaintBackground()) {
                Color color = this.isSelected() ? this._table.getSelectionBackground() : this.getBackground();
                graphics.setColor(color);
                if (this.isPaintMarginBackground() && !bl) {
                    if (bl2) {
                        graphics.fillRect(16, 0, this.getWidth() - 16, this.getHeight());
                    } else {
                        graphics.fillRect(0, 0, this.getWidth() - 16, this.getHeight());
                    }
                } else {
                    graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight());
                }
            }
        }
    }

    public Color getMarginBackground() {
        if (this._marginBackground == null) {
            if (this._table instanceof CategorizedTable) {
                return ((CategorizedTable)this._table).getMarginBackground();
            }
            return this._table.getGridColor();
        }
        return this._marginBackground;
    }

    public void setMarginBackground(Color color) {
        this._marginBackground = color;
    }

    public boolean isPaintMarginBackground() {
        return this._paintMarginBackground;
    }

    public void setPaintMarginBackground(boolean bl) {
        this._paintMarginBackground = bl;
    }
}

