/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.RegexFilter;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.ShrinkSearchableSupport;
import com.jidesoft.list.FilterableListModel;
import com.jidesoft.swing.ListSearchable;
import com.jidesoft.swing.Searchable;
import java.beans.PropertyChangeEvent;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.ListModel;

public class ListShrinkSearchableSupport
extends ShrinkSearchableSupport {
    protected FilterableListModel _filterableListModel;

    public ListShrinkSearchableSupport(Searchable searchable) {
        super(searchable);
        if (this._searchable == null || !(this._searchable instanceof ListSearchable)) {
            throw new IllegalArgumentException("The searchable instance should be ListSearchable for ListShrinkSearchableSupport");
        }
    }

    @Override
    protected boolean needReinstallFilterableModel(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getSource() == this._searchable.getComponent() && propertyChangeEvent.getNewValue() != this._filterableListModel;
    }

    @Override
    public void installFilterableModel() {
        if (this._searchable.getComponent() instanceof JList) {
            if (!this._searchable.isSearchableListenerInstalled(this)) {
                this._searchable.addSearchableListener(this);
            }
            this._filterableListModel = this.createFilterableListModel(((JList)this._searchable.getComponent()).getModel());
            this._searchable.getComponent().removePropertyChangeListener("model", this);
            ((JList)this._searchable.getComponent()).setModel(this._filterableListModel);
            this._searchable.getComponent().addPropertyChangeListener("model", this);
        }
    }

    protected FilterableListModel createFilterableListModel(ListModel listModel) {
        return new FilterableListModel(listModel);
    }

    @Override
    public void uninstallFilterableModel() {
        this._searchable.getComponent().removePropertyChangeListener("model", this);
        if (this._filterableListModel != null) {
            this._searchable.removeSearchableListener(this);
            ((JList)this._searchable.getComponent()).setModel(this._filterableListModel.getActualModel());
            this._filterableListModel = null;
        }
    }

    @Override
    protected void applyFilter(String string) {
        Object object;
        if (this._filterableListModel == null) {
            return;
        }
        this._filterableListModel.clearFilters();
        if (this._searchable.isWildcardEnabled() && (object = this._searchable.getWildcardSupport()) != null) {
            string = object.convert(string);
        }
        object = new WildcardFilter(string){
            private static final long serialVersionUID = 2695571198145437693L;

            @Override
            protected String convertElementToString(Object object) {
                Object object2 = this.getObjectGrouper() == null ? object : this.getObjectGrouper().getValue(object);
                String string = ListShrinkSearchableSupport.this.convertElementToString(object2);
                if (string == null) {
                    string = super.convertElementToString(object);
                }
                return string != null ? string : ObjectConverterManager.toString(object2);
            }

            @Override
            protected Pattern createRegexPattern() {
                return Pattern.compile(this.isBeginWith() ? "^" + this.getPattern() : this.getPattern(), this.isCaseSensitive() ? 0 : 2);
            }
        };
        ((RegexFilter)object).setBeginWith(this._searchable.isFromStart());
        ((RegexFilter)object).setEndWith(false);
        this._filterableListModel.addFilter(object);
        this._filterableListModel.setFiltersApplied(true);
    }

    @Override
    protected int getActualIndexAt(int n) {
        if (this._filterableListModel == null) {
            return n;
        }
        return this._filterableListModel.getActualIndexAt(n);
    }

    @Override
    protected int getVisualIndexAt(int n) {
        if (this._filterableListModel == null || n < 0 || n >= this._filterableListModel.getActualModel().getSize()) {
            return n;
        }
        return this._filterableListModel.getIndexAt(n);
    }
}

