/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.FontListCellRenderer;
import com.jidesoft.combobox.ListComboBox;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.LegacyListComboBoxCellEditor;
import com.jidesoft.swing.AutoCompletion;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.text.JTextComponent;

public class LegacyFontNameCellEditor
extends LegacyListComboBoxCellEditor {
    public static final EditorContext CONTEXT = new EditorContext("FontName");
    private static final long serialVersionUID = -5805524500248586743L;

    public LegacyFontNameCellEditor() {
        super(new FontNameComboBoxModel());
    }

    @Override
    protected ListComboBox createListComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
        ListComboBox listComboBox = super.createListComboBox(comboBoxModel, clazz);
        listComboBox.setEditable(true);
        listComboBox.setRenderer(new FontListCellRenderer(listComboBox.getRenderer()));
        this.setupListComboBox(listComboBox);
        return listComboBox;
    }

    protected void setupListComboBox(ListComboBox listComboBox) {
        Component component = listComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < listComboBox.getModel().getSize(); ++i) {
                Object e = listComboBox.getModel().getElementAt(i);
                arrayList.add(e);
            }
            new AutoCompletion((JTextComponent)component, arrayList);
        }
    }

    private static class FontNameComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = 7928225035278585153L;
        private String[] _fontNames = null;
        private Object _selectedFontName;

        protected FontNameComboBoxModel() {
        }

        private void initFontNames() {
            if (this._fontNames != null) {
                return;
            }
            try {
                this._fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void setSelectedItem(Object object) {
            this._selectedFontName = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public void setSelectedFont(Font font) {
            this.initFontNames();
            for (int i = 0; i < this._fontNames.length; ++i) {
                if (!font.getFontName().equals(this._fontNames[i])) continue;
                this.setSelectedItem(this.getElementAt(i));
                break;
            }
        }

        @Override
        public Object getSelectedItem() {
            return this._selectedFontName;
        }

        @Override
        public int getSize() {
            this.initFontNames();
            return this._fontNames.length;
        }

        @Override
        public Object getElementAt(int n) {
            this.initFontNames();
            return this._fontNames[n];
        }
    }
}

