/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.AbstractRow;
import com.jidesoft.grid.Cacheable;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.GroupRow;
import com.jidesoft.grid.ReferenceRow;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.swing.JideSwingUtilities;
import javax.swing.table.TableModel;

public class IndexReferenceRow
extends AbstractRow
implements ReferenceRow,
Cacheable {
    private int _rowIndex;
    private TableModel _tableModel;
    private DefaultGroupTableModel _groupTableModel;
    private Object _filtered = INVALID_VALUE;

    public IndexReferenceRow(TableModel tableModel, int n) {
        this._rowIndex = n;
        this._tableModel = tableModel;
    }

    public IndexReferenceRow(DefaultGroupTableModel defaultGroupTableModel, TableModel tableModel, int n) {
        this._rowIndex = n;
        this._tableModel = tableModel;
        this._groupTableModel = defaultGroupTableModel;
    }

    public int getActualColumnIndex(int n) {
        if (this._groupTableModel != null) {
            int n2 = this._groupTableModel.getActualColumnAt(n);
            if (n2 == -1) {
                return n;
            }
            return n2;
        }
        return n;
    }

    @Override
    public Object getValueAt(int n) {
        TableModel tableModel = this.getTableModel();
        TreeTableModel treeTableModel = this.getTreeTableModel();
        if (treeTableModel instanceof DefaultGroupTableModel) {
            boolean bl = ((DefaultGroupTableModel)treeTableModel).isDisplayCountColumn();
            boolean bl2 = ((DefaultGroupTableModel)treeTableModel).isDisplaySeparateGroupColumn();
            if (bl && n == 0 || bl2 && JideSwingUtilities.equals(((DefaultGroupTableModel)treeTableModel).getColumnIdentifier(n), "GROUP_COLUMN:::HEADER")) {
                return null;
            }
        }
        return tableModel.getValueAt(this.getRowIndex(), this.getActualColumnIndex(n));
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public void setRowIndex(int n) {
        this._rowIndex = n;
    }

    @Override
    public TreeTableModel getTreeTableModel() {
        Expandable expandable = this.getParent();
        if (expandable instanceof RootExpandableRow) {
            return ((RootExpandableRow)expandable).getTreeTableModel();
        }
        if (expandable instanceof GroupRow) {
            return ((GroupRow)((Object)expandable)).getTreeTableModel();
        }
        return null;
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public ConverterContext getConverterContextAt(int n) {
        if (this.getTableModel() instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this.getTableModel()).getConverterContextAt(this.getRowIndex(), this.getActualColumnIndex(n));
        }
        return super.getConverterContextAt(this.getActualColumnIndex(n));
    }

    @Override
    public EditorContext getEditorContextAt(int n) {
        if (this.getTableModel() instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this.getTableModel()).getEditorContextAt(this.getRowIndex(), this.getActualColumnIndex(n));
        }
        return super.getEditorContextAt(this.getActualColumnIndex(n));
    }

    public Class getCellClassAt(int n) {
        if (this.getTableModel() instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this.getTableModel()).getCellClassAt(this.getRowIndex(), this.getActualColumnIndex(n));
        }
        if (this.getTableModel() != null) {
            return this.getTableModel().getColumnClass(this.getActualColumnIndex(n));
        }
        return super.getCellClassAt(this.getActualColumnIndex(n));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getTreeTableModel() instanceof DefaultGroupTableModel && ((DefaultGroupTableModel)this.getTreeTableModel()).isTableModelAdjusting()) {
            return false;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IndexReferenceRow indexReferenceRow = (IndexReferenceRow)object;
        if (this.getRowIndex() != indexReferenceRow.getRowIndex()) {
            return false;
        }
        return !(this.getTableModel() != null ? !this.getTableModel().equals(indexReferenceRow.getTableModel()) : indexReferenceRow.getTableModel() != null);
    }

    public int hashCode() {
        int n = this.getRowIndex();
        n = 31 * n + (this.getTableModel() != null ? this.getTableModel().hashCode() : 0);
        return n;
    }

    @Override
    public Object getCachedValue() {
        return this._filtered;
    }

    @Override
    public void setCachedValue(Object object) {
        this._filtered = object;
    }

    @Override
    public boolean isCacheValid() {
        return this._filtered != INVALID_VALUE;
    }

    @Override
    public void invalidateCache() {
        this._filtered = INVALID_VALUE;
    }

    @Override
    public void invalidateCache(Object object) {
        if (this._filtered == object) {
            this._filtered = INVALID_VALUE;
        }
    }

    @Override
    public boolean isCellEditable(int n) {
        TableModel tableModel = this.getTableModel();
        return tableModel.isCellEditable(this.getRowIndex(), this.getActualColumnIndex(n));
    }

    @Override
    public void setValueAt(Object object, int n) {
        TableModel tableModel = this.getTableModel();
        tableModel.setValueAt(object, this.getRowIndex(), this.getActualColumnIndex(n));
    }
}

