/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ExpandedPanel;
import com.jidesoft.grid.HierarchicalRowHeights;
import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.TableModelWrapperUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class HierarchicalTableLayout
implements LayoutManager {
    private static Comparator COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            if (object instanceof ExpandedPanel && object2 instanceof ExpandedPanel) {
                int n = ((ExpandedPanel)object).getVisualRow();
                int n2 = ((ExpandedPanel)object2).getVisualRow();
                return Integer.compare(n, n2);
            }
            if (object2 instanceof ExpandedPanel) {
                return 1;
            }
            if (object instanceof ExpandedPanel) {
                return -1;
            }
            return -1;
        }
    };

    @Override
    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            if (container instanceof JideTable) {
                int n;
                int n2;
                JideTable jideTable = (JideTable)container;
                TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jideTable.getModel(), HierarchicalTableModel.class);
                if (!(jideTable.getRowHeights() instanceof HierarchicalRowHeights)) {
                    return;
                }
                HierarchicalRowHeights hierarchicalRowHeights = (HierarchicalRowHeights)jideTable.getRowHeights();
                for (int i = 0; i < jideTable.getComponentCount(); ++i) {
                    Component[] componentArray = jideTable.getComponent(i);
                    if (!(componentArray instanceof ExpandedPanel)) continue;
                    int n3 = ((ExpandedPanel)componentArray).getRow();
                    int n4 = TableModelWrapperUtils.getRowAt(jideTable.getModel(), tableModel, n3);
                    int n5 = ((ExpandedPanel)componentArray).getVisualRow();
                    if (n5 == n4) continue;
                    if (n5 != -1) {
                        n2 = jideTable.isBatchProcessing() ? 1 : 0;
                        n = jideTable.isScrollRowWhenRowHeightChanges() ? 1 : 0;
                        jideTable.setBatchProcessing(false);
                        jideTable.setScrollRowWhenRowHeightChanges(false);
                        try {
                            jideTable.setRowHeight(n5, hierarchicalRowHeights.getActualRowHeight(n5));
                        }
                        finally {
                            jideTable.setBatchProcessing(n2 != 0);
                            jideTable.setScrollRowWhenRowHeightChanges(n != 0);
                        }
                    }
                    ((ExpandedPanel)componentArray).setVisualRow(n4);
                }
                Component[] componentArray = jideTable.getComponents();
                Arrays.sort(componentArray, COMPARATOR);
                for (Component component : componentArray) {
                    if (!(component instanceof ExpandedPanel)) continue;
                    n2 = ((ExpandedPanel)component).getRow();
                    n = ((ExpandedPanel)component).getVisualRow();
                    if (n == -1) {
                        component.setVisible(false);
                        continue;
                    }
                    int n6 = hierarchicalRowHeights.getRowPosition(n);
                    int n7 = hierarchicalRowHeights.getActualRowHeight(n);
                    int n8 = ((ExpandedPanel)component).getComponent().getPreferredSize().height;
                    if (tableModel instanceof HierarchicalTableModel && ((HierarchicalTableModel)((Object)tableModel)).isHierarchical(n2)) {
                        n6 += n7;
                        int n9 = n7 + n8;
                        if (jideTable.getRowHeight(n) != n9) {
                            jideTable.setRowHeight(n, n9);
                        }
                    } else if (tableModel instanceof HierarchicalTableModel && !((HierarchicalTableModel)((Object)tableModel)).isHierarchical(n2)) {
                        jideTable.setRowHeight(n, n8);
                    }
                    Rectangle rectangle = new Rectangle(0, n6, jideTable.getWidth(), n8);
                    if (rectangle.equals(component.getBounds())) continue;
                    ComponentListener[] componentListenerArray = ((ExpandedPanel)component).getComponent().getComponentListeners();
                    ComponentListener componentListener = null;
                    for (ComponentListener componentListener2 : componentListenerArray) {
                        if (componentListener2.getClass().getName().indexOf("com.jidesoft.grid.Hierarchical") == -1) continue;
                        componentListener = componentListener2;
                        ((ExpandedPanel)component).getComponent().removeComponentListener(componentListener);
                        break;
                    }
                    component.setBounds(rectangle);
                    if (!component.isVisible()) {
                        component.setVisible(true);
                    }
                    if (componentListener == null) continue;
                    ((ExpandedPanel)component).getComponent().addComponentListener(componentListener);
                }
            }
        }
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        if (!(container instanceof HierarchicalTable)) {
            return null;
        }
        HierarchicalTable hierarchicalTable = (HierarchicalTable)container;
        long l = 0L;
        Enumeration<TableColumn> enumeration = hierarchicalTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(hierarchicalTable, l);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        if (!(container instanceof HierarchicalTable)) {
            return null;
        }
        HierarchicalTable hierarchicalTable = (HierarchicalTable)container;
        long l = 0L;
        Enumeration<TableColumn> enumeration = hierarchicalTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(hierarchicalTable, l);
    }

    private Dimension createTableSize(HierarchicalTable hierarchicalTable, long l) {
        long l2;
        int n = 0;
        int n2 = hierarchicalTable.getRowCount();
        if (n2 > 0 && hierarchicalTable.getColumnCount() > 0) {
            Rectangle rectangle = hierarchicalTable.getCellRect(n2 - 1, 0, true);
            n = rectangle.y + rectangle.height;
        }
        if ((l2 = Math.abs(l)) > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l2, n);
    }
}

