/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class HierarchicalPanel
extends JPanel {
    private Component _component;
    private Border _border;
    private ResizeComponentAdapter _resizeComponentListener;
    private boolean _tabKeyEnabled = true;

    public HierarchicalPanel() {
        this.initComponents();
    }

    public HierarchicalPanel(Component component) {
        this._component = component;
        this.initComponents();
    }

    public HierarchicalPanel(Component component, Border border) {
        this._component = component;
        this._border = border;
        this.initComponents();
    }

    public void setComponent(Component component) {
        if (component != this._component && this._component != null) {
            this._component.removeComponentListener(this._resizeComponentListener);
        }
        this.remove(this._component);
        this._component = component;
        this._component.addComponentListener(this._resizeComponentListener);
        this.add(this._component, "Center");
    }

    protected void initComponents() {
        this._resizeComponentListener = new ResizeComponentAdapter();
        this.setLayout(new BorderLayout());
        if (this._component != null) {
            this.add(this._component, "Center");
            this._component.addComponentListener(this._resizeComponentListener);
        }
        if (this._border == null) {
            this.setDefaultBorder();
        } else {
            this.setBorder(this._border);
        }
        this.disableTableInputMap();
    }

    protected void setDefaultBorder() {
        if (this.getComponentOrientation().isLeftToRight()) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 16));
        }
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        if (this._border == null) {
            this.setDefaultBorder();
        }
    }

    public boolean isTabKeyEnabled() {
        return this._tabKeyEnabled;
    }

    public void setTabKeyEnabled(boolean bl) {
        this._tabKeyEnabled = bl;
    }

    public Set getFocusTraversalKeys(int n) {
        if (!this.isTabKeyEnabled()) {
            return super.getFocusTraversalKeys(n);
        }
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>();
        switch (n) {
            case 0: {
                hashSet.add(KeyStroke.getAWTKeyStroke(9, 0));
                break;
            }
            case 1: {
                hashSet.add(KeyStroke.getAWTKeyStroke(9, 64));
            }
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private void disableTableInputMap() {
        InputMap inputMap = new JTable().getInputMap(1);
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        CustomAction customAction = new CustomAction();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            this.muteAction(keyStrokeArray[i], customAction);
        }
    }

    private void muteAction(KeyStroke keyStroke, Action action) {
        InputMap inputMap = this.getInputMap(1);
        Object object = inputMap.get(keyStroke);
        if (object != null) {
            this.getActionMap().put(object, action);
        } else {
            inputMap.put(keyStroke, keyStroke.toString());
            this.getActionMap().put(keyStroke.toString(), action);
        }
    }

    private static class CustomAction
    extends AbstractAction {
        private CustomAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class ResizeComponentAdapter
    extends ComponentAdapter {
        ResizeComponentAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            HierarchicalPanel.this.setSize(HierarchicalPanel.this.getSize().width, HierarchicalPanel.this.getPreferredSize().height);
        }
    }
}

