/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.DefaultSummaryCalculator;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GroupTable;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.basic.BasicGroupTableHeaderUIDelegate;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class GroupTablePopupMenuCustomizer
implements TableHeaderPopupMenuCustomizer {
    public static final String CONTEXT_MENU_UNGROUP = "GroupTable.ungroup";
    public static final String CONTEXT_MENU_GROUP = "GroupTable.group";
    public static final String CONTEXT_MENU_SUMMARY = "GroupTable.summary";
    public static final String CONTEXT_MENU_EXPAND = "GroupTable.expandColumn";
    public static final String CONTEXT_MENU_COLLAPSE = "GroupTable.collapseColumn";
    public static final String CONTEXT_MENU_EXPAND_ALL = "GroupTable.expandAll";
    public static final String CONTEXT_MENU_COLLAPSE_ALL = "GroupTable.collapseAll";
    private int[] _groupableColumns;
    private Set<Integer> _groupableColumnsSet;
    private Locale _locale;

    public int[] getGroupableColumns() {
        return this._groupableColumns;
    }

    public void setGroupableColumns(int[] nArray) {
        this._groupableColumns = nArray;
    }

    private Set<Integer> getGroupableColumnsSet() {
        int[] nArray;
        if (this._groupableColumnsSet == null) {
            this._groupableColumnsSet = new HashSet<Integer>();
        }
        if ((nArray = this.getGroupableColumns()) != null) {
            for (int n : nArray) {
                this._groupableColumnsSet.add(n);
            }
        } else {
            this._groupableColumnsSet.clear();
        }
        return this._groupableColumnsSet;
    }

    private boolean isGroupable(int n) {
        Set<Integer> set = this.getGroupableColumnsSet();
        return set.size() == 0 || set.contains(n);
    }

    protected String getResourceString(String string) {
        return GridResource.getResourceBundle(this._locale != null ? this._locale : Locale.getDefault()).getString(string);
    }

    @Override
    public void customizePopupMenu(final JTableHeader jTableHeader, JPopupMenu jPopupMenu, int n) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        this._locale = jTableHeader.getLocale();
        if (!(jTableHeader.getTable() instanceof GroupTable)) {
            return;
        }
        final GroupTable groupTable = (GroupTable)jTableHeader.getTable();
        final DefaultGroupTableModel defaultGroupTableModel = (DefaultGroupTableModel)TableModelWrapperUtils.getActualTableModel(groupTable.getModel(), DefaultGroupTableModel.class);
        if (defaultGroupTableModel == null) {
            return;
        }
        TableModel tableModel = defaultGroupTableModel.getActualModel();
        int n3 = n >= 0 ? groupTable.convertColumnIndexToModel(n) : n;
        int n4 = defaultGroupTableModel.getGroupColumnCount();
        int n5 = n3 >= 0 ? defaultGroupTableModel.getActualColumnAt(n3) : (n2 = n3 > -2 || n3 <= -2 - n4 ? n3 : defaultGroupTableModel.getGroupColumnAt(-2 - n3));
        if (n >= 0 && n2 >= 0 && groupTable.getColumnCount() > 1 && defaultGroupTableModel.isColumnGroupable(n2) && this.isGroupable(n2)) {
            String string = tableModel.getColumnName(n2);
            object4 = new JMenuItem(this.getResourceString(CONTEXT_MENU_GROUP) + "(" + this.getResourceString("Sort.ascending") + ")");
            ((Component)object4).setName("GroupTable.group: " + string);
            ((AbstractButton)object4).addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 6635038664900821164L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableUtils.saveColumnOrders(groupTable, false);
                    String string = TableUtils.getTablePreferenceByName(groupTable);
                    String string2 = TableUtils.getSortableTablePreference(groupTable, true);
                    defaultGroupTableModel.addGroupColumn(n2);
                    defaultGroupTableModel.groupAndRefresh();
                    TableUtils.setTablePreferenceByName(groupTable, string);
                    TableUtils.setSortableTablePreference(groupTable, string2, true);
                }
            });
            jPopupMenu.add((JMenuItem)object4);
            object3 = new JMenuItem(this.getResourceString(CONTEXT_MENU_GROUP) + "(" + this.getResourceString("Sort.descending") + ")");
            ((Component)object3).setName("GroupTable.group: " + string + "(descending)");
            ((AbstractButton)object3).addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 6635038664900821164L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableUtils.saveColumnOrders(groupTable, false);
                    String string = TableUtils.getTablePreferenceByName(groupTable);
                    String string2 = TableUtils.getSortableTablePreference(groupTable, true);
                    defaultGroupTableModel.addGroupColumn(n2, -1);
                    defaultGroupTableModel.groupAndRefresh();
                    TableUtils.setTablePreferenceByName(groupTable, string);
                    TableUtils.setSortableTablePreference(groupTable, string2, true);
                }
            });
            jPopupMenu.add((JMenuItem)object3);
            if (defaultGroupTableModel.isSummaryMode()) {
                object2 = new JMenu(this.getResourceString(CONTEXT_MENU_SUMMARY));
                ((Component)object2).setName(CONTEXT_MENU_SUMMARY);
                object = new DefaultSummaryCalculator();
                int[] nArray = ((DefaultSummaryCalculator)object).getAllowedSummaries(defaultGroupTableModel.getActualModel().getColumnClass(n2));
                int n6 = defaultGroupTableModel.getSummaryTypeAt(n2);
                for (final int n7 : nArray) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(((DefaultSummaryCalculator)object).getSummaryName(groupTable.getLocale(), n7));
                    jCheckBoxMenuItem.addActionListener(new AbstractAction(){
                        private static final long serialVersionUID = -5539707754960338635L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            defaultGroupTableModel.setSummaryType(n2, n7);
                        }
                    });
                    if (n6 == n7) {
                        jCheckBoxMenuItem.setSelected(true);
                    }
                    ((JMenu)object2).add(jCheckBoxMenuItem);
                }
                jPopupMenu.add((JMenuItem)object2);
            }
        }
        for (int i = 0; i < defaultGroupTableModel.getGroupColumnCount(); ++i) {
            final int n8 = defaultGroupTableModel.getGroupColumnAt(i);
            object3 = tableModel.getColumnName(n8);
            object2 = this.getResourceString(CONTEXT_MENU_UNGROUP);
            object = new JMenuItem(MessageFormat.format((String)object2, object3));
            ((Component)object).setName("GroupTable.ungroup: " + (String)object3);
            ((AbstractButton)object).addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 2486571101671652864L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = TableUtils.getTablePreferenceByName(groupTable);
                    String string2 = TableUtils.getSortableTablePreference(groupTable, true);
                    int n = -1;
                    if (jTableHeader.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate() instanceof BasicGroupTableHeaderUIDelegate) {
                        n = ((BasicGroupTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)jTableHeader.getUI())).getHeaderUIDelegate()).getActualModelPreferredWidth(n8);
                    }
                    defaultGroupTableModel.removeGroupColumn(n8);
                    defaultGroupTableModel.groupAndRefresh();
                    TableUtils.setTablePreferenceByName(groupTable, string);
                    TableUtils.setSortableTablePreference(groupTable, string2, true);
                    TableUtils.clearColumnOrdersMemory(groupTable);
                    int n2 = jTableHeader.getTable().convertColumnIndexToView(defaultGroupTableModel.getVisualColumnAt(n8));
                    if (n2 >= 0 && n2 < jTableHeader.getColumnModel().getColumnCount() && n > 0) {
                        TableColumn tableColumn = jTableHeader.getColumnModel().getColumn(n2);
                        tableColumn.setPreferredWidth(n);
                        tableColumn.setWidth(n);
                    }
                }
            });
            jPopupMenu.add((JMenuItem)object);
        }
        if (defaultGroupTableModel.hasGroupColumns()) {
            TableHeaderPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            if (n2 >= 0 && defaultGroupTableModel.isColumnGrouped(n2)) {
                String string = defaultGroupTableModel.getActualModel().getColumnName(n2);
                object4 = this.getResourceString(CONTEXT_MENU_EXPAND);
                object3 = new JMenuItem(new AbstractAction(MessageFormat.format((String)object4, string)){
                    private static final long serialVersionUID = -5920488828818748698L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = -1;
                        for (int i = defaultGroupTableModel.getGroupColumnCount() - 1; i >= 0; --i) {
                            if (defaultGroupTableModel.getGroupColumnAt(i) != n2) continue;
                            n = i;
                            break;
                        }
                        if (n >= 0) {
                            defaultGroupTableModel.expandGroupColumn(n);
                        }
                    }
                });
                ((Component)object3).setName(CONTEXT_MENU_EXPAND);
                jPopupMenu.add((JMenuItem)object3);
                object4 = this.getResourceString(CONTEXT_MENU_COLLAPSE);
                object2 = new JMenuItem(new AbstractAction(MessageFormat.format((String)object4, string)){
                    private static final long serialVersionUID = -4282114364839496014L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = -1;
                        for (int i = defaultGroupTableModel.getGroupColumnCount() - 1; i >= 0; --i) {
                            if (defaultGroupTableModel.getGroupColumnAt(i) != n2) continue;
                            n = i;
                            break;
                        }
                        if (n >= 0) {
                            defaultGroupTableModel.collapseGroupColumn(n);
                        }
                    }
                });
                ((Component)object2).setName(CONTEXT_MENU_COLLAPSE);
                jPopupMenu.add((JMenuItem)object2);
            }
            JMenuItem jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString(CONTEXT_MENU_EXPAND_ALL)){
                private static final long serialVersionUID = -5539707754960338635L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    groupTable.expandAll();
                }
            });
            jMenuItem.setName(CONTEXT_MENU_EXPAND_ALL);
            jPopupMenu.add(jMenuItem);
            object4 = new JMenuItem(new AbstractAction(this.getResourceString(CONTEXT_MENU_COLLAPSE_ALL)){
                private static final long serialVersionUID = -6954218961074237551L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    groupTable.collapseAll();
                }
            });
            ((Component)object4).setName(CONTEXT_MENU_COLLAPSE_ALL);
            jPopupMenu.add((JMenuItem)object4);
        }
    }
}

