/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.combobox.FontListCellRenderer;
import com.jidesoft.combobox.ListExComboBox;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.ListComboBoxCellEditor;
import com.jidesoft.swing.AutoCompletion;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.text.JTextComponent;

public class FontNameCellEditor
extends ListComboBoxCellEditor {
    public static final EditorContext CONTEXT = new EditorContext("FontName");
    private static final long serialVersionUID = -259915094957510669L;

    public FontNameCellEditor() {
        super(new FontNameComboBoxModel());
    }

    @Override
    protected ListExComboBox createListComboBox(ComboBoxModel comboBoxModel, Class<?> clazz) {
        ListExComboBox listExComboBox = super.createListComboBox(comboBoxModel, clazz);
        listExComboBox.setEditable(true);
        listExComboBox.setRenderer(new FontListCellRenderer(listExComboBox.getRenderer()));
        this.setupListComboBox(listExComboBox);
        return listExComboBox;
    }

    protected void setupListComboBox(ListExComboBox listExComboBox) {
        Component component = listExComboBox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < listExComboBox.getModel().getSize(); ++i) {
                Object e = listExComboBox.getModel().getElementAt(i);
                arrayList.add(e);
            }
            new AutoCompletion((JTextComponent)component, arrayList);
        }
    }

    private static class FontNameComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private static final long serialVersionUID = -4940532017466186600L;
        private String[] _fontNames = null;
        private Object _selectedFontName;

        protected FontNameComboBoxModel() {
        }

        private void initFontNames() {
            if (this._fontNames != null) {
                return;
            }
            try {
                this._fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void setSelectedItem(Object object) {
            this._selectedFontName = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public void setSelectedFont(Font font) {
            this.initFontNames();
            for (int i = 0; i < this._fontNames.length; ++i) {
                if (!font.getFontName().equals(this._fontNames[i])) continue;
                this.setSelectedItem(this.getElementAt(i));
                break;
            }
        }

        @Override
        public Object getSelectedItem() {
            return this._selectedFontName;
        }

        @Override
        public int getSize() {
            this.initFontNames();
            return this._fontNames.length;
        }

        @Override
        public Object getElementAt(int n) {
            this.initFontNames();
            return this._fontNames[n];
        }
    }
}

