/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.filter.Filter;
import com.jidesoft.grid.AbstractGroupTableModel;
import com.jidesoft.grid.CachedTableModel;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.DefaultGroupRow;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ITreeTableModel;
import com.jidesoft.grid.IndexedRowTableModelWrapper;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.RowTableModelValueProvider;
import com.jidesoft.grid.RowValueProvider;
import com.jidesoft.grid.TableFilter;
import com.jidesoft.grid.TableModelValueProvider;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableRowFilter;
import com.jidesoft.grid.TreeTableUtils;
import com.jidesoft.grid.ValueProvider;
import com.jidesoft.grid.WrapperOfIndexdRowTableModelWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.TableModel;

public class FilterableTreeTableModel<T extends Row>
extends FilterableTableModel
implements ITreeTableModel<T> {
    private static final long serialVersionUID = 7749851797462584730L;
    private boolean _keepAllChildren = true;
    private boolean _keepParentNode = true;
    private int _defaultPossibleValuesType = 127;
    private int[] _possibleValuesTypes;
    private Map<Row, Boolean> _rowVisibleCache;
    public static final int POSSIBLE_VALUES_FIRST_LEVEL = 1;
    public static final int POSSIBLE_VALUES_LEAF_LEVEL = 2;
    public static final int POSSIBLE_VALUES_NON_FIRST_NON_LEAF_LEVEL = 4;
    public static final int POSSIBLE_VALUES_COLLAPSED_ROWS = 128;
    public static final int POSSIBLE_VALUES_ALL_ROWS = 255;
    private Map<Integer, Set<Integer>> _cachedRowRelations;
    private Map<Integer, List<RowValueProvider>> _cachedCollapsedRows;
    private Map<Integer, List<Set<Row>>> _cachedFilteredCollapsedRows;
    private final Map<Object, Boolean> _filterCache = new HashMap<Object, Boolean>();

    public FilterableTreeTableModel(TableModel tableModel) {
        super(tableModel);
        this.setFilterAlgorithm(1);
        if (TableModelWrapperUtils.getActualTableModel(tableModel, DefaultGroupTableModel.class) != null) {
            this.setDefaultPossibleValuesType(2);
        }
    }

    public boolean isKeepAllChildren() {
        return this._keepAllChildren;
    }

    public void setKeepAllChildren(boolean bl) {
        this._keepAllChildren = bl;
    }

    public boolean isKeepParentNode() {
        return this._keepParentNode;
    }

    public void setKeepParentNode(boolean bl) {
        this._keepParentNode = bl;
    }

    @Override
    protected void filter(boolean bl) {
        if (this.isFilteringPaused()) {
            return;
        }
        if (this._rowVisibleCache != null) {
            this._rowVisibleCache.clear();
        }
        this._rowVisibleCache = null;
        super.filter(bl);
    }

    @Override
    protected void invalidateFilterCache() {
        super.invalidateFilterCache();
        if (this.getFilterAlgorithm() == 1) {
            if (this._cachedRowRelations == null) {
                this._cachedRowRelations = new HashMap<Integer, Set<Integer>>();
            } else {
                this._cachedRowRelations.clear();
            }
            if (this._cachedCollapsedRows == null) {
                this._cachedCollapsedRows = new HashMap<Integer, List<RowValueProvider>>();
            } else {
                this._cachedCollapsedRows.clear();
            }
            if (this._cachedFilteredCollapsedRows == null) {
                this._cachedFilteredCollapsedRows = new HashMap<Integer, List<Set<Row>>>();
            } else {
                this._cachedFilteredCollapsedRows.clear();
            }
            if (this._originalEvent != null && !(this._originalEvent instanceof CompoundTableModelEvent) && this._rowVisibleCache != null) {
                this._rowVisibleCache.clear();
            }
        } else {
            this._filterCache.clear();
        }
    }

    void invalidateFilterCache(int n, int n2) {
        if (this.getFilterAlgorithm() == 1) {
            for (int i = n; i <= n2; ++i) {
                if (this._cachedRowRelations != null) {
                    this._cachedRowRelations.remove(i);
                    this._cachedRowRelations.remove(-1 - i);
                }
                if (this._cachedCollapsedRows != null) {
                    this._cachedCollapsedRows.remove(i);
                }
                if (this._cachedFilteredCollapsedRows != null) {
                    this._cachedFilteredCollapsedRows.remove(i);
                }
                if (!(this._cachedRowRelations != null && !this._cachedRowRelations.isEmpty() || this._cachedCollapsedRows != null && !this._cachedCollapsedRows.isEmpty() || this._cachedFilteredCollapsedRows != null && !this._cachedFilteredCollapsedRows.isEmpty())) break;
                this._rowVisibleCache.clear();
            }
        }
    }

    @Deprecated
    protected void invalidateFilterCache(Object object) {
        this.invalidateFilterCache(object, false);
    }

    @Deprecated
    protected void invalidateFilterCache(Object object, boolean bl) {
        super.invalidateFilterCache();
    }

    @Override
    protected void tableRowsUpdated(int n, int n2) {
        this.invalidateFilterCache(n, n2);
        super.tableRowsUpdated(n, n2);
    }

    @Override
    protected void tableCellsUpdated(int n, int n2, int n3) {
        if (n == -1 || this.hasFilter(n)) {
            this.invalidateFilterCache(n2, n3);
        }
        super.tableCellsUpdated(n, n2, n3);
    }

    @Override
    List<Integer> expandRowList(List<Integer> list, Filter filter, int n) {
        Object object;
        Collection<Object> collection;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
        if (!(tableModel instanceof IExpandableTreeTableModel)) {
            return super.expandRowList(list, filter, n);
        }
        if (tableModel instanceof AbstractGroupTableModel && !((AbstractGroupTableModel)tableModel).isGroupEnabled()) {
            return super.expandRowList(list, filter, n);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(list);
        if (this.isKeepAllChildren()) {
            for (int n2 : list) {
                collection = this._cachedRowRelations.get(n2);
                if (collection != null) {
                    hashSet.addAll(collection);
                    continue;
                }
                object = TreeTableUtils.getRow(this._model, n2);
                collection = new HashSet<Integer>();
                if (object instanceof Expandable && ((Expandable)object).hasChildren()) {
                    for (int i = TreeTableUtils.getDescendantCount(this._model, (Row)object, false, false) - 1; i >= 0; --i) {
                        int n3 = n2 + i + 1;
                        collection.add(n3);
                    }
                }
                this._cachedRowRelations.put(n2, (Set<Integer>)collection);
                hashSet.addAll(collection);
            }
        }
        if (this.isKeepParentNode()) {
            for (int i = tableModel.getRowCount() - 1; i >= 0; --i) {
                if (hashSet.contains(i)) continue;
                List<RowValueProvider> list2 = this._cachedCollapsedRows.get(i);
                if (list2 == null && (collection = TreeTableUtils.getRow(this._model, i)) instanceof Expandable && ((Expandable)((Object)collection)).hasChildren() && !TreeTableUtils.hasDescendant(tableModel, collection, false, false)) {
                    list2 = this.getCollapsedRows((Expandable)((Object)collection));
                    this._cachedCollapsedRows.put(i, list2);
                }
                if (list2 == null || list2.size() <= 0) continue;
                collection = this._cachedFilteredCollapsedRows.get(i);
                if (collection == null) {
                    collection = new ArrayList();
                    this._cachedFilteredCollapsedRows.put(i, (List<Set<Row>>)collection);
                }
                object = new HashSet();
                for (RowValueProvider rowValueProvider : list2) {
                    if (this.isValueFiltered(this._model, rowValueProvider, filter, n)) continue;
                    if (object.size() == 0) {
                        hashSet.add(i);
                        list.add(i);
                    }
                    object.add(rowValueProvider.getRow());
                }
                collection.add(object);
            }
            for (int n4 : list) {
                collection = this._cachedRowRelations.get(-1 - n4);
                if (collection != null) {
                    hashSet.addAll(collection);
                    continue;
                }
                object = TreeTableUtils.getRow(this._model, n4);
                collection = this.getAncestorSet(this._model, (Row)object);
                this._cachedRowRelations.put(-1 - n4, (Set<Integer>)collection);
                hashSet.addAll(collection);
            }
        }
        Iterator<Integer> iterator = new ArrayList();
        iterator.addAll(hashSet);
        Collections.sort(iterator);
        return iterator;
    }

    @Override
    boolean shouldKeepThisRow(ValueProvider valueProvider, int n, List<List<Integer>> list) {
        Row row;
        boolean bl;
        if (this._rowVisibleCache == null) {
            this._rowVisibleCache = new HashMap<Row, Boolean>();
        }
        if ((bl = super.shouldKeepThisRow(valueProvider, n, list)) && valueProvider instanceof RowValueProvider && super.shouldBeFiltered(valueProvider, n, this._allColumnFilters, this._anyColumnFilters, this._eachColumnFilters) && this.isKeepParentNode()) {
            bl = this.hasValidCollapsedChildren(n);
        }
        if ((row = TreeTableUtils.getRow(this.getActualModel(), n)) != null) {
            this._rowVisibleCache.put(row, bl);
        }
        return bl;
    }

    @Override
    void setCacheIfNecessary(List<Integer> list) {
        super.setCacheIfNecessary(list);
        for (Integer n : this._cachedCollapsedRows.keySet()) {
            this.hasValidCollapsedChildren(n);
        }
    }

    private boolean hasValidCollapsedChildren(int n) {
        List<Set<Row>> list;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
        if (!(tableModel instanceof IExpandableTreeTableModel)) {
            return true;
        }
        if (tableModel instanceof AbstractGroupTableModel && !((AbstractGroupTableModel)tableModel).isGroupEnabled()) {
            return true;
        }
        IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)tableModel);
        Row row = iExpandableTreeTableModel.getRowAt(TableModelWrapperUtils.getActualRowAt(this._model, n, tableModel));
        boolean bl = true;
        if (row instanceof Expandable && !((Expandable)((Object)row)).isExpanded() && this._cachedCollapsedRows.get(n) != null && this._cachedCollapsedRows.get(n).size() > 0 && (list = this._cachedFilteredCollapsedRows.get(n)) != null) {
            Object object;
            Collection<Object> collection;
            HashSet<Row> hashSet = new HashSet<Row>();
            if (list.size() > 1 && this.isAndMode()) {
                collection = list.get(0);
                for (Row row2 : collection) {
                    int n2;
                    for (n2 = list.size() - 1; n2 >= 1 && (object = list.get(n2)).contains(row2); --n2) {
                    }
                    if (n2 >= 1) continue;
                    hashSet.add(row2);
                }
            } else {
                for (Set<Row> set : list) {
                    hashSet.addAll(set);
                }
            }
            if (this.isKeepParentNode()) {
                collection = new HashSet();
                for (Row row3 : hashSet) {
                    for (Expandable expandable = row3.getParent(); expandable != row && expandable instanceof Row && !hashSet.contains(object = (Row)((Object)expandable)) && !collection.contains(object); expandable = expandable.getParent()) {
                        collection.add(object);
                    }
                }
                hashSet.addAll(collection);
            }
            bl = hashSet.size() > 0;
            collection = this._cachedCollapsedRows.get(n);
            if (collection != null) {
                for (RowValueProvider rowValueProvider : collection) {
                    Row row4 = rowValueProvider.getRow();
                    this._rowVisibleCache.put(row4, hashSet.contains(row4));
                }
            }
        }
        return bl;
    }

    private Set<Integer> getAncestorSet(TableModel tableModel, Row row) {
        if (row == null) {
            return new HashSet<Integer>();
        }
        if (tableModel instanceof CachedTableModel) {
            return this.getAncestorSet(((CachedTableModel)tableModel).getActualModel(), row);
        }
        if (!(tableModel instanceof ITreeTableModel)) {
            return new HashSet<Integer>();
        }
        Row row2 = (Row)((Object)row.getParent());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (row2 != null && row2 != ((ITreeTableModel)((Object)tableModel)).getRoot()) {
            int n = TableModelWrapperUtils.getRowAt(this._model, tableModel, ((ITreeTableModel)((Object)tableModel)).getRowIndex(row2));
            Set<Integer> set = this._cachedRowRelations.get(-1 - n);
            if (set == null) {
                set = this.getAncestorSet(tableModel, row2);
                this._cachedRowRelations.put(-1 - n, set);
            }
            hashSet.add(n);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    @Override
    public Row getRowAt(int n) {
        IndexedRowTableModelWrapper indexedRowTableModelWrapper;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._model, ITreeTableModel.class);
        if (!(tableModel instanceof ITreeTableModel)) {
            return null;
        }
        ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
        int n2 = TableModelWrapperUtils.getActualRowAt((TableModel)this, n, tableModel);
        if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            n2 = indexedRowTableModelWrapper.getActualRowAt(n2);
        }
        return iTreeTableModel.getRowAt(n2);
    }

    @Override
    public int getRowIndex(T t) {
        IndexedRowTableModelWrapper indexedRowTableModelWrapper;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._model, ITreeTableModel.class);
        if (!(tableModel instanceof ITreeTableModel)) {
            return -1;
        }
        ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
        int n = iTreeTableModel.getRowIndex(t);
        if (tableModel instanceof WrapperOfIndexdRowTableModelWrapper && (indexedRowTableModelWrapper = ((WrapperOfIndexdRowTableModelWrapper)((Object)tableModel)).getIndexedRowTableModelWrapper()) != null && indexedRowTableModelWrapper.getActualModel() instanceof ITreeTableModel) {
            n = indexedRowTableModelWrapper.getVisualRowAt(n);
        }
        return this.getVisualRowAt(n);
    }

    @Override
    public Object getRoot() {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this._model, ITreeTableModel.class);
        if (!(tableModel instanceof ITreeTableModel)) {
            return null;
        }
        ITreeTableModel iTreeTableModel = (ITreeTableModel)((Object)tableModel);
        return iTreeTableModel.getRoot();
    }

    @Override
    protected List<Integer> shouldNotBeFiltered(ValueProvider valueProvider, List<Integer> list, Filter filter, int n) {
        if (!this.isFiltersApplied() || filter == null || !filter.isEnabled() || list.isEmpty()) {
            return list;
        }
        IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class));
        DefaultGroupTableModel defaultGroupTableModel = (DefaultGroupTableModel)TableModelWrapperUtils.getActualTableModel(this._model, DefaultGroupTableModel.class);
        if (filter instanceof TableRowFilter && n == -2 && iExpandableTreeTableModel != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            boolean bl = false;
            if (!(valueProvider instanceof RowValueProvider) && !(valueProvider instanceof RowTableModelValueProvider)) {
                bl = true;
            }
            for (int n2 : list) {
                Row row;
                if (bl) {
                    row = iExpandableTreeTableModel.getRowAt(TableModelWrapperUtils.getActualRowAt(this._model, n2, (TableModel)((Object)iExpandableTreeTableModel)));
                    valueProvider = new RowValueProvider(row);
                }
                if (filter.isValueFiltered(row = valueProvider instanceof RowValueProvider ? ((RowValueProvider)valueProvider).getRow() : ((RowTableModelValueProvider)valueProvider).getRowAt(n2))) continue;
                arrayList.add(n2);
            }
            return arrayList;
        }
        if (filter instanceof QuickTableFilterField.FieldTableFilter && defaultGroupTableModel != null && n == -2) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n3 = this._model.getColumnCount();
            for (int n4 : list) {
                boolean bl = true;
                for (int i = 0; i < n3; ++i) {
                    int n5;
                    Row row;
                    int n6;
                    Object object;
                    if (!this._columnIncluded[i]) continue;
                    ((TableFilter)filter).setValueProvider(valueProvider);
                    ((TableFilter)filter).setColumnIndex(i);
                    ((TableFilter)filter).setRowIndex(n4);
                    if (i == 0 && (object = ((QuickTableFilterField.FieldTableFilter)filter).getActualSearchingColumnIndices()) != null && !object.contains(n6 = (row = defaultGroupTableModel.getRowAt(n5 = TableModelWrapperUtils.getActualRowAt(this._model, n4, defaultGroupTableModel))) instanceof DefaultGroupRow ? ((DefaultGroupRow)row).getConditionColumn(((DefaultGroupRow)row).getNumberOfConditions() - 1) : TableModelWrapperUtils.getActualColumnAt(this._model, 0, defaultGroupTableModel.getActualModel())) || filter.isValueFiltered(object = valueProvider.getValueAt(n4, i))) continue;
                    bl = false;
                    break;
                }
                if (bl) continue;
                arrayList.add(n4);
            }
            return arrayList;
        }
        return super.shouldNotBeFiltered(valueProvider, list, filter, n);
    }

    private List<RowValueProvider> getCollapsedRows(Expandable expandable) {
        Map<Row, Boolean> map;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List<?> list = expandable.getChildren();
        if (list == null) {
            return new ArrayList<RowValueProvider>();
        }
        arrayList.addAll(list);
        for (int i = 0; i < arrayList.size(); ++i) {
            map = (Row)arrayList.get(i);
            if (!(map instanceof Expandable) || ((Expandable)((Object)map)).getChildren() == null) continue;
            for (Object e : ((Expandable)((Object)map)).getChildren()) {
                arrayList.add(e);
            }
        }
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getActualModel(), FilterableTreeTableModel.class);
        while (tableModel instanceof FilterableTreeTableModel) {
            map = ((FilterableTreeTableModel)tableModel).getRowVisibleCache();
            if (map != null) {
                int e;
                ArrayList arrayList2 = new ArrayList();
                boolean n = false;
                while (e < arrayList.size()) {
                    Boolean bl = (Boolean)map.get(arrayList.get(e));
                    if (bl == null || !bl.booleanValue()) {
                        arrayList2.add(e);
                    }
                    ++e;
                }
                for (e = arrayList2.size() - 1; e >= 0; --e) {
                    arrayList.remove(arrayList2.get(e));
                }
            }
            tableModel = TableModelWrapperUtils.getActualTableModel(((FilterableTreeTableModel)tableModel).getActualModel(), FilterableTreeTableModel.class);
        }
        map = new ArrayList<RowValueProvider>();
        for (Object e : arrayList) {
            map.add((RowValueProvider)new RowValueProvider((Row)e));
        }
        return map;
    }

    private boolean isValueFiltered(TableModel tableModel, RowValueProvider rowValueProvider, Filter filter, int n) {
        if (tableModel instanceof CachedTableModel) {
            return this.isValueFiltered(((CachedTableModel)tableModel).getActualModel(), rowValueProvider, filter, n);
        }
        if (!(tableModel instanceof ITreeTableModel)) {
            return false;
        }
        int n2 = ((ITreeTableModel)((Object)tableModel)).getRowIndex(rowValueProvider.getRow());
        if (n == -2) {
            int n3 = this._model.getColumnCount();
            boolean bl = true;
            for (int i = 0; i < n3; ++i) {
                Object object;
                if (!this._columnIncluded[i]) continue;
                if (filter instanceof TableFilter) {
                    ((TableFilter)filter).setValueProvider(rowValueProvider);
                    ((TableFilter)filter).setRowIndex(n2);
                    ((TableFilter)filter).setColumnIndex(i);
                }
                if (filter.isValueFiltered(object = filter instanceof TableRowFilter ? rowValueProvider.getRow() : rowValueProvider.getValueAt(n2, i))) continue;
                bl = false;
                break;
            }
            return bl;
        }
        if (filter instanceof TableFilter) {
            ((TableFilter)filter).setValueProvider(rowValueProvider);
            ((TableFilter)filter).setRowIndex(n2);
            ((TableFilter)filter).setColumnIndex(n);
        }
        Object object = filter instanceof TableRowFilter ? rowValueProvider.getRow() : rowValueProvider.getValueAt(n2, n);
        return filter.isValueFiltered(object);
    }

    @Override
    protected boolean shouldBeFiltered(ValueProvider valueProvider, int n, List<Filter> list, List<Filter> list2, List<Filter>[] listArray) {
        boolean bl;
        if (!this.isKeepAllChildren()) {
            return this.filtering(valueProvider, n, list, list2, listArray);
        }
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        List[] listArray2 = new List[listArray.length];
        if (list != null && list.size() > 0) {
            for (Filter list3 : list) {
                arrayList.clear();
                arrayList.add(list3);
                bl = this.filtering(valueProvider, n, arrayList, null, listArray2);
                if (!bl) continue;
                return bl;
            }
        }
        if (list2 != null && list2.size() > 0) {
            for (Filter filter : list2) {
                arrayList.clear();
                arrayList.add(filter);
                bl = this.filtering(valueProvider, n, null, arrayList, listArray2);
                if (!bl) continue;
                return bl;
            }
        }
        if (listArray.length > 0) {
            for (int i = 0; i < listArray.length; ++i) {
                List<Filter> list3 = listArray[i];
                if (list3 == null || list3.size() <= 0) continue;
                for (Filter filter : list3) {
                    boolean bl2;
                    arrayList.clear();
                    arrayList.add(filter);
                    for (bl2 = false; bl2 < listArray2.length; bl2 += 1) {
                        listArray2[bl2] = null;
                    }
                    listArray2[i] = arrayList;
                    bl2 = this.filtering(valueProvider, n, null, null, listArray2);
                    if (!bl2) continue;
                    return bl2;
                }
            }
        }
        return false;
    }

    protected boolean shouldBeFilteredCached(ValueProvider valueProvider, int n, List<Filter> list, List<Filter> list2, List<Filter>[] listArray) {
        Boolean bl;
        if (valueProvider instanceof RowValueProvider ? (bl = this._filterCache.get(((RowValueProvider)valueProvider).getRow())) != null : (valueProvider instanceof RowTableModelValueProvider ? (bl = this._filterCache.get(((RowTableModelValueProvider)valueProvider).getRowAt(n))) != null : !(valueProvider instanceof TableModelValueProvider) && (bl = this._filterCache.get(valueProvider)) != null)) {
            return bl;
        }
        boolean bl2 = super.shouldBeFiltered(valueProvider, n, list, list2, listArray);
        if (valueProvider instanceof RowValueProvider) {
            Row row = ((RowValueProvider)valueProvider).getRow();
            this._filterCache.put(row, bl2);
            if (this.isKeepAllChildren() && !bl2 && row instanceof Expandable) {
                int n2 = ((Expandable)((Object)row)).getChildrenCount();
                for (int i = 0; i < n2; ++i) {
                    this._filterCache.put(((Expandable)((Object)row)).getChildAt(i), false);
                }
            }
        } else if (valueProvider instanceof RowTableModelValueProvider) {
            Row row = ((RowTableModelValueProvider)valueProvider).getRowAt(n);
            this._filterCache.put(row, bl2);
            if (this.isKeepAllChildren() && !bl2 && row instanceof Expandable) {
                int n3 = ((Expandable)((Object)row)).getChildrenCount();
                for (int i = 0; i < n3; ++i) {
                    this._filterCache.put(((Expandable)((Object)row)).getChildAt(i), false);
                }
            }
        } else {
            this._filterCache.put(valueProvider, bl2);
        }
        return bl2;
    }

    protected boolean filtering(ValueProvider valueProvider, int n, List<Filter> list, List<Filter> list2, List<Filter>[] listArray) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this, IExpandableTreeTableModel.class);
        if (tableModel instanceof AbstractGroupTableModel && !((AbstractGroupTableModel)tableModel).isGroupEnabled()) {
            return this.shouldBeFilteredCached(valueProvider, n, list, list2, listArray);
        }
        if (tableModel instanceof IExpandableTreeTableModel) {
            Row row;
            IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)tableModel);
            Row row2 = row = valueProvider instanceof RowValueProvider ? ((RowValueProvider)valueProvider).getRow() : iExpandableTreeTableModel.getRowAt(TableModelWrapperUtils.getActualRowAt(this._model, n, tableModel));
            if (row == null) {
                return true;
            }
            boolean bl = !(row instanceof Expandable) || !((Expandable)((Object)row)).hasChildren();
            boolean bl2 = row.getParent() == iExpandableTreeTableModel.getRoot();
            boolean bl3 = this.shouldBeFilteredCached(valueProvider instanceof RowValueProvider ? valueProvider : new RowValueProvider(row), n, list, list2, listArray);
            if (bl3 && this.isKeepAllChildren() && !bl2) {
                for (Row row3 = (Row)((Object)row.getParent()); row3 != null && row3 != iExpandableTreeTableModel.getRoot(); row3 = (Row)((Object)row3.getParent())) {
                    bl3 = this.shouldBeFilteredCached(new RowValueProvider(row3), iExpandableTreeTableModel.getRowIndex(row3), list, list2, listArray);
                    if (bl3) continue;
                    return false;
                }
            }
            if (bl3 && !bl && this.isKeepParentNode()) {
                for (int i = 0; i < ((Expandable)((Object)row)).getChildrenCount(); ++i) {
                    Row row4 = (Row)((Expandable)((Object)row)).getChildAt(i);
                    bl3 = this.shouldBeFilteredCached(new RowValueProvider(row4), iExpandableTreeTableModel.getRowIndex(row4), list, list2, listArray);
                    if (bl3) continue;
                    return false;
                }
                return true;
            }
            return bl3;
        }
        return this.shouldBeFilteredCached(valueProvider, n, list, list2, listArray);
    }

    protected boolean shouldRowBeIncluded(int n, Row row) {
        if (row == null) {
            return true;
        }
        int n2 = this.getPossibleValuesType(n);
        if ((n2 & 1) == 1 && row.getParent() == this.getRoot()) {
            return true;
        }
        if (!((n2 & 2) != 2 || row instanceof Expandable && ((Expandable)((Object)row)).isExpandable() && ((Expandable)((Object)row)).hasChildren())) {
            return true;
        }
        return (n2 & 4) == 4 && row.getParent() != this.getRoot() && row instanceof Expandable && ((Expandable)((Object)row)).isExpandable() && ((Expandable)((Object)row)).hasChildren();
    }

    @Override
    public Object[] getPossibleValues(int n, Comparator comparator) {
        if (n >= 0 && n < this.getColumnCount()) {
            HashSet<Object> hashSet = new HashSet<Object>();
            boolean bl = false;
            Filter[] filterArray = this.getFilters(n);
            FilterableTreeTableModel filterableTreeTableModel = filterArray == null || filterArray.length == 0 ? this : this._model;
            int n2 = filterableTreeTableModel.getRowCount();
            for (int i = 0; i < n2; ++i) {
                Row row;
                Iterator iterator = filterableTreeTableModel.getValueAt(i, n);
                boolean bl2 = this.shouldPossibleValueBeIncluded(iterator, n);
                if (bl2 && filterableTreeTableModel instanceof ITreeTableModel) {
                    bl2 = this.shouldRowBeIncluded(n, ((ITreeTableModel)filterableTreeTableModel).getRowAt(i));
                }
                if (bl2) {
                    if (iterator == null) {
                        bl = true;
                    } else {
                        hashSet.add(iterator);
                    }
                }
                if ((this.getPossibleValuesType(n) & 0x80) == 0 || !(filterableTreeTableModel instanceof ITreeTableModel) || !((row = ((ITreeTableModel)filterableTreeTableModel).getRowAt(i)) instanceof Expandable) || !((Expandable)((Object)row)).isExpandable() || !((Expandable)((Object)row)).hasChildren() || ((Expandable)((Object)row)).isExpanded()) continue;
                List<Row> list = TreeTableUtils.getDescendants(filterableTreeTableModel, row, false, false, true);
                for (Row row2 : list) {
                    Object object = this.getValueAt(row2, n);
                    bl2 = this.shouldPossibleValueBeIncluded(object, n) && this.shouldRowBeIncluded(n, row2);
                    if (!bl2) continue;
                    if (object == null) {
                        bl = true;
                        continue;
                    }
                    hashSet.add(object);
                }
            }
            Object[] objectArray = new Object[bl ? hashSet.size() + 1 : hashSet.size()];
            n2 = 0;
            if (bl) {
                objectArray[n2] = null;
                ++n2;
            }
            for (Object e : hashSet) {
                objectArray[n2] = e;
                ++n2;
            }
            try {
                if (objectArray.length >= 2) {
                    if (bl) {
                        Arrays.sort(objectArray, 1, objectArray.length, comparator);
                    } else {
                        Arrays.sort(objectArray, comparator);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return objectArray;
        }
        return null;
    }

    protected Object getValueAt(Row row, int n) {
        if (row == null) {
            return null;
        }
        int n2 = TableModelWrapperUtils.getActualColumnAt((TableModel)this, n, IExpandableTreeTableModel.class);
        if (n2 >= 0) {
            return row.getValueAt(n2);
        }
        int n3 = this.getRowIndex(row);
        return this.getValueAt(n3, n);
    }

    public int getDefaultPossibleValuesType() {
        return this._defaultPossibleValuesType;
    }

    public void setDefaultPossibleValuesType(int n) {
        this._defaultPossibleValuesType = n;
    }

    public int getPossibleValuesType(int n) {
        if (this._possibleValuesTypes != null && n >= 0 && n < this._possibleValuesTypes.length) {
            int n2 = this._possibleValuesTypes[n];
            if (n2 == -1) {
                return this.getDefaultPossibleValuesType();
            }
            return n2;
        }
        return this.getDefaultPossibleValuesType();
    }

    public void setPossibleValuesType(int n, int n2) {
        if (this._possibleValuesTypes == null || this._possibleValuesTypes.length != this.getActualModel().getColumnCount()) {
            this._possibleValuesTypes = new int[this.getActualModel().getColumnCount()];
            Arrays.fill(this._possibleValuesTypes, -1);
        }
        if (this._possibleValuesTypes != null && n >= 0 && n < this._possibleValuesTypes.length) {
            this._possibleValuesTypes[n] = n2;
        }
    }

    Map<Row, Boolean> getRowVisibleCache() {
        return this._rowVisibleCache;
    }
}

