/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.AutoFilterTableHeaderAdapter;
import com.jidesoft.grid.Cacheable;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DefaultTableModelWrapper;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.FilterItemSupport;
import com.jidesoft.grid.FilterableTableModelEvent;
import com.jidesoft.grid.FilterableTableModelListener;
import com.jidesoft.grid.GridIconsFactory;
import com.jidesoft.grid.GroupRow;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.RowTableModelValueProvider;
import com.jidesoft.grid.RowValueProvider;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.grid.TableFilter;
import com.jidesoft.grid.TableModelValueProvider;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableRowFilter;
import com.jidesoft.grid.TableRowModel;
import com.jidesoft.grid.ValueProvider;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StringConverter;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class FilterableTableModel
extends DefaultTableModelWrapper
implements IFilterableTableModel {
    protected FilterItemSupport _filterItemSupport = new FilterItemSupport();
    private boolean _isAdjusting = false;
    private boolean _filteringPaused = false;
    protected ValueProvider _valueProvider;
    protected transient List<Filter> _allColumnFilters;
    protected transient List<Filter> _anyColumnFilters;
    protected transient List<Filter>[] _eachColumnFilters;
    protected transient boolean[] _columnIncluded;
    private transient boolean _hasFilter;
    private transient boolean _filtersApplied;
    private transient boolean _andMode;
    private transient List<Filter> _previousAllColumnFilters;
    private transient List<Filter> _previousAnyColumnFilters;
    private transient List<Filter>[] _previousEachColumnFilters;
    private boolean _needFilterAllData = false;
    private boolean _needFilterAllDataInternal = true;
    private int _filterApplyRecords = 0;
    private int _filteredModelRowCount = 0;
    private Map<Integer, List<DynamicTableFilter>> _dynamicFiltersMap;
    private boolean _clearFiltersOnStructureChanged = false;
    private boolean _splitArrayOrCollection = false;
    private static final Logger LOGGER_EVENT = Logger.getLogger(FilterableTableModelEvent.class.getName());
    public static final int FILTER_ALGORITHM_BY_ROW = 0;
    public static final int FILTER_ALGORITHM_BY_FILTER = 1;
    private int _filterAlgorithm = 0;
    private static final long serialVersionUID = 6744406208291714466L;
    private boolean tableStructureChanged = false;

    public FilterableTableModel(TableModel tableModel) {
        super(tableModel);
        this._valueProvider = tableModel instanceof TableRowModel ? new RowTableModelValueProvider((TableRowModel)tableModel) : new TableModelValueProvider(tableModel);
        this.setCacheEnabled(false);
        this.reallocateIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tableDataChanged(CompoundTableModelEvent compoundTableModelEvent) {
        if (this.isAdjusting()) {
            return;
        }
        if (compoundTableModelEvent == null || compoundTableModelEvent.getEvents() == null || compoundTableModelEvent.getEvents().length <= 0) {
            this.tableDataChanged();
            return;
        }
        if (!this.isFiltersApplied() || !this.hasFilter()) {
            int n = this.fireIndexChanging();
            try {
                this.reallocateIndexes();
                CompoundTableModelEvent compoundTableModelEvent2 = this.createCompoundTableModelEvent();
                for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), tableModelEvent.getColumn(), tableModelEvent.getType()));
                }
                CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent2);
            }
            finally {
                this.fireIndexChanged(n);
            }
            return;
        }
        boolean bl = false;
        for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
            if (tableModelEvent.getType() != 0) continue;
            if (tableModelEvent.getFirstRow() == -1) {
                this.tableStructureChanged();
                return;
            }
            if (tableModelEvent.getLastRow() != Integer.MAX_VALUE) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.tableDataChanged();
            return;
        }
        this.invalidateFilterCache();
        int n = this.fireIndexChanging();
        CompoundTableModelEvent compoundTableModelEvent3 = this.createCompoundTableModelEvent();
        try {
            block13: for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
                switch (tableModelEvent.getType()) {
                    case 1: {
                        this.internalTableRowsInserted(compoundTableModelEvent3, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        continue block13;
                    }
                    case -1: {
                        this.internalTableRowsDeleted(compoundTableModelEvent3, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        continue block13;
                    }
                    case 0: {
                        if (tableModelEvent.getColumn() == -1) {
                            this.internalTableRowsUpdated(compoundTableModelEvent3, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                            continue block13;
                        }
                        this.internalTableCellsUpdated(compoundTableModelEvent3, tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        continue block13;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown Embedded TableModelEvent type: " + tableModelEvent.getType());
                    }
                }
            }
        }
        finally {
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent3);
            this.fireIndexChanged(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tableDataChanged() {
        if (this.isAdjusting()) {
            return;
        }
        if (!this.isFiltersApplied() || !this.hasFilter()) {
            int n = this.fireIndexChanging();
            try {
                this.reallocateIndexes();
                this.fireTableDataChanged();
            }
            finally {
                this.fireIndexChanged(n);
            }
            return;
        }
        if (this.isFilteringPaused() && this._model.getRowCount() == this._filteredModelRowCount) {
            int n = this.fireIndexChanging();
            try {
                this.fireTableDataChanged();
            }
            finally {
                this.fireIndexChanged(n);
            }
            return;
        }
        int n = this.fireIndexChanging();
        try {
            this.forceFilter(true);
            this.fireTableDataChanged();
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    @Override
    protected void tableStructureChanged() {
        if (this.isAdjusting()) {
            this.tableStructureChanged = true;
            return;
        }
        if (this.isClearFiltersOnStructureChanged()) {
            this.clearFilters();
        }
        if (!this.isFiltersApplied() || !this.hasFilter()) {
            int n = this.fireIndexChanging();
            try {
                this.reallocateIndexes();
                this.fireTableStructureChanged();
            }
            finally {
                this.fireIndexChanged(n);
            }
            return;
        }
        int n = this.fireIndexChanging();
        try {
            this.forceFilter(true);
            this.fireTableStructureChanged();
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    protected static int getNearestRow(int[] nArray, int n, boolean bl) {
        if (bl) {
            for (int i = 0; i < nArray.length; ++i) {
                int n2 = nArray[i];
                if (n != n2) continue;
                int n3 = i;
                return n3;
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                int n4 = nArray[i];
                if (n > n4) continue;
                int n5 = i;
                return n5;
            }
        }
        return nArray.length;
    }

    protected static int[] insertIndexes(int[] nArray, int n, int n2, int n3, boolean bl) {
        int n4 = n3 - n2 + 1;
        if (nArray.length < n) {
            int n5;
            int n6 = FilterableTableModel.getNearestRow(nArray, n2, bl);
            int[] nArray2 = (int[])nArray.clone();
            for (n5 = 0; n5 < nArray2.length; ++n5) {
                int n7 = nArray2[n5];
                if (n7 < n2) continue;
                nArray2[n5] = n7 + n4;
            }
            nArray = new int[nArray2.length + n4];
            System.arraycopy(nArray2, 0, nArray, 0, n6);
            for (n5 = 0; n5 < n4; ++n5) {
                nArray[n6 + n5] = n2 + n5;
            }
            n5 = n6 + n4;
            System.arraycopy(nArray2, n6, nArray, n5, nArray2.length - n6);
        }
        return nArray;
    }

    protected static int[] deleteIndexes(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n2 - n + 1;
        int n8 = 0;
        int n9 = -1;
        int[] nArray2 = (int[])nArray.clone();
        for (n6 = 0; n6 < nArray2.length; ++n6) {
            n5 = nArray2[n6];
            if (n5 >= n && n5 <= n2) {
                if (n9 < 0) {
                    n9 = n6;
                }
                ++n8;
                continue;
            }
            if (n5 <= n2) continue;
            nArray2[n6] = n5 - n7;
        }
        if (n8 == 0) {
            return nArray2;
        }
        n6 = nArray2.length - n8;
        nArray = new int[n6];
        if (n6 > 0) {
            int n10;
            if (n9 >= 0) {
                System.arraycopy(nArray2, 0, nArray, 0, n9);
            }
            if (n9 < 0) {
                n9 = 0;
            }
            if ((n10 = nArray2.length - (n5 = n9 + n8)) > 0) {
                System.arraycopy(nArray2, n5, nArray, n9, n10);
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tableRowsInserted(int n, int n2) {
        if (this.isAdjusting()) {
            return;
        }
        this.invalidateFilterCache();
        int n3 = this.fireIndexChanging();
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        try {
            this.internalTableRowsInserted(compoundTableModelEvent, n, n2);
        }
        finally {
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
            this.fireIndexChanged(n3);
        }
    }

    private void internalTableRowsInserted(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
        int n3;
        int n4;
        if (!this.isFiltersApplied() || !this.hasFilter()) {
            if (this._indexes != null && this._indexes.length != this._model.getRowCount()) {
                this.reallocateIndexes();
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n2, -1, 1));
            } else {
                int n5;
                int n6 = this.getVisualRowAt(n);
                if (n6 < 0) {
                    return;
                }
                if (n2 >= this._model.getRowCount()) {
                    n2 = this._model.getRowCount() - 1;
                }
                if ((n5 = this.getVisualRowAt(n2)) < 0) {
                    n5 = n2;
                }
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n6, n5, -1, 1));
            }
            return;
        }
        if (!this.isFilteringPaused() && this._indexes != null) {
            int n7;
            n4 = n2 - n + 1;
            for (n7 = 0; n7 < this._indexes.length; ++n7) {
                if (this._indexes[n7] < n) continue;
                int n8 = n7;
                this._indexes[n8] = this._indexes[n8] + n4;
            }
            this.prepareFilters();
            if (this.getFilterAlgorithm() == 0) {
                for (n7 = n; n7 <= n2; ++n7) {
                    boolean bl = this.shouldBeFiltered(n7);
                    if (bl) continue;
                    this.insert(n7);
                }
            } else {
                List<Integer> list = this.getReservedRows(n, n2);
                for (int n9 : list) {
                    this.insert(n9);
                }
            }
            this.setFilterApplyRecords(n4);
        }
        if (this.isFilteringPaused() && this.isFiltersApplied() && this.hasFilter()) {
            this._indexes = FilterableTableModel.insertIndexes(this._indexes, this._model.getRowCount(), n, n2, false);
        }
        int n10 = n;
        while ((n4 = this.getVisualRowAt(n10++)) == -1 && n10 <= n2) {
        }
        n10 = n2;
        while ((n3 = this.getVisualRowAt(n10--)) == -1 && n10 >= n) {
        }
        if (n4 != -1 && n3 != -1) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n4, n3, -1, 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tableRowsDeleted(int n, int n2) {
        if (this.isAdjusting()) {
            return;
        }
        this.invalidateFilterCache();
        int n3 = this.fireIndexChanging();
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        try {
            this.internalTableRowsDeleted(compoundTableModelEvent, n, n2);
        }
        finally {
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
            this.fireIndexChanged(n3);
        }
    }

    private void internalTableRowsDeleted(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
        int n3;
        int n4;
        if (!this.isFiltersApplied() || !this.hasFilter()) {
            if (this._indexes != null && this._indexes.length != this._model.getRowCount()) {
                this.reallocateIndexes();
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n2, -1, -1));
            } else {
                int n5;
                int n6 = this.getVisualRowAt(n);
                if (n6 == -1) {
                    n6 = n;
                }
                if ((n5 = this.getVisualRowAt(n2)) == -1) {
                    n5 = n2;
                }
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n6, n5, -1, -1));
            }
            return;
        }
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n4 = n2; n4 >= n; --n4) {
            n3 = this.getVisualRowAt(n4);
            if (n3 == -1) continue;
            vector2.add(n4);
            vector.add(n3);
        }
        if (!this.isFilteringPaused() && this._indexes != null) {
            for (Integer n7 : vector2) {
                this.remove(n7);
            }
            n4 = n2 - n + 1;
            for (n3 = 0; n3 < this._indexes.length; ++n3) {
                if (this._indexes[n3] <= n2) continue;
                int n8 = n3;
                this._indexes[n8] = this._indexes[n8] - n4;
            }
        }
        if (this.isFilteringPaused() && this.isFiltersApplied() && this._filterItemSupport.hasFilter()) {
            this._indexes = FilterableTableModel.deleteIndexes(this._indexes, n, n2, this.getVisualRowAt(n), this.getVisualRowAt(n2));
        }
        if (vector != null && vector.size() != 0) {
            if (vector.size() == 1) {
                compoundTableModelEvent.addEvent(new TableModelEvent(this, (Integer)vector.get(0), (Integer)vector.get(0), -1, -1));
            } else {
                n3 = n4 = ((Integer)vector.get(0)).intValue();
                for (int i = 1; i < vector.size(); ++i) {
                    int n9 = (Integer)vector.get(i);
                    if (n9 == n3 - 1) {
                        n3 = n9;
                    } else {
                        compoundTableModelEvent.addEvent(new TableModelEvent(this, n3, n4, -1, -1));
                        n4 = n9;
                        n3 = n9;
                    }
                    if (i != vector.size() - 1) continue;
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, n3, n4, -1, -1));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tableRowsUpdated(int n, int n2) {
        if (this.isAdjusting()) {
            return;
        }
        int n3 = this.fireIndexChanging();
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        try {
            this.internalTableRowsUpdated(compoundTableModelEvent, n, n2);
        }
        finally {
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
            this.fireIndexChanged(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTableRowsUpdated(CompoundTableModelEvent compoundTableModelEvent, int n, int n2) {
        if (!this.isFiltersApplied() || !this.hasFilter()) {
            if (this._indexes != null && this._indexes.length != this._model.getRowCount()) {
                this.reallocateIndexes();
                compoundTableModelEvent.addEvent(new TableModelEvent(this));
            } else {
                int n3 = this.getVisualRowAt(n);
                int n4 = this.getVisualRowAt(n2);
                if (n3 != -1 && n4 != -1) {
                    compoundTableModelEvent.addEvent(new TableModelEvent(this, n3, n4, -1, 0));
                }
            }
            return;
        }
        if (this.isFilteringPaused()) {
            int n5;
            int n6;
            int n7 = -1;
            int n8 = -1;
            int n9 = n;
            for (n6 = n; n6 <= n2; ++n6) {
                n5 = this.getVisualRowAt(n6);
                if (n5 == -1) continue;
                n7 = n5;
                n9 = n6;
                break;
            }
            for (n6 = n2; n6 >= n9; --n6) {
                n5 = this.getVisualRowAt(n6);
                if (n5 == -1) continue;
                n8 = n5;
                break;
            }
            if (n7 != -1 && n8 != -1) {
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n7, n8, -1, 0));
            }
            return;
        }
        if (!this.shouldOptimize(n, n2)) {
            boolean bl = this.isNeedFilterAllData();
            try {
                this.setNeedFilterAllData(true);
                this.refresh();
            }
            finally {
                this.setNeedFilterAllData(bl);
            }
            return;
        }
        this.prepareFilters();
        List<Object> list = this.getFilterAlgorithm() == 0 ? new ArrayList() : this.getReservedRows(n, n2);
        for (int i = n; i <= n2; ++i) {
            boolean bl;
            boolean bl2;
            int n10 = this.getVisualRowAt(i);
            boolean bl3 = bl2 = n10 == -1;
            if (this.getFilterAlgorithm() == 0) {
                bl = this.shouldBeFiltered(i);
            } else {
                boolean bl4 = bl = !list.contains(i);
            }
            if (bl2 && bl) continue;
            if (bl2 && !bl) {
                int n11 = this.insert(i);
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n11, n11, -1, 1));
                continue;
            }
            if (bl) {
                this.remove(i);
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n10, n10, -1, -1));
                continue;
            }
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n10, n10, -1, 0));
        }
        this.setFilterApplyRecords(n2 - n + 1);
    }

    protected boolean shouldOptimize(int n, int n2) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this);
        return n == n2 || n2 - n < tableModel.getRowCount() / 10;
    }

    protected List<Integer> getReservedRows(int n, int n2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = n; i <= n2; ++i) {
            arrayList.add(i);
        }
        return this.getShowIndexesAfterFilter(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tableCellsUpdated(int n, int n2, int n3) {
        if (this.isAdjusting()) {
            return;
        }
        int n4 = this.fireIndexChanging();
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        try {
            this.internalTableCellsUpdated(compoundTableModelEvent, n, n2, n3);
        }
        finally {
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
            this.fireIndexChanged(n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalTableCellsUpdated(CompoundTableModelEvent compoundTableModelEvent, int n, int n2, int n3) {
        if (!this.isFiltersApplied()) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, this.getVisualRowAt(n2), this.getVisualRowAt(n3), n, 0));
            return;
        }
        if (!this.hasFilter(n) || this.isFilteringPaused()) {
            int n4;
            int n5;
            int n6 = -1;
            int n7 = -1;
            int n8 = n2;
            for (n5 = n2; n5 <= n3; ++n5) {
                n4 = this.getVisualRowAt(n5);
                if (n4 == -1) continue;
                n6 = n4;
                n8 = n5;
                break;
            }
            for (n5 = n3; n5 >= n8; --n5) {
                n4 = this.getVisualRowAt(n5);
                if (n4 == -1) continue;
                n7 = n4;
                break;
            }
            if (n6 != -1 && n7 != -1) {
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n6, n7, n, 0));
            }
            return;
        }
        if (!this.shouldOptimize(n2, n3)) {
            boolean bl = this.isNeedFilterAllData();
            try {
                this.setNeedFilterAllData(true);
                this.refresh();
            }
            finally {
                this.setNeedFilterAllData(bl);
            }
            return;
        }
        this.prepareFilters();
        List<Object> list = this.getFilterAlgorithm() == 0 ? new ArrayList() : this.getReservedRows(n2, n3);
        for (int i = n2; i <= n3; ++i) {
            boolean bl;
            int n9 = this.getVisualRowAt(i);
            boolean bl2 = bl = n9 == -1;
            boolean bl3 = this.getFilterAlgorithm() == 0 ? this.shouldBeFiltered(i) : !list.contains(i);
            int n10 = this.getVisualRowAt(i);
            if (bl && bl3) continue;
            if (bl && !bl3) {
                int n11 = this.insert(i);
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n11, n11, -1, 1));
                continue;
            }
            if (!bl3) {
                compoundTableModelEvent.addEvent(new TableModelEvent(this, n10, n10, n, 0));
                continue;
            }
            this.remove(i);
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n10, n10, -1, -1));
        }
        this.setFilterApplyRecords(n3 - n2 + 1);
    }

    @Override
    public void refresh() {
        int n = this.fireIndexChanging();
        try {
            this.forceFilter(this.isNeedFilterAllData() || this.isNeedFilterAllDataInternal());
            this.fireTableDataChanged();
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    @Override
    void setActualModel(TableModel tableModel, boolean bl) {
        super.setActualModel(tableModel, bl);
        if (this._initialized) {
            this.forceFilter(this.isNeedFilterAllData() || this.isNeedFilterAllDataInternal());
        }
    }

    private void forceFilter(boolean bl) {
        boolean bl2 = this.isFilteringPaused();
        if (bl2) {
            this.setFilteringPaused(false);
        }
        this.filter(bl);
        if (bl2) {
            this.setFilteringPaused(true);
        }
    }

    private boolean containOldFilterSet() {
        int n;
        boolean bl;
        if (this._previousAllColumnFilters == null || this._previousAnyColumnFilters == null || this._previousEachColumnFilters == null) {
            return false;
        }
        if (this._previousAllColumnFilters.size() == 0 && this._previousAnyColumnFilters.size() == 0) {
            bl = false;
            List<Filter>[] listArray = this._previousEachColumnFilters;
            n = listArray.length;
            for (int i = 0; i < n; ++i) {
                List<Filter> list = listArray[i];
                if (list == null || list.size() <= 0) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
        }
        bl = this.isAndMode();
        if (this._allColumnFilters != null) {
            if (this._previousAllColumnFilters != null) {
                if (bl && this._previousAllColumnFilters.size() > this._allColumnFilters.size() || !bl && this._previousAllColumnFilters.size() < this._allColumnFilters.size()) {
                    return false;
                }
                for (int i = 0; i < Math.min(this._previousAllColumnFilters.size(), this._allColumnFilters.size()); ++i) {
                    if (this._allColumnFilters.get(i).stricterThan(this._previousAllColumnFilters.get(i))) continue;
                    return false;
                }
            }
        } else if (this._previousAllColumnFilters != null && this._previousAllColumnFilters.size() > 0) {
            return false;
        }
        if (this._anyColumnFilters != null) {
            if (this._previousAnyColumnFilters != null) {
                if (bl && this._previousAnyColumnFilters.size() > this._anyColumnFilters.size() || !bl && this._previousAnyColumnFilters.size() < this._anyColumnFilters.size()) {
                    return false;
                }
                for (int i = 0; i < Math.min(this._previousAnyColumnFilters.size(), this._anyColumnFilters.size()); ++i) {
                    if (this._anyColumnFilters.get(i).stricterThan(this._previousAnyColumnFilters.get(i))) continue;
                    return false;
                }
            }
        } else if (this._previousAnyColumnFilters != null && this._previousAnyColumnFilters.size() > 0) {
            return false;
        }
        if (this._eachColumnFilters != null) {
            if (this._eachColumnFilters.length < this._previousEachColumnFilters.length) {
                return false;
            }
            for (int i = 0; i < this._previousEachColumnFilters.length; ++i) {
                if (this._eachColumnFilters[i] != null && this._previousEachColumnFilters[i] != null) {
                    if (bl && this._previousEachColumnFilters[i].size() > this._eachColumnFilters[i].size() || !bl && this._previousEachColumnFilters[i].size() < this._eachColumnFilters[i].size()) {
                        return false;
                    }
                    for (n = 0; n < Math.min(this._previousEachColumnFilters[i].size(), this._eachColumnFilters[i].size()); ++n) {
                        if (this._eachColumnFilters[i].get(n).stricterThan(this._previousEachColumnFilters[i].get(n))) continue;
                        return false;
                    }
                    continue;
                }
                if (this._previousEachColumnFilters[i] == null || this._previousEachColumnFilters[i].size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void fireIndexChanged(int n) {
        super.fireIndexChanged(n);
        try {
            Filter filter;
            int n2;
            if (this._previousAllColumnFilters == null) {
                this._previousAllColumnFilters = new ArrayList<Filter>();
            }
            this._previousAllColumnFilters.clear();
            if (this._allColumnFilters != null) {
                for (n2 = 0; n2 < this._allColumnFilters.size(); ++n2) {
                    filter = this._allColumnFilters.get(n2);
                    try {
                        this._previousAllColumnFilters.add((Filter)filter.clone());
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
            }
            if (this._previousAnyColumnFilters == null) {
                this._previousAnyColumnFilters = new ArrayList<Filter>();
            }
            this._previousAnyColumnFilters.clear();
            if (this._anyColumnFilters != null) {
                for (n2 = 0; n2 < this._anyColumnFilters.size(); ++n2) {
                    filter = this._anyColumnFilters.get(n2);
                    try {
                        this._previousAnyColumnFilters.add((Filter)filter.clone());
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
            }
            n2 = this._model.getColumnCount();
            if (this._previousEachColumnFilters == null || this._previousEachColumnFilters.length != n2) {
                this._previousEachColumnFilters = new List[n2];
            }
            if (this._eachColumnFilters != null) {
                for (int i = 0; i < n2; ++i) {
                    if (this._previousEachColumnFilters[i] == null) {
                        this._previousEachColumnFilters[i] = new ArrayList<Filter>();
                    }
                    this._previousEachColumnFilters[i].clear();
                    if (this._eachColumnFilters[i] == null) continue;
                    List<Filter> list = this._eachColumnFilters[i];
                    for (int j = 0; j < list.size(); ++j) {
                        Filter filter2 = list.get(j);
                        try {
                            this._previousEachColumnFilters[i].add((Filter)filter2.clone());
                            continue;
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            this._previousAllColumnFilters = null;
            this._previousAnyColumnFilters = null;
            this._previousEachColumnFilters = null;
        }
    }

    @Override
    protected int fireIndexChanging() {
        int n = super.fireIndexChanging();
        this.prepareFilters();
        this.setNeedFilterAllDataInternal(!this.containOldFilterSet());
        this.setFilterApplyRecords(0);
        return n;
    }

    protected boolean shouldBeFiltered(int n) {
        return this.shouldBeFiltered(n, this._allColumnFilters, this._anyColumnFilters, this._eachColumnFilters);
    }

    protected boolean shouldBeFiltered(ValueProvider valueProvider, int n) {
        return this.shouldBeFiltered(valueProvider, n, this._allColumnFilters, this._anyColumnFilters, this._eachColumnFilters);
    }

    protected void prepareFilters() {
        int n = this._model.getColumnCount();
        if (this._eachColumnFilters == null || this._eachColumnFilters.length != n) {
            this._eachColumnFilters = new List[n];
        }
        if (this._columnIncluded == null || this._columnIncluded.length != n) {
            this._columnIncluded = new boolean[n];
        }
        if (this._filterItemSupport == null || this._filterItemSupport._allFilters == null || this._filterItemSupport._allFilters.size() == 0) {
            int n2;
            this._allColumnFilters = null;
            this._anyColumnFilters = null;
            for (n2 = 0; n2 < n; ++n2) {
                this._eachColumnFilters[n2] = new ArrayList<Filter>();
            }
            for (n2 = 0; n2 < n; ++n2) {
                this._columnIncluded[n2] = this.isColumnVisible(n2) && this.isColumnFilterable(n2);
            }
        } else {
            int n3;
            this._allColumnFilters = this._filterItemSupport.internalGetFilters(-1);
            if (this._allColumnFilters.size() == 0) {
                this._allColumnFilters = null;
            }
            this._anyColumnFilters = this._filterItemSupport.internalGetFilters(-2);
            if (this._anyColumnFilters.size() == 0) {
                this._anyColumnFilters = null;
            }
            for (n3 = 0; n3 < n; ++n3) {
                this._eachColumnFilters[n3] = this._filterItemSupport.internalGetFilters(n3);
                if (this._eachColumnFilters[n3].size() != 0) continue;
                this._eachColumnFilters[n3] = null;
            }
            for (n3 = 0; n3 < n; ++n3) {
                this._columnIncluded[n3] = this.isColumnVisible(n3) && this.isColumnFilterable(n3);
            }
        }
        this._hasFilter = this.hasFilter();
        this._filtersApplied = this.isFiltersApplied();
        this._andMode = this.isAndMode();
    }

    protected void invalidateFilterCache() {
    }

    protected void filter(boolean bl) {
        if (this.isFilteringPaused()) {
            return;
        }
        this._filteredModelRowCount = this._model.getRowCount();
        this.invalidateFilterCache();
        if (this._filtersApplied && this._hasFilter) {
            int n;
            int n2;
            int n3;
            int n4 = this._model.getRowCount();
            List<Integer> list = new ArrayList<Integer>();
            if (this.getFilterAlgorithm() == 0) {
                if (bl || this._indexes == null) {
                    for (int i = 0; i < n4; ++i) {
                        n3 = this.shouldBeFiltered(i) ? 1 : 0;
                        if (n3 != 0) continue;
                        list.add(i);
                    }
                    this.setFilterApplyRecords(n4);
                } else {
                    int[] nArray = this._indexes;
                    n3 = nArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = nArray[n2];
                        boolean bl2 = this.shouldBeFiltered(n);
                        if (bl2) continue;
                        list.add(n);
                    }
                    this.setFilterApplyRecords(this._indexes.length);
                }
            } else {
                if (bl || this._indexes == null) {
                    this.setIndexes(null);
                    for (int i = 0; i < n4; ++i) {
                        list.add(i);
                    }
                    this.setFilterApplyRecords(n4);
                } else {
                    int[] nArray = this._indexes;
                    n3 = nArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = nArray[n2];
                        list.add(n);
                    }
                    this.setFilterApplyRecords(this._indexes.length);
                }
                list = this.getShowIndexesAfterFilter(list);
            }
            int[] nArray = new int[list.size()];
            for (n3 = 0; n3 < list.size(); ++n3) {
                nArray[n3] = list.get(n3);
            }
            this.setIndexes(nArray);
        } else {
            this.setIndexes(null);
        }
    }

    private void mergeTwoSortedList(List<Integer> list, List<Integer> list2) {
        Integer n;
        if (list.size() == 0) {
            list.addAll(list2);
            return;
        }
        if (list2.size() == 0) {
            return;
        }
        int n2 = list.size() - 1;
        int n3 = list2.size() - 1;
        while (n2 >= 0 && n3 >= 0) {
            Integer n4 = list.get(n2);
            if (n4.equals(n = list2.get(n3))) {
                --n2;
                --n3;
                continue;
            }
            if (n4 < n) {
                list.add(n2, n);
                --n3;
                continue;
            }
            --n2;
        }
        while (n3 >= 0) {
            n = list2.get(n3);
            list.add(0, n);
            --n3;
        }
    }

    private synchronized List<Integer> getShowIndexesAfterFilter(List<Integer> list) {
        int n;
        Object object;
        if (!this._filtersApplied || !this._hasFilter) {
            return new ArrayList<Integer>();
        }
        List<Integer> list2 = list;
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
        ArrayList<Filter> arrayList2 = new ArrayList<Filter>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        int[] nArray = this.getIndexes();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        if (nArray.length != 0) {
            object = nArray;
            n = ((int[])object).length;
            for (int i = 0; i < n; ++i) {
                int n2 = object[i];
                arrayList4.add(n2);
            }
            if (list2.size() != 0) {
                this.mergeTwoSortedList(arrayList4, list2);
            }
            list2 = this.shrinkRowsBeforeFilter(this._valueProvider, arrayList4);
        } else {
            list2 = this.shrinkRowsBeforeFilter(this._valueProvider, list);
        }
        if (list2.size() == 0) {
            return list;
        }
        if (this._anyColumnFilters != null) {
            for (Filter filter : this._anyColumnFilters) {
                object = this.shouldNotBeFiltered(this._valueProvider, list2, filter, -2);
                arrayList.add((List<Integer>)object);
                arrayList2.add(filter);
                arrayList3.add(-2);
            }
        }
        for (n = 0; n < this._model.getColumnCount(); ++n) {
            if (!this._columnIncluded[n] || this._eachColumnFilters[n] == null && this._allColumnFilters == null) continue;
            if (this._eachColumnFilters[n] != null) {
                for (Filter filter : this._eachColumnFilters[n]) {
                    object = this.shouldNotBeFiltered(this._valueProvider, list2, filter, n);
                    arrayList.add((List<Integer>)object);
                    arrayList2.add(filter);
                    arrayList3.add(n);
                }
            }
            if (this._allColumnFilters == null) continue;
            for (Filter filter : this._allColumnFilters) {
                object = this.shouldNotBeFiltered(this._valueProvider, list2, filter, n);
                arrayList.add((List<Integer>)object);
                arrayList2.add(filter);
                arrayList3.add(n);
            }
        }
        this.expandCachedRowLists(arrayList, arrayList2, arrayList3);
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        for (int n3 : list) {
            if (!this.shouldKeepThisRow(this._valueProvider, n3, arrayList)) continue;
            arrayList5.add(n3);
        }
        this.setCacheIfNecessary(list);
        return arrayList5;
    }

    void setCacheIfNecessary(List<Integer> list) {
    }

    private void expandCachedRowLists(List<List<Integer>> list, List<Filter> list2, List<Integer> list3) {
        for (int i = list.size() - 1; i >= 0; --i) {
            List<Integer> list4 = list.get(i);
            list.remove(i);
            list4 = this.expandRowList(list4, list2.get(i), list3.get(i));
            list.add(list4);
        }
    }

    List<Integer> expandRowList(List<Integer> list, Filter filter, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            arrayList.add((Integer)object);
        }
        return arrayList;
    }

    boolean shouldKeepThisRow(ValueProvider valueProvider, int n, List<List<Integer>> list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        if (this.isAndMode()) {
            for (List<Integer> list2 : list) {
                if (this.shouldBeKept(this._valueProvider, n, list2)) continue;
                return false;
            }
            return true;
        }
        for (List<Integer> list3 : list) {
            if (!this.shouldBeKept(this._valueProvider, n, list3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isColumnVisible(int n) {
        return true;
    }

    @Override
    public boolean isColumnFilterable(int n) {
        return true;
    }

    @Override
    public boolean isColumnAutoFilterable(int n) {
        return true;
    }

    @Override
    public boolean isValuePredetermined(int n) {
        return true;
    }

    protected boolean shouldBeFiltered(int n, List<Filter> list, List<Filter> list2, List<Filter>[] listArray) {
        return this.shouldBeFiltered(this._valueProvider, n, list, list2, listArray);
    }

    protected boolean shouldBeFiltered(ValueProvider valueProvider, int n, List<Filter> list, List<Filter> list2, List<Filter>[] listArray) {
        Cacheable cacheable;
        boolean bl;
        block28: {
            bl = false;
            boolean bl2 = false;
            if (this.isFilteringPaused()) {
                return bl;
            }
            cacheable = null;
            if (valueProvider instanceof RowValueProvider && ((RowValueProvider)valueProvider).getRow() instanceof Cacheable) {
                cacheable = (Cacheable)((Object)((RowValueProvider)valueProvider).getRow());
                Object object2 = cacheable.getCachedValue();
                if (cacheable.isCacheValid()) {
                    return object2 != Cacheable.INVALID_VALUE;
                }
            }
            if (!this._filtersApplied || !this._hasFilter) break block28;
            int n2 = this._model.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                if (!this._columnIncluded[i] || (listArray[i] == null || listArray[i].size() == 0) && (list == null || list.size() == 0)) continue;
                List<Filter> object3 = listArray[i];
                Object object = valueProvider.getValueAt(n, i);
                if (object3 != null) {
                    for (Filter filter : object3) {
                        if (!filter.isEnabled()) continue;
                        if (filter instanceof TableFilter) {
                            ((TableFilter)filter).setValueProvider(valueProvider);
                            ((TableFilter)filter).setColumnIndex(i);
                            ((TableFilter)filter).setRowIndex(n);
                        }
                        if (filter.isValueFiltered(object)) {
                            bl = true;
                        } else {
                            bl2 = true;
                        }
                        if (this._andMode && bl) {
                            if (cacheable != null) {
                                cacheable.setCachedValue(1);
                            }
                            return true;
                        }
                        if (this._andMode || !bl2) continue;
                        if (cacheable != null) {
                            cacheable.setCachedValue(0);
                        }
                        return false;
                    }
                }
                if (list == null) continue;
                for (Filter filter : list) {
                    if (!filter.isEnabled()) continue;
                    if (filter instanceof TableFilter) {
                        ((TableFilter)filter).setValueProvider(valueProvider);
                        ((TableFilter)filter).setColumnIndex(i);
                        ((TableFilter)filter).setRowIndex(n);
                    }
                    if (filter.isValueFiltered(object)) {
                        bl = true;
                    } else {
                        bl2 = true;
                    }
                    if (this._andMode && bl) {
                        if (cacheable != null) {
                            cacheable.setCachedValue(1);
                        }
                        return true;
                    }
                    if (this._andMode || !bl2) continue;
                    if (cacheable != null) {
                        cacheable.setCachedValue(0);
                    }
                    return false;
                }
            }
            if (list2 == null) break block28;
            for (Filter filter : list2) {
                boolean bl3;
                block29: {
                    block30: {
                        Row row;
                        bl3 = false;
                        if (!filter.isEnabled()) break block29;
                        if (!(filter instanceof TableRowFilter) || !(valueProvider instanceof RowValueProvider) && !(valueProvider instanceof RowTableModelValueProvider)) break block30;
                        Row row2 = row = valueProvider instanceof RowValueProvider ? ((RowValueProvider)valueProvider).getRow() : ((RowTableModelValueProvider)valueProvider).getRowAt(n);
                        if (filter.isValueFiltered(row)) break block29;
                        bl3 = true;
                        break block29;
                    }
                    for (int i = 0; i < n2; ++i) {
                        if (!this._columnIncluded[i]) continue;
                        Object object = valueProvider.getValueAt(n, i);
                        if (filter instanceof TableFilter) {
                            ((TableFilter)filter).setValueProvider(valueProvider);
                            ((TableFilter)filter).setColumnIndex(i);
                            ((TableFilter)filter).setRowIndex(n);
                        }
                        if (filter.isValueFiltered(object)) continue;
                        bl3 = true;
                        break;
                    }
                }
                if (!bl3) {
                    bl = true;
                } else {
                    bl2 = true;
                }
                if (this._andMode && bl) {
                    if (cacheable != null) {
                        cacheable.setCachedValue(1);
                    }
                    return true;
                }
                if (this._andMode || !bl2) continue;
                if (cacheable != null) {
                    cacheable.setCachedValue(0);
                }
                return false;
            }
        }
        if (cacheable != null) {
            cacheable.setCachedValue(bl ? 1 : 0);
        }
        return bl;
    }

    private List<Integer> shrinkRowsBeforeFilter(ValueProvider valueProvider, List<Integer> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int n : list) {
            if (this.shouldBeIgnored(valueProvider, n)) continue;
            arrayList.add(n);
        }
        return arrayList;
    }

    protected boolean shouldBeIgnored(ValueProvider valueProvider, int n) {
        return false;
    }

    protected List<Integer> shouldNotBeFiltered(ValueProvider valueProvider, List<Integer> list, Filter filter, int n) {
        if (!this.isFiltersApplied() || filter == null || !filter.isEnabled() || list.isEmpty()) {
            return list;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n == -2) {
            int n2 = this._model.getColumnCount();
            for (int n3 : list) {
                boolean bl = true;
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    if (!this._columnIncluded[i]) continue;
                    if (filter instanceof TableFilter) {
                        ((TableFilter)filter).setValueProvider(valueProvider);
                        ((TableFilter)filter).setColumnIndex(i);
                        ((TableFilter)filter).setRowIndex(n3);
                    }
                    if (filter.isValueFiltered(object = valueProvider.getValueAt(n3, i))) continue;
                    bl = false;
                    break;
                }
                if (bl) continue;
                arrayList.add(n3);
            }
        } else {
            for (int n4 : list) {
                Object object;
                if (filter instanceof TableFilter) {
                    ((TableFilter)filter).setValueProvider(valueProvider);
                    ((TableFilter)filter).setColumnIndex(n);
                    ((TableFilter)filter).setRowIndex(n4);
                }
                if (filter.isValueFiltered(object = valueProvider.getValueAt(n4, n))) continue;
                arrayList.add(n4);
            }
        }
        return arrayList;
    }

    protected boolean shouldBeKept(ValueProvider valueProvider, int n, List<Integer> list) {
        if (list.size() == 0) {
            return false;
        }
        int n2 = 0;
        int n3 = list.size() - 1;
        do {
            int n4;
            if (list.get(n4 = (n2 + n3) / 2) > n) {
                n3 = n4;
                continue;
            }
            if (list.get(n4) < n) {
                n2 = n4;
                continue;
            }
            return true;
        } while (n3 > n2 + 1);
        return list.get(n2) == n || list.get(n3) == n;
    }

    @Override
    public void addFilter(int n, Filter filter) {
        if (filter != null) {
            this.addFilter(new IFilterableTableModel.FilterItem(n, filter));
        }
    }

    @Override
    public void addFilter(IFilterableTableModel.FilterItem filterItem) {
        this._filterItemSupport.addFilter(filterItem);
        this.fireFilterAdded(filterItem.column, filterItem.filter);
    }

    @Override
    public void addFilter(Filter filter) {
        this.addFilter(-2, filter);
    }

    @Override
    public void removeFilter(int n, Filter filter) {
        if (filter != null) {
            this.removeFilter(new IFilterableTableModel.FilterItem(n, filter));
        }
    }

    @Override
    public void removeFilter(IFilterableTableModel.FilterItem filterItem) {
        if (this._filterItemSupport.removeFilter(filterItem)) {
            this.fireFilterRemoved(filterItem.column, filterItem.filter);
        }
    }

    @Override
    public void removeFilter(Filter filter) {
        this.removeFilter(-2, filter);
    }

    @Override
    public void removeAllFilters(int n) {
        if (this._filterItemSupport.removeAllFilters(n)) {
            this.fireFilterRemoved(n, null);
        }
    }

    @Override
    public void removeAllFilters() {
        this.removeAllFilters(-2);
    }

    @Override
    public void clearFilters() {
        this.invalidateFilterCache();
        if (this._filterItemSupport.clearFilters()) {
            this.fireFilterRemoved(-3, null);
        }
    }

    @Override
    public Filter[] getFilters(int n) {
        return this._filterItemSupport.getFilters(n);
    }

    @Override
    public List<IFilterableTableModel.FilterItem> getFilterItems() {
        return this._filterItemSupport.getFilterItems();
    }

    @Override
    public void setFiltersApplied(boolean bl) {
        this._filterItemSupport.setFiltersApplied(bl);
        this.refresh();
    }

    @Override
    public boolean isFiltersApplied() {
        return this._filterItemSupport.isFiltersApplied();
    }

    @Override
    public boolean hasFilter() {
        return this._filterItemSupport.hasFilter();
    }

    @Override
    public boolean hasFilter(int n) {
        return this._filterItemSupport.hasFilter(n);
    }

    public JMenuItem[] getPopupMenuItems(final int n) {
        ArrayList<JCheckBoxMenuItem> arrayList = new ArrayList<JCheckBoxMenuItem>();
        Filter[] filterArray = this.getFilters(n);
        if (filterArray.length == 0) {
            return new JMenuItem[0];
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        jCheckBoxMenuItem.setAction(new AbstractAction("(All)"){
            private static final long serialVersionUID = -9127109477305727306L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Filter[] filterArray;
                for (Filter filter : filterArray = FilterableTableModel.this.getFilters(n)) {
                    filter.setEnabled(false);
                }
                FilterableTableModel.this.refresh();
            }
        });
        arrayList.add(jCheckBoxMenuItem);
        boolean bl = false;
        for (final Filter filter : filterArray) {
            final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
            jCheckBoxMenuItem2.setAction(new AbstractAction(filter.getName()){
                private static final long serialVersionUID = -1668675414526301255L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    filter.setEnabled(!filter.isEnabled());
                    jCheckBoxMenuItem2.setSelected(filter.isEnabled());
                    FilterableTableModel.this.refresh();
                }
            });
            if (!bl) {
                bl = filter.isEnabled();
            }
            jCheckBoxMenuItem2.setSelected(filter.isEnabled());
            arrayList.add(jCheckBoxMenuItem2);
        }
        jCheckBoxMenuItem.setSelected(!bl);
        return arrayList.toArray(new JMenuItem[arrayList.size()]);
    }

    @Override
    public boolean isAndMode() {
        return this._filterItemSupport.isAndMode();
    }

    @Override
    public void setAndMode(boolean bl) {
        boolean bl2 = this._filterItemSupport.isAndMode();
        if (bl2 != bl) {
            this._filterItemSupport.setAndMode(bl);
            this._previousAllColumnFilters = null;
            this._previousAnyColumnFilters = null;
            this._previousEachColumnFilters = null;
        }
    }

    public int getFilterAlgorithm() {
        return this._filterAlgorithm;
    }

    public void setFilterAlgorithm(int n) {
        this._filterAlgorithm = n;
    }

    int insert(int n) {
        if (this._indexes != null) {
            int n2 = -1;
            for (int i = 0; i < this._indexes.length; ++i) {
                int n3 = this._indexes[i];
                if (n >= n3) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                n2 = this._indexes.length;
            }
            int[] nArray = (int[])this._indexes.clone();
            this._indexes = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, this._indexes, 0, n2);
            this._indexes[n2] = n;
            System.arraycopy(nArray, n2, this._indexes, n2 + 1, this._indexes.length - n2 - 1);
            return n2;
        }
        return n;
    }

    void remove(int n) {
        if (this._indexes != null) {
            int n2 = this.getVisualRowAt(n);
            int[] nArray = (int[])this._indexes.clone();
            this._indexes = new int[nArray.length - 1];
            System.arraycopy(nArray, 0, this._indexes, 0, n2);
            System.arraycopy(nArray, n2 + 1, this._indexes, n2, this._indexes.length - n2);
        }
    }

    @Override
    public boolean isAdjusting() {
        return this._isAdjusting;
    }

    @Override
    public void setAdjusting(boolean bl) {
        if (this._isAdjusting != bl) {
            this._isAdjusting = bl;
            if (!this._isAdjusting) {
                int n = this.fireIndexChanging();
                try {
                    if (this.tableStructureChanged && this.isClearFiltersOnStructureChanged()) {
                        this.clearFilters();
                    }
                    this.filter(true);
                    if (this.tableStructureChanged) {
                        this.fireTableStructureChanged();
                        this.tableStructureChanged = false;
                    } else {
                        this.fireTableDataChanged();
                    }
                }
                finally {
                    this.fireIndexChanged(n);
                }
            }
        }
    }

    protected boolean shouldPossibleValueBeIncluded(Object object, int n) {
        return true;
    }

    /*
     * Could not resolve type clashes
     */
    @Override
    public Object[] getPossibleValues(int n, Comparator comparator) {
        if (n >= 0 && n < this.getColumnCount()) {
            HashSet<Object> hashSet = new HashSet<Object>();
            boolean bl = false;
            TableModel tableModel = this.getTableModelForPossibleValues(n);
            int n2 = tableModel.getRowCount();
            for (int i = 0; i < n2; ++i) {
                int n3;
                Iterator iterator = tableModel.getValueAt(i, n);
                if (this.isSplitArrayOrCollection() && iterator != null && iterator.getClass().isArray()) {
                    n3 = Array.getLength(iterator);
                    for (int j = 0; j < n3; ++j) {
                        Object object = Array.get(iterator, j);
                        boolean bl2 = this.shouldPossibleValueBeIncluded(object, n);
                        if (!bl2) continue;
                        if (object == null) {
                            bl = true;
                            continue;
                        }
                        hashSet.add(object);
                    }
                    continue;
                }
                if (this.isSplitArrayOrCollection() && iterator instanceof Collection) {
                    for (Object e : (Collection)((Object)iterator)) {
                        boolean bl3 = this.shouldPossibleValueBeIncluded(e, n);
                        if (!bl3) continue;
                        if (e == null) {
                            bl = true;
                            continue;
                        }
                        hashSet.add(e);
                    }
                    continue;
                }
                n3 = this.shouldPossibleValueBeIncluded(iterator, n);
                if (n3 == 0) continue;
                if (iterator == null) {
                    bl = true;
                    continue;
                }
                hashSet.add(iterator);
            }
            Object[] objectArray = new Object[bl ? hashSet.size() + 1 : hashSet.size()];
            n2 = 0;
            if (bl) {
                objectArray[n2] = null;
                ++n2;
            }
            for (Object e : hashSet) {
                objectArray[n2] = e;
                ++n2;
            }
            try {
                if (objectArray.length >= 2) {
                    if (bl) {
                        Arrays.sort(objectArray, 1, objectArray.length, comparator);
                    } else {
                        Arrays.sort(objectArray, comparator);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return objectArray;
        }
        return null;
    }

    protected TableModel getTableModelForPossibleValues(int n) {
        Filter[] filterArray = this.getFilters(n);
        return filterArray == null || filterArray.length == 0 ? this : this._model;
    }

    @Override
    public Object[] getPossibleValuesAndConverters(int n, Comparator comparator) {
        int n2;
        Serializable serializable;
        if (n < 0 || n >= this.getColumnCount() || this.getRowCount() == 0) {
            return new Object[0];
        }
        TableModel tableModel = this.getTableModelForPossibleValues(n);
        boolean bl = false;
        if (!this.isSameConverterAt(n)) {
            serializable = this.getConverterContextAt(0, n);
            for (int i = this.getRowCount() - 1; i >= 1; --i) {
                if (JideSwingUtilities.equals(this.getConverterContextAt(i, n), serializable)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return this.getPossibleValues(n, comparator);
        }
        serializable = new ArrayList();
        ArrayList<ConverterContext> arrayList = new ArrayList<ConverterContext>();
        int n3 = tableModel.getRowCount();
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            boolean bl2;
            Object object = tableModel.getValueAt(n2, n);
            if (object instanceof GroupRow && n != 0 || !(bl2 = this.shouldPossibleValueBeIncluded(object, n))) continue;
            ConverterContext converterContext = null;
            if (tableModel instanceof ContextSensitiveTableModel) {
                converterContext = ((ContextSensitiveTableModel)tableModel).getConverterContextAt(n2, n);
            }
            for (n4 = serializable.size() - 1; n4 >= 0 && !(object == null ? serializable.get(n4) == null && converterContext == arrayList.get(n4) : object.equals(serializable.get(n4)) && converterContext == arrayList.get(n4)); --n4) {
            }
            if (n4 >= 0) continue;
            serializable.add(object);
            arrayList.add(converterContext);
        }
        n2 = serializable.size();
        Object[] objectArray = new Object[n2 * 2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = serializable.get(i);
            objectArray[i + n2] = arrayList.get(i);
        }
        return objectArray;
    }

    @Override
    public void setFilteringPaused(boolean bl) {
        this._filteringPaused = bl;
    }

    @Override
    public boolean isFilteringPaused() {
        return this._filteringPaused;
    }

    @Override
    public void addFilterableTableModelListener(FilterableTableModelListener filterableTableModelListener) {
        this.listenerList.add(FilterableTableModelListener.class, filterableTableModelListener);
    }

    @Override
    public void removeFilterableTableModelListener(FilterableTableModelListener filterableTableModelListener) {
        this.listenerList.remove(FilterableTableModelListener.class, filterableTableModelListener);
    }

    @Override
    public FilterableTableModelListener[] getFilterableTableModelListeners() {
        return (FilterableTableModelListener[])this.listenerList.getListeners(FilterableTableModelListener.class);
    }

    public void fireFilterChanged(FilterableTableModelEvent filterableTableModelEvent) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (filterableTableModelEvent.getID()) {
                case 7099: {
                    LOGGER_EVENT.fine("FilterableTableModel: \"" + filterableTableModelEvent.getFilter() + "\" is added at column index " + filterableTableModelEvent.getColumn());
                    break;
                }
                case 7100: {
                    if (filterableTableModelEvent.getFilter() == null) {
                        LOGGER_EVENT.fine("FilterableTableModel: all filters are cleared at column index " + filterableTableModelEvent.getColumn());
                        break;
                    }
                    LOGGER_EVENT.fine("FilterableTableModel: \"" + filterableTableModelEvent.getFilter() + "\" is removed at column index " + filterableTableModelEvent.getColumn());
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FilterableTableModelListener.class) continue;
            ((FilterableTableModelListener)objectArray[i + 1]).filterableTableModelChanged(filterableTableModelEvent);
        }
    }

    public void fireFilterAdded(int n, Filter filter) {
        this.fireFilterChanged(new FilterableTableModelEvent(this, 7099, n, filter));
    }

    public void fireFilterRemoved(int n, Filter filter) {
        this.fireFilterChanged(new FilterableTableModelEvent(this, 7100, n, filter));
    }

    @Override
    public Icon getFilterIcon(int n) {
        return GridIconsFactory.getImageIcon("icons/filter.png");
    }

    protected boolean isNeedFilterAllData() {
        return this._needFilterAllData;
    }

    protected void setNeedFilterAllData(boolean bl) {
        this._needFilterAllData = bl;
    }

    private boolean isNeedFilterAllDataInternal() {
        return this._needFilterAllDataInternal;
    }

    private void setNeedFilterAllDataInternal(boolean bl) {
        this._needFilterAllDataInternal = bl;
    }

    @Deprecated
    public int retrieveFilterApplyRecords() {
        return this._filterApplyRecords;
    }

    void setFilterApplyRecords(int n) {
        this._filterApplyRecords = n;
    }

    @Override
    public boolean isSameConverterAt(int n) {
        return true;
    }

    private void initializeDynamicTableFilters(int n) {
        List<DynamicTableFilter> list;
        if (this._dynamicFiltersMap == null) {
            this._dynamicFiltersMap = new HashMap<Integer, List<DynamicTableFilter>>();
        }
        if ((list = this._dynamicFiltersMap.get(n)) == null) {
            list = new ArrayList<DynamicTableFilter>();
            this._dynamicFiltersMap.put(n, list);
        }
    }

    public void addDynamicTableFilter(int n, DynamicTableFilter dynamicTableFilter) {
        this.initializeDynamicTableFilters(n);
        List<DynamicTableFilter> list = this._dynamicFiltersMap.get(n);
        list.add(dynamicTableFilter);
    }

    public void removeDynamicTableFilter(int n, DynamicTableFilter dynamicTableFilter) {
        this.initializeDynamicTableFilters(n);
        List<DynamicTableFilter> list = this._dynamicFiltersMap.get(n);
        list.remove(dynamicTableFilter);
    }

    @Override
    public DynamicTableFilter[] getDynamicTableFilters(int n) {
        this.initializeDynamicTableFilters(n);
        List<DynamicTableFilter> list = this._dynamicFiltersMap.get(n);
        return list.toArray(new DynamicTableFilter[list.size()]);
    }

    @Override
    public boolean isAllowMultipleValues(int n) {
        return true;
    }

    @Override
    public StringConverter getTitleConverter(int n) {
        return null;
    }

    @Override
    public AutoFilterTableHeaderAdapter.FilterTitleFormatter getFilterTitleFormatter(int n) {
        return null;
    }

    @Override
    public ListCellRenderer getListCellRenderer(int n) {
        return null;
    }

    @Override
    public boolean isUseTableCellRenderer(int n) {
        return false;
    }

    @Override
    public boolean isAllowCustomFilter(int n) {
        return true;
    }

    public boolean isClearFiltersOnStructureChanged() {
        return this._clearFiltersOnStructureChanged;
    }

    public void setClearFiltersOnStructureChanged(boolean bl) {
        this._clearFiltersOnStructureChanged = bl;
    }

    @Override
    public boolean isSplitArrayOrCollection() {
        return this._splitArrayOrCollection;
    }

    @Override
    public void setSplitArrayOrCollection(boolean bl) {
        this._splitArrayOrCollection = bl;
    }

    @Override
    public SingleValueFilter createSingleValueFilter(Object object) {
        return new SingleValueFilter<Object>(object);
    }

    @Override
    public MultipleValuesFilter createMultipleValuesFilter(Object[] objectArray) {
        return new MultipleValuesFilter<Object>(objectArray);
    }
}

