/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.IndexedRowTableModelWrapper;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.TableModelWrapperImpl;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;

public class DefaultTableModelWrapper
extends TableModelWrapperImpl
implements IndexedRowTableModelWrapper {
    protected int[] _indexes;
    private int[] _reverseIndexes;
    private boolean _cacheEnabled = false;
    private static final long serialVersionUID = 1980847372381449088L;
    private static final Logger LOGGER_EVENT = Logger.getLogger(DefaultTableModelWrapper.class.getName());

    public DefaultTableModelWrapper(TableModel tableModel) {
        super(tableModel);
    }

    @Override
    public synchronized int getActualRowAt(int n) {
        if (this._indexes == null) {
            return n;
        }
        if (n < 0 || n >= this._indexes.length) {
            return -1;
        }
        return this._indexes[n];
    }

    private void cacheReverseIndex() {
        boolean bl = false;
        this._reverseIndexes = new int[this._indexes.length];
        for (int i = 0; i < this._indexes.length; ++i) {
            if (this._indexes[i] < this._indexes.length) {
                this._reverseIndexes[this._indexes[i]] = i;
                continue;
            }
            bl = true;
        }
        if (bl && LOGGER_EVENT.isLoggable(Level.SEVERE)) {
            StringBuffer stringBuffer = new StringBuffer("DefaultTableModelWrapper \" Model wrapper has wrong indexes:");
            for (int n : this._indexes) {
                stringBuffer.append(n).append(";");
            }
            LOGGER_EVENT.fine(stringBuffer.toString());
        }
    }

    @Override
    void prepareBeforeFireEvent() {
        super.prepareBeforeFireEvent();
        this.reallocateIndexes();
    }

    @Override
    public synchronized int getVisualRowAt(int n) {
        if (this._indexes == null) {
            return n;
        }
        if (!this.isCacheEnabled()) {
            for (int i = 0; i < this._indexes.length; ++i) {
                int n2 = this._indexes[i];
                if (n2 != n) continue;
                return i;
            }
            return -1;
        }
        if (this._reverseIndexes == null) {
            this.cacheReverseIndex();
        }
        if (n < 0 || n >= this._reverseIndexes.length) {
            return -1;
        }
        return this._reverseIndexes[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this._indexes != null && (n < 0 || n >= this._indexes.length)) {
            return null;
        }
        return super.getValueAt(this.getActualRowAt(n), n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this._indexes == null || n >= 0 && n < this._indexes.length) {
            super.setValueAt(object, this.getActualRowAt(n), n2);
        }
    }

    @Override
    public synchronized int getRowCount() {
        if (this._indexes == null) {
            return super.getRowCount();
        }
        return this._indexes.length;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this._indexes == null) {
            return super.isCellEditable(n, n2);
        }
        return n >= 0 && n < this._indexes.length && super.isCellEditable(this.getActualRowAt(n), n2);
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        return super.getConverterContextAt(this.getActualRowAt(n), n2);
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        return super.getEditorContextAt(this.getActualRowAt(n), n2);
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        return super.getCellClassAt(this.getActualRowAt(n), n2);
    }

    public boolean isRowCountChanged() {
        return this._indexes == null || super.getRowCount() != this.getRowCount();
    }

    protected synchronized void reallocateIndexes() {
        int n = super.getRowCount();
        this._indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this._indexes[i] = i;
        }
    }

    @Override
    public synchronized int[] getIndexes() {
        if (this._indexes == null) {
            return new int[0];
        }
        return (int[])this._indexes.clone();
    }

    @Override
    public synchronized void setIndexes(int[] nArray) {
        this._indexes = nArray;
    }

    public boolean isCacheEnabled() {
        return this._cacheEnabled;
    }

    public void setCacheEnabled(boolean bl) {
        this._cacheEnabled = bl;
    }

    @Override
    protected int fireIndexChanging() {
        return this.fireIndexChanging(false);
    }

    @Override
    int fireIndexChanging(boolean bl) {
        int n = super.fireIndexChanging(bl);
        this._reverseIndexes = null;
        return n;
    }

    @Override
    protected void fireIndexChanged(int n) {
        this._reverseIndexes = null;
        super.fireIndexChanged(n);
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        TableModel tableModel = this.getActualModel();
        if (tableModel instanceof SpanModel) {
            CellSpan cellSpan = ((SpanModel)((Object)tableModel)).getCellSpanAt(this.getActualRowAt(n), n2);
            if (cellSpan != null) {
                int n3 = cellSpan.getRowSpan();
                int n4 = this.getVisualRowAt(cellSpan.getRow());
                for (int i = 1; i < cellSpan.getRowSpan(); ++i) {
                    int n5 = this.getVisualRowAt(cellSpan.getRow() + i);
                    if (n5 == -1) {
                        --n3;
                        continue;
                    }
                    if (n4 == -1) {
                        --n3;
                        n4 = n5;
                        continue;
                    }
                    if (n5 >= n4) continue;
                    n4 = n5;
                }
                if (n3 <= 0) {
                    return null;
                }
                cellSpan.setRowSpan(n3);
                cellSpan.setRow(n4);
            }
            return cellSpan;
        }
        return null;
    }

    @Override
    protected void tableRowsInserted(int n, int n2) {
        super.tableRowsInserted(this.getVisualRowAt(n), this.getVisualRowAt(n2));
    }

    @Override
    protected void tableRowsDeleted(int n, int n2) {
        super.tableRowsDeleted(this.getVisualRowAt(n), this.getVisualRowAt(n2));
    }

    @Override
    protected void tableRowsUpdated(int n, int n2) {
        super.tableRowsUpdated(this.getVisualRowAt(n), this.getVisualRowAt(n2));
    }

    @Override
    protected void tableCellsUpdated(int n, int n2, int n3) {
        super.tableCellsUpdated(n, this.getVisualRowAt(n2), this.getVisualRowAt(n3));
    }

    @Override
    protected void tableDataChanged(CompoundTableModelEvent compoundTableModelEvent) {
        if (compoundTableModelEvent == null || compoundTableModelEvent.getEvents() == null || compoundTableModelEvent.getEvents().length <= 0) {
            this.tableDataChanged();
            return;
        }
        CompoundTableModelEvent compoundTableModelEvent2 = this.createCompoundTableModelEvent();
        block5: for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
            switch (tableModelEvent.getType()) {
                case 1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, this.getVisualRowAt(tableModelEvent.getFirstRow()), this.getVisualRowAt(tableModelEvent.getLastRow()), -1, 1));
                    continue block5;
                }
                case -1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, this.getVisualRowAt(tableModelEvent.getFirstRow()), this.getVisualRowAt(tableModelEvent.getLastRow()), -1, -1));
                    continue block5;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, -1));
                        continue block5;
                    }
                    if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this));
                        continue block5;
                    }
                    if (tableModelEvent.getColumn() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, this.getVisualRowAt(tableModelEvent.getFirstRow()), this.getVisualRowAt(tableModelEvent.getLastRow()), -1, 0));
                        continue block5;
                    }
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, this.getVisualRowAt(tableModelEvent.getFirstRow()), this.getVisualRowAt(tableModelEvent.getLastRow()), tableModelEvent.getColumn(), 0));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Embedded TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent2);
    }

    @Override
    protected void tableDataChanged() {
        super.tableDataChanged();
    }

    @Override
    protected void tableStructureChanged() {
        super.tableStructureChanged();
    }

    @Override
    public int getEditorStyleAt(int n, int n2) {
        return super.getEditorStyleAt(this.getActualRowAt(n), n2);
    }

    @Override
    void setActualModel(TableModel tableModel, boolean bl) {
        super.setActualModel(tableModel, bl);
        this._reverseIndexes = null;
    }
}

